%{
open OcamlTypes
open CoqInterface
open MreAST 
%}

%token UNIT
%token TRUE
%token FALSE
%token IN
%token INL
%token INR
%token LET 
%token EQUAL
%token COMMA
%token COLON 
%token QUESTION
%token SEMICOLON
%token LBRACKET
%token RBRACKET
%token PLUS
%token TIMES
%token BANG 
%token LPAREN RPAREN GETS 
%token <int> INT
%token <string> ID
%token EOF

%right COMMA SEMICOLON

%start exp
%start command 
%start algebra
%start term

%type <OcamlTypes.ast> term
%type <OcamlTypes.ast list> term_list
%type <MreAST.commandAst> command 
%type <MreAST.interfaceExpressionAST> exp
%type <MreAST.interfaceExpressionAST list> exp_list
%type <MreAST.preAlgebraAst> algebra 

%%

command:
  | comm EOF               { $1 }

algebra:
  | algebra_exp EOF        { $1 }

term :
    UNIT                            { Ast_unit }
  | TRUE                            { Ast_bool true }
  | FALSE                           { Ast_bool false }
  | INT                             { Ast_int (int_nat $1) }
  | INL term                        { Ast_inl $2 }
  | INR term                        { Ast_inr $2 }
  | LPAREN term COMMA term RPAREN   { Ast_prod ($2, $4) }
  | LBRACKET RBRACKET               { Ast_list [] }
  | LBRACKET term_list RBRACKET     { Ast_list $2 }
  | LPAREN term RPAREN              { $2 }
  
term_list :
    term                            { [ $1 ] }
  | term SEMICOLON term_list        { $1 :: $3 }

exp :
    UNIT                            { IEA_unit }
  | TRUE                            { IEA_bool true }
  | FALSE                           { IEA_bool false }
  | ID                              { IEA_ident $1 }
  | INT                             { IEA_int (int_nat $1) }
  | INL exp                         { IEA_inl $2 }
  | INR exp                         { IEA_inr $2 }
  | LPAREN exp COMMA exp RPAREN     { IEA_prod ($2, $4) }
  | LBRACKET RBRACKET               { IEA_list [] }
  | LBRACKET exp_list RBRACKET      { IEA_list $2 }
  | LPAREN exp RPAREN               { $2 }
  | exp COMMA exp                   { IEA_plus ($1, $3) }
  | exp COMMA exp                   { IEA_times ($1, $3) }
  
exp_list :
    exp                             { [ $1 ] }
  | exp SEMICOLON exp_list          { $1 :: $3 }

comm:
  | ID GETS algebra        { BindAlgebra($1, $3) }
  | ID COLON ID GETS exp   { BindExpression($1, $3, $5) }
  | BANG ID id_list        { DoAction($2, $3) }
  | QUESTION               { DoAction("?", []) }

id_list :
    ID                              { [ $1 ] }
  | ID id_list                      { $1 :: $2 }
  |                                 { [] }

algebra_exp:
  | ID                                       { try PTA_app (PID_const(algebraConst_of_string $1), []) with _ -> PTA_var $1 }
  | ID algebra_exp_list                      { PTA_app (PID_const(algebraConst_of_string $1), $2) }
  | LET ID EQUAL algebra_exp IN algebra_exp  { PTA_let ($2, $4, $6) }
  | LPAREN algebra_exp RPAREN                { $2 }

algebra_exp_list:
  | INT                                        { (PTA_app (PID_const (TC_int $1), []))::[] } 
  | INT algebra_exp_list                       { (PTA_app (PID_const (TC_int $1), []))::$2 } 
  | ID algebra_exp_list                        { (try PTA_app (PID_const(algebraConst_of_string $1), []) with _ -> PTA_var $1 ) :: $2 }
  | LPAREN algebra_exp RPAREN algebra_exp_list { $2 :: $4 }
  |                                            { [] }

