
let parseCommand termString =
   let lexbuf = Lexing.from_string termString in
   Yacc_spec.command Lex_spec.token lexbuf 

let parseTerm termString =
   let lexbuf = Lexing.from_string termString in
   let preterm = Yacc_spec.algebra Lex_spec.token lexbuf in 
   MreAST.coqLang_of_preAlgebraAst preterm

(*---------------------------------------------------------------------------*)
(*                         string ---> CarrierAst                            *)
(*---------------------------------------------------------------------------*)


let parseCarrier tp carrierString : OcamlTypes.wfAst =
   let lexbuf = Lexing.from_string carrierString in
   let t = Yacc_spec.term Lex_spec.token lexbuf in
   match OcamlTypes.ast_wfAst tp t with
   | Datatypes.Coq_inl e' -> e'
   | Datatypes.Coq_inr (OcamlTypes.NotWT (e, tp)) -> raise (Errors.AstDoesNotTypecheck (e, tp))

