open Datatypes
open DecSetoid
open DecSetoidProperties
open List0
open Specif

let __ = let rec f _ = Obj.repr f in Obj.repr f

(** val eq_union :
    coq_DecSetoid -> coq_DecSetoid -> (carrier, carrier) sum -> (carrier,
    carrier) sum -> bool **)

let eq_union a b x y =
  match x with
    | Coq_inl a0 ->
        (match y with
           | Coq_inl b0 -> a.equal a0 b0
           | Coq_inr c -> false)
    | Coq_inr a0 ->
        (match y with
           | Coq_inl c -> false
           | Coq_inr b0 -> b.equal a0 b0)

(** val unionDecSetoid : coq_DecSetoid -> coq_DecSetoid -> coq_DecSetoid **)

let unionDecSetoid a b =
  { choose = (Obj.magic (Coq_inl a.choose)); equal =
    (Obj.magic (eq_union a b)) }

(** val isSingleton_comp :
    coq_DecSetoid -> coq_DecSetoid -> coq_IsSingleton_comp **)

let isSingleton_comp a b c =
  match Obj.magic c with
    | Coq_inl x -> Coq_existT ((Obj.magic (Coq_inr b.choose)), __)
    | Coq_inr x -> Coq_existT ((Obj.magic (Coq_inl a.choose)), __)

(** val twoElements :
    coq_DecSetoid -> coq_DecSetoid -> (coq_IsSingleton * coq_IsSingleton) ->
    coq_TwoElements **)

let twoElements a b = function
  | i , x0 ->
      let Coq_existT (a0, _) = i in
      let Coq_existT (b0, _) = x0 in
      Coq_existT ((Obj.magic (Coq_inl a0)), (Coq_existT
      ((Obj.magic (Coq_inr b0)), __)))

(** val twoElements_comp :
    coq_DecSetoid -> coq_DecSetoid -> (coq_IsSingleton_comp,
    coq_IsSingleton_comp) sum -> coq_TwoElements_comp **)

let twoElements_comp a b x a0 b0 =
  match x with
    | Coq_inl sa ->
        (match Obj.magic a0 with
           | Coq_inl x0 ->
               (match Obj.magic b0 with
                  | Coq_inl y -> Coq_existT ((Obj.magic (Coq_inr b.choose)),
                      __)
                  | Coq_inr y ->
                      let Coq_existT (c, _) = sa x0 in
                      Coq_existT ((Obj.magic (Coq_inl c)), __))
           | Coq_inr x0 ->
               (match Obj.magic b0 with
                  | Coq_inl y ->
                      let Coq_existT (c, _) = sa y in
                      Coq_existT ((Obj.magic (Coq_inl c)), __)
                  | Coq_inr y -> Coq_existT ((Obj.magic (Coq_inl a.choose)),
                      __)))
    | Coq_inr sb ->
        (match Obj.magic a0 with
           | Coq_inl x0 ->
               (match Obj.magic b0 with
                  | Coq_inl y -> Coq_existT ((Obj.magic (Coq_inr b.choose)),
                      __)
                  | Coq_inr y ->
                      let Coq_existT (c, _) = sb y in
                      Coq_existT ((Obj.magic (Coq_inr c)), __))
           | Coq_inr x0 ->
               (match Obj.magic b0 with
                  | Coq_inl y ->
                      let Coq_existT (c, _) = sb x0 in
                      Coq_existT ((Obj.magic (Coq_inr c)), __)
                  | Coq_inr y -> Coq_existT ((Obj.magic (Coq_inl a.choose)),
                      __)))

(** val finite :
    coq_DecSetoid -> coq_DecSetoid -> (coq_Finite * coq_Finite) -> coq_Finite **)

let finite a b = function
  | f , x0 ->
      let Coq_existT (la, _) = f in
      let Coq_existT (lb, _) = x0 in
      Coq_existT
      ((app (map (Obj.magic (fun x1 -> Coq_inl x1)) la)
         (map (Obj.magic (fun x1 -> Coq_inr x1)) lb)), __)

(** val finite_comp :
    coq_DecSetoid -> coq_DecSetoid -> (coq_Finite_comp, coq_Finite_comp) sum
    -> coq_Finite_comp **)

let finite_comp a b x l =
  match x with
    | Coq_inl fa ->
        let Coq_existT (x0, _) =
          let rec f = function
            | [] -> Coq_existT ([], __)
            | a0 :: l1 ->
                let Coq_existT (x0, _) = f l1 in
                (match Obj.magic a0 with
                   | Coq_inl c -> Coq_existT ((c :: (Obj.magic x0)), __)
                   | Coq_inr c -> Coq_existT ((Obj.magic x0), __))
          in f l
        in
        let Coq_existT (y, _) = fa x0 in
        Coq_existT ((Obj.magic (Coq_inl y)), __)
    | Coq_inr fb ->
        let Coq_existT (x0, _) =
          let rec f = function
            | [] -> Coq_existT ([], __)
            | a0 :: l1 ->
                let Coq_existT (x0, _) = f l1 in
                (match Obj.magic a0 with
                   | Coq_inl c -> Coq_existT ((Obj.magic x0), __)
                   | Coq_inr c -> Coq_existT ((c :: (Obj.magic x0)), __))
          in f l
        in
        let Coq_existT (y, _) = fb x0 in
        Coq_existT ((Obj.magic (Coq_inr y)), __)

