open Datatypes
open DecSetoid
open Semigroup
open SemigroupProperties
open Specif
open Union
open Unit

type __ = Obj.t
let __ = let rec f _ = Obj.repr f in Obj.repr f

(** val top_union_setoid :
    coq_Semigroup -> coq_Semigroup -> coq_DecSetoid **)

let top_union_setoid a b =
  unionDecSetoid (unionDecSetoid a.setoid b.setoid) unitDecSetoid

(** val top_el : coq_Semigroup -> coq_Semigroup -> carrier **)

let top_el a b =
  Obj.magic (Coq_inr ())

(** val coq_A_el : coq_Semigroup -> coq_Semigroup -> carrier -> carrier **)

let coq_A_el a b x =
  Obj.magic (Coq_inl (Coq_inl x))

(** val coq_B_el : coq_Semigroup -> coq_Semigroup -> carrier -> carrier **)

let coq_B_el a b x =
  Obj.magic (Coq_inl (Coq_inr x))

(** val top_union_op :
    coq_Semigroup -> coq_Semigroup -> carrier -> carrier -> carrier **)

let top_union_op a b x y =
  match Obj.magic x with
    | Coq_inl c ->
        (match c with
           | Coq_inl a0 ->
               (match Obj.magic y with
                  | Coq_inl c0 ->
                      (match c0 with
                         | Coq_inl b0 ->
                             Obj.magic (Coq_inl (Coq_inl (a.op a0 b0)))
                         | Coq_inr c1 -> Obj.magic (Coq_inr ()))
                  | Coq_inr c0 -> Obj.magic (Coq_inr ()))
           | Coq_inr a0 ->
               (match Obj.magic y with
                  | Coq_inl c0 ->
                      (match c0 with
                         | Coq_inl c1 -> Obj.magic (Coq_inr ())
                         | Coq_inr b0 ->
                             Obj.magic (Coq_inl (Coq_inr (b.op a0 b0))))
                  | Coq_inr c0 -> Obj.magic (Coq_inr ())))
    | Coq_inr c -> Obj.magic (Coq_inr ())

(** val topUnionSemigroup :
    coq_Semigroup -> coq_Semigroup -> coq_Semigroup **)

let topUnionSemigroup a b =
  { setoid = (top_union_setoid a b); op = (top_union_op a b) }

(** val isIdempotent_comp :
    coq_Semigroup -> coq_Semigroup -> (coq_IsIdempotent_comp,
    coq_IsIdempotent_comp) sum -> coq_IsIdempotent_comp **)

let isIdempotent_comp a b = function
  | Coq_inl i ->
      let Coq_existT (a0, _) = i in
      Coq_existT ((Obj.magic (Coq_inl (Coq_inl a0))), __)
  | Coq_inr i ->
      let Coq_existT (b0, _) = i in
      Coq_existT ((Obj.magic (Coq_inl (Coq_inr b0))), __)

(** val isSelective_comp :
    coq_Semigroup -> coq_Semigroup -> coq_IsSelective_comp **)

let isSelective_comp a b =
  Coq_existT ((Obj.magic (Coq_inl (Coq_inl a.setoid.choose))), (Coq_existT
    ((Obj.magic (Coq_inl (Coq_inr b.setoid.choose))), __)))

(** val isCommutative_comp :
    coq_Semigroup -> coq_Semigroup -> (coq_IsCommutative_comp,
    coq_IsCommutative_comp) sum -> coq_IsCommutative_comp **)

let isCommutative_comp a b = function
  | Coq_inl i ->
      let Coq_existT (a0, s) = i in
      let Coq_existT (a', _) = s in
      Coq_existT ((Obj.magic (Coq_inl (Coq_inl a0))), (Coq_existT
      ((Obj.magic (Coq_inl (Coq_inl a'))), __)))
  | Coq_inr i ->
      let Coq_existT (b0, s) = i in
      let Coq_existT (b', _) = s in
      Coq_existT ((Obj.magic (Coq_inl (Coq_inr b0))), (Coq_existT
      ((Obj.magic (Coq_inl (Coq_inr b'))), __)))

(** val hasIdentity_comp :
    coq_Semigroup -> coq_Semigroup -> coq_HasIdentity_comp **)

let hasIdentity_comp a b i =
  match Obj.magic i with
    | Coq_inl c ->
        (match c with
           | Coq_inl x -> Coq_existT
               ((Obj.magic (Coq_inl (Coq_inr b.setoid.choose))), __)
           | Coq_inr x -> Coq_existT
               ((Obj.magic (Coq_inl (Coq_inl a.setoid.choose))), __))
    | Coq_inr c ->
        let () = c in
        Coq_existT ((Obj.magic (Coq_inl (Coq_inl a.setoid.choose))), __)

(** val hasAnnihilator :
    coq_Semigroup -> coq_Semigroup -> coq_HasAnnihilator **)

let hasAnnihilator a b =
  Coq_existT ((Obj.magic (Coq_inr ())), __)

(** val isLeft_comp : coq_Semigroup -> coq_Semigroup -> coq_IsLeft_comp **)

let isLeft_comp a b =
  Coq_existT ((Obj.magic (Coq_inl (Coq_inl a.setoid.choose))), (Coq_existT
    ((Obj.magic (Coq_inr ())), __)))

(** val isRight_comp : coq_Semigroup -> coq_Semigroup -> coq_IsRight_comp **)

let isRight_comp a b =
  Coq_existT ((Obj.magic (Coq_inr ())), (Coq_existT
    ((Obj.magic (Coq_inl (Coq_inl a.setoid.choose))), __)))

(** val leftCondensed_comp :
    coq_Semigroup -> coq_Semigroup -> coq_LeftCondensed_comp **)

let leftCondensed_comp a b =
  Coq_existT ((Obj.magic (Coq_inl (Coq_inl a.setoid.choose))), (Coq_existT
    ((Obj.magic (Coq_inr ())), (Coq_existT
    ((Obj.magic (Coq_inl (Coq_inl a.setoid.choose))), __)))))

(** val rightCondensed_comp :
    coq_Semigroup -> coq_Semigroup -> coq_RightCondensed_comp **)

let rightCondensed_comp a b =
  Coq_existT ((Obj.magic (Coq_inl (Coq_inl a.setoid.choose))), (Coq_existT
    ((Obj.magic (Coq_inr ())), (Coq_existT
    ((Obj.magic (Coq_inl (Coq_inl a.setoid.choose))), __)))))

(** val leftCancelative_comp :
    coq_Semigroup -> coq_Semigroup -> coq_LeftCancelative_comp **)

let leftCancelative_comp a b =
  Coq_existT ((Obj.magic (Coq_inl (Coq_inl a.setoid.choose))), (Coq_existT
    ((Obj.magic (Coq_inl (Coq_inr b.setoid.choose))), (Coq_existT
    ((Obj.magic (Coq_inr ())), __)))))

(** val rightCancelative_comp :
    coq_Semigroup -> coq_Semigroup -> coq_RightCancelative_comp **)

let rightCancelative_comp a b =
  Coq_existT ((Obj.magic (Coq_inl (Coq_inl a.setoid.choose))), (Coq_existT
    ((Obj.magic (Coq_inl (Coq_inr b.setoid.choose))), (Coq_existT
    ((Obj.magic (Coq_inr ())), __)))))

(** val antiLeft_comp :
    coq_Semigroup -> coq_Semigroup -> coq_AntiLeft_comp **)

let antiLeft_comp a b =
  Coq_existT ((Obj.magic (Coq_inr ())), (Coq_existT
    ((Obj.magic (Coq_inl (Coq_inl a.setoid.choose))), __)))

(** val antiRight_comp :
    coq_Semigroup -> coq_Semigroup -> coq_AntiRight_comp **)

let antiRight_comp a b =
  Coq_existT ((Obj.magic (Coq_inl (Coq_inl a.setoid.choose))), (Coq_existT
    ((Obj.magic (Coq_inr ())), __)))

(** val treeGlb_comp :
    coq_Semigroup -> coq_Semigroup -> (coq_TreeGlb_comp, coq_TreeGlb_comp)
    sum -> (carrier, (carrier, (carrier, __) sigT) sigT) sigT **)

let treeGlb_comp a b = function
  | Coq_inl ta ->
      let Coq_existT (x0, s) = ta __ __ in
      let Coq_existT (y, s0) = s in
      let Coq_existT (z, _) = s0 in
      Coq_existT ((Obj.magic (Coq_inl (Coq_inl x0))), (Coq_existT
      ((Obj.magic (Coq_inl (Coq_inl y))), (Coq_existT
      ((Obj.magic (Coq_inl (Coq_inl z))), __)))))
  | Coq_inr tb ->
      let Coq_existT (x0, s) = tb __ __ in
      let Coq_existT (y, s0) = s in
      let Coq_existT (z, _) = s0 in
      Coq_existT ((Obj.magic (Coq_inl (Coq_inr x0))), (Coq_existT
      ((Obj.magic (Coq_inl (Coq_inr y))), (Coq_existT
      ((Obj.magic (Coq_inl (Coq_inr z))), __)))))

