open Datatypes
open DecSetoid
open DecSetoidProperties
open FSets
open List0
open Semigroup
open SemigroupProperties
open SimpleSeq
open Specif

let __ = let rec f _ = Obj.repr f in Obj.repr f

(** val disjoint : coq_DecSetoid -> carrier list -> carrier list -> bool **)

let disjoint a x y =
  forallb (fun a0 -> negb (mem a a0 y)) x

(** val simpleSeqSemigroup : coq_DecSetoid -> coq_Semigroup **)

let simpleSeqSemigroup a =
  { setoid = (simpleSeqDecSetoid a); op =
    (Obj.magic (fun x x0 -> app x x0)) }

(** val isIdempotent_comp : coq_DecSetoid -> coq_IsIdempotent_comp **)

let isIdempotent_comp a =
  Coq_existT ((Obj.magic (a.choose :: [])), __)

(** val isCommutative_comp :
    coq_DecSetoid -> coq_IsSingleton_comp -> coq_IsCommutative_comp **)

let isCommutative_comp a sg =
  let a0 = a.choose in
  let Coq_existT (b, _) = sg a0 in
  Coq_existT ((Obj.magic (a0 :: [])), (Coq_existT (
  (Obj.magic (b :: [])), __)))

(** val isSelective_comp : coq_DecSetoid -> coq_IsSelective_comp **)

let isSelective_comp a =
  let a0 = a.choose in
  Coq_existT ((Obj.magic (a0 :: [])), (Coq_existT (
  (Obj.magic (a0 :: [])), __)))

(** val hasIdentity : coq_DecSetoid -> coq_HasIdentity **)

let hasIdentity a =
  Coq_existT ((Obj.magic []), __)

(** val hasAnnihilator : coq_DecSetoid -> coq_HasAnnihilator **)

let hasAnnihilator a =
  Coq_existT ((Obj.magic (err a)), __)

(** val isLeft_comp : coq_DecSetoid -> coq_IsLeft_comp **)

let isLeft_comp a =
  Coq_existT ((Obj.magic []), (Coq_existT ((Obj.magic (err a)), __)))

(** val isRight_comp : coq_DecSetoid -> coq_IsRight_comp **)

let isRight_comp a =
  Coq_existT ((Obj.magic (err a)), (Coq_existT ((Obj.magic []), __)))

(** val leftCondensed_comp : coq_DecSetoid -> coq_LeftCondensed_comp **)

let leftCondensed_comp a =
  Coq_existT ((Obj.magic []), (Coq_existT ((Obj.magic (err a)), (Coq_existT
    ((Obj.magic []), __)))))

(** val rightCondensed_comp : coq_DecSetoid -> coq_RightCondensed_comp **)

let rightCondensed_comp a =
  Coq_existT ((Obj.magic []), (Coq_existT ((Obj.magic []), (Coq_existT
    ((Obj.magic (err a)), __)))))

(** val leftCancelative_comp : coq_DecSetoid -> coq_LeftCancelative_comp **)

let leftCancelative_comp a =
  Coq_existT ((Obj.magic (err a)), (Coq_existT ((Obj.magic []), (Coq_existT
    ((Obj.magic (err a)), __)))))

(** val rightCancelative_comp :
    coq_DecSetoid -> coq_RightCancelative_comp **)

let rightCancelative_comp a =
  Coq_existT ((Obj.magic []), (Coq_existT ((Obj.magic (err a)), (Coq_existT
    ((Obj.magic (err a)), __)))))

(** val antiLeft_comp : coq_DecSetoid -> coq_AntiLeft_comp **)

let antiLeft_comp a =
  Coq_existT ((Obj.magic []), (Coq_existT ((Obj.magic []), __)))

(** val antiRight_comp : coq_DecSetoid -> coq_AntiRight_comp **)

let antiRight_comp a =
  Coq_existT ((Obj.magic []), (Coq_existT ((Obj.magic []), __)))

