open Datatypes
open DecSetoid
open DecSetoidProperties
open FSets
open Logic0
open Seq
open Specif

let __ = let rec f _ = Obj.repr f in Obj.repr f

(** val simple : coq_DecSetoid -> carrier list -> bool **)

let rec simple a = function
  | [] -> true
  | a0 :: x' -> if mem a a0 x' then false else simple a x'

(** val sseq_eq : coq_DecSetoid -> carrier list -> carrier list -> bool **)

let sseq_eq a x y =
  if if negb (simple a x) then negb (simple a y) else false
  then true
  else if if simple a x then simple a y else false
       then seq_eq a x y
       else false

(** val simpleSeqDecSetoid : coq_DecSetoid -> coq_DecSetoid **)

let simpleSeqDecSetoid a =
  { choose = (Obj.magic []); equal = (Obj.magic (sseq_eq a)) }

(** val err : coq_DecSetoid -> carrier list **)

let err a =
  let a0 = a.choose in a0 :: (a0 :: [])

(** val isSingleton_comp : coq_DecSetoid -> coq_IsSingleton_comp **)

let isSingleton_comp a x =
  let Coq_existT (w, _) = copy_var (simple a (Obj.magic x)) in
  if w
  then Coq_existT ((Obj.magic (err a)), __)
  else Coq_existT ((Obj.magic []), __)

(** val twoElements_comp : coq_DecSetoid -> coq_TwoElements_comp **)

let twoElements_comp a x y =
  let Coq_existT (w, _) = copy_var (simple a (Obj.magic x)) in
  if w
  then let Coq_existT (w0, _) = copy_var (simple a (Obj.magic y)) in
       if w0
       then Coq_existT ((Obj.magic (err a)), __)
       else (match Obj.magic x with
               | [] -> Coq_existT ((Obj.magic (a.choose :: [])), __)
               | a0 :: x0 -> Coq_existT ((Obj.magic []), __))
  else let Coq_existT (w0, _) = copy_var (simple a (Obj.magic y)) in
       if w0
       then (match Obj.magic y with
               | [] -> Coq_existT ((Obj.magic (a.choose :: [])), __)
               | a0 :: y0 -> Coq_existT ((Obj.magic []), __))
       else Coq_existT ((Obj.magic []), __)

