open DecSetoid
open Semigroup
open Specif
open Transform

type __ = Obj.t
let __ = let rec f _ = Obj.repr f in Obj.repr f

type coq_SemigroupTransform = { setoid : coq_DecSetoid;
                                op : (carrier -> carrier -> carrier);
                                fn : coq_DecSetoid;
                                app : (carrier -> carrier -> carrier) }

(** val coq_SemigroupTransform_rect :
    (coq_DecSetoid -> (carrier -> carrier -> carrier) -> __ -> __ ->
    coq_DecSetoid -> (carrier -> carrier -> carrier) -> __ -> 'a1) ->
    coq_SemigroupTransform -> 'a1 **)

let coq_SemigroupTransform_rect f s =
  let { setoid = x; op = x0; fn = x1; app = x2 } = s in f x x0 __ __ x1 x2 __

(** val coq_SemigroupTransform_rec :
    (coq_DecSetoid -> (carrier -> carrier -> carrier) -> __ -> __ ->
    coq_DecSetoid -> (carrier -> carrier -> carrier) -> __ -> 'a1) ->
    coq_SemigroupTransform -> 'a1 **)

let coq_SemigroupTransform_rec f s =
  let { setoid = x; op = x0; fn = x1; app = x2 } = s in f x x0 __ __ x1 x2 __

(** val setoid : coq_SemigroupTransform -> coq_DecSetoid **)

let setoid x = x.setoid

(** val op : coq_SemigroupTransform -> carrier -> carrier -> carrier **)

let op x = x.op

(** val fn : coq_SemigroupTransform -> coq_DecSetoid **)

let fn x = x.fn

(** val app : coq_SemigroupTransform -> carrier -> carrier -> carrier **)

let app x = x.app

(** val semigroupST : coq_SemigroupTransform -> coq_Semigroup **)

let semigroupST a =
  { Semigroup.setoid = a.setoid; Semigroup.op = a.op }

(** val transformST : coq_SemigroupTransform -> coq_Transform **)

let transformST a =
  { Transform.setoid = a.setoid; Transform.fn = a.fn; Transform.app = a.app }

(** val coq_IsSTfIso_rect :
    coq_SemigroupTransform -> coq_SemigroupTransform -> coq_DsIso ->
    coq_DsIso -> (__ -> __ -> __ -> __ -> 'a1) -> 'a1 **)

let coq_IsSTfIso_rect s s' dsIso0 fnIso0 f =
  f __ __ __ __

(** val coq_IsSTfIso_rec :
    coq_SemigroupTransform -> coq_SemigroupTransform -> coq_DsIso ->
    coq_DsIso -> (__ -> __ -> __ -> __ -> 'a1) -> 'a1 **)

let coq_IsSTfIso_rec s s' dsIso0 fnIso0 f =
  f __ __ __ __

type coq_STfIso = { dsIso : coq_DsIso; fnIso : coq_DsIso }

(** val coq_STfIso_rect :
    coq_SemigroupTransform -> coq_SemigroupTransform -> (coq_DsIso ->
    coq_DsIso -> __ -> 'a1) -> coq_STfIso -> 'a1 **)

let coq_STfIso_rect s s' f s0 =
  let { dsIso = x; fnIso = x0 } = s0 in f x x0 __

(** val coq_STfIso_rec :
    coq_SemigroupTransform -> coq_SemigroupTransform -> (coq_DsIso ->
    coq_DsIso -> __ -> 'a1) -> coq_STfIso -> 'a1 **)

let coq_STfIso_rec s s' f s0 =
  let { dsIso = x; fnIso = x0 } = s0 in f x x0 __

(** val dsIso :
    coq_SemigroupTransform -> coq_SemigroupTransform -> coq_STfIso ->
    coq_DsIso **)

let dsIso _ _ x = x.dsIso

(** val fnIso :
    coq_SemigroupTransform -> coq_SemigroupTransform -> coq_STfIso ->
    coq_DsIso **)

let fnIso _ _ x = x.fnIso

(** val coq_SmgSTfIso :
    coq_SemigroupTransform -> coq_SemigroupTransform -> coq_STfIso ->
    coq_SmgIso **)

let coq_SmgSTfIso s s' iso =
  iso.dsIso

(** val coq_TfStfIso :
    coq_SemigroupTransform -> coq_SemigroupTransform -> coq_STfIso ->
    coq_TfIso **)

let coq_TfStfIso s s' iso =
  { Transform.dsIso = iso.dsIso; Transform.fnIso = iso.fnIso }

(** val coq_STfIso_refl : coq_SemigroupTransform -> coq_STfIso **)

let coq_STfIso_refl s =
  { dsIso = { phi = (fun x -> x); phi' = (fun x -> x) }; fnIso = { phi =
    (fun x -> x); phi' = (fun x -> x) } }

(** val coq_STfIso_sym :
    coq_SemigroupTransform -> coq_SemigroupTransform -> coq_STfIso ->
    coq_STfIso **)

let coq_STfIso_sym s s' i =
  { dsIso =
    (let dsIso0 = i.dsIso in { phi = dsIso0.phi'; phi' = dsIso0.phi });
    fnIso =
    (let dsIso0 = i.fnIso in { phi = dsIso0.phi'; phi' = dsIso0.phi }) }

(** val coq_STfIso_trans :
    coq_SemigroupTransform -> coq_SemigroupTransform ->
    coq_SemigroupTransform -> coq_STfIso -> coq_STfIso -> coq_STfIso **)

let coq_STfIso_trans s s' s'' i i' =
  { dsIso = (coq_DsIso_trans s.setoid s'.setoid s''.setoid i.dsIso i'.dsIso);
    fnIso = (coq_DsIso_trans s.fn s'.fn s''.fn i.fnIso i'.fnIso) }

(** val liftSTfIso :
    coq_DecSetoid -> coq_SemigroupTransform -> coq_DsIso ->
    (coq_SemigroupTransform, coq_STfIso * __) sigT **)

let liftSTfIso a b iso =
  Coq_existT ({ setoid = a; op = (fun x y ->
    iso.phi' (b.op (iso.phi x) (iso.phi y))); fn = b.fn; app = (fun f x ->
    iso.phi' (b.app f (iso.phi x))) }, ({ dsIso = { phi = iso.phi; phi' =
    iso.phi' }; fnIso = { phi = (fun x -> x); phi' = (fun x -> x) } } , __))

