open Datatypes
open DecSetoid
open DecSetoidProperties
open Logic0
open Product
open Semigroup
open SemigroupProperties
open Specif

let __ = let rec f _ = Obj.repr f in Obj.repr f

type coq_LexComp =
  | Coq_equiv
  | Coq_less
  | Coq_more
  | Coq_none

(** val coq_LexComp_rect : 'a1 -> 'a1 -> 'a1 -> 'a1 -> coq_LexComp -> 'a1 **)

let coq_LexComp_rect f f0 f1 f2 = function
  | Coq_equiv -> f
  | Coq_less -> f0
  | Coq_more -> f1
  | Coq_none -> f2

(** val coq_LexComp_rec : 'a1 -> 'a1 -> 'a1 -> 'a1 -> coq_LexComp -> 'a1 **)

let coq_LexComp_rec f f0 f1 f2 = function
  | Coq_equiv -> f
  | Coq_less -> f0
  | Coq_more -> f1
  | Coq_none -> f2

(** val lexComp : coq_Semigroup -> carrier -> carrier -> coq_LexComp **)

let lexComp a a0 c =
  if a.setoid.equal (a.op a0 c) a0
  then if a.setoid.equal (a.op a0 c) c then Coq_equiv else Coq_less
  else if a.setoid.equal (a.op a0 c) c then Coq_more else Coq_none

(** val lexOp :
    coq_Semigroup -> coq_Semigroup -> carrier -> carrier -> carrier **)

let lexOp a b x y =
  let a0 , b0 = Obj.magic x in
  let c , d = Obj.magic y in
  Obj.magic ((a.op a0 c) ,
    (match lexComp a a0 c with
       | Coq_equiv -> b.op b0 d
       | Coq_less -> b0
       | Coq_more -> d
       | Coq_none -> b.setoid.choose))

(** val swapComp : coq_LexComp -> coq_LexComp **)

let swapComp = function
  | Coq_equiv -> Coq_equiv
  | Coq_less -> Coq_more
  | Coq_more -> Coq_less
  | Coq_none -> Coq_none

(** val lex_case : coq_Semigroup -> carrier -> carrier -> sumbool sumor **)

let lex_case a x y =
  let Coq_existT (w, _) = copy_var (a.setoid.equal (a.op x y) x) in
  if w
  then let Coq_existT (w0, _) = copy_var (a.setoid.equal (a.op x y) y) in
       if w0 then Coq_inleft Coq_left else Coq_inleft Coq_right
  else let Coq_existT (w0, _) = copy_var (a.setoid.equal (a.op x y) y) in
       if w0 then Coq_inright else assert false (* absurd case *)

(** val selLexSemigroup : coq_Semigroup -> coq_Semigroup -> coq_Semigroup **)

let selLexSemigroup a b =
  { setoid = (prodDecSetoid a.setoid b.setoid); op = (lexOp a b) }

(** val isIdempotent_comp :
    coq_Semigroup -> coq_Semigroup -> coq_IsIdempotent_comp ->
    coq_IsIdempotent_comp **)

let isIdempotent_comp a b = function
  | Coq_existT (b0, _) -> Coq_existT ((Obj.magic (a.setoid.choose , b0)), __)

(** val isSelective_comp :
    coq_Semigroup -> coq_Semigroup -> coq_IsSelective_comp ->
    coq_IsSelective_comp **)

let isSelective_comp a b = function
  | Coq_existT (y1, s) ->
      let Coq_existT (y2, _) = s in
      Coq_existT ((Obj.magic (a.setoid.choose , y1)), (Coq_existT
      ((Obj.magic (a.setoid.choose , y2)), __)))

(** val isCommutative_comp :
    coq_Semigroup -> coq_Semigroup -> coq_IsCommutative_comp ->
    coq_IsCommutative_comp **)

let isCommutative_comp a b = function
  | Coq_existT (x0, s) ->
      let Coq_existT (y, _) = s in
      Coq_existT ((Obj.magic (a.setoid.choose , x0)), (Coq_existT
      ((Obj.magic (a.setoid.choose , y)), __)))

(** val hasIdentity :
    coq_Semigroup -> coq_Semigroup -> (coq_HasIdentity * coq_HasIdentity) ->
    coq_HasIdentity **)

let hasIdentity a b = function
  | h , x0 ->
      let Coq_existT (a0, _) = h in
      let Coq_existT (b0, _) = x0 in Coq_existT ((Obj.magic (a0 , b0)), __)

(** val hasIdentity_comp :
    coq_Semigroup -> coq_Semigroup -> (coq_HasIdentity_comp,
    coq_HasIdentity_comp) sum -> coq_HasIdentity_comp **)

let hasIdentity_comp a b x i =
  match x with
    | Coq_inl ia ->
        let x1 , x2 = Obj.magic i in
        let Coq_existT (a0, _) = ia x1 in
        Coq_existT ((Obj.magic (a0 , b.setoid.choose)), __)
    | Coq_inr ib ->
        let x1 , x2 = Obj.magic i in
        let Coq_existT (b0, _) = ib x2 in
        Coq_existT ((Obj.magic (x1 , b0)), __)

(** val hasAnnihilator :
    coq_Semigroup -> coq_Semigroup -> (coq_HasAnnihilator *
    coq_HasAnnihilator) -> coq_HasAnnihilator **)

let hasAnnihilator a b = function
  | h , x0 ->
      let Coq_existT (na, _) = h in
      let Coq_existT (nb, _) = x0 in Coq_existT ((Obj.magic (na , nb)), __)

(** val hasAnnihilator_comp :
    coq_Semigroup -> coq_Semigroup -> (coq_HasAnnihilator_comp,
    coq_HasAnnihilator_comp) sum -> coq_HasAnnihilator_comp **)

let hasAnnihilator_comp a b x w =
  match x with
    | Coq_inl na ->
        let x1 , x2 = Obj.magic w in
        let Coq_existT (a0, _) = na x1 in
        Coq_existT ((Obj.magic (a0 , b.setoid.choose)), __)
    | Coq_inr nb ->
        let x1 , x2 = Obj.magic w in
        let Coq_existT (b0, _) = nb x2 in
        Coq_existT ((Obj.magic (x1 , b0)), __)

(** val isLeft_comp :
    coq_Semigroup -> coq_Semigroup -> (coq_IsSingleton_comp, coq_IsLeft_comp)
    sum -> coq_IsLeft_comp **)

let isLeft_comp a b = function
  | Coq_inl sa ->
      let Coq_existT (a', _) = sa a.setoid.choose in
      let Coq_existT (w, _) =
        copy_var (a.setoid.equal a.setoid.choose (a.op a.setoid.choose a'))
      in
      if w
      then Coq_existT ((Obj.magic (a' , b.setoid.choose)), (Coq_existT
             ((Obj.magic (a.setoid.choose , b.setoid.choose)), __)))
      else Coq_existT ((Obj.magic (a.setoid.choose , b.setoid.choose)),
             (Coq_existT ((Obj.magic (a' , b.setoid.choose)), __)))
  | Coq_inr i ->
      let Coq_existT (x0, s) = i in
      let Coq_existT (y, _) = s in
      Coq_existT ((Obj.magic (a.setoid.choose , x0)), (Coq_existT
      ((Obj.magic (a.setoid.choose , y)), __)))

(** val isRight_comp :
    coq_Semigroup -> coq_Semigroup -> (coq_IsSingleton_comp,
    coq_IsRight_comp) sum -> coq_IsRight_comp **)

let isRight_comp a b = function
  | Coq_inl sa ->
      let Coq_existT (a', _) = sa a.setoid.choose in
      let Coq_existT (w, _) =
        copy_var (a.setoid.equal a.setoid.choose (a.op a.setoid.choose a'))
      in
      if w
      then Coq_existT ((Obj.magic (a.setoid.choose , b.setoid.choose)),
             (Coq_existT ((Obj.magic (a' , b.setoid.choose)), __)))
      else Coq_existT ((Obj.magic (a' , b.setoid.choose)), (Coq_existT
             ((Obj.magic (a.setoid.choose , b.setoid.choose)), __)))
  | Coq_inr i ->
      let Coq_existT (x0, s) = i in
      let Coq_existT (y, _) = s in
      Coq_existT ((Obj.magic (a.setoid.choose , x0)), (Coq_existT
      ((Obj.magic (a.setoid.choose , y)), __)))

(** val leftCondensed_comp :
    coq_Semigroup -> coq_Semigroup -> (coq_IsSingleton_comp,
    coq_LeftCondensed_comp) sum -> coq_LeftCondensed_comp **)

let leftCondensed_comp a b = function
  | Coq_inl sa ->
      let Coq_existT (w, _) = sa a.setoid.choose in
      let Coq_existT (w0, _) =
        copy_var (a.setoid.equal (a.op a.setoid.choose w) w)
      in
      if w0
      then let Coq_existT (w1, _) =
             copy_var
               (a.setoid.equal (a.op a.setoid.choose w) a.setoid.choose)
           in
           if w1
           then assert false (* absurd case *)
           else Coq_existT ((Obj.magic (a.setoid.choose , b.setoid.choose)),
                  (Coq_existT
                  ((Obj.magic (a.setoid.choose , b.setoid.choose)),
                  (Coq_existT
                  ((Obj.magic ((a.op a.setoid.choose w) , b.setoid.choose)),
                  __)))))
      else let Coq_existT (w1, _) =
             copy_var
               (a.setoid.equal (a.op a.setoid.choose w) a.setoid.choose)
           in
           Coq_existT ((Obj.magic (w , b.setoid.choose)), (Coq_existT
           ((Obj.magic (w , b.setoid.choose)), (Coq_existT
           ((Obj.magic ((a.op a.setoid.choose w) , b.setoid.choose)), __)))))
  | Coq_inr sb ->
      let Coq_existT (x0, s) = sb in
      let Coq_existT (y, s0) = s in
      let Coq_existT (z, _) = s0 in
      Coq_existT ((Obj.magic (a.setoid.choose , x0)), (Coq_existT
      ((Obj.magic (a.setoid.choose , y)), (Coq_existT
      ((Obj.magic (a.setoid.choose , z)), __)))))

(** val rightCondensed_comp :
    coq_Semigroup -> coq_Semigroup -> (coq_IsSingleton_comp,
    coq_RightCondensed_comp) sum -> coq_RightCondensed_comp **)

let rightCondensed_comp a b = function
  | Coq_inl sa ->
      let Coq_existT (w, _) = sa a.setoid.choose in
      let Coq_existT (w0, _) =
        copy_var (a.setoid.equal (a.op a.setoid.choose w) w)
      in
      if w0
      then let Coq_existT (w1, _) =
             copy_var
               (a.setoid.equal (a.op a.setoid.choose w) a.setoid.choose)
           in
           if w1
           then assert false (* absurd case *)
           else Coq_existT ((Obj.magic (a.setoid.choose , b.setoid.choose)),
                  (Coq_existT
                  ((Obj.magic (a.setoid.choose , b.setoid.choose)),
                  (Coq_existT
                  ((Obj.magic ((a.op a.setoid.choose w) , b.setoid.choose)),
                  __)))))
      else let Coq_existT (w1, _) =
             copy_var
               (a.setoid.equal (a.op a.setoid.choose w) a.setoid.choose)
           in
           Coq_existT ((Obj.magic (w , b.setoid.choose)), (Coq_existT
           ((Obj.magic (w , b.setoid.choose)), (Coq_existT
           ((Obj.magic ((a.op a.setoid.choose w) , b.setoid.choose)), __)))))
  | Coq_inr sb ->
      let Coq_existT (x0, s) = sb in
      let Coq_existT (y, s0) = s in
      let Coq_existT (z, _) = s0 in
      Coq_existT ((Obj.magic (a.setoid.choose , x0)), (Coq_existT
      ((Obj.magic (a.setoid.choose , y)), (Coq_existT
      ((Obj.magic (a.setoid.choose , z)), __)))))

(** val leftCancelative_comp :
    coq_Semigroup -> coq_Semigroup -> (coq_IsSingleton_comp *
    (coq_IsSingleton, coq_IsSingleton_comp) sum, coq_LeftCancelative_comp)
    sum -> coq_LeftCancelative_comp **)

let leftCancelative_comp a b = function
  | Coq_inl p ->
      let sga , s = p in
      (match s with
         | Coq_inl i ->
             let Coq_existT (x0, _) = i in
             let a0 = a.setoid.choose in
             let Coq_existT (b0, _) = sga a0 in
             let Coq_existT (w, _) =
               copy_var (a.setoid.equal (a.op a0 b0) a0)
             in
             if w
             then Coq_existT ((Obj.magic (a0 , x0)), (Coq_existT
                    ((Obj.magic (b0 , x0)), (Coq_existT
                    ((Obj.magic (a0 , x0)), __)))))
             else Coq_existT ((Obj.magic (b0 , x0)), (Coq_existT
                    ((Obj.magic (a0 , x0)), (Coq_existT
                    ((Obj.magic (b0 , x0)), __)))))
         | Coq_inr sgb ->
             let a1 = a.setoid.choose in
             let Coq_existT (a2, _) = sga a1 in
             let Coq_existT (w, _) =
               copy_var (a.setoid.equal (a.op a1 a2) a1)
             in
             if w
             then Obj.magic (fun x0 y _ ->
                    let b1 = b.setoid.choose in
                    let Coq_existT (b2, _) = sgb b1 in
                    Coq_existT ((y , b1), (Coq_existT ((y , b2), (Coq_existT
                    ((x0 , b1), __)))))) a1 a2 __
             else Obj.magic (fun x0 y _ ->
                    let b1 = b.setoid.choose in
                    let Coq_existT (b2, _) = sgb b1 in
                    Coq_existT ((y , b1), (Coq_existT ((y , b2), (Coq_existT
                    ((x0 , b1), __)))))) a2 a1 __)
  | Coq_inr l ->
      let Coq_existT (x2, s) = l in
      let Coq_existT (y2, s0) = s in
      let Coq_existT (z2, _) = s0 in
      Coq_existT ((Obj.magic (a.setoid.choose , x2)), (Coq_existT
      ((Obj.magic (a.setoid.choose , y2)), (Coq_existT
      ((Obj.magic (a.setoid.choose , z2)), __)))))

(** val rightCancelative_comp :
    coq_Semigroup -> coq_Semigroup -> (coq_IsSingleton_comp *
    (coq_IsSingleton, coq_IsSingleton_comp) sum, coq_RightCancelative_comp)
    sum -> coq_RightCancelative_comp **)

let rightCancelative_comp a b = function
  | Coq_inl p ->
      let sga , s = p in
      (match s with
         | Coq_inl i ->
             let Coq_existT (x0, _) = i in
             let a0 = a.setoid.choose in
             let Coq_existT (b0, _) = sga a0 in
             let Coq_existT (w, _) =
               copy_var (a.setoid.equal (a.op a0 b0) a0)
             in
             if w
             then Coq_existT ((Obj.magic (a0 , x0)), (Coq_existT
                    ((Obj.magic (b0 , x0)), (Coq_existT
                    ((Obj.magic (a0 , x0)), __)))))
             else Coq_existT ((Obj.magic (b0 , x0)), (Coq_existT
                    ((Obj.magic (a0 , x0)), (Coq_existT
                    ((Obj.magic (b0 , x0)), __)))))
         | Coq_inr sgb ->
             let a1 = a.setoid.choose in
             let Coq_existT (a2, _) = sga a1 in
             let Coq_existT (w, _) =
               copy_var (a.setoid.equal (a.op a1 a2) a1)
             in
             if w
             then Obj.magic (fun x0 y _ ->
                    let b1 = b.setoid.choose in
                    let Coq_existT (b2, _) = sgb b1 in
                    Coq_existT ((y , b1), (Coq_existT ((y , b2), (Coq_existT
                    ((x0 , b1), __)))))) a1 a2 __
             else Obj.magic (fun x0 y _ ->
                    let b1 = b.setoid.choose in
                    let Coq_existT (b2, _) = sgb b1 in
                    Coq_existT ((y , b1), (Coq_existT ((y , b2), (Coq_existT
                    ((x0 , b1), __)))))) a2 a1 __)
  | Coq_inr r ->
      let Coq_existT (x2, s) = r in
      let Coq_existT (y2, s0) = s in
      let Coq_existT (z2, _) = s0 in
      Coq_existT ((Obj.magic (a.setoid.choose , x2)), (Coq_existT
      ((Obj.magic (a.setoid.choose , y2)), (Coq_existT
      ((Obj.magic (a.setoid.choose , z2)), __)))))

(** val antiRight_comp :
    coq_Semigroup -> coq_Semigroup -> (coq_IsSingleton_comp,
    coq_AntiRight_comp) sum -> coq_AntiRight_comp **)

let antiRight_comp a b = function
  | Coq_inl sga ->
      let a0 = a.setoid.choose in
      let Coq_existT (b0, _) = sga a0 in
      let x0 = b.setoid.choose in
      let Coq_existT (w, _) = copy_var (a.setoid.equal (a.op a0 b0) a0) in
      if w
      then Coq_existT ((Obj.magic (b0 , x0)), (Coq_existT
             ((Obj.magic (a0 , x0)), __)))
      else Coq_existT ((Obj.magic (a0 , x0)), (Coq_existT
             ((Obj.magic (b0 , x0)), __)))
  | Coq_inr a0 ->
      let Coq_existT (x0, s) = a0 in
      let Coq_existT (y, _) = s in
      let a1 = a.setoid.choose in
      Coq_existT ((Obj.magic (a1 , x0)), (Coq_existT (
      (Obj.magic (a1 , y)), __)))

(** val antiLeft_comp :
    coq_Semigroup -> coq_Semigroup -> (coq_IsSingleton_comp,
    coq_AntiLeft_comp) sum -> coq_AntiLeft_comp **)

let antiLeft_comp a b = function
  | Coq_inl sga ->
      let a0 = a.setoid.choose in
      let Coq_existT (b0, _) = sga a0 in
      let x0 = b.setoid.choose in
      let Coq_existT (w, _) = copy_var (a.setoid.equal (a.op a0 b0) a0) in
      if w
      then Coq_existT ((Obj.magic (a0 , x0)), (Coq_existT
             ((Obj.magic (b0 , x0)), __)))
      else Coq_existT ((Obj.magic (b0 , x0)), (Coq_existT
             ((Obj.magic (a0 , x0)), __)))
  | Coq_inr a0 ->
      let Coq_existT (x0, s) = a0 in
      let Coq_existT (y, _) = s in
      let a1 = a.setoid.choose in
      Coq_existT ((Obj.magic (a1 , x0)), (Coq_existT (
      (Obj.magic (a1 , y)), __)))

