open DecSetoid
open Preorder
open Semigroup

(** val rle : coq_Semigroup -> carrier -> carrier -> bool **)

let rle s x y =
  s.setoid.equal (s.op x y) y

(** val rightNaturalOrder : coq_Semigroup -> coq_Preorder **)

let rightNaturalOrder s =
  { Preorder.setoid = s.setoid; le = (rle s) }

(** val naturalOrderProIso : coq_Semigroup -> coq_ProIso **)

let naturalOrderProIso s =
  { phi = (fun x -> x); phi' = (fun x -> x) }

