open DecSetoid
open DecSetoidProperties
open Semigroup
open SemigroupProperties
open Specif

let __ = let rec f _ = Obj.repr f in Obj.repr f

(** val right_op : coq_DecSetoid -> carrier -> carrier -> carrier **)

let right_op a x y =
  y

(** val rightSemigroup : coq_DecSetoid -> coq_Semigroup **)

let rightSemigroup a =
  { setoid = a; op = (fun x y -> y) }

(** val isCommutative_comp :
    coq_DecSetoid -> coq_IsSingleton_comp -> coq_IsCommutative_comp **)

let isCommutative_comp a sg =
  let Coq_existT (b, _) = sg a.choose in
  Coq_existT (a.choose, (Coq_existT (b, __)))

(** val hasIdentity : coq_DecSetoid -> coq_IsSingleton -> coq_HasIdentity **)

let hasIdentity a = function
  | Coq_existT (a0, _) -> Coq_existT (a0, __)

(** val hasIdentity_comp :
    coq_DecSetoid -> coq_IsSingleton_comp -> coq_HasIdentity_comp **)

let hasIdentity_comp a sg x =
  let Coq_existT (b, _) = sg x in Coq_existT (b, __)

(** val hasAnnihilator :
    coq_DecSetoid -> coq_IsSingleton -> coq_HasAnnihilator **)

let hasAnnihilator a = function
  | Coq_existT (a0, _) -> Coq_existT (a0, __)

(** val hasAnnihilator_comp :
    coq_DecSetoid -> coq_IsSingleton_comp -> coq_HasAnnihilator_comp **)

let hasAnnihilator_comp a sg x =
  let Coq_existT (b, _) = sg x in Coq_existT (b, __)

(** val isLeft_comp :
    coq_DecSetoid -> coq_IsSingleton_comp -> coq_IsLeft_comp **)

let isLeft_comp a sg =
  let Coq_existT (b, _) = sg a.choose in
  Coq_existT (a.choose, (Coq_existT (b, __)))

(** val leftCondensed_comp :
    coq_DecSetoid -> coq_IsSingleton_comp -> coq_LeftCondensed_comp **)

let leftCondensed_comp a sg =
  let Coq_existT (b, _) = sg a.choose in
  Coq_existT (b, (Coq_existT (b, (Coq_existT (a.choose, __)))))

(** val rightCancelative_comp :
    coq_DecSetoid -> coq_IsSingleton_comp -> coq_RightCancelative_comp **)

let rightCancelative_comp a sg =
  let Coq_existT (b, _) = sg a.choose in
  Coq_existT (b, (Coq_existT (a.choose, (Coq_existT (b, __)))))

(** val antiRight_comp : coq_DecSetoid -> coq_AntiRight_comp **)

let antiRight_comp a =
  Coq_existT (a.choose, (Coq_existT (a.choose, __)))

(** val antiLeft_comp : coq_DecSetoid -> coq_AntiLeft_comp **)

let antiLeft_comp a =
  Coq_existT (a.choose, (Coq_existT (a.choose, __)))

