open DecSetoid
open Semigroup
open SemigroupProperties
open Specif

type __ = Obj.t
let __ = let rec f _ = Obj.repr f in Obj.repr f

(** val rev_op : coq_Semigroup -> carrier -> carrier -> carrier **)

let rev_op a x y =
  a.op y x

(** val revOpSemigroup : coq_Semigroup -> coq_Semigroup **)

let revOpSemigroup a =
  { setoid = a.setoid; op = (rev_op a) }

(** val isIdempotent_comp :
    coq_Semigroup -> coq_IsIdempotent_comp -> coq_IsIdempotent_comp **)

let isIdempotent_comp a = function
  | Coq_existT (x0, _) -> Coq_existT (x0, __)

(** val isSelective_comp :
    coq_Semigroup -> coq_IsSelective_comp -> coq_IsSelective_comp **)

let isSelective_comp a = function
  | Coq_existT (x0, s) ->
      let Coq_existT (y, _) = s in Coq_existT (y, (Coq_existT (x0, __)))

(** val isCommutative_comp :
    coq_Semigroup -> coq_IsCommutative_comp -> coq_IsCommutative_comp **)

let isCommutative_comp a = function
  | Coq_existT (x0, s) ->
      let Coq_existT (y, _) = s in Coq_existT (x0, (Coq_existT (y, __)))

(** val hasIdentity : coq_Semigroup -> coq_HasIdentity -> coq_HasIdentity **)

let hasIdentity a = function
  | Coq_existT (id, _) -> Coq_existT (id, __)

(** val hasIdentity_comp :
    coq_Semigroup -> coq_HasIdentity_comp -> coq_HasIdentity_comp **)

let hasIdentity_comp a hid x =
  let Coq_existT (y, _) = hid x in Coq_existT (y, __)

(** val hasAnnihilator :
    coq_Semigroup -> coq_HasAnnihilator -> coq_HasAnnihilator **)

let hasAnnihilator a = function
  | Coq_existT (id, _) -> Coq_existT (id, __)

(** val hasAnnihilator_comp :
    coq_Semigroup -> coq_HasAnnihilator_comp -> coq_HasAnnihilator_comp **)

let hasAnnihilator_comp a hid x =
  let Coq_existT (y, _) = hid x in Coq_existT (y, __)

(** val isLeft_comp :
    coq_Semigroup -> coq_IsRight_comp -> coq_IsLeft_comp **)

let isLeft_comp a = function
  | Coq_existT (x0, s) ->
      let Coq_existT (y, _) = s in Coq_existT (y, (Coq_existT (x0, __)))

(** val isRight_comp :
    coq_Semigroup -> coq_IsLeft_comp -> coq_IsRight_comp **)

let isRight_comp a = function
  | Coq_existT (x0, s) ->
      let Coq_existT (y, _) = s in Coq_existT (y, (Coq_existT (x0, __)))

(** val leftCondensed_comp :
    coq_Semigroup -> coq_RightCondensed_comp -> coq_LeftCondensed_comp **)

let leftCondensed_comp a = function
  | Coq_existT (x0, s) ->
      let Coq_existT (y, s0) = s in
      let Coq_existT (z, _) = s0 in
      Coq_existT (x0, (Coq_existT (y, (Coq_existT (z, __)))))

(** val rightCondensed_comp :
    coq_Semigroup -> coq_LeftCondensed_comp -> coq_RightCondensed_comp **)

let rightCondensed_comp a = function
  | Coq_existT (x0, s) ->
      let Coq_existT (y, s0) = s in
      let Coq_existT (z, _) = s0 in
      Coq_existT (x0, (Coq_existT (y, (Coq_existT (z, __)))))

(** val leftCancelative_comp :
    coq_Semigroup -> coq_RightCancelative_comp -> coq_LeftCancelative_comp **)

let leftCancelative_comp a = function
  | Coq_existT (x0, s) ->
      let Coq_existT (y, s0) = s in
      let Coq_existT (z, _) = s0 in
      Coq_existT (x0, (Coq_existT (y, (Coq_existT (z, __)))))

(** val rightCancelative_comp :
    coq_Semigroup -> coq_LeftCancelative_comp -> coq_RightCancelative_comp **)

let rightCancelative_comp a = function
  | Coq_existT (x0, s) ->
      let Coq_existT (y, s0) = s in
      let Coq_existT (z, _) = s0 in
      Coq_existT (x0, (Coq_existT (y, (Coq_existT (z, __)))))

(** val antiLeft_comp :
    coq_Semigroup -> coq_AntiRight_comp -> coq_AntiLeft_comp **)

let antiLeft_comp a = function
  | Coq_existT (x0, s) ->
      let Coq_existT (y, _) = s in Coq_existT (y, (Coq_existT (x0, __)))

(** val antiRight_comp :
    coq_Semigroup -> coq_AntiLeft_comp -> coq_AntiRight_comp **)

let antiRight_comp a = function
  | Coq_existT (x0, s) ->
      let Coq_existT (y, _) = s in Coq_existT (y, (Coq_existT (x0, __)))

(** val treeGlb_comp :
    coq_Semigroup -> coq_TreeGlb_comp -> (carrier, (carrier, (carrier, __)
    sigT) sigT) sigT **)

let treeGlb_comp a tg =
  let Coq_existT (x, s) = tg __ __ in
  let Coq_existT (y, s0) = s in
  let Coq_existT (z, _) = s0 in
  Coq_existT (y, (Coq_existT (x, (Coq_existT (z, __)))))

