open Datatypes
open Min
open Range
open Semigroup
open SemigroupProperties
open Specif

let __ = let rec f _ = Obj.repr f in Obj.repr f

(** val rangeMinSemigroup : nat -> coq_Semigroup **)

let rangeMinSemigroup n =
  { setoid = (rangeDecSetoid n); op = (Obj.magic min) }

(** val rmin0SmgIso : coq_SmgIso **)

let rmin0SmgIso =
  range0DsIso

(** val rmin1SmgIso : coq_SmgIso **)

let rmin1SmgIso =
  range1DsIso

(** val hasIdentity : nat -> coq_HasIdentity **)

let hasIdentity n =
  Coq_existT ((Obj.magic n), __)

(** val hasAnnihilator : nat -> coq_HasAnnihilator **)

let hasAnnihilator n =
  Coq_existT ((Obj.magic O), __)

(** val isLeft_comp : nat -> coq_IsLeft_comp **)

let isLeft_comp n =
  Coq_existT ((Obj.magic (S O)), (Coq_existT ((Obj.magic O), __)))

(** val isRight_comp : nat -> coq_IsRight_comp **)

let isRight_comp n =
  Coq_existT ((Obj.magic O), (Coq_existT ((Obj.magic (S O)), __)))

(** val leftCondensed_comp : nat -> coq_LeftCondensed_comp **)

let leftCondensed_comp n =
  Coq_existT ((Obj.magic (S O)), (Coq_existT ((Obj.magic (S O)), (Coq_existT
    ((Obj.magic O), __)))))

(** val rightCondensed_comp : nat -> coq_RightCondensed_comp **)

let rightCondensed_comp n =
  Coq_existT ((Obj.magic (S O)), (Coq_existT ((Obj.magic (S O)), (Coq_existT
    ((Obj.magic O), __)))))

(** val leftCancelative_comp : nat -> coq_LeftCancelative_comp **)

let leftCancelative_comp n =
  Coq_existT ((Obj.magic O), (Coq_existT ((Obj.magic (S O)), (Coq_existT
    ((Obj.magic O), __)))))

(** val rightCancelative_comp : nat -> coq_RightCancelative_comp **)

let rightCancelative_comp n =
  Coq_existT ((Obj.magic O), (Coq_existT ((Obj.magic (S O)), (Coq_existT
    ((Obj.magic O), __)))))

(** val antiLeft_comp : nat -> coq_AntiLeft_comp **)

let antiLeft_comp n =
  Coq_existT ((Obj.magic O), (Coq_existT ((Obj.magic O), __)))

(** val antiRight_comp : nat -> coq_AntiRight_comp **)

let antiRight_comp n =
  Coq_existT ((Obj.magic O), (Coq_existT ((Obj.magic O), __)))

