open Datatypes
open DecSetoid
open Product
open Specif
open Transform
open TransformProperties

let __ = let rec f _ = Obj.repr f in Obj.repr f

(** val prod_app :
    coq_Transform -> coq_Transform -> carrier -> carrier -> carrier **)

let prod_app a b f x =
  let x1 , x2 = Obj.magic x in
  let f1 , f2 = Obj.magic f in Obj.magic ((a.app f1 x1) , (b.app f2 x2))

(** val prodTransform : coq_Transform -> coq_Transform -> coq_Transform **)

let prodTransform a b =
  { setoid = (prodDecSetoid a.setoid b.setoid); fn =
    (prodDecSetoid a.fn b.fn); app = (prod_app a b) }

(** val cancelative_comp :
    coq_Transform -> coq_Transform -> (coq_Cancelative_comp,
    coq_Cancelative_comp) sum -> coq_Cancelative_comp **)

let cancelative_comp a b = function
  | Coq_inl c ->
      let Coq_existT (x0, s) = c in
      let Coq_existT (y, s0) = s in
      let Coq_existT (f1, _) = s0 in
      Coq_existT ((Obj.magic (x0 , b.setoid.choose)), (Coq_existT
      ((Obj.magic (y , b.setoid.choose)), (Coq_existT
      ((Obj.magic (f1 , b.fn.choose)), __)))))
  | Coq_inr c ->
      let Coq_existT (x0, s) = c in
      let Coq_existT (y, s0) = s in
      let Coq_existT (f2, _) = s0 in
      Coq_existT ((Obj.magic (a.setoid.choose , x0)), (Coq_existT
      ((Obj.magic (a.setoid.choose , y)), (Coq_existT
      ((Obj.magic (a.fn.choose , f2)), __)))))

(** val condensed_comp :
    coq_Transform -> coq_Transform -> (coq_Condensed_comp,
    coq_Condensed_comp) sum -> coq_Condensed_comp **)

let condensed_comp a b = function
  | Coq_inl c ->
      let Coq_existT (x0, s) = c in
      let Coq_existT (y, s0) = s in
      let Coq_existT (f1, _) = s0 in
      Coq_existT ((Obj.magic (x0 , b.setoid.choose)), (Coq_existT
      ((Obj.magic (y , b.setoid.choose)), (Coq_existT
      ((Obj.magic (f1 , b.fn.choose)), __)))))
  | Coq_inr c ->
      let Coq_existT (x0, s) = c in
      let Coq_existT (y, s0) = s in
      let Coq_existT (f2, _) = s0 in
      Coq_existT ((Obj.magic (a.setoid.choose , x0)), (Coq_existT
      ((Obj.magic (a.setoid.choose , y)), (Coq_existT
      ((Obj.magic (a.fn.choose , f2)), __)))))

(** val identity_comp :
    coq_Transform -> coq_Transform -> (coq_Identity_comp, coq_Identity_comp)
    sum -> coq_Identity_comp **)

let identity_comp a b = function
  | Coq_inl i ->
      let Coq_existT (x0, s) = i in
      let Coq_existT (f, _) = s in
      Coq_existT ((Obj.magic (x0 , b.setoid.choose)), (Coq_existT
      ((Obj.magic (f , b.fn.choose)), __)))
  | Coq_inr i ->
      let Coq_existT (x0, s) = i in
      let Coq_existT (f, _) = s in
      Coq_existT ((Obj.magic (a.setoid.choose , x0)), (Coq_existT
      ((Obj.magic (a.fn.choose , f)), __)))

