open Bisemigroup
open BisemigroupGlue
open BisemigroupProperties
open Datatypes
open DecSetoid
open Logic0
open Product0
open SemigroupProperties
open Specif

type __ = Obj.t
let __ = let rec f _ = Obj.repr f in Obj.repr f

(** val prodBisemigroup :
    coq_Bisemigroup -> coq_Bisemigroup -> coq_Bisemigroup **)

let prodBisemigroup a b =
  glueBSmg (prodSemigroup (plusSmg a) (plusSmg b))
    (prodSemigroup (timesSmg a) (timesSmg b))

(** val isLeftDistributive_comp :
    coq_Bisemigroup -> coq_Bisemigroup -> (coq_IsLeftDistributive_comp,
    coq_IsLeftDistributive_comp) sum -> coq_IsLeftDistributive_comp **)

let isLeftDistributive_comp a b = function
  | Coq_inl i ->
      let Coq_existT (x0, s) = i in
      let Coq_existT (y, s0) = s in
      let Coq_existT (z, _) = s0 in
      Coq_existT ((Obj.magic (x0 , b.setoid.choose)), (Coq_existT
      ((Obj.magic (y , b.setoid.choose)), (Coq_existT
      ((Obj.magic (z , b.setoid.choose)), __)))))
  | Coq_inr i ->
      let Coq_existT (x0, s) = i in
      let Coq_existT (y, s0) = s in
      let Coq_existT (z, _) = s0 in
      Coq_existT ((Obj.magic (a.setoid.choose , x0)), (Coq_existT
      ((Obj.magic (a.setoid.choose , y)), (Coq_existT
      ((Obj.magic (a.setoid.choose , z)), __)))))

(** val isRightDistributive_comp :
    coq_Bisemigroup -> coq_Bisemigroup -> (coq_IsRightDistributive_comp,
    coq_IsRightDistributive_comp) sum -> coq_IsRightDistributive_comp **)

let isRightDistributive_comp a b = function
  | Coq_inl i ->
      let Coq_existT (x0, s) = i in
      let Coq_existT (y, s0) = s in
      let Coq_existT (z, _) = s0 in
      Coq_existT ((Obj.magic (x0 , b.setoid.choose)), (Coq_existT
      ((Obj.magic (y , b.setoid.choose)), (Coq_existT
      ((Obj.magic (z , b.setoid.choose)), __)))))
  | Coq_inr i ->
      let Coq_existT (x0, s) = i in
      let Coq_existT (y, s0) = s in
      let Coq_existT (z, _) = s0 in
      Coq_existT ((Obj.magic (a.setoid.choose , x0)), (Coq_existT
      ((Obj.magic (a.setoid.choose , y)), (Coq_existT
      ((Obj.magic (a.setoid.choose , z)), __)))))

(** val hasPlusId_back_a :
    coq_Bisemigroup -> coq_Bisemigroup -> coq_HasIdentity -> coq_HasIdentity **)

let hasPlusId_back_a a b = function
  | Coq_existT (x0, x1) ->
      let ida , idb = Obj.magic x0 in Coq_existT (ida, __)

(** val hasPlusId_back_b :
    coq_Bisemigroup -> coq_Bisemigroup -> coq_HasIdentity -> coq_HasIdentity **)

let hasPlusId_back_b a b = function
  | Coq_existT (x0, x1) ->
      let ida , idb = Obj.magic x0 in Coq_existT (idb, __)

(** val hasPlusAnn_back_a :
    coq_Bisemigroup -> coq_Bisemigroup -> coq_HasAnnihilator ->
    coq_HasAnnihilator **)

let hasPlusAnn_back_a a b = function
  | Coq_existT (x0, x1) ->
      let ida , idb = Obj.magic x0 in Coq_existT (ida, __)

(** val hasPlusAnn_back_b :
    coq_Bisemigroup -> coq_Bisemigroup -> coq_HasAnnihilator ->
    coq_HasAnnihilator **)

let hasPlusAnn_back_b a b = function
  | Coq_existT (x0, x1) ->
      let ida , idb = Obj.magic x0 in Coq_existT (idb, __)

(** val hasTimesId_back_a :
    coq_Bisemigroup -> coq_Bisemigroup -> coq_HasIdentity -> coq_HasIdentity **)

let hasTimesId_back_a a b = function
  | Coq_existT (x0, x1) ->
      let ida , idb = Obj.magic x0 in Coq_existT (ida, __)

(** val hasTimesId_back_b :
    coq_Bisemigroup -> coq_Bisemigroup -> coq_HasIdentity -> coq_HasIdentity **)

let hasTimesId_back_b a b = function
  | Coq_existT (x0, x1) ->
      let ida , idb = Obj.magic x0 in Coq_existT (idb, __)

(** val hasTimesAnn_back_a :
    coq_Bisemigroup -> coq_Bisemigroup -> coq_HasAnnihilator ->
    coq_HasAnnihilator **)

let hasTimesAnn_back_a a b = function
  | Coq_existT (x0, x1) ->
      let ida , idb = Obj.magic x0 in Coq_existT (ida, __)

(** val hasTimesAnn_back_b :
    coq_Bisemigroup -> coq_Bisemigroup -> coq_HasAnnihilator ->
    coq_HasAnnihilator **)

let hasTimesAnn_back_b a b = function
  | Coq_existT (x0, x1) ->
      let ida , idb = Obj.magic x0 in Coq_existT (idb, __)

(** val isRightStrictStable_comp :
    coq_Bisemigroup -> coq_Bisemigroup -> (((coq_IsRightStrictStable_comp,
    coq_IsRightStrictStable_comp) sum, coq_RightDiscrete_comp *
    coq_IsRightCompEqCancel_comp) sum, coq_RightDiscrete_comp *
    coq_IsRightCompEqCancel_comp) sum -> (carrier, (carrier, (carrier, __)
    sigT) sigT) sigT **)

let isRightStrictStable_comp a b = function
  | Coq_inl s ->
      (match s with
         | Coq_inl s0 ->
             (match s0 with
                | Coq_inl rssa ->
                    let Coq_existT (x0, s1) = rssa __ __ in
                    let Coq_existT (y, s2) = s1 in
                    let Coq_existT (z, _) = s2 in
                    Coq_existT ((Obj.magic (x0 , b.setoid.choose)),
                    (Coq_existT ((Obj.magic (y , b.setoid.choose)),
                    (Coq_existT ((Obj.magic (z , b.setoid.choose)), __)))))
                | Coq_inr rssb ->
                    let Coq_existT (x0, s1) = rssb __ __ in
                    let Coq_existT (y, s2) = s1 in
                    let Coq_existT (z, _) = s2 in
                    Coq_existT ((Obj.magic (a.setoid.choose , x0)),
                    (Coq_existT ((Obj.magic (a.setoid.choose , y)),
                    (Coq_existT ((Obj.magic (a.setoid.choose , z)), __))))))
         | Coq_inr p ->
             let rda , rcecb = p in
             let Coq_existT (x1, s0) = rda __ __ in
             let Coq_existT (y1, s1) = s0 in
             let Coq_existT (z1, _) = s1 in
             let Coq_existT (x2, s2) = rcecb __ __ in
             let Coq_existT (y2, s3) = s2 in
             let Coq_existT (z2, _) = s3 in
             Coq_existT ((Obj.magic (x1 , x2)), (Coq_existT
             ((Obj.magic (y1 , y2)), (Coq_existT ((Obj.magic (z1 , z2)),
             __))))))
  | Coq_inr p ->
      let rdb , rceca = p in
      let Coq_existT (x1, s) = rceca __ __ in
      let Coq_existT (y1, s0) = s in
      let Coq_existT (z1, _) = s0 in
      let Coq_existT (x2, s1) = rdb __ __ in
      let Coq_existT (y2, s2) = s1 in
      let Coq_existT (z2, _) = s2 in
      Coq_existT ((Obj.magic (x1 , x2)), (Coq_existT (
      (Obj.magic (y1 , y2)), (Coq_existT ((Obj.magic (z1 , z2)), __)))))

(** val isLeftStrictStable_comp :
    coq_Bisemigroup -> coq_Bisemigroup -> (((coq_IsLeftStrictStable_comp,
    coq_IsLeftStrictStable_comp) sum, coq_LeftDiscrete_comp *
    coq_IsLeftCompEqCancel_comp) sum, coq_LeftDiscrete_comp *
    coq_IsLeftCompEqCancel_comp) sum -> (carrier, (carrier, (carrier, __)
    sigT) sigT) sigT **)

let isLeftStrictStable_comp a b = function
  | Coq_inl s ->
      (match s with
         | Coq_inl s0 ->
             (match s0 with
                | Coq_inl rssa ->
                    let Coq_existT (x0, s1) = rssa __ __ in
                    let Coq_existT (y, s2) = s1 in
                    let Coq_existT (z, _) = s2 in
                    Coq_existT ((Obj.magic (x0 , b.setoid.choose)),
                    (Coq_existT ((Obj.magic (y , b.setoid.choose)),
                    (Coq_existT ((Obj.magic (z , b.setoid.choose)), __)))))
                | Coq_inr rssb ->
                    let Coq_existT (x0, s1) = rssb __ __ in
                    let Coq_existT (y, s2) = s1 in
                    let Coq_existT (z, _) = s2 in
                    Coq_existT ((Obj.magic (a.setoid.choose , x0)),
                    (Coq_existT ((Obj.magic (a.setoid.choose , y)),
                    (Coq_existT ((Obj.magic (a.setoid.choose , z)), __))))))
         | Coq_inr p ->
             let rda , rcecb = p in
             let Coq_existT (x1, s0) = rda __ __ in
             let Coq_existT (y1, s1) = s0 in
             let Coq_existT (z1, _) = s1 in
             let Coq_existT (x2, s2) = rcecb __ __ in
             let Coq_existT (y2, s3) = s2 in
             let Coq_existT (z2, _) = s3 in
             Coq_existT ((Obj.magic (x1 , x2)), (Coq_existT
             ((Obj.magic (y1 , y2)), (Coq_existT ((Obj.magic (z1 , z2)),
             __))))))
  | Coq_inr p ->
      let rdb , rceca = p in
      let Coq_existT (x1, s) = rceca __ __ in
      let Coq_existT (y1, s0) = s in
      let Coq_existT (z1, _) = s0 in
      let Coq_existT (x2, s1) = rdb __ __ in
      let Coq_existT (y2, s2) = s1 in
      let Coq_existT (z2, _) = s2 in
      Coq_existT ((Obj.magic (x1 , x2)), (Coq_existT (
      (Obj.magic (y1 , y2)), (Coq_existT ((Obj.magic (z1 , z2)), __)))))

(** val leftDiscrete_comp :
    coq_Bisemigroup -> coq_Bisemigroup -> (coq_LeftDiscrete_comp,
    coq_LeftDiscrete_comp) sum -> (carrier, (carrier, (carrier, __) sigT)
    sigT) sigT **)

let leftDiscrete_comp a b = function
  | Coq_inl lda ->
      let Coq_existT (x0, s) = lda __ __ in
      let Coq_existT (y, s0) = s in
      let Coq_existT (z, _) = s0 in
      Coq_existT ((Obj.magic (x0 , b.setoid.choose)), (Coq_existT
      ((Obj.magic (y , b.setoid.choose)), (Coq_existT
      ((Obj.magic (z , b.setoid.choose)), __)))))
  | Coq_inr ldb ->
      let Coq_existT (x0, s) = ldb __ __ in
      let Coq_existT (y, s0) = s in
      let Coq_existT (z, _) = s0 in
      Coq_existT ((Obj.magic (a.setoid.choose , x0)), (Coq_existT
      ((Obj.magic (a.setoid.choose , y)), (Coq_existT
      ((Obj.magic (a.setoid.choose , z)), __)))))

(** val rightDiscrete_comp :
    coq_Bisemigroup -> coq_Bisemigroup -> (coq_RightDiscrete_comp,
    coq_RightDiscrete_comp) sum -> (carrier, (carrier, (carrier, __) sigT)
    sigT) sigT **)

let rightDiscrete_comp a b = function
  | Coq_inl lda ->
      let Coq_existT (x0, s) = lda __ __ in
      let Coq_existT (y, s0) = s in
      let Coq_existT (z, _) = s0 in
      Coq_existT ((Obj.magic (x0 , b.setoid.choose)), (Coq_existT
      ((Obj.magic (y , b.setoid.choose)), (Coq_existT
      ((Obj.magic (z , b.setoid.choose)), __)))))
  | Coq_inr ldb ->
      let Coq_existT (x0, s) = ldb __ __ in
      let Coq_existT (y, s0) = s in
      let Coq_existT (z, _) = s0 in
      Coq_existT ((Obj.magic (a.setoid.choose , x0)), (Coq_existT
      ((Obj.magic (a.setoid.choose , y)), (Coq_existT
      ((Obj.magic (a.setoid.choose , z)), __)))))

(** val leftComparable_comp :
    coq_Bisemigroup -> coq_Bisemigroup -> ((coq_LeftComparable_comp,
    coq_LeftComparable_comp) sum, coq_LeftDiscrete_comp *
    coq_LeftDiscrete_comp) sum -> (carrier, (carrier, (carrier, __) sigT)
    sigT) sigT **)

let leftComparable_comp a b = function
  | Coq_inl s ->
      (match s with
         | Coq_inl lca ->
             let Coq_existT (x0, s0) = lca __ __ in
             let Coq_existT (y, s1) = s0 in
             let Coq_existT (z, _) = s1 in
             Coq_existT ((Obj.magic (x0 , b.setoid.choose)), (Coq_existT
             ((Obj.magic (y , b.setoid.choose)), (Coq_existT
             ((Obj.magic (z , b.setoid.choose)), __)))))
         | Coq_inr lcb ->
             let Coq_existT (x0, s0) = lcb __ __ in
             let Coq_existT (y, s1) = s0 in
             let Coq_existT (z, _) = s1 in
             Coq_existT ((Obj.magic (a.setoid.choose , x0)), (Coq_existT
             ((Obj.magic (a.setoid.choose , y)), (Coq_existT
             ((Obj.magic (a.setoid.choose , z)), __))))))
  | Coq_inr p ->
      let lda , ldb = p in
      let Coq_existT (x1, s) = lda __ __ in
      let Coq_existT (y1, s0) = s in
      let Coq_existT (z1, _) = s0 in
      let Coq_existT (x2, s1) = ldb __ __ in
      let Coq_existT (y2, s2) = s1 in
      let Coq_existT (z2, _) = s2 in
      Coq_existT ((Obj.magic (y1 , x2)), (Coq_existT (
      (Obj.magic (x1 , y2)), (Coq_existT ((Obj.magic (z1 , z2)), __)))))

(** val rightComparable_comp :
    coq_Bisemigroup -> coq_Bisemigroup -> ((coq_RightComparable_comp,
    coq_RightComparable_comp) sum, coq_RightDiscrete_comp *
    coq_RightDiscrete_comp) sum -> (carrier, (carrier, (carrier, __) sigT)
    sigT) sigT **)

let rightComparable_comp a b = function
  | Coq_inl s ->
      (match s with
         | Coq_inl lca ->
             let Coq_existT (x0, s0) = lca __ __ in
             let Coq_existT (y, s1) = s0 in
             let Coq_existT (z, _) = s1 in
             Coq_existT ((Obj.magic (x0 , b.setoid.choose)), (Coq_existT
             ((Obj.magic (y , b.setoid.choose)), (Coq_existT
             ((Obj.magic (z , b.setoid.choose)), __)))))
         | Coq_inr lcb ->
             let Coq_existT (x0, s0) = lcb __ __ in
             let Coq_existT (y, s1) = s0 in
             let Coq_existT (z, _) = s1 in
             Coq_existT ((Obj.magic (a.setoid.choose , x0)), (Coq_existT
             ((Obj.magic (a.setoid.choose , y)), (Coq_existT
             ((Obj.magic (a.setoid.choose , z)), __))))))
  | Coq_inr p ->
      let lda , ldb = p in
      let Coq_existT (x1, s) = lda __ __ in
      let Coq_existT (y1, s0) = s in
      let Coq_existT (z1, _) = s0 in
      let Coq_existT (x2, s1) = ldb __ __ in
      let Coq_existT (y2, s2) = s1 in
      let Coq_existT (z2, _) = s2 in
      Coq_existT ((Obj.magic (y1 , x2)), (Coq_existT (
      (Obj.magic (x1 , y2)), (Coq_existT ((Obj.magic (z1 , z2)), __)))))

(** val isRightCompEqCancel_comp :
    coq_Bisemigroup -> coq_Bisemigroup -> ((coq_IsRightCompEqCancel_comp,
    coq_IsRightCompEqCancel_comp) sum, coq_RightCancelative_comp *
    coq_RightCancelative_comp) sum -> (carrier, (carrier, (carrier, __) sigT)
    sigT) sigT **)

let isRightCompEqCancel_comp a b = function
  | Coq_inl s ->
      (match s with
         | Coq_inl lceca ->
             let Coq_existT (x1, s0) = lceca __ __ in
             let Coq_existT (y1, s1) = s0 in
             let Coq_existT (z1, _) = s1 in
             Coq_existT ((Obj.magic (x1 , b.setoid.choose)), (Coq_existT
             ((Obj.magic (y1 , b.setoid.choose)), (Coq_existT
             ((Obj.magic (z1 , b.setoid.choose)), __)))))
         | Coq_inr lcecb ->
             let Coq_existT (x2, s0) = lcecb __ __ in
             let Coq_existT (y2, s1) = s0 in
             let Coq_existT (z2, _) = s1 in
             Coq_existT ((Obj.magic (a.setoid.choose , x2)), (Coq_existT
             ((Obj.magic (a.setoid.choose , y2)), (Coq_existT
             ((Obj.magic (a.setoid.choose , z2)), __))))))
  | Coq_inr p ->
      let r , x0 = p in
      let Coq_existT (a1, s) = r in
      let Coq_existT (b1, s0) = s in
      let Coq_existT (c1, _) = s0 in
      let Coq_existT (a2, s1) = x0 in
      let Coq_existT (b2, s2) = s1 in
      let Coq_existT (c2, _) = s2 in
      let Coq_existT (w, _) = copy_var (a.setoid.equal (a.plus a1 b1) a1) in
      if w
      then let Coq_existT (w0, _) =
             copy_var (b.setoid.equal (b.plus a2 b2) a2)
           in
           if w0
           then Coq_existT ((Obj.magic (a1 , b2)), (Coq_existT
                  ((Obj.magic (b1 , a2)), (Coq_existT (
                  (Obj.magic (c1 , c2)), __)))))
           else Coq_existT ((Obj.magic (a1 , a2)), (Coq_existT
                  ((Obj.magic (b1 , b2)), (Coq_existT (
                  (Obj.magic (c1 , c2)), __)))))
      else let Coq_existT (w0, _) =
             copy_var (b.setoid.equal (b.plus a2 b2) a2)
           in
           if w0
           then Coq_existT ((Obj.magic (a1 , a2)), (Coq_existT
                  ((Obj.magic (b1 , b2)), (Coq_existT (
                  (Obj.magic (c1 , c2)), __)))))
           else Coq_existT ((Obj.magic (a1 , b2)), (Coq_existT
                  ((Obj.magic (b1 , a2)), (Coq_existT (
                  (Obj.magic (c1 , c2)), __)))))

(** val isLeftCompEqCancel_comp :
    coq_Bisemigroup -> coq_Bisemigroup -> ((coq_IsLeftCompEqCancel_comp,
    coq_IsLeftCompEqCancel_comp) sum, coq_LeftCancelative_comp *
    coq_LeftCancelative_comp) sum -> (carrier, (carrier, (carrier, __) sigT)
    sigT) sigT **)

let isLeftCompEqCancel_comp a b = function
  | Coq_inl s ->
      (match s with
         | Coq_inl lceca ->
             let Coq_existT (x1, s0) = lceca __ __ in
             let Coq_existT (y1, s1) = s0 in
             let Coq_existT (z1, _) = s1 in
             Coq_existT ((Obj.magic (x1 , b.setoid.choose)), (Coq_existT
             ((Obj.magic (y1 , b.setoid.choose)), (Coq_existT
             ((Obj.magic (z1 , b.setoid.choose)), __)))))
         | Coq_inr lcecb ->
             let Coq_existT (x2, s0) = lcecb __ __ in
             let Coq_existT (y2, s1) = s0 in
             let Coq_existT (z2, _) = s1 in
             Coq_existT ((Obj.magic (a.setoid.choose , x2)), (Coq_existT
             ((Obj.magic (a.setoid.choose , y2)), (Coq_existT
             ((Obj.magic (a.setoid.choose , z2)), __))))))
  | Coq_inr p ->
      let l , x0 = p in
      let Coq_existT (a1, s) = l in
      let Coq_existT (b1, s0) = s in
      let Coq_existT (c1, _) = s0 in
      let Coq_existT (a2, s1) = x0 in
      let Coq_existT (b2, s2) = s1 in
      let Coq_existT (c2, _) = s2 in
      let Coq_existT (w, _) = copy_var (a.setoid.equal (a.plus a1 b1) a1) in
      if w
      then let Coq_existT (w0, _) =
             copy_var (b.setoid.equal (b.plus a2 b2) a2)
           in
           if w0
           then Coq_existT ((Obj.magic (a1 , b2)), (Coq_existT
                  ((Obj.magic (b1 , a2)), (Coq_existT (
                  (Obj.magic (c1 , c2)), __)))))
           else Coq_existT ((Obj.magic (a1 , a2)), (Coq_existT
                  ((Obj.magic (b1 , b2)), (Coq_existT (
                  (Obj.magic (c1 , c2)), __)))))
      else let Coq_existT (w0, _) =
             copy_var (b.setoid.equal (b.plus a2 b2) a2)
           in
           if w0
           then Coq_existT ((Obj.magic (a1 , a2)), (Coq_existT
                  ((Obj.magic (b1 , b2)), (Coq_existT (
                  (Obj.magic (c1 , c2)), __)))))
           else Coq_existT ((Obj.magic (a1 , b2)), (Coq_existT
                  ((Obj.magic (b1 , a2)), (Coq_existT (
                  (Obj.magic (c1 , c2)), __)))))

(** val leftIncreasing_comp :
    coq_Bisemigroup -> coq_Bisemigroup -> (coq_LeftIncreasing_comp,
    coq_LeftIncreasing_comp) sum -> (carrier, (carrier, __) sigT) sigT **)

let leftIncreasing_comp a b = function
  | Coq_inl la ->
      let Coq_existT (x0, s) = la __ __ in
      let Coq_existT (y, _) = s in
      Coq_existT ((Obj.magic (x0 , b.setoid.choose)), (Coq_existT
      ((Obj.magic (y , b.setoid.choose)), __)))
  | Coq_inr lb ->
      let Coq_existT (x0, s) = lb __ __ in
      let Coq_existT (y, _) = s in
      Coq_existT ((Obj.magic (a.setoid.choose , x0)), (Coq_existT
      ((Obj.magic (a.setoid.choose , y)), __)))

(** val rightIncreasing_comp :
    coq_Bisemigroup -> coq_Bisemigroup -> (coq_RightIncreasing_comp,
    coq_RightIncreasing_comp) sum -> (carrier, (carrier, __) sigT) sigT **)

let rightIncreasing_comp a b = function
  | Coq_inl la ->
      let Coq_existT (x0, s) = la __ __ in
      let Coq_existT (y, _) = s in
      Coq_existT ((Obj.magic (x0 , b.setoid.choose)), (Coq_existT
      ((Obj.magic (y , b.setoid.choose)), __)))
  | Coq_inr lb ->
      let Coq_existT (x0, s) = lb __ __ in
      let Coq_existT (y, _) = s in
      Coq_existT ((Obj.magic (a.setoid.choose , x0)), (Coq_existT
      ((Obj.magic (a.setoid.choose , y)), __)))

(** val leftStrictIncreasing_comp :
    coq_Bisemigroup -> coq_Bisemigroup -> ((coq_LeftIncreasing_comp,
    coq_LeftStrictIncreasing_comp) sum * (coq_LeftStrictIncreasing_comp,
    coq_LeftIncreasing_comp) sum) -> (carrier, (carrier, __) sigT) sigT **)

let leftStrictIncreasing_comp a b = function
  | s , x0 ->
      (match s with
         | Coq_inl la ->
             let Coq_existT (x1, s0) = la __ __ in
             let Coq_existT (y1, _) = s0 in
             Coq_existT ((Obj.magic (x1 , b.setoid.choose)), (Coq_existT
             ((Obj.magic (y1 , b.setoid.choose)), __)))
         | Coq_inr lsb ->
             (match x0 with
                | Coq_inl lsa ->
                    let Coq_existT (x1, s0) = lsa __ __ in
                    let Coq_existT (y1, _) = s0 in
                    let Coq_existT (x2, s1) = lsb __ __ in
                    let Coq_existT (y2, _) = s1 in
                    Coq_existT ((Obj.magic (x1 , x2)), (Coq_existT
                    ((Obj.magic (y1 , y2)), __)))
                | Coq_inr lb ->
                    let Coq_existT (x2, s0) = lb __ __ in
                    let Coq_existT (y2, _) = s0 in
                    Coq_existT ((Obj.magic (a.setoid.choose , x2)),
                    (Coq_existT ((Obj.magic (a.setoid.choose , y2)), __)))))

(** val rightStrictIncreasing_comp :
    coq_Bisemigroup -> coq_Bisemigroup -> ((coq_RightIncreasing_comp,
    coq_RightStrictIncreasing_comp) sum * (coq_RightStrictIncreasing_comp,
    coq_RightIncreasing_comp) sum) -> (carrier, (carrier, __) sigT) sigT **)

let rightStrictIncreasing_comp a b = function
  | s , x0 ->
      (match s with
         | Coq_inl la ->
             let Coq_existT (x1, s0) = la __ __ in
             let Coq_existT (y1, _) = s0 in
             Coq_existT ((Obj.magic (x1 , b.setoid.choose)), (Coq_existT
             ((Obj.magic (y1 , b.setoid.choose)), __)))
         | Coq_inr lsb ->
             (match x0 with
                | Coq_inl lsa ->
                    let Coq_existT (x1, s0) = lsa __ __ in
                    let Coq_existT (y1, _) = s0 in
                    let Coq_existT (x2, s1) = lsb __ __ in
                    let Coq_existT (y2, _) = s1 in
                    Coq_existT ((Obj.magic (x1 , x2)), (Coq_existT
                    ((Obj.magic (y1 , y2)), __)))
                | Coq_inr lb ->
                    let Coq_existT (x2, s0) = lb __ __ in
                    let Coq_existT (y2, _) = s0 in
                    Coq_existT ((Obj.magic (a.setoid.choose , x2)),
                    (Coq_existT ((Obj.magic (a.setoid.choose , y2)), __)))))

(** val isLeftTimesMapToIdConstantPlus_comp :
    coq_Bisemigroup -> coq_Bisemigroup ->
    (coq_IsLeftTimesMapToIdConstantPlus_comp,
    coq_IsLeftTimesMapToIdConstantPlus_comp) sum ->
    coq_IsLeftTimesMapToIdConstantPlus_comp **)

let isLeftTimesMapToIdConstantPlus_comp a b x hasId =
  match x with
    | Coq_inl tica ->
        let Coq_existT (x1, s) =
          tica
            (let Coq_existT (x0, x1) = hasId in
            let ida , idb = Obj.magic x0 in Coq_existT (ida, __))
        in
        let Coq_existT (y1, s0) = s in
        let Coq_existT (z1, _) = s0 in
        let Coq_existT (x0, x2) = hasId in
        let ida , idb = Obj.magic x0 in
        Coq_existT ((Obj.magic (x1 , idb)), (Coq_existT
        ((Obj.magic (y1 , idb)), (Coq_existT ((Obj.magic (z1 , idb)), __)))))
    | Coq_inr ticb ->
        let Coq_existT (x2, s) =
          ticb
            (let Coq_existT (x0, x1) = hasId in
            let ida , idb = Obj.magic x0 in Coq_existT (idb, __))
        in
        let Coq_existT (y2, s0) = s in
        let Coq_existT (z2, _) = s0 in
        let Coq_existT (x0, x1) = hasId in
        let ida , idb = Obj.magic x0 in
        Coq_existT ((Obj.magic (ida , x2)), (Coq_existT
        ((Obj.magic (ida , y2)), (Coq_existT ((Obj.magic (ida , z2)), __)))))

(** val isRightTimesMapToIdConstantPlus_comp :
    coq_Bisemigroup -> coq_Bisemigroup ->
    (coq_IsRightTimesMapToIdConstantPlus_comp,
    coq_IsRightTimesMapToIdConstantPlus_comp) sum ->
    coq_IsRightTimesMapToIdConstantPlus_comp **)

let isRightTimesMapToIdConstantPlus_comp a b x hasId =
  match x with
    | Coq_inl tica ->
        let Coq_existT (x1, s) =
          tica
            (let Coq_existT (x0, x1) = hasId in
            let ida , idb = Obj.magic x0 in Coq_existT (ida, __))
        in
        let Coq_existT (y1, s0) = s in
        let Coq_existT (z1, _) = s0 in
        let Coq_existT (x0, x2) = hasId in
        let ida , idb = Obj.magic x0 in
        Coq_existT ((Obj.magic (x1 , idb)), (Coq_existT
        ((Obj.magic (y1 , idb)), (Coq_existT ((Obj.magic (z1 , idb)), __)))))
    | Coq_inr ticb ->
        let Coq_existT (x2, s) =
          ticb
            (let Coq_existT (x0, x1) = hasId in
            let ida , idb = Obj.magic x0 in Coq_existT (idb, __))
        in
        let Coq_existT (y2, s0) = s in
        let Coq_existT (z2, _) = s0 in
        let Coq_existT (x0, x1) = hasId in
        let ida , idb = Obj.magic x0 in
        Coq_existT ((Obj.magic (ida , x2)), (Coq_existT
        ((Obj.magic (ida , y2)), (Coq_existT ((Obj.magic (ida , z2)), __)))))

(** val plusIdentityIsTimesLeftAnnihilator_comp :
    coq_Bisemigroup -> coq_Bisemigroup ->
    (coq_PlusIdentityIsTimesLeftAnnihilator_comp,
    coq_PlusIdentityIsTimesLeftAnnihilator_comp) sum ->
    coq_PlusIdentityIsTimesLeftAnnihilator_comp **)

let plusIdentityIsTimesLeftAnnihilator_comp a b x hasId =
  match x with
    | Coq_inl tica ->
        let Coq_existT (x1, _) =
          tica
            (let Coq_existT (x0, x1) = hasId in
            let ida , idb = Obj.magic x0 in Coq_existT (ida, __))
        in
        let Coq_existT (x0, x2) = hasId in
        let ida , idb = Obj.magic x0 in
        Coq_existT ((Obj.magic (x1 , idb)), __)
    | Coq_inr ticb ->
        let Coq_existT (x2, _) =
          ticb
            (let Coq_existT (x0, x1) = hasId in
            let ida , idb = Obj.magic x0 in Coq_existT (idb, __))
        in
        let Coq_existT (x0, x1) = hasId in
        let ida , idb = Obj.magic x0 in
        Coq_existT ((Obj.magic (ida , x2)), __)

(** val plusIdentityIsTimesRightAnnihilator_comp :
    coq_Bisemigroup -> coq_Bisemigroup ->
    (coq_PlusIdentityIsTimesRightAnnihilator_comp,
    coq_PlusIdentityIsTimesRightAnnihilator_comp) sum ->
    coq_PlusIdentityIsTimesRightAnnihilator_comp **)

let plusIdentityIsTimesRightAnnihilator_comp a b x hasId =
  match x with
    | Coq_inl tica ->
        let Coq_existT (x1, _) =
          tica
            (let Coq_existT (x0, x1) = hasId in
            let ida , idb = Obj.magic x0 in Coq_existT (ida, __))
        in
        let Coq_existT (x0, x2) = hasId in
        let ida , idb = Obj.magic x0 in
        Coq_existT ((Obj.magic (x1 , idb)), __)
    | Coq_inr ticb ->
        let Coq_existT (x2, _) =
          ticb
            (let Coq_existT (x0, x1) = hasId in
            let ida , idb = Obj.magic x0 in Coq_existT (idb, __))
        in
        let Coq_existT (x0, x1) = hasId in
        let ida , idb = Obj.magic x0 in
        Coq_existT ((Obj.magic (ida , x2)), __)

