open Datatypes
open DecSetoid
open DecSetoidProperties
open Logic0
open Product
open Semigroup
open SemigroupProperties
open Specif

type __ = Obj.t
let __ = let rec f _ = Obj.repr f in Obj.repr f

(** val prod_op :
    coq_Semigroup -> coq_Semigroup -> carrier -> carrier -> carrier **)

let prod_op a b x y =
  let x1 , x2 = Obj.magic x in
  let y1 , y2 = Obj.magic y in Obj.magic ((a.op x1 y1) , (b.op x2 y2))

(** val prodSemigroup : coq_Semigroup -> coq_Semigroup -> coq_Semigroup **)

let prodSemigroup a b =
  { setoid = (prodDecSetoid a.setoid b.setoid); op = (prod_op a b) }

(** val isIdempotent_comp :
    coq_Semigroup -> coq_Semigroup -> (coq_IsIdempotent_comp,
    coq_IsIdempotent_comp) sum -> coq_IsIdempotent_comp **)

let isIdempotent_comp a b = function
  | Coq_inl i ->
      let Coq_existT (a0, _) = i in
      Coq_existT ((Obj.magic (a0 , b.setoid.choose)), __)
  | Coq_inr i ->
      let Coq_existT (b0, _) = i in
      Coq_existT ((Obj.magic (a.setoid.choose , b0)), __)

(** val isSelective_comp :
    coq_Semigroup -> coq_Semigroup -> ((((coq_IsLeft_comp, coq_IsLeft_comp)
    sum * (coq_IsRight_comp, coq_IsRight_comp) sum) * (coq_IsSelective_comp,
    coq_IsSingleton_comp) sum) * (coq_IsSelective_comp, coq_IsSingleton_comp)
    sum) -> coq_IsSelective_comp **)

let isSelective_comp a b = function
  | p , x0 ->
      let p0 , x1 = p in
      let s , x2 = p0 in
      (match s with
         | Coq_inl i ->
             let Coq_existT (x3, s0) = i in
             let Coq_existT (y, _) = s0 in
             (match x2 with
                | Coq_inl i0 ->
                    let Coq_existT (z, s1) = i0 in
                    let Coq_existT (w, _) = s1 in
                    (match x1 with
                       | Coq_inl i1 ->
                           let Coq_existT (a0, s2) = i1 in
                           let Coq_existT (a', _) = s2 in
                           (match x0 with
                              | Coq_inl i2 ->
                                  let Coq_existT (b0, s3) = i2 in
                                  let Coq_existT (b', _) = s3 in
                                  Coq_existT
                                  ((Obj.magic (a0 , b.setoid.choose)),
                                  (Coq_existT
                                  ((Obj.magic (a' , b.setoid.choose)), __)))
                              | Coq_inr ia -> Coq_existT
                                  ((Obj.magic (a0 , b.setoid.choose)),
                                  (Coq_existT
                                  ((Obj.magic (a' , b.setoid.choose)), __))))
                       | Coq_inr ib ->
                           (match x0 with
                              | Coq_inl i1 ->
                                  let Coq_existT (b0, s2) = i1 in
                                  let Coq_existT (b', _) = s2 in
                                  Coq_existT
                                  ((Obj.magic (a.setoid.choose , b0)),
                                  (Coq_existT
                                  ((Obj.magic (a.setoid.choose , b')), __)))
                              | Coq_inr ia ->
                                  (match let x' = b.setoid.choose in
                                         let Coq_existT (y', _) = ib x' in
                                         let Coq_existT (
                                           w0, _) =
                                           copy_var
                                             (b.setoid.equal (b.op x' y') x')
                                         in
                                         if w0
                                         then let Coq_existT (
                                                w1, _) =
                                                copy_var
                                                  (b.setoid.equal
                                                  (b.op x' y') y')
                                              in
                                              if w1
                                              then 
                                                assert false
                                                  (* absurd case *)
                                              else 
                                                Coq_inr (Coq_existT (x',
                                                  (Coq_existT (y', __))))
                                         else let Coq_existT (
                                                w1, _) =
                                                copy_var
                                                  (b.setoid.equal
                                                  (b.op x' y') y')
                                              in
                                              Coq_inl (Coq_existT (x',
                                              (Coq_existT (y', __)))) with
                                     | Coq_inl i1 ->
                                         let Coq_existT (b1, s2) = i1 in
                                         let Coq_existT (b2, _) = s2 in
                                         Coq_existT (
                                         (Obj.magic (z , b1)), (Coq_existT
                                         ((Obj.magic (w , b2)), __)))
                                     | Coq_inr i1 ->
                                         let Coq_existT (b1, s2) = i1 in
                                         let Coq_existT (b2, _) = s2 in
                                         Coq_existT (
                                         (Obj.magic (x3 , b1)), (Coq_existT
                                         ((Obj.magic (y , b2)), __))))))
                | Coq_inr i0 ->
                    let Coq_existT (z, s1) = i0 in
                    let Coq_existT (w, _) = s1 in
                    (match x1 with
                       | Coq_inl i1 ->
                           let Coq_existT (a0, s2) = i1 in
                           let Coq_existT (a', _) = s2 in
                           (match x0 with
                              | Coq_inl i2 ->
                                  let Coq_existT (b0, s3) = i2 in
                                  let Coq_existT (b', _) = s3 in
                                  Coq_existT
                                  ((Obj.magic (a0 , b.setoid.choose)),
                                  (Coq_existT
                                  ((Obj.magic (a' , b.setoid.choose)), __)))
                              | Coq_inr ia -> Coq_existT
                                  ((Obj.magic (a0 , b.setoid.choose)),
                                  (Coq_existT
                                  ((Obj.magic (a' , b.setoid.choose)), __))))
                       | Coq_inr ib ->
                           (match x0 with
                              | Coq_inl i1 ->
                                  let Coq_existT (b0, s2) = i1 in
                                  let Coq_existT (b', _) = s2 in
                                  Coq_existT
                                  ((Obj.magic (a.setoid.choose , b0)),
                                  (Coq_existT
                                  ((Obj.magic (a.setoid.choose , b')), __)))
                              | Coq_inr ia -> Coq_existT
                                  ((Obj.magic (x3 , z)), (Coq_existT
                                  ((Obj.magic (y , w)), __))))))
         | Coq_inr i ->
             let Coq_existT (x3, s0) = i in
             let Coq_existT (y, _) = s0 in
             (match x2 with
                | Coq_inl i0 ->
                    let Coq_existT (z, s1) = i0 in
                    let Coq_existT (w, _) = s1 in
                    (match x1 with
                       | Coq_inl i1 ->
                           let Coq_existT (a0, s2) = i1 in
                           let Coq_existT (a', _) = s2 in
                           (match x0 with
                              | Coq_inl i2 ->
                                  let Coq_existT (b0, s3) = i2 in
                                  let Coq_existT (b', _) = s3 in
                                  Coq_existT
                                  ((Obj.magic (a0 , b.setoid.choose)),
                                  (Coq_existT
                                  ((Obj.magic (a' , b.setoid.choose)), __)))
                              | Coq_inr ia -> Coq_existT
                                  ((Obj.magic (a0 , b.setoid.choose)),
                                  (Coq_existT
                                  ((Obj.magic (a' , b.setoid.choose)), __))))
                       | Coq_inr ib ->
                           (match x0 with
                              | Coq_inl i1 ->
                                  let Coq_existT (b0, s2) = i1 in
                                  let Coq_existT (b', _) = s2 in
                                  Coq_existT
                                  ((Obj.magic (a.setoid.choose , b0)),
                                  (Coq_existT
                                  ((Obj.magic (a.setoid.choose , b')), __)))
                              | Coq_inr ia -> Coq_existT
                                  ((Obj.magic (z , x3)), (Coq_existT
                                  ((Obj.magic (w , y)), __)))))
                | Coq_inr i0 ->
                    let Coq_existT (z, s1) = i0 in
                    let Coq_existT (w, _) = s1 in
                    (match x1 with
                       | Coq_inl i1 ->
                           let Coq_existT (a0, s2) = i1 in
                           let Coq_existT (a', _) = s2 in
                           (match x0 with
                              | Coq_inl i2 ->
                                  let Coq_existT (b0, s3) = i2 in
                                  let Coq_existT (b', _) = s3 in
                                  Coq_existT
                                  ((Obj.magic (a0 , b.setoid.choose)),
                                  (Coq_existT
                                  ((Obj.magic (a' , b.setoid.choose)), __)))
                              | Coq_inr ia -> Coq_existT
                                  ((Obj.magic (a0 , b.setoid.choose)),
                                  (Coq_existT
                                  ((Obj.magic (a' , b.setoid.choose)), __))))
                       | Coq_inr ib ->
                           (match x0 with
                              | Coq_inl i1 ->
                                  let Coq_existT (b0, s2) = i1 in
                                  let Coq_existT (b', _) = s2 in
                                  Coq_existT
                                  ((Obj.magic (a.setoid.choose , b0)),
                                  (Coq_existT
                                  ((Obj.magic (a.setoid.choose , b')), __)))
                              | Coq_inr ia ->
                                  (match let x' = a.setoid.choose in
                                         let Coq_existT (y', _) = ia x' in
                                         let Coq_existT (
                                           w0, _) =
                                           copy_var
                                             (a.setoid.equal (a.op x' y') x')
                                         in
                                         if w0
                                         then let Coq_existT (
                                                w1, _) =
                                                copy_var
                                                  (a.setoid.equal
                                                  (a.op x' y') y')
                                              in
                                              if w1
                                              then 
                                                assert false
                                                  (* absurd case *)
                                              else 
                                                Coq_inr (Coq_existT (x',
                                                  (Coq_existT (y', __))))
                                         else let Coq_existT (
                                                w1, _) =
                                                copy_var
                                                  (a.setoid.equal
                                                  (a.op x' y') y')
                                              in
                                              Coq_inl (Coq_existT (x',
                                              (Coq_existT (y', __)))) with
                                     | Coq_inl i1 ->
                                         let Coq_existT (a1, s2) = i1 in
                                         let Coq_existT (a2, _) = s2 in
                                         Coq_existT (
                                         (Obj.magic (a1 , z)), (Coq_existT
                                         ((Obj.magic (a2 , w)), __)))
                                     | Coq_inr i1 ->
                                         let Coq_existT (a1, s2) = i1 in
                                         let Coq_existT (a2, _) = s2 in
                                         Coq_existT (
                                         (Obj.magic (a1 , x3)), (Coq_existT
                                         ((Obj.magic (a2 , y)), __))))))))

(** val isCommutative_comp :
    coq_Semigroup -> coq_Semigroup -> (coq_IsCommutative_comp,
    coq_IsCommutative_comp) sum -> coq_IsCommutative_comp **)

let isCommutative_comp a b = function
  | Coq_inl i ->
      let Coq_existT (x1, s) = i in
      let Coq_existT (x2, _) = s in
      Coq_existT ((Obj.magic (x1 , b.setoid.choose)), (Coq_existT
      ((Obj.magic (x2 , b.setoid.choose)), __)))
  | Coq_inr i ->
      let Coq_existT (y1, s) = i in
      let Coq_existT (y2, _) = s in
      Coq_existT ((Obj.magic (a.setoid.choose , y1)), (Coq_existT
      ((Obj.magic (a.setoid.choose , y2)), __)))

(** val hasIdentity :
    coq_Semigroup -> coq_Semigroup -> (coq_HasIdentity * coq_HasIdentity) ->
    coq_HasIdentity **)

let hasIdentity a b = function
  | h , x0 ->
      let Coq_existT (a0, _) = h in
      let Coq_existT (b0, _) = x0 in Coq_existT ((Obj.magic (a0 , b0)), __)

(** val hasIdentity_comp :
    coq_Semigroup -> coq_Semigroup -> (coq_HasIdentity_comp,
    coq_HasIdentity_comp) sum -> coq_HasIdentity_comp **)

let hasIdentity_comp a b x i =
  match x with
    | Coq_inl ia ->
        let x1 , x2 = Obj.magic i in
        let Coq_existT (a0, _) = ia x1 in
        Coq_existT ((Obj.magic (a0 , b.setoid.choose)), __)
    | Coq_inr ib ->
        let x1 , x2 = Obj.magic i in
        let Coq_existT (b0, _) = ib x2 in
        Coq_existT ((Obj.magic (a.setoid.choose , b0)), __)

(** val hasAnnihilator :
    coq_Semigroup -> coq_Semigroup -> (coq_HasAnnihilator *
    coq_HasAnnihilator) -> coq_HasAnnihilator **)

let hasAnnihilator a b = function
  | h , x0 ->
      let Coq_existT (a0, _) = h in
      let Coq_existT (b0, _) = x0 in Coq_existT ((Obj.magic (a0 , b0)), __)

(** val hasAnnihilator_comp :
    coq_Semigroup -> coq_Semigroup -> (coq_HasAnnihilator_comp,
    coq_HasAnnihilator_comp) sum -> coq_HasAnnihilator_comp **)

let hasAnnihilator_comp a b x w =
  match x with
    | Coq_inl aa ->
        let x1 , x2 = Obj.magic w in
        let Coq_existT (a0, _) = aa x1 in
        Coq_existT ((Obj.magic (a0 , b.setoid.choose)), __)
    | Coq_inr ab ->
        let x1 , x2 = Obj.magic w in
        let Coq_existT (b0, _) = ab x2 in
        Coq_existT ((Obj.magic (a.setoid.choose , b0)), __)

(** val isLeft_comp :
    coq_Semigroup -> coq_Semigroup -> (coq_IsLeft_comp, coq_IsLeft_comp) sum
    -> coq_IsLeft_comp **)

let isLeft_comp a b = function
  | Coq_inl i ->
      let Coq_existT (a0, s) = i in
      let Coq_existT (a', _) = s in
      Coq_existT ((Obj.magic (a0 , b.setoid.choose)), (Coq_existT
      ((Obj.magic (a' , b.setoid.choose)), __)))
  | Coq_inr i ->
      let Coq_existT (b0, s) = i in
      let Coq_existT (b', _) = s in
      Coq_existT ((Obj.magic (a.setoid.choose , b0)), (Coq_existT
      ((Obj.magic (a.setoid.choose , b')), __)))

(** val isRight_comp :
    coq_Semigroup -> coq_Semigroup -> (coq_IsRight_comp, coq_IsRight_comp)
    sum -> coq_IsRight_comp **)

let isRight_comp a b = function
  | Coq_inl i ->
      let Coq_existT (a0, s) = i in
      let Coq_existT (a', _) = s in
      Coq_existT ((Obj.magic (a0 , b.setoid.choose)), (Coq_existT
      ((Obj.magic (a' , b.setoid.choose)), __)))
  | Coq_inr i ->
      let Coq_existT (b0, s) = i in
      let Coq_existT (b', _) = s in
      Coq_existT ((Obj.magic (a.setoid.choose , b0)), (Coq_existT
      ((Obj.magic (a.setoid.choose , b')), __)))

(** val leftCondensed_comp :
    coq_Semigroup -> coq_Semigroup -> (coq_LeftCondensed_comp,
    coq_LeftCondensed_comp) sum -> coq_LeftCondensed_comp **)

let leftCondensed_comp a b = function
  | Coq_inl l ->
      let Coq_existT (x0, s) = l in
      let Coq_existT (y, s0) = s in
      let Coq_existT (z, _) = s0 in
      Coq_existT ((Obj.magic (x0 , b.setoid.choose)), (Coq_existT
      ((Obj.magic (y , b.setoid.choose)), (Coq_existT
      ((Obj.magic (z , b.setoid.choose)), __)))))
  | Coq_inr l ->
      let Coq_existT (x0, s) = l in
      let Coq_existT (y, s0) = s in
      let Coq_existT (z, _) = s0 in
      Coq_existT ((Obj.magic (a.setoid.choose , x0)), (Coq_existT
      ((Obj.magic (a.setoid.choose , y)), (Coq_existT
      ((Obj.magic (a.setoid.choose , z)), __)))))

(** val rightCondensed_comp :
    coq_Semigroup -> coq_Semigroup -> (coq_RightCondensed_comp,
    coq_RightCondensed_comp) sum -> coq_RightCondensed_comp **)

let rightCondensed_comp a b = function
  | Coq_inl r ->
      let Coq_existT (x0, s) = r in
      let Coq_existT (y, s0) = s in
      let Coq_existT (z, _) = s0 in
      Coq_existT ((Obj.magic (x0 , b.setoid.choose)), (Coq_existT
      ((Obj.magic (y , b.setoid.choose)), (Coq_existT
      ((Obj.magic (z , b.setoid.choose)), __)))))
  | Coq_inr r ->
      let Coq_existT (x0, s) = r in
      let Coq_existT (y, s0) = s in
      let Coq_existT (z, _) = s0 in
      Coq_existT ((Obj.magic (a.setoid.choose , x0)), (Coq_existT
      ((Obj.magic (a.setoid.choose , y)), (Coq_existT
      ((Obj.magic (a.setoid.choose , z)), __)))))

(** val leftCancelative_comp :
    coq_Semigroup -> coq_Semigroup -> (coq_LeftCancelative_comp,
    coq_LeftCancelative_comp) sum -> coq_LeftCancelative_comp **)

let leftCancelative_comp a b = function
  | Coq_inl l ->
      let Coq_existT (x1, s) = l in
      let Coq_existT (y1, s0) = s in
      let Coq_existT (z1, _) = s0 in
      Coq_existT ((Obj.magic (x1 , b.setoid.choose)), (Coq_existT
      ((Obj.magic (y1 , b.setoid.choose)), (Coq_existT
      ((Obj.magic (z1 , b.setoid.choose)), __)))))
  | Coq_inr l ->
      let Coq_existT (x2, s) = l in
      let Coq_existT (y2, s0) = s in
      let Coq_existT (z2, _) = s0 in
      Coq_existT ((Obj.magic (a.setoid.choose , x2)), (Coq_existT
      ((Obj.magic (a.setoid.choose , y2)), (Coq_existT
      ((Obj.magic (a.setoid.choose , z2)), __)))))

(** val rightCancelative_comp :
    coq_Semigroup -> coq_Semigroup -> (coq_RightCancelative_comp,
    coq_RightCancelative_comp) sum -> coq_RightCancelative_comp **)

let rightCancelative_comp a b = function
  | Coq_inl r ->
      let Coq_existT (x1, s) = r in
      let Coq_existT (y1, s0) = s in
      let Coq_existT (z1, _) = s0 in
      Coq_existT ((Obj.magic (x1 , b.setoid.choose)), (Coq_existT
      ((Obj.magic (y1 , b.setoid.choose)), (Coq_existT
      ((Obj.magic (z1 , b.setoid.choose)), __)))))
  | Coq_inr r ->
      let Coq_existT (x2, s) = r in
      let Coq_existT (y2, s0) = s in
      let Coq_existT (z2, _) = s0 in
      Coq_existT ((Obj.magic (a.setoid.choose , x2)), (Coq_existT
      ((Obj.magic (a.setoid.choose , y2)), (Coq_existT
      ((Obj.magic (a.setoid.choose , z2)), __)))))

(** val antiLeft_comp :
    coq_Semigroup -> coq_Semigroup -> (coq_AntiLeft_comp * coq_AntiLeft_comp)
    -> coq_AntiLeft_comp **)

let antiLeft_comp a b = function
  | a0 , x0 ->
      let Coq_existT (x1, s) = a0 in
      let Coq_existT (y1, _) = s in
      let Coq_existT (x2, s0) = x0 in
      let Coq_existT (y2, _) = s0 in
      Coq_existT ((Obj.magic (x1 , x2)), (Coq_existT (
      (Obj.magic (y1 , y2)), __)))

(** val antiRight_comp :
    coq_Semigroup -> coq_Semigroup -> (coq_AntiRight_comp *
    coq_AntiRight_comp) -> coq_AntiRight_comp **)

let antiRight_comp a b = function
  | a0 , x0 ->
      let Coq_existT (x1, s) = a0 in
      let Coq_existT (y1, _) = s in
      let Coq_existT (x2, s0) = x0 in
      let Coq_existT (y2, _) = s0 in
      Coq_existT ((Obj.magic (x1 , x2)), (Coq_existT (
      (Obj.magic (y1 , y2)), __)))

(** val treeGlb_comp :
    coq_Semigroup -> coq_Semigroup -> ((coq_TreeGlb_comp,
    coq_IsSingleton_comp) sum * (coq_TreeGlb_comp, coq_IsSingleton_comp) sum)
    -> (carrier, (carrier, (carrier, __) sigT) sigT) sigT **)

let treeGlb_comp a b = function
  | s , x0 ->
      (match s with
         | Coq_inl ta ->
             let b0 = b.setoid.choose in
             let Coq_existT (x1, s0) = ta __ __ in
             let Coq_existT (y1, s1) = s0 in
             let Coq_existT (z1, _) = s1 in
             Coq_existT ((Obj.magic (x1 , b0)), (Coq_existT
             ((Obj.magic (y1 , b0)), (Coq_existT ((Obj.magic (z1 , b0)),
             __)))))
         | Coq_inr sgb ->
             (match x0 with
                | Coq_inl tb ->
                    let a0 = a.setoid.choose in
                    let Coq_existT (x2, s0) = tb __ __ in
                    let Coq_existT (y2, s1) = s0 in
                    let Coq_existT (z2, _) = s1 in
                    Coq_existT ((Obj.magic (a0 , x2)), (Coq_existT
                    ((Obj.magic (a0 , y2)), (Coq_existT
                    ((Obj.magic (a0 , z2)), __)))))
                | Coq_inr sga ->
                    let a0 = a.setoid.choose in
                    let b0 = b.setoid.choose in
                    let Coq_existT (c, _) = sga a0 in
                    let Coq_existT (d, _) = sgb b0 in
                    let Coq_existT (w, _) =
                      copy_var (a.setoid.equal (a.op a0 c) a0)
                    in
                    if w
                    then let Coq_existT (w0, _) =
                           copy_var (b.setoid.equal (b.op b0 d) b0)
                         in
                         if w0
                         then Coq_existT ((Obj.magic (c , b0)), (Coq_existT
                                ((Obj.magic (a0 , d)), (Coq_existT
                                ((Obj.magic (c , d)), __)))))
                         else Coq_existT ((Obj.magic (c , d)), (Coq_existT
                                ((Obj.magic (a0 , b0)), (Coq_existT
                                ((Obj.magic (c , b0)), __)))))
                    else let Coq_existT (w0, _) =
                           copy_var (b.setoid.equal (b.op b0 d) b0)
                         in
                         if w0
                         then Coq_existT ((Obj.magic (a0 , b0)), (Coq_existT
                                ((Obj.magic (c , d)), (Coq_existT
                                ((Obj.magic (a0 , d)), __)))))
                         else Coq_existT ((Obj.magic (a0 , d)), (Coq_existT
                                ((Obj.magic (c , b0)), (Coq_existT
                                ((Obj.magic (a0 , b0)), __)))))))

