open DecSetoid
open Specif

type __ = Obj.t
let __ = let rec f _ = Obj.repr f in Obj.repr f

type coq_Preorder = { setoid : coq_DecSetoid;
                      le : (carrier -> carrier -> bool) }

(** val coq_Preorder_rect :
    (coq_DecSetoid -> (carrier -> carrier -> bool) -> __ -> __ -> __ -> 'a1)
    -> coq_Preorder -> 'a1 **)

let coq_Preorder_rect f p =
  let { setoid = x; le = x0 } = p in f x x0 __ __ __

(** val coq_Preorder_rec :
    (coq_DecSetoid -> (carrier -> carrier -> bool) -> __ -> __ -> __ -> 'a1)
    -> coq_Preorder -> 'a1 **)

let coq_Preorder_rec f p =
  let { setoid = x; le = x0 } = p in f x x0 __ __ __

(** val setoid : coq_Preorder -> coq_DecSetoid **)

let setoid x = x.setoid

(** val le : coq_Preorder -> carrier -> carrier -> bool **)

let le x = x.le

(** val coq_IsProIso_rect :
    coq_Preorder -> coq_Preorder -> coq_DsIso -> (__ -> __ -> 'a1) -> 'a1 **)

let coq_IsProIso_rect p p' dsIso0 f =
  f __ __

(** val coq_IsProIso_rec :
    coq_Preorder -> coq_Preorder -> coq_DsIso -> (__ -> __ -> 'a1) -> 'a1 **)

let coq_IsProIso_rec p p' dsIso0 f =
  f __ __

type coq_ProIso =
  coq_DsIso
  (* singleton inductive, whose constructor was Build_ProIso *)

(** val coq_ProIso_rect :
    coq_Preorder -> coq_Preorder -> (coq_DsIso -> __ -> 'a1) -> coq_ProIso ->
    'a1 **)

let coq_ProIso_rect p p' f p0 =
  f p0 __

(** val coq_ProIso_rec :
    coq_Preorder -> coq_Preorder -> (coq_DsIso -> __ -> 'a1) -> coq_ProIso ->
    'a1 **)

let coq_ProIso_rec p p' f p0 =
  f p0 __

(** val dsIso : coq_Preorder -> coq_Preorder -> coq_ProIso -> coq_DsIso **)

let dsIso p p' p0 =
  p0

(** val coq_ProIso_refl : coq_Preorder -> coq_ProIso **)

let coq_ProIso_refl p =
  { phi = (fun x -> x); phi' = (fun x -> x) }

(** val coq_ProIso_sym :
    coq_Preorder -> coq_Preorder -> coq_ProIso -> coq_ProIso **)

let coq_ProIso_sym p p' i =
  { phi = i.phi'; phi' = i.phi }

(** val coq_ProIso_trans :
    coq_Preorder -> coq_Preorder -> coq_Preorder -> coq_ProIso -> coq_ProIso
    -> coq_ProIso **)

let coq_ProIso_trans p p' p'' i i' =
  coq_DsIso_trans p.setoid p'.setoid p''.setoid i i'

(** val liftProIso :
    coq_DecSetoid -> coq_Preorder -> coq_DsIso -> (coq_Preorder, coq_ProIso *
    __) sigT **)

let liftProIso a b iso =
  Coq_existT ({ setoid = a; le = (fun x y -> b.le (iso.phi x) (iso.phi y)) },
    ({ phi = iso.phi; phi' = iso.phi' } , __))

