open DecSetoid
open DecSetoidProperties
open List0
open Semigroup
open SemigroupProperties
open Seq
open Specif

let __ = let rec f _ = Obj.repr f in Obj.repr f

(** val prefix : coq_DecSetoid -> carrier -> carrier -> carrier **)

let rec prefix a x y =
  match Obj.magic x with
    | [] -> Obj.magic []
    | a0 :: x' ->
        (match Obj.magic y with
           | [] -> Obj.magic []
           | b :: y' ->
               if a.equal a0 b
               then Obj.magic (a0 ::
                      (Obj.magic (fun x0 x1 -> prefix a x0 x1) x' y'))
               else Obj.magic [])

(** val prefixSemigroup : coq_DecSetoid -> coq_Semigroup **)

let prefixSemigroup a =
  { setoid = (seqDecSetoid a); op = (prefix a) }

(** val isSelective_comp :
    coq_DecSetoid -> coq_IsSingleton_comp -> coq_IsSelective_comp **)

let isSelective_comp a sg =
  let a0 = a.choose in
  let Coq_existT (b, _) = sg a0 in
  Coq_existT ((Obj.magic (a0 :: [])), (Coq_existT (
  (Obj.magic (b :: [])), __)))

(** val hasIdentity_comp : coq_DecSetoid -> coq_HasIdentity_comp **)

let hasIdentity_comp a x =
  Coq_existT ((Obj.magic (app (Obj.magic x) (a.choose :: []))), __)

(** val hasAnnihilator : coq_DecSetoid -> coq_HasAnnihilator **)

let hasAnnihilator a =
  Coq_existT ((Obj.magic []), __)

(** val isLeft_comp : coq_DecSetoid -> coq_IsLeft_comp **)

let isLeft_comp a =
  Coq_existT ((Obj.magic (a.choose :: [])), (Coq_existT (
    (Obj.magic []), __)))

(** val isRight_comp : coq_DecSetoid -> coq_IsRight_comp **)

let isRight_comp a =
  Coq_existT ((Obj.magic []), (Coq_existT ((Obj.magic (a.choose :: [])),
    __)))

(** val leftCondensed_comp : coq_DecSetoid -> coq_LeftCondensed_comp **)

let leftCondensed_comp a =
  let a0 = a.choose in
  Coq_existT ((Obj.magic (a0 :: [])), (Coq_existT (
  (Obj.magic []), (Coq_existT ((Obj.magic (a0 :: [])), __)))))

(** val rightCondensed_comp : coq_DecSetoid -> coq_RightCondensed_comp **)

let rightCondensed_comp a =
  let a0 = a.choose in
  Coq_existT ((Obj.magic (a0 :: [])), (Coq_existT (
  (Obj.magic []), (Coq_existT ((Obj.magic (a0 :: [])), __)))))

(** val leftCancelative_comp : coq_DecSetoid -> coq_LeftCancelative_comp **)

let leftCancelative_comp a =
  Coq_existT ((Obj.magic []), (Coq_existT ((Obj.magic (a.choose :: [])),
    (Coq_existT ((Obj.magic []), __)))))

(** val rightCancelative_comp :
    coq_DecSetoid -> coq_RightCancelative_comp **)

let rightCancelative_comp a =
  Coq_existT ((Obj.magic []), (Coq_existT ((Obj.magic (a.choose :: [])),
    (Coq_existT ((Obj.magic []), __)))))

(** val antiLeft_comp : coq_DecSetoid -> coq_AntiLeft_comp **)

let antiLeft_comp a =
  Coq_existT ((Obj.magic []), (Coq_existT ((Obj.magic []), __)))

(** val antiRight_comp : coq_DecSetoid -> coq_AntiRight_comp **)

let antiRight_comp a =
  Coq_existT ((Obj.magic []), (Coq_existT ((Obj.magic []), __)))

