open DecSetoid
open Preorder
open Semigroup
open Specif

type __ = Obj.t
let __ = let rec f _ = Obj.repr f in Obj.repr f

type coq_OrderSemigroup = { setoid : coq_DecSetoid;
                            le : (carrier -> carrier -> bool);
                            op : (carrier -> carrier -> carrier) }

(** val coq_OrderSemigroup_rect :
    (coq_DecSetoid -> (carrier -> carrier -> bool) -> __ -> __ -> __ ->
    (carrier -> carrier -> carrier) -> __ -> __ -> 'a1) -> coq_OrderSemigroup
    -> 'a1 **)

let coq_OrderSemigroup_rect f o =
  let { setoid = x; le = x0; op = x1 } = o in f x x0 __ __ __ x1 __ __

(** val coq_OrderSemigroup_rec :
    (coq_DecSetoid -> (carrier -> carrier -> bool) -> __ -> __ -> __ ->
    (carrier -> carrier -> carrier) -> __ -> __ -> 'a1) -> coq_OrderSemigroup
    -> 'a1 **)

let coq_OrderSemigroup_rec f o =
  let { setoid = x; le = x0; op = x1 } = o in f x x0 __ __ __ x1 __ __

(** val setoid : coq_OrderSemigroup -> coq_DecSetoid **)

let setoid x = x.setoid

(** val le : coq_OrderSemigroup -> carrier -> carrier -> bool **)

let le x = x.le

(** val op : coq_OrderSemigroup -> carrier -> carrier -> carrier **)

let op x = x.op

(** val preorderOS : coq_OrderSemigroup -> coq_Preorder **)

let preorderOS os =
  { Preorder.setoid = os.setoid; Preorder.le = os.le }

(** val semigroupOS : coq_OrderSemigroup -> coq_Semigroup **)

let semigroupOS os =
  { Semigroup.setoid = os.setoid; Semigroup.op = os.op }

(** val coq_IsOSmgIso_rect :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_DsIso -> (__ -> __ -> __
    -> __ -> 'a1) -> 'a1 **)

let coq_IsOSmgIso_rect o o' dsIso0 f =
  f __ __ __ __

(** val coq_IsOSmgIso_rec :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_DsIso -> (__ -> __ -> __
    -> __ -> 'a1) -> 'a1 **)

let coq_IsOSmgIso_rec o o' dsIso0 f =
  f __ __ __ __

type coq_OSmgIso =
  coq_DsIso
  (* singleton inductive, whose constructor was Build_OSmgIso *)

(** val coq_OSmgIso_rect :
    coq_OrderSemigroup -> coq_OrderSemigroup -> (coq_DsIso -> __ -> 'a1) ->
    coq_OSmgIso -> 'a1 **)

let coq_OSmgIso_rect o o' f o0 =
  f o0 __

(** val coq_OSmgIso_rec :
    coq_OrderSemigroup -> coq_OrderSemigroup -> (coq_DsIso -> __ -> 'a1) ->
    coq_OSmgIso -> 'a1 **)

let coq_OSmgIso_rec o o' f o0 =
  f o0 __

(** val dsIso :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_OSmgIso -> coq_DsIso **)

let dsIso o o' o0 =
  o0

(** val coq_SmgOSmgIso :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_OSmgIso -> coq_SmgIso **)

let coq_SmgOSmgIso o o' iso =
  iso

(** val coq_ProOSmgIso :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_OSmgIso -> coq_ProIso **)

let coq_ProOSmgIso o o' iso =
  iso

(** val coq_OSmgIso_refl : coq_OrderSemigroup -> coq_OSmgIso **)

let coq_OSmgIso_refl o =
  { phi = (fun x -> x); phi' = (fun x -> x) }

(** val coq_OSmgIso_sym :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_OSmgIso -> coq_OSmgIso **)

let coq_OSmgIso_sym o o' i =
  { phi = i.phi'; phi' = i.phi }

(** val coq_OSmgIso_trans :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_OrderSemigroup ->
    coq_OSmgIso -> coq_OSmgIso -> coq_OSmgIso **)

let coq_OSmgIso_trans o o' o'' i i' =
  coq_DsIso_trans o.setoid o'.setoid o''.setoid i i'

(** val liftOSmgIso :
    coq_DecSetoid -> coq_OrderSemigroup -> coq_DsIso -> (coq_OrderSemigroup,
    coq_OSmgIso * __) sigT **)

let liftOSmgIso a b iso =
  Coq_existT ({ setoid = a; le = (fun x y -> b.le (iso.phi x) (iso.phi y));
    op = (fun x y -> iso.phi' (b.op (iso.phi x) (iso.phi y))) }, ({ phi =
    iso.phi; phi' = iso.phi' } , __))

