open Datatypes
open Max
open Nat
open Semigroup
open SemigroupProperties
open Specif

let __ = let rec f _ = Obj.repr f in Obj.repr f

(** val natMaxSemigroup : coq_Semigroup **)

let natMaxSemigroup =
  { setoid = natDecSetoid; op = (Obj.magic max) }

(** val hasIdentity : coq_HasIdentity **)

let hasIdentity =
  Coq_existT ((Obj.magic O), __)

(** val hasAnnihilator_comp : coq_HasAnnihilator_comp **)

let hasAnnihilator_comp c =
  Coq_existT ((Obj.magic (S (Obj.magic c))), __)

(** val isLeft_comp : coq_IsLeft_comp **)

let isLeft_comp =
  Coq_existT ((Obj.magic O), (Coq_existT ((Obj.magic (S O)), __)))

(** val isRight_comp : coq_IsRight_comp **)

let isRight_comp =
  Coq_existT ((Obj.magic (S O)), (Coq_existT ((Obj.magic O), __)))

(** val leftCondensed_comp : coq_LeftCondensed_comp **)

let leftCondensed_comp =
  Coq_existT ((Obj.magic O), (Coq_existT ((Obj.magic (S O)), (Coq_existT
    ((Obj.magic O), __)))))

(** val rightCondensed_comp : coq_RightCondensed_comp **)

let rightCondensed_comp =
  Coq_existT ((Obj.magic O), (Coq_existT ((Obj.magic (S O)), (Coq_existT
    ((Obj.magic O), __)))))

(** val leftCancelative_comp : coq_LeftCancelative_comp **)

let leftCancelative_comp =
  Coq_existT ((Obj.magic O), (Coq_existT ((Obj.magic (S O)), (Coq_existT
    ((Obj.magic (S O)), __)))))

(** val rightCancelative_comp : coq_RightCancelative_comp **)

let rightCancelative_comp =
  Coq_existT ((Obj.magic O), (Coq_existT ((Obj.magic (S O)), (Coq_existT
    ((Obj.magic (S O)), __)))))

(** val antiLeft_comp : coq_AntiLeft_comp **)

let antiLeft_comp =
  Coq_existT ((Obj.magic O), (Coq_existT ((Obj.magic O), __)))

(** val antiRight_comp : coq_AntiRight_comp **)

let antiRight_comp =
  Coq_existT ((Obj.magic O), (Coq_existT ((Obj.magic O), __)))

