open Datatypes
open DecSetoid
open DecSetoidProperties
open EqNat
open Peano
open Specif

let __ = let rec f _ = Obj.repr f in Obj.repr f

(** val natDecSetoid : coq_DecSetoid **)

let natDecSetoid =
  { choose = (Obj.magic O); equal = (Obj.magic beq_nat) }

(** val isSingleton_comp : coq_IsSingleton_comp **)

let isSingleton_comp c =
  match Obj.magic c with
    | O -> Coq_existT ((Obj.magic (S O)), __)
    | S x -> Coq_existT ((Obj.magic O), __)

(** val twoElements_comp : coq_TwoElements_comp **)

let twoElements_comp a b =
  match Obj.magic a with
    | O ->
        (match Obj.magic b with
           | O -> Coq_existT ((Obj.magic (S O)), __)
           | S n ->
               (match n with
                  | O -> Coq_existT ((Obj.magic (S (S O))), __)
                  | S y -> Coq_existT ((Obj.magic (S O)), __)))
    | S n ->
        (match n with
           | O ->
               (match Obj.magic b with
                  | O -> Coq_existT ((Obj.magic (S (S O))), __)
                  | S n0 -> Coq_existT ((Obj.magic O), __))
           | S x ->
               (match Obj.magic b with
                  | O -> Coq_existT ((Obj.magic (S O)), __)
                  | S n0 -> Coq_existT ((Obj.magic O), __)))

(** val finite_comp : coq_Finite_comp **)

let finite_comp l =
  let Coq_existT (x, _) =
    let rec f = function
      | [] -> Coq_existT (O, __)
      | a :: l1 ->
          let Coq_existT (x, _) = f l1 in
          Coq_existT ((plus x (Obj.magic a)), __)
    in f l
  in
  Coq_existT ((Obj.magic (S x)), __)

