open DecSetoid
open DecSetoidProperties
open FSets
open List0
open Min
open MultiSets
open Semigroup
open SemigroupProperties
open Specif

type __ = Obj.t
let __ = let rec f _ = Obj.repr f in Obj.repr f

(** val multi_intersection :
    coq_DecSetoid -> carrier -> carrier -> carrier **)

let multi_intersection a x y =
  fold_right (fun a0 res ->
    Obj.magic
      (app
        (same a a0
          (min (count a a0 (Obj.magic x)) (count a a0 (Obj.magic y))))
        (Obj.magic res))) (Obj.magic []) (nodub a (Obj.magic x))

(** val multisetIntersectionSemigroup : coq_DecSetoid -> coq_Semigroup **)

let multisetIntersectionSemigroup a =
  { setoid = (multisetDecSetoid a); op = (multi_intersection a) }

(** val sg_multiset_intersection_nat_min_smgIso :
    coq_DecSetoid -> coq_IsSingleton -> coq_SmgIso **)

let sg_multiset_intersection_nat_min_smgIso a sg =
  sg_multiset_nat_dsIso a sg

(** val isSelective_comp :
    coq_DecSetoid -> coq_IsSingleton_comp -> coq_IsSelective_comp **)

let isSelective_comp a sg =
  let a0 = a.choose in
  let Coq_existT (b, _) = sg a0 in
  Coq_existT ((Obj.magic (a0 :: [])), (Coq_existT (
  (Obj.magic (b :: [])), __)))

(** val hasIdentity_comp : coq_DecSetoid -> coq_HasIdentity_comp **)

let hasIdentity_comp a x =
  Coq_existT ((Obj.magic (a.choose :: (Obj.magic x))), __)

(** val hasAnnihilator : coq_DecSetoid -> coq_HasAnnihilator **)

let hasAnnihilator a =
  Coq_existT ((Obj.magic []), __)

(** val isLeft_comp : coq_DecSetoid -> coq_IsLeft_comp **)

let isLeft_comp a =
  Coq_existT ((Obj.magic (a.choose :: [])), (Coq_existT (
    (Obj.magic []), __)))

(** val isRight_comp : coq_DecSetoid -> coq_IsRight_comp **)

let isRight_comp a =
  Coq_existT ((Obj.magic []), (Coq_existT ((Obj.magic (a.choose :: [])),
    __)))

(** val leftCondensed_comp : coq_DecSetoid -> coq_LeftCondensed_comp **)

let leftCondensed_comp a =
  let a0 = a.choose in
  Coq_existT ((Obj.magic (a0 :: [])), (Coq_existT (
  (Obj.magic (a0 :: [])), (Coq_existT ((Obj.magic []), __)))))

(** val rightCondensed_comp : coq_DecSetoid -> coq_RightCondensed_comp **)

let rightCondensed_comp a =
  let a0 = a.choose in
  Coq_existT ((Obj.magic (a0 :: [])), (Coq_existT (
  (Obj.magic (a0 :: [])), (Coq_existT ((Obj.magic []), __)))))

(** val leftCancelative_comp : coq_DecSetoid -> coq_LeftCancelative_comp **)

let leftCancelative_comp a =
  Coq_existT ((Obj.magic []), (Coq_existT ((Obj.magic (a.choose :: [])),
    (Coq_existT ((Obj.magic []), __)))))

(** val rightCancelative_comp :
    coq_DecSetoid -> coq_RightCancelative_comp **)

let rightCancelative_comp a =
  Coq_existT ((Obj.magic []), (Coq_existT ((Obj.magic (a.choose :: [])),
    (Coq_existT ((Obj.magic []), __)))))

(** val antiLeft_comp : coq_DecSetoid -> coq_AntiLeft_comp **)

let antiLeft_comp a =
  Coq_existT ((Obj.magic []), (Coq_existT ((Obj.magic []), __)))

(** val antiRight_comp : coq_DecSetoid -> coq_AntiRight_comp **)

let antiRight_comp a =
  Coq_existT ((Obj.magic []), (Coq_existT ((Obj.magic []), __)))

(** val treeGlb_comp :
    coq_DecSetoid -> coq_IsSingleton_comp -> (carrier, (carrier, (carrier,
    __) sigT) sigT) sigT **)

let treeGlb_comp a sg =
  let a0 = a.choose in
  let Coq_existT (b, _) = sg a0 in
  Coq_existT ((Obj.magic (a0 :: [])), (Coq_existT (
  (Obj.magic (b :: [])), (Coq_existT ((Obj.magic (a0 :: (b :: []))), __)))))

