open Datatypes
open Specif

(** val min : nat -> nat -> nat **)

let rec min n m =
  match n with
    | O -> O
    | S n' -> (match m with
                 | O -> O
                 | S m' -> S (min n' m'))

(** val min_dec : nat -> nat -> sumbool **)

let rec min_dec n m =
  match n with
    | O -> let rec f n0 =
             Coq_left
           in f m
    | S n0 -> (match m with
                 | O -> Coq_right
                 | S n1 -> min_dec n0 n1)

(** val min_case : nat -> nat -> 'a1 -> 'a1 -> 'a1 **)

let rec min_case n m x x0 =
  match n with
    | O -> x
    | S n0 -> (match m with
                 | O -> x0
                 | S n1 -> min_case n0 n1 x x0)

