open Datatypes
open Specif

(** val max : nat -> nat -> nat **)

let rec max n m =
  match n with
    | O -> m
    | S n' -> (match m with
                 | O -> n
                 | S m' -> S (max n' m'))

(** val max_dec : nat -> nat -> sumbool **)

let rec max_dec n m =
  match n with
    | O -> let rec f = function
             | O -> Coq_left
             | S n1 -> Coq_right
           in f m
    | S n0 -> (match m with
                 | O -> Coq_left
                 | S n1 -> max_dec n0 n1)

(** val max_case : nat -> nat -> 'a1 -> 'a1 -> 'a1 **)

let rec max_case n m x x0 =
  match n with
    | O -> x0
    | S n0 -> (match m with
                 | O -> x
                 | S n1 -> max_case n0 n1 x x0)

