open Datatypes
open Specif

type __ = Obj.t
let __ = let rec f _ = Obj.repr f in Obj.repr f

(** val copy_var : 'a1 -> ('a1, __) sigT **)

let copy_var x =
  Coq_existT (x, __)

(** val orb_destruct_replace : bool -> bool -> (__, __) sum **)

let orb_destruct_replace x y =
  if x
  then Coq_inl __
  else if y then Coq_inr __ else assert false (* absurd case *)

(** val iffb : bool -> bool -> bool **)

let iffb x y =
  if if x then y else false then true else if negb x then negb y else false

(** val list_dec : 'a1 list -> ('a1 -> bool) -> (__, __) sum **)

let rec list_dec s f =
  match s with
    | [] -> Coq_inl __
    | a :: l -> if f a then Coq_inr __ else list_dec l f

(** val opfn : ('a1 -> 'a2) -> 'a1 option -> 'a2 option **)

let opfn f = function
  | Some x0 -> Some (f x0)
  | None -> None

(** val opAnd : 'a1 option -> 'a2 option -> ('a1 * 'a2) option **)

let opAnd x y =
  match x with
    | Some a -> (match y with
                   | Some b -> Some (a , b)
                   | None -> None)
    | None -> None

(** val opOr : 'a1 option -> 'a2 option -> ('a1, 'a2) sum option **)

let opOr x y =
  match x with
    | Some a -> Some (Coq_inl a)
    | None -> (match y with
                 | Some b -> Some (Coq_inr b)
                 | None -> None)

(** val opMap : ('a1 -> 'a2) -> 'a1 option -> 'a2 option **)

let opMap f = function
  | Some a -> Some (f a)
  | None -> None

(** val opInit : 'a1 -> 'a1 option **)

let opInit f =
  Some f

