open Datatypes
open DecSetoid
open Lex
open Logic0
open Product2
open SemigroupProperties
open SemigroupTransform
open SemigroupTransformGlue
open SemigroupTransformProperties
open Specif
open TransformProperties

type __ = Obj.t
let __ = let rec f _ = Obj.repr f in Obj.repr f

(** val lexSemigroupTransform :
    coq_SemigroupTransform -> coq_SemigroupTransform -> coq_HasIdentity ->
    coq_SemigroupTransform **)

let lexSemigroupTransform a b b_hasId =
  glueSTf_DsEq (lexSemigroup (semigroupST a) (semigroupST b) b_hasId)
    (prodTransform (transformST a) (transformST b))

(** val distributive_comp :
    coq_SemigroupTransform -> coq_SemigroupTransform -> coq_HasIdentity ->
    ((coq_Distributive_comp, coq_Distributive_comp) sum, coq_Cancelative_comp
    * coq_Condensed_comp) sum -> coq_Distributive_comp **)

let distributive_comp a b b_hasId = function
  | Coq_inl s ->
      (match s with
         | Coq_inl d ->
             let Coq_existT (a0, s0) = d in
             let Coq_existT (b0, s1) = s0 in
             let Coq_existT (f, _) = s1 in
             Coq_existT ((Obj.magic (a0 , b.setoid.choose)), (Coq_existT
             ((Obj.magic (b0 , b.setoid.choose)), (Coq_existT
             ((Obj.magic (f , b.fn.choose)), __)))))
         | Coq_inr d ->
             let Coq_existT (x0, s0) = d in
             let Coq_existT (y, s1) = s0 in
             let Coq_existT (g, _) = s1 in
             Coq_existT ((Obj.magic (a.setoid.choose , x0)), (Coq_existT
             ((Obj.magic (a.setoid.choose , y)), (Coq_existT
             ((Obj.magic (a.fn.choose , g)), __))))))
  | Coq_inr p ->
      let c , x0 = p in
      let Coq_existT (a0, s) = c in
      let Coq_existT (b0, s0) = s in
      let Coq_existT (f, _) = s0 in
      let Coq_existT (x1, s1) = x0 in
      let Coq_existT (y, s2) = s1 in
      let Coq_existT (g, _) = s2 in
      let Coq_existT (w, _) = copy_var (lexComp (semigroupST a) a0 b0) in
      (match w with
         | Coq_equiv -> Coq_existT ((Obj.magic (a0 , x1)), (Coq_existT
             ((Obj.magic (b0 , y)), (Coq_existT ((Obj.magic (f , g)), __)))))
         | Coq_more ->
             let Coq_existT (w0, _) =
               copy_var
                 (b.setoid.equal (b.app g x1) (b.app g (projT1 b_hasId)))
             in
             if w0
             then Coq_existT ((Obj.magic (a0 , y)), (Coq_existT
                    ((Obj.magic (b0 , (projT1 b_hasId))), (Coq_existT
                    ((Obj.magic (f , g)), __)))))
             else Coq_existT ((Obj.magic (a0 , x1)), (Coq_existT
                    ((Obj.magic (b0 , (projT1 b_hasId))), (Coq_existT
                    ((Obj.magic (f , g)), __)))))
         | _ ->
             let Coq_existT (w0, _) =
               copy_var
                 (b.setoid.equal (b.app g x1) (b.app g (projT1 b_hasId)))
             in
             if w0
             then Coq_existT ((Obj.magic (a0 , (projT1 b_hasId))),
                    (Coq_existT ((Obj.magic (b0 , y)), (Coq_existT
                    ((Obj.magic (f , g)), __)))))
             else Coq_existT ((Obj.magic (a0 , (projT1 b_hasId))),
                    (Coq_existT ((Obj.magic (b0 , x1)), (Coq_existT
                    ((Obj.magic (f , g)), __))))))

(** val inflationary_comp :
    coq_SemigroupTransform -> coq_SemigroupTransform -> coq_HasIdentity ->
    (coq_Inflationary_comp, coq_StrictInflationary_comp *
    coq_Inflationary_comp) sum -> (carrier, (carrier, __) sigT) sigT **)

let inflationary_comp a b b_hasId = function
  | Coq_inl ia ->
      let Coq_existT (x0, s) = ia __ __ in
      let Coq_existT (f, _) = s in
      Coq_existT ((Obj.magic (x0 , b.setoid.choose)), (Coq_existT
      ((Obj.magic (f , b.fn.choose)), __)))
  | Coq_inr p ->
      let sia , ib = p in
      let Coq_existT (a0, s) = sia __ __ in
      let Coq_existT (g, _) = s in
      let Coq_existT (x0, s0) = ib __ __ in
      let Coq_existT (f, _) = s0 in
      Coq_existT ((Obj.magic (a0 , x0)), (Coq_existT (
      (Obj.magic (g , f)), __)))

(** val deflationary_comp :
    coq_SemigroupTransform -> coq_SemigroupTransform -> coq_HasIdentity ->
    (coq_Deflationary_comp, coq_StrictDeflationary_comp *
    coq_Deflationary_comp) sum -> (carrier, (carrier, __) sigT) sigT **)

let deflationary_comp a b b_hasId = function
  | Coq_inl ia ->
      let Coq_existT (x0, s) = ia __ __ in
      let Coq_existT (f, _) = s in
      Coq_existT ((Obj.magic (x0 , b.setoid.choose)), (Coq_existT
      ((Obj.magic (f , b.fn.choose)), __)))
  | Coq_inr p ->
      let sia , ib = p in
      let Coq_existT (a0, s) = sia __ __ in
      let Coq_existT (g, _) = s in
      let Coq_existT (x0, s0) = ib __ __ in
      let Coq_existT (f, _) = s0 in
      Coq_existT ((Obj.magic (a0 , x0)), (Coq_existT (
      (Obj.magic (g , f)), __)))

(** val strictInflationary_comp :
    coq_SemigroupTransform -> coq_SemigroupTransform -> coq_HasIdentity ->
    (coq_StrictInflationary_comp * (coq_Inflationary_comp,
    coq_StrictInflationary_comp) sum) -> (carrier, (carrier, __) sigT) sigT **)

let strictInflationary_comp a b b_hasId = function
  | sia , s ->
      (match s with
         | Coq_inl ia ->
             let Coq_existT (b0, s0) = ia __ __ in
             let Coq_existT (k, _) = s0 in
             Coq_existT ((Obj.magic (b0 , b.setoid.choose)), (Coq_existT
             ((Obj.magic (k , b.fn.choose)), __)))
         | Coq_inr sib ->
             let Coq_existT (a0, s0) = sia __ __ in
             let Coq_existT (g, _) = s0 in
             let Coq_existT (b0, s1) = sib __ __ in
             let Coq_existT (k, _) = s1 in
             Coq_existT ((Obj.magic (a0 , b0)), (Coq_existT
             ((Obj.magic (g , k)), __))))

(** val strictDeflationary_comp :
    coq_SemigroupTransform -> coq_SemigroupTransform -> coq_HasIdentity ->
    (coq_StrictDeflationary_comp * (coq_Deflationary_comp,
    coq_StrictDeflationary_comp) sum) -> (carrier, (carrier, __) sigT) sigT **)

let strictDeflationary_comp a b b_hasId = function
  | sia , s ->
      (match s with
         | Coq_inl ia ->
             let Coq_existT (b0, s0) = ia __ __ in
             let Coq_existT (k, _) = s0 in
             Coq_existT ((Obj.magic (b0 , b.setoid.choose)), (Coq_existT
             ((Obj.magic (k , b.fn.choose)), __)))
         | Coq_inr sib ->
             let Coq_existT (a0, s0) = sia __ __ in
             let Coq_existT (g, _) = s0 in
             let Coq_existT (b0, s1) = sib __ __ in
             let Coq_existT (k, _) = s1 in
             Coq_existT ((Obj.magic (a0 , b0)), (Coq_existT
             ((Obj.magic (g , k)), __))))

(** val hasId_back_a :
    coq_SemigroupTransform -> coq_SemigroupTransform -> coq_HasIdentity ->
    coq_HasIdentity -> coq_HasIdentity **)

let hasId_back_a a b b_hasId = function
  | Coq_existT (x0, x1) ->
      let ida , idb = Obj.magic x0 in Coq_existT (ida, __)

(** val hasId_back_b :
    coq_SemigroupTransform -> coq_SemigroupTransform -> coq_HasIdentity ->
    coq_HasIdentity -> coq_HasIdentity **)

let hasId_back_b a b b_hasId = function
  | Coq_existT (x0, x1) ->
      let ida , idb = Obj.magic x0 in Coq_existT (idb, __)

(** val strict_comp :
    coq_SemigroupTransform -> coq_SemigroupTransform -> coq_HasIdentity ->
    (coq_Strict_comp, coq_Strict_comp) sum -> coq_Strict_comp **)

let strict_comp a b b_hasId x hasId =
  match x with
    | Coq_inl sta ->
        let Coq_existT (f, _) =
          sta
            (let Coq_existT (x0, x1) = hasId in
            let ida , idb = Obj.magic x0 in Coq_existT (ida, __))
        in
        let Coq_existT (x0, x1) = hasId in
        let ida , idb = Obj.magic x0 in
        Coq_existT ((Obj.magic (f , b.fn.choose)), __)
    | Coq_inr stb ->
        let Coq_existT (f, _) =
          stb
            (let Coq_existT (x0, x1) = hasId in
            let ida , idb = Obj.magic x0 in Coq_existT (idb, __))
        in
        let Coq_existT (x0, x1) = hasId in
        let ida , idb = Obj.magic x0 in
        Coq_existT ((Obj.magic (a.fn.choose , f)), __)

