open Bisemigroup
open BisemigroupGlue
open BisemigroupProperties
open Datatypes
open DecSetoid
open Lex
open Logic0
open Product0
open SemigroupProperties
open Specif

type __ = Obj.t
let __ = let rec f _ = Obj.repr f in Obj.repr f

(** val lexBisemigroup :
    coq_Bisemigroup -> coq_Bisemigroup -> coq_HasIdentity -> coq_Bisemigroup **)

let lexBisemigroup a b b_hasId =
  glueBSmg (lexSemigroup (plusSmg a) (plusSmg b) b_hasId)
    (prodSemigroup (timesSmg a) (timesSmg b))

(** val isRightDistributive_comp :
    coq_Bisemigroup -> coq_Bisemigroup -> coq_HasIdentity ->
    ((((coq_IsRightDistributive_comp, coq_IsRightDistributive_comp) sum,
    coq_IsRightStrictStable_comp * coq_RightCondensed_comp) sum,
    coq_IsRightCompEqCancel_comp * coq_IsRightTimesMapToIdConstantPlus_comp)
    sum, coq_IsRightCompCancel_comp *
    coq_PlusIdentityIsTimesLeftAnnihilator_comp) sum ->
    coq_IsRightDistributive_comp **)

let isRightDistributive_comp a b b_hasId = function
  | Coq_inl s ->
      (match s with
         | Coq_inl s0 ->
             (match s0 with
                | Coq_inl s1 ->
                    (match s1 with
                       | Coq_inl i ->
                           let Coq_existT (x0, s2) = i in
                           let Coq_existT (y, s3) = s2 in
                           let Coq_existT (z, _) = s3 in
                           Coq_existT ((Obj.magic (x0 , (projT1 b_hasId))),
                           (Coq_existT ((Obj.magic (y , (projT1 b_hasId))),
                           (Coq_existT ((Obj.magic (z , (projT1 b_hasId))),
                           __)))))
                       | Coq_inr i ->
                           let Coq_existT (x0, s2) = i in
                           let Coq_existT (y, s3) = s2 in
                           let Coq_existT (z, _) = s3 in
                           Coq_existT ((Obj.magic (a.setoid.choose , x0)),
                           (Coq_existT ((Obj.magic (a.setoid.choose , y)),
                           (Coq_existT ((Obj.magic (a.setoid.choose , z)),
                           __))))))
                | Coq_inr p ->
                    let rss , r = p in
                    let Coq_existT (z, s1) = r in
                    let Coq_existT (x0, s2) = s1 in
                    let Coq_existT (y, _) = s2 in
                    let Coq_existT (a0, s3) = rss __ __ in
                    let Coq_existT (b0, s4) = s3 in
                    let Coq_existT (c, _) = s4 in
                    let Coq_existT (w, _) =
                      copy_var
                        (lexComp (plusSmg a) (a.times a0 c) (a.times b0 c))
                    in
                    (match w with
                       | Coq_equiv ->
                           let Coq_existT (w0, _) =
                             copy_var
                               (b.setoid.equal (b.times y z)
                                 (b.plus (b.times y z) (b.times x0 z)))
                           in
                           if w0
                           then Coq_existT ((Obj.magic (b0 , y)), (Coq_existT
                                  ((Obj.magic (a0 , x0)), (Coq_existT
                                  ((Obj.magic (c , z)), __)))))
                           else Coq_existT ((Obj.magic (a0 , y)), (Coq_existT
                                  ((Obj.magic (b0 , x0)), (Coq_existT
                                  ((Obj.magic (c , z)), __)))))
                       | Coq_less ->
                           let Coq_existT (w0, _) =
                             copy_var
                               (b.setoid.equal (b.times (projT1 b_hasId) z)
                                 (b.times x0 z))
                           in
                           if w0
                           then Coq_existT ((Obj.magic (a0 , y)), (Coq_existT
                                  ((Obj.magic (b0 , x0)), (Coq_existT
                                  ((Obj.magic (c , z)), __)))))
                           else Coq_existT ((Obj.magic (b0 , y)), (Coq_existT
                                  ((Obj.magic (a0 , x0)), (Coq_existT
                                  ((Obj.magic (c , z)), __)))))
                       | Coq_more -> Coq_existT ((Obj.magic (a0 , x0)),
                           (Coq_existT ((Obj.magic (b0 , y)), (Coq_existT
                           ((Obj.magic (c , z)), __)))))
                       | Coq_none ->
                           let Coq_existT (w0, _) =
                             copy_var
                               (b.setoid.equal (b.times x0 z)
                                 (projT1 b_hasId))
                           in
                           if w0
                           then Coq_existT ((Obj.magic (a0 , y)), (Coq_existT
                                  ((Obj.magic (b0 , x0)), (Coq_existT
                                  ((Obj.magic (c , z)), __)))))
                           else Coq_existT ((Obj.magic (a0 , x0)),
                                  (Coq_existT ((Obj.magic (b0 , y)),
                                  (Coq_existT ((Obj.magic (c , z)), __)))))))
         | Coq_inr p ->
             let rcec , tic = p in
             let Coq_existT (a0, s0) = rcec __ __ in
             let Coq_existT (b0, s1) = s0 in
             let Coq_existT (c, _) = s1 in
             let Coq_existT (x0, s2) = tic b_hasId in
             let Coq_existT (y, s3) = s2 in
             let Coq_existT (z, _) = s3 in
             Coq_existT ((Obj.magic (a0 , x0)), (Coq_existT
             ((Obj.magic (b0 , y)), (Coq_existT ((Obj.magic (c , z)), __))))))
  | Coq_inr p ->
      let rcc , idla = p in
      let Coq_existT (x0, _) = idla b_hasId in
      let Coq_existT (a0, s) = rcc __ __ in
      let Coq_existT (b0, s0) = s in
      let Coq_existT (c, _) = s0 in
      Coq_existT ((Obj.magic (a0 , x0)), (Coq_existT (
      (Obj.magic (b0 , x0)), (Coq_existT ((Obj.magic (c , x0)), __)))))

(** val isLeftDistributive_comp :
    coq_Bisemigroup -> coq_Bisemigroup -> coq_HasIdentity ->
    ((((coq_IsLeftDistributive_comp, coq_IsLeftDistributive_comp) sum,
    coq_IsLeftStrictStable_comp * coq_LeftCondensed_comp) sum,
    coq_IsLeftCompEqCancel_comp * coq_IsLeftTimesMapToIdConstantPlus_comp)
    sum, coq_IsLeftCompCancel_comp *
    coq_PlusIdentityIsTimesRightAnnihilator_comp) sum ->
    coq_IsLeftDistributive_comp **)

let isLeftDistributive_comp a b b_hasId = function
  | Coq_inl s ->
      (match s with
         | Coq_inl s0 ->
             (match s0 with
                | Coq_inl s1 ->
                    (match s1 with
                       | Coq_inl i ->
                           let Coq_existT (x0, s2) = i in
                           let Coq_existT (y, s3) = s2 in
                           let Coq_existT (z, _) = s3 in
                           Coq_existT ((Obj.magic (x0 , (projT1 b_hasId))),
                           (Coq_existT ((Obj.magic (y , (projT1 b_hasId))),
                           (Coq_existT ((Obj.magic (z , (projT1 b_hasId))),
                           __)))))
                       | Coq_inr i ->
                           let Coq_existT (x0, s2) = i in
                           let Coq_existT (y, s3) = s2 in
                           let Coq_existT (z, _) = s3 in
                           Coq_existT ((Obj.magic (a.setoid.choose , x0)),
                           (Coq_existT ((Obj.magic (a.setoid.choose , y)),
                           (Coq_existT ((Obj.magic (a.setoid.choose , z)),
                           __))))))
                | Coq_inr p ->
                    let rss , l = p in
                    let Coq_existT (z, s1) = l in
                    let Coq_existT (x0, s2) = s1 in
                    let Coq_existT (y, _) = s2 in
                    let Coq_existT (a0, s3) = rss __ __ in
                    let Coq_existT (b0, s4) = s3 in
                    let Coq_existT (c, _) = s4 in
                    let Coq_existT (w, _) =
                      copy_var
                        (lexComp (plusSmg a) (a.times c a0) (a.times c b0))
                    in
                    (match w with
                       | Coq_equiv ->
                           let Coq_existT (w0, _) =
                             copy_var
                               (b.setoid.equal (b.times z y)
                                 (b.plus (b.times z y) (b.times z x0)))
                           in
                           if w0
                           then Coq_existT ((Obj.magic (b0 , y)), (Coq_existT
                                  ((Obj.magic (a0 , x0)), (Coq_existT
                                  ((Obj.magic (c , z)), __)))))
                           else Coq_existT ((Obj.magic (a0 , y)), (Coq_existT
                                  ((Obj.magic (b0 , x0)), (Coq_existT
                                  ((Obj.magic (c , z)), __)))))
                       | Coq_less ->
                           let Coq_existT (w0, _) =
                             copy_var
                               (b.setoid.equal (b.times z (projT1 b_hasId))
                                 (b.times z x0))
                           in
                           if w0
                           then Coq_existT ((Obj.magic (a0 , y)), (Coq_existT
                                  ((Obj.magic (b0 , x0)), (Coq_existT
                                  ((Obj.magic (c , z)), __)))))
                           else Coq_existT ((Obj.magic (b0 , y)), (Coq_existT
                                  ((Obj.magic (a0 , x0)), (Coq_existT
                                  ((Obj.magic (c , z)), __)))))
                       | Coq_more -> Coq_existT ((Obj.magic (a0 , x0)),
                           (Coq_existT ((Obj.magic (b0 , y)), (Coq_existT
                           ((Obj.magic (c , z)), __)))))
                       | Coq_none ->
                           let Coq_existT (w0, _) =
                             copy_var
                               (b.setoid.equal (b.times z x0)
                                 (projT1 b_hasId))
                           in
                           if w0
                           then Coq_existT ((Obj.magic (a0 , y)), (Coq_existT
                                  ((Obj.magic (b0 , x0)), (Coq_existT
                                  ((Obj.magic (c , z)), __)))))
                           else Coq_existT ((Obj.magic (a0 , x0)),
                                  (Coq_existT ((Obj.magic (b0 , y)),
                                  (Coq_existT ((Obj.magic (c , z)), __)))))))
         | Coq_inr p ->
             let rcec , tic = p in
             let Coq_existT (a0, s0) = rcec __ __ in
             let Coq_existT (b0, s1) = s0 in
             let Coq_existT (c, _) = s1 in
             let Coq_existT (x0, s2) = tic b_hasId in
             let Coq_existT (y, s3) = s2 in
             let Coq_existT (z, _) = s3 in
             Coq_existT ((Obj.magic (a0 , x0)), (Coq_existT
             ((Obj.magic (b0 , y)), (Coq_existT ((Obj.magic (c , z)), __))))))
  | Coq_inr p ->
      let rcc , idla = p in
      let Coq_existT (x0, _) = idla b_hasId in
      let Coq_existT (a0, s) = rcc __ __ in
      let Coq_existT (b0, s0) = s in
      let Coq_existT (c, _) = s0 in
      Coq_existT ((Obj.magic (a0 , x0)), (Coq_existT (
      (Obj.magic (b0 , x0)), (Coq_existT ((Obj.magic (c , x0)), __)))))

(** val isLeftStrictStable_comp :
    coq_Bisemigroup -> coq_Bisemigroup -> coq_HasIdentity ->
    ((coq_IsLeftStrictStable_comp, coq_IsLeftStrictStable_comp) sum,
    coq_IsLeftCompEqCancel_comp * coq_LeftDiscrete_comp) sum -> (carrier,
    (carrier, (carrier, __) sigT) sigT) sigT **)

let isLeftStrictStable_comp a b b_hasId = function
  | Coq_inl s ->
      (match s with
         | Coq_inl lssa ->
             let Coq_existT (x0, s0) = lssa __ __ in
             let Coq_existT (y, s1) = s0 in
             let Coq_existT (z, _) = s1 in
             Coq_existT ((Obj.magic (x0 , b.setoid.choose)), (Coq_existT
             ((Obj.magic (y , b.setoid.choose)), (Coq_existT
             ((Obj.magic (z , b.setoid.choose)), __)))))
         | Coq_inr lssb ->
             let Coq_existT (x0, s0) = lssb __ __ in
             let Coq_existT (y, s1) = s0 in
             let Coq_existT (z, _) = s1 in
             Coq_existT ((Obj.magic (a.setoid.choose , x0)), (Coq_existT
             ((Obj.magic (a.setoid.choose , y)), (Coq_existT
             ((Obj.magic (a.setoid.choose , z)), __))))))
  | Coq_inr p ->
      let lcec , ldc = p in
      let Coq_existT (a0, s) = lcec __ __ in
      let Coq_existT (b0, s0) = s in
      let Coq_existT (c, _) = s0 in
      let Coq_existT (x0, s1) = ldc __ __ in
      let Coq_existT (y, s2) = s1 in
      let Coq_existT (z, _) = s2 in
      Coq_existT ((Obj.magic (a0 , x0)), (Coq_existT (
      (Obj.magic (b0 , y)), (Coq_existT ((Obj.magic (c , z)), __)))))

(** val isRightStrictStable_comp :
    coq_Bisemigroup -> coq_Bisemigroup -> coq_HasIdentity ->
    ((coq_IsRightStrictStable_comp, coq_IsRightStrictStable_comp) sum,
    coq_IsRightCompEqCancel_comp * coq_RightDiscrete_comp) sum -> (carrier,
    (carrier, (carrier, __) sigT) sigT) sigT **)

let isRightStrictStable_comp a b b_hasId = function
  | Coq_inl s ->
      (match s with
         | Coq_inl lssa ->
             let Coq_existT (x0, s0) = lssa __ __ in
             let Coq_existT (y, s1) = s0 in
             let Coq_existT (z, _) = s1 in
             Coq_existT ((Obj.magic (x0 , b.setoid.choose)), (Coq_existT
             ((Obj.magic (y , b.setoid.choose)), (Coq_existT
             ((Obj.magic (z , b.setoid.choose)), __)))))
         | Coq_inr lssb ->
             let Coq_existT (x0, s0) = lssb __ __ in
             let Coq_existT (y, s1) = s0 in
             let Coq_existT (z, _) = s1 in
             Coq_existT ((Obj.magic (a.setoid.choose , x0)), (Coq_existT
             ((Obj.magic (a.setoid.choose , y)), (Coq_existT
             ((Obj.magic (a.setoid.choose , z)), __))))))
  | Coq_inr p ->
      let lcec , ldc = p in
      let Coq_existT (a0, s) = lcec __ __ in
      let Coq_existT (b0, s0) = s in
      let Coq_existT (c, _) = s0 in
      let Coq_existT (x0, s1) = ldc __ __ in
      let Coq_existT (y, s2) = s1 in
      let Coq_existT (z, _) = s2 in
      Coq_existT ((Obj.magic (a0 , x0)), (Coq_existT (
      (Obj.magic (b0 , y)), (Coq_existT ((Obj.magic (c , z)), __)))))

(** val leftDiscrete_comp :
    coq_Bisemigroup -> coq_Bisemigroup -> coq_HasIdentity ->
    (coq_LeftDiscrete_comp, coq_LeftDiscrete_comp) sum -> (carrier, (carrier,
    (carrier, __) sigT) sigT) sigT **)

let leftDiscrete_comp a b b_hasId = function
  | Coq_inl lda ->
      let Coq_existT (x0, s) = lda __ __ in
      let Coq_existT (y, s0) = s in
      let Coq_existT (z, _) = s0 in
      Coq_existT ((Obj.magic (x0 , b.setoid.choose)), (Coq_existT
      ((Obj.magic (y , b.setoid.choose)), (Coq_existT
      ((Obj.magic (z , b.setoid.choose)), __)))))
  | Coq_inr ldb ->
      let Coq_existT (x0, s) = ldb __ __ in
      let Coq_existT (y, s0) = s in
      let Coq_existT (z, _) = s0 in
      Coq_existT ((Obj.magic (a.setoid.choose , x0)), (Coq_existT
      ((Obj.magic (a.setoid.choose , y)), (Coq_existT
      ((Obj.magic (a.setoid.choose , z)), __)))))

(** val rightDiscrete_comp :
    coq_Bisemigroup -> coq_Bisemigroup -> coq_HasIdentity ->
    (coq_RightDiscrete_comp, coq_RightDiscrete_comp) sum -> (carrier,
    (carrier, (carrier, __) sigT) sigT) sigT **)

let rightDiscrete_comp a b b_hasId = function
  | Coq_inl lda ->
      let Coq_existT (x0, s) = lda __ __ in
      let Coq_existT (y, s0) = s in
      let Coq_existT (z, _) = s0 in
      Coq_existT ((Obj.magic (x0 , b.setoid.choose)), (Coq_existT
      ((Obj.magic (y , b.setoid.choose)), (Coq_existT
      ((Obj.magic (z , b.setoid.choose)), __)))))
  | Coq_inr ldb ->
      let Coq_existT (x0, s) = ldb __ __ in
      let Coq_existT (y, s0) = s in
      let Coq_existT (z, _) = s0 in
      Coq_existT ((Obj.magic (a.setoid.choose , x0)), (Coq_existT
      ((Obj.magic (a.setoid.choose , y)), (Coq_existT
      ((Obj.magic (a.setoid.choose , z)), __)))))

(** val hasPlusId_back_a :
    coq_Bisemigroup -> coq_Bisemigroup -> coq_HasIdentity -> coq_HasIdentity
    -> coq_HasIdentity **)

let hasPlusId_back_a a b b_hasId = function
  | Coq_existT (x0, x1) ->
      let ida , idb = Obj.magic x0 in Coq_existT (ida, __)

(** val hasPlusId_back_b :
    coq_Bisemigroup -> coq_Bisemigroup -> coq_HasIdentity -> coq_HasIdentity
    -> coq_HasIdentity **)

let hasPlusId_back_b a b b_hasId = function
  | Coq_existT (x0, x1) ->
      let ida , idb = Obj.magic x0 in Coq_existT (idb, __)

(** val hasPlusAnn_back_a :
    coq_Bisemigroup -> coq_Bisemigroup -> coq_HasIdentity ->
    coq_HasAnnihilator -> coq_HasAnnihilator **)

let hasPlusAnn_back_a a b b_hasId = function
  | Coq_existT (x0, x1) ->
      let ida , idb = Obj.magic x0 in Coq_existT (ida, __)

(** val hasPlusAnn_back_b :
    coq_Bisemigroup -> coq_Bisemigroup -> coq_HasIdentity ->
    coq_HasAnnihilator -> coq_HasAnnihilator **)

let hasPlusAnn_back_b a b b_hasId = function
  | Coq_existT (x0, x1) ->
      let ida , idb = Obj.magic x0 in Coq_existT (idb, __)

(** val hasTimesId_back_a :
    coq_Bisemigroup -> coq_Bisemigroup -> coq_HasIdentity -> coq_HasIdentity
    -> coq_HasIdentity **)

let hasTimesId_back_a a b b_hasId = function
  | Coq_existT (x0, x1) ->
      let ida , idb = Obj.magic x0 in Coq_existT (ida, __)

(** val hasTimesId_back_b :
    coq_Bisemigroup -> coq_Bisemigroup -> coq_HasIdentity -> coq_HasIdentity
    -> coq_HasIdentity **)

let hasTimesId_back_b a b b_hasId = function
  | Coq_existT (x0, x1) ->
      let ida , idb = Obj.magic x0 in Coq_existT (idb, __)

(** val hasTimesAnn_back_a :
    coq_Bisemigroup -> coq_Bisemigroup -> coq_HasIdentity ->
    coq_HasAnnihilator -> coq_HasAnnihilator **)

let hasTimesAnn_back_a a b b_hasId = function
  | Coq_existT (x0, x1) ->
      let ida , idb = Obj.magic x0 in Coq_existT (ida, __)

(** val hasTimesAnn_back_b :
    coq_Bisemigroup -> coq_Bisemigroup -> coq_HasIdentity ->
    coq_HasAnnihilator -> coq_HasAnnihilator **)

let hasTimesAnn_back_b a b b_hasId = function
  | Coq_existT (x0, x1) ->
      let ida , idb = Obj.magic x0 in Coq_existT (idb, __)

(** val isLeftCompEqCancel_comp :
    coq_Bisemigroup -> coq_Bisemigroup -> coq_HasIdentity ->
    (coq_IsLeftCompEqCancel_comp, coq_IsLeftCompEqCancel_comp) sum ->
    (carrier, (carrier, (carrier, __) sigT) sigT) sigT **)

let isLeftCompEqCancel_comp a b b_hasId = function
  | Coq_inl lceca ->
      let Coq_existT (x0, s) = lceca __ __ in
      let Coq_existT (y, s0) = s in
      let Coq_existT (z, _) = s0 in
      Coq_existT ((Obj.magic (x0 , (projT1 b_hasId))), (Coq_existT
      ((Obj.magic (y , (projT1 b_hasId))), (Coq_existT
      ((Obj.magic (z , (projT1 b_hasId))), __)))))
  | Coq_inr lcecb ->
      let Coq_existT (x0, s) = lcecb __ __ in
      let Coq_existT (y, s0) = s in
      let Coq_existT (z, _) = s0 in
      Coq_existT ((Obj.magic (a.setoid.choose , x0)), (Coq_existT
      ((Obj.magic (a.setoid.choose , y)), (Coq_existT
      ((Obj.magic (a.setoid.choose , z)), __)))))

(** val isRightCompEqCancel_comp :
    coq_Bisemigroup -> coq_Bisemigroup -> coq_HasIdentity ->
    (coq_IsRightCompEqCancel_comp, coq_IsRightCompEqCancel_comp) sum ->
    (carrier, (carrier, (carrier, __) sigT) sigT) sigT **)

let isRightCompEqCancel_comp a b b_hasId = function
  | Coq_inl lceca ->
      let Coq_existT (x0, s) = lceca __ __ in
      let Coq_existT (y, s0) = s in
      let Coq_existT (z, _) = s0 in
      Coq_existT ((Obj.magic (x0 , (projT1 b_hasId))), (Coq_existT
      ((Obj.magic (y , (projT1 b_hasId))), (Coq_existT
      ((Obj.magic (z , (projT1 b_hasId))), __)))))
  | Coq_inr lcecb ->
      let Coq_existT (x0, s) = lcecb __ __ in
      let Coq_existT (y, s0) = s in
      let Coq_existT (z, _) = s0 in
      Coq_existT ((Obj.magic (a.setoid.choose , x0)), (Coq_existT
      ((Obj.magic (a.setoid.choose , y)), (Coq_existT
      ((Obj.magic (a.setoid.choose , z)), __)))))

(** val isLeftCompCancel_comp :
    coq_Bisemigroup -> coq_Bisemigroup -> coq_HasIdentity ->
    ((coq_IsLeftCompEqCancel_comp * coq_LeftComparable_comp,
    coq_IsLeftCompCancel_comp) sum, coq_IsLeftCompCancel_comp) sum ->
    (carrier, (carrier, (carrier, __) sigT) sigT) sigT **)

let isLeftCompCancel_comp a b b_hasId = function
  | Coq_inl s ->
      (match s with
         | Coq_inl p ->
             let lceca , lcmp = p in
             let Coq_existT (x0, s0) = lceca __ __ in
             let Coq_existT (y, s1) = s0 in
             let Coq_existT (z, _) = s1 in
             let Coq_existT (a0, s2) = lcmp __ __ in
             let Coq_existT (b0, s3) = s2 in
             let Coq_existT (c, _) = s3 in
             Coq_existT ((Obj.magic (x0 , a0)), (Coq_existT
             ((Obj.magic (y , b0)), (Coq_existT ((Obj.magic (z , c)), __)))))
         | Coq_inr lcca ->
             let Coq_existT (x0, s0) = lcca __ __ in
             let Coq_existT (y, s1) = s0 in
             let Coq_existT (z, _) = s1 in
             Coq_existT ((Obj.magic (x0 , (projT1 b_hasId))), (Coq_existT
             ((Obj.magic (y , (projT1 b_hasId))), (Coq_existT
             ((Obj.magic (z , (projT1 b_hasId))), __))))))
  | Coq_inr lccb ->
      let Coq_existT (x0, s) = lccb __ __ in
      let Coq_existT (y, s0) = s in
      let Coq_existT (z, _) = s0 in
      Coq_existT ((Obj.magic (a.setoid.choose , x0)), (Coq_existT
      ((Obj.magic (a.setoid.choose , y)), (Coq_existT
      ((Obj.magic (a.setoid.choose , z)), __)))))

(** val isRightCompCancel_comp :
    coq_Bisemigroup -> coq_Bisemigroup -> coq_HasIdentity ->
    ((coq_IsRightCompEqCancel_comp * coq_RightComparable_comp,
    coq_IsRightCompCancel_comp) sum, coq_IsRightCompCancel_comp) sum ->
    (carrier, (carrier, (carrier, __) sigT) sigT) sigT **)

let isRightCompCancel_comp a b b_hasId = function
  | Coq_inl s ->
      (match s with
         | Coq_inl p ->
             let lceca , lcmp = p in
             let Coq_existT (x0, s0) = lceca __ __ in
             let Coq_existT (y, s1) = s0 in
             let Coq_existT (z, _) = s1 in
             let Coq_existT (a0, s2) = lcmp __ __ in
             let Coq_existT (b0, s3) = s2 in
             let Coq_existT (c, _) = s3 in
             Coq_existT ((Obj.magic (x0 , a0)), (Coq_existT
             ((Obj.magic (y , b0)), (Coq_existT ((Obj.magic (z , c)), __)))))
         | Coq_inr lcca ->
             let Coq_existT (x0, s0) = lcca __ __ in
             let Coq_existT (y, s1) = s0 in
             let Coq_existT (z, _) = s1 in
             Coq_existT ((Obj.magic (x0 , (projT1 b_hasId))), (Coq_existT
             ((Obj.magic (y , (projT1 b_hasId))), (Coq_existT
             ((Obj.magic (z , (projT1 b_hasId))), __))))))
  | Coq_inr lccb ->
      let Coq_existT (x0, s) = lccb __ __ in
      let Coq_existT (y, s0) = s in
      let Coq_existT (z, _) = s0 in
      Coq_existT ((Obj.magic (a.setoid.choose , x0)), (Coq_existT
      ((Obj.magic (a.setoid.choose , y)), (Coq_existT
      ((Obj.magic (a.setoid.choose , z)), __)))))

(** val leftComparable_comp :
    coq_Bisemigroup -> coq_Bisemigroup -> coq_HasIdentity ->
    (coq_LeftComparable_comp, coq_LeftComparable_comp) sum -> (carrier,
    (carrier, (carrier, __) sigT) sigT) sigT **)

let leftComparable_comp a b b_hasId = function
  | Coq_inl lca ->
      let Coq_existT (x0, s) = lca __ __ in
      let Coq_existT (y, s0) = s in
      let Coq_existT (z, _) = s0 in
      Coq_existT ((Obj.magic (x0 , (projT1 b_hasId))), (Coq_existT
      ((Obj.magic (y , (projT1 b_hasId))), (Coq_existT
      ((Obj.magic (z , (projT1 b_hasId))), __)))))
  | Coq_inr lcb ->
      let Coq_existT (x0, s) = lcb __ __ in
      let Coq_existT (y, s0) = s in
      let Coq_existT (z, _) = s0 in
      Coq_existT ((Obj.magic (a.setoid.choose , x0)), (Coq_existT
      ((Obj.magic (a.setoid.choose , y)), (Coq_existT
      ((Obj.magic (a.setoid.choose , z)), __)))))

(** val rightComparable_comp :
    coq_Bisemigroup -> coq_Bisemigroup -> coq_HasIdentity ->
    (coq_RightComparable_comp, coq_RightComparable_comp) sum -> (carrier,
    (carrier, (carrier, __) sigT) sigT) sigT **)

let rightComparable_comp a b b_hasId = function
  | Coq_inl lca ->
      let Coq_existT (x0, s) = lca __ __ in
      let Coq_existT (y, s0) = s in
      let Coq_existT (z, _) = s0 in
      Coq_existT ((Obj.magic (x0 , (projT1 b_hasId))), (Coq_existT
      ((Obj.magic (y , (projT1 b_hasId))), (Coq_existT
      ((Obj.magic (z , (projT1 b_hasId))), __)))))
  | Coq_inr lcb ->
      let Coq_existT (x0, s) = lcb __ __ in
      let Coq_existT (y, s0) = s in
      let Coq_existT (z, _) = s0 in
      Coq_existT ((Obj.magic (a.setoid.choose , x0)), (Coq_existT
      ((Obj.magic (a.setoid.choose , y)), (Coq_existT
      ((Obj.magic (a.setoid.choose , z)), __)))))

(** val leftIncreasing_comp :
    coq_Bisemigroup -> coq_Bisemigroup -> coq_HasIdentity ->
    (coq_LeftStrictIncreasing_comp * (coq_LeftIncreasing_comp,
    coq_LeftIncreasing_comp) sum) -> (carrier, (carrier, __) sigT) sigT **)

let leftIncreasing_comp a b b_hasId = function
  | ls , s ->
      (match s with
         | Coq_inl la ->
             let Coq_existT (x0, s0) = la __ __ in
             let Coq_existT (y, _) = s0 in
             Coq_existT ((Obj.magic (x0 , b.setoid.choose)), (Coq_existT
             ((Obj.magic (y , b.setoid.choose)), __)))
         | Coq_inr lb ->
             let Coq_existT (x1, s0) = ls __ __ in
             let Coq_existT (y1, _) = s0 in
             let Coq_existT (x2, s1) = lb __ __ in
             let Coq_existT (y2, _) = s1 in
             Coq_existT ((Obj.magic (x1 , x2)), (Coq_existT
             ((Obj.magic (y1 , y2)), __))))

(** val rightIncreasing_comp :
    coq_Bisemigroup -> coq_Bisemigroup -> coq_HasIdentity ->
    (coq_RightStrictIncreasing_comp * (coq_RightIncreasing_comp,
    coq_RightIncreasing_comp) sum) -> (carrier, (carrier, __) sigT) sigT **)

let rightIncreasing_comp a b b_hasId = function
  | ls , s ->
      (match s with
         | Coq_inl la ->
             let Coq_existT (x0, s0) = la __ __ in
             let Coq_existT (y, _) = s0 in
             Coq_existT ((Obj.magic (x0 , b.setoid.choose)), (Coq_existT
             ((Obj.magic (y , b.setoid.choose)), __)))
         | Coq_inr lb ->
             let Coq_existT (x1, s0) = ls __ __ in
             let Coq_existT (y1, _) = s0 in
             let Coq_existT (x2, s1) = lb __ __ in
             let Coq_existT (y2, _) = s1 in
             Coq_existT ((Obj.magic (x1 , x2)), (Coq_existT
             ((Obj.magic (y1 , y2)), __))))

(** val leftStrictIncreasing_comp :
    coq_Bisemigroup -> coq_Bisemigroup -> coq_HasIdentity ->
    (coq_LeftStrictIncreasing_comp * (coq_LeftIncreasing_comp,
    coq_LeftStrictIncreasing_comp) sum) -> (carrier, (carrier, __) sigT) sigT **)

let leftStrictIncreasing_comp a b b_hasId = function
  | ls , s ->
      (match s with
         | Coq_inl la ->
             let Coq_existT (x0, s0) = la __ __ in
             let Coq_existT (y, _) = s0 in
             Coq_existT ((Obj.magic (x0 , b.setoid.choose)), (Coq_existT
             ((Obj.magic (y , b.setoid.choose)), __)))
         | Coq_inr lb ->
             let Coq_existT (x1, s0) = ls __ __ in
             let Coq_existT (y1, _) = s0 in
             let Coq_existT (x2, s1) = lb __ __ in
             let Coq_existT (y2, _) = s1 in
             Coq_existT ((Obj.magic (x1 , x2)), (Coq_existT
             ((Obj.magic (y1 , y2)), __))))

(** val rightStrictIncreasing_comp :
    coq_Bisemigroup -> coq_Bisemigroup -> coq_HasIdentity ->
    (coq_RightStrictIncreasing_comp * (coq_RightIncreasing_comp,
    coq_RightStrictIncreasing_comp) sum) -> (carrier, (carrier, __) sigT)
    sigT **)

let rightStrictIncreasing_comp a b b_hasId = function
  | ls , s ->
      (match s with
         | Coq_inl la ->
             let Coq_existT (x0, s0) = la __ __ in
             let Coq_existT (y, _) = s0 in
             Coq_existT ((Obj.magic (x0 , b.setoid.choose)), (Coq_existT
             ((Obj.magic (y , b.setoid.choose)), __)))
         | Coq_inr lb ->
             let Coq_existT (x1, s0) = ls __ __ in
             let Coq_existT (y1, _) = s0 in
             let Coq_existT (x2, s1) = lb __ __ in
             let Coq_existT (y2, _) = s1 in
             Coq_existT ((Obj.magic (x1 , x2)), (Coq_existT
             ((Obj.magic (y1 , y2)), __))))

(** val isRightTimesMapToIdConstantPlus_comp :
    coq_Bisemigroup -> coq_Bisemigroup -> coq_HasIdentity ->
    (((coq_IsRightTimesMapToIdConstantPlus_comp,
    coq_IsRightTimesMapToIdConstantPlus_comp) sum, coq_RightDiscrete_comp *
    coq_RightCondensed_comp) sum, coq_RightComparable_comp *
    coq_PlusIdentityIsTimesLeftAnnihilator_comp) sum ->
    coq_IsRightTimesMapToIdConstantPlus_comp **)

let isRightTimesMapToIdConstantPlus_comp a b b_hasId x hasId =
  match x with
    | Coq_inl s ->
        (match s with
           | Coq_inl s0 ->
               (match s0 with
                  | Coq_inl tica ->
                      let Coq_existT (x0, x1) = hasId in
                      let ida , idb = Obj.magic x0 in
                      let Coq_existT (x2, s1) =
                        tica
                          (let Coq_existT (x2, x3) = hasId in
                          let ida0 , idb0 = Obj.magic x2 in
                          Coq_existT (ida0, __))
                      in
                      let Coq_existT (y, s2) = s1 in
                      let Coq_existT (z, _) = s2 in
                      Coq_existT ((Obj.magic (x2 , (projT1 b_hasId))),
                      (Coq_existT ((Obj.magic (y , (projT1 b_hasId))),
                      (Coq_existT ((Obj.magic (z , (projT1 b_hasId))),
                      __)))))
                  | Coq_inr ticb ->
                      let Coq_existT (x0, x1) = hasId in
                      let ida , idb = Obj.magic x0 in
                      let Coq_existT (x2, s1) =
                        ticb
                          (let Coq_existT (x2, x3) = hasId in
                          let ida0 , idb0 = Obj.magic x2 in
                          Coq_existT (idb0, __))
                      in
                      let Coq_existT (y, s2) = s1 in
                      let Coq_existT (z, _) = s2 in
                      Coq_existT ((Obj.magic (a.setoid.choose , x2)),
                      (Coq_existT ((Obj.magic (a.setoid.choose , y)),
                      (Coq_existT ((Obj.magic (a.setoid.choose , z)), __))))))
           | Coq_inr p ->
               let rda , r = p in
               let Coq_existT (x0, s0) = r in
               let Coq_existT (y, s1) = s0 in
               let Coq_existT (z, _) = s1 in
               let Coq_existT (a0, s2) = rda __ __ in
               let Coq_existT (b0, s3) = s2 in
               let Coq_existT (c, _) = s3 in
               let Coq_existT (x1, x2) = hasId in
               let ida , idb = Obj.magic x1 in
               let Coq_existT (w, _) =
                 copy_var (b.setoid.equal (b.times z x0) (b.times idb x0))
               in
               if w
               then Coq_existT ((Obj.magic (a0 , y)), (Coq_existT
                      ((Obj.magic (b0 , z)), (Coq_existT
                      ((Obj.magic (c , x0)), __)))))
               else Coq_existT ((Obj.magic (a0 , z)), (Coq_existT
                      ((Obj.magic (b0 , y)), (Coq_existT
                      ((Obj.magic (c , x0)), __))))))
    | Coq_inr p ->
        let rca , idla = p in
        let Coq_existT (a0, s) = rca __ __ in
        let Coq_existT (b0, s0) = s in
        let Coq_existT (c, _) = s0 in
        let Coq_existT (x0, _) =
          idla
            (let Coq_existT (x0, x1) = hasId in
            let ida , idb = Obj.magic x0 in Coq_existT (idb, __))
        in
        let Coq_existT (x1, x2) = hasId in
        let ida , idb = Obj.magic x1 in
        Coq_existT ((Obj.magic (a0 , x0)), (Coq_existT
        ((Obj.magic (b0 , x0)), (Coq_existT ((Obj.magic (c , x0)), __)))))

(** val isLeftTimesMapToIdConstantPlus_comp :
    coq_Bisemigroup -> coq_Bisemigroup -> coq_HasIdentity ->
    (((coq_IsLeftTimesMapToIdConstantPlus_comp,
    coq_IsLeftTimesMapToIdConstantPlus_comp) sum, coq_LeftDiscrete_comp *
    coq_LeftCondensed_comp) sum, coq_LeftComparable_comp *
    coq_PlusIdentityIsTimesRightAnnihilator_comp) sum ->
    coq_IsLeftTimesMapToIdConstantPlus_comp **)

let isLeftTimesMapToIdConstantPlus_comp a b b_hasId x hasId =
  match x with
    | Coq_inl s ->
        (match s with
           | Coq_inl s0 ->
               (match s0 with
                  | Coq_inl tica ->
                      let Coq_existT (x0, x1) = hasId in
                      let ida , idb = Obj.magic x0 in
                      let Coq_existT (x2, s1) =
                        tica
                          (let Coq_existT (x2, x3) = hasId in
                          let ida0 , idb0 = Obj.magic x2 in
                          Coq_existT (ida0, __))
                      in
                      let Coq_existT (y, s2) = s1 in
                      let Coq_existT (z, _) = s2 in
                      Coq_existT ((Obj.magic (x2 , (projT1 b_hasId))),
                      (Coq_existT ((Obj.magic (y , (projT1 b_hasId))),
                      (Coq_existT ((Obj.magic (z , (projT1 b_hasId))),
                      __)))))
                  | Coq_inr ticb ->
                      let Coq_existT (x0, x1) = hasId in
                      let ida , idb = Obj.magic x0 in
                      let Coq_existT (x2, s1) =
                        ticb
                          (let Coq_existT (x2, x3) = hasId in
                          let ida0 , idb0 = Obj.magic x2 in
                          Coq_existT (idb0, __))
                      in
                      let Coq_existT (y, s2) = s1 in
                      let Coq_existT (z, _) = s2 in
                      Coq_existT ((Obj.magic (a.setoid.choose , x2)),
                      (Coq_existT ((Obj.magic (a.setoid.choose , y)),
                      (Coq_existT ((Obj.magic (a.setoid.choose , z)), __))))))
           | Coq_inr p ->
               let rda , l = p in
               let Coq_existT (x0, s0) = l in
               let Coq_existT (y, s1) = s0 in
               let Coq_existT (z, _) = s1 in
               let Coq_existT (a0, s2) = rda __ __ in
               let Coq_existT (b0, s3) = s2 in
               let Coq_existT (c, _) = s3 in
               let Coq_existT (x1, x2) = hasId in
               let ida , idb = Obj.magic x1 in
               let Coq_existT (w, _) =
                 copy_var (b.setoid.equal (b.times x0 z) (b.times x0 idb))
               in
               if w
               then Coq_existT ((Obj.magic (a0 , y)), (Coq_existT
                      ((Obj.magic (b0 , z)), (Coq_existT
                      ((Obj.magic (c , x0)), __)))))
               else Coq_existT ((Obj.magic (a0 , z)), (Coq_existT
                      ((Obj.magic (b0 , y)), (Coq_existT
                      ((Obj.magic (c , x0)), __))))))
    | Coq_inr p ->
        let rca , idla = p in
        let Coq_existT (a0, s) = rca __ __ in
        let Coq_existT (b0, s0) = s in
        let Coq_existT (c, _) = s0 in
        let Coq_existT (x0, _) =
          idla
            (let Coq_existT (x0, x1) = hasId in
            let ida , idb = Obj.magic x0 in Coq_existT (idb, __))
        in
        let Coq_existT (x1, x2) = hasId in
        let ida , idb = Obj.magic x1 in
        Coq_existT ((Obj.magic (a0 , x0)), (Coq_existT
        ((Obj.magic (b0 , x0)), (Coq_existT ((Obj.magic (c , x0)), __)))))

(** val plusIdentityIsTimesLeftAnnihilator_comp :
    coq_Bisemigroup -> coq_Bisemigroup -> coq_HasIdentity ->
    (coq_PlusIdentityIsTimesLeftAnnihilator_comp,
    coq_PlusIdentityIsTimesLeftAnnihilator_comp) sum ->
    coq_PlusIdentityIsTimesLeftAnnihilator_comp **)

let plusIdentityIsTimesLeftAnnihilator_comp a b b_hasId x hasId =
  match x with
    | Coq_inl idla ->
        let Coq_existT (x0, _) =
          idla
            (let Coq_existT (x0, x1) = hasId in
            let ida , idb = Obj.magic x0 in Coq_existT (ida, __))
        in
        let Coq_existT (x1, x2) = hasId in
        let ida , idb = Obj.magic x1 in
        Coq_existT ((Obj.magic (x0 , idb)), __)
    | Coq_inr idlb ->
        let Coq_existT (x0, _) =
          idlb
            (let Coq_existT (x0, x1) = hasId in
            let ida , idb = Obj.magic x0 in Coq_existT (idb, __))
        in
        let Coq_existT (x1, x2) = hasId in
        let ida , idb = Obj.magic x1 in
        Coq_existT ((Obj.magic (ida , x0)), __)

(** val plusIdentityIsTimesRightAnnihilator_comp :
    coq_Bisemigroup -> coq_Bisemigroup -> coq_HasIdentity ->
    (coq_PlusIdentityIsTimesRightAnnihilator_comp,
    coq_PlusIdentityIsTimesRightAnnihilator_comp) sum ->
    coq_PlusIdentityIsTimesRightAnnihilator_comp **)

let plusIdentityIsTimesRightAnnihilator_comp a b b_hasId x hasId =
  match x with
    | Coq_inl idla ->
        let Coq_existT (x0, _) =
          idla
            (let Coq_existT (x0, x1) = hasId in
            let ida , idb = Obj.magic x0 in Coq_existT (ida, __))
        in
        let Coq_existT (x1, x2) = hasId in
        let ida , idb = Obj.magic x1 in
        Coq_existT ((Obj.magic (x0 , idb)), __)
    | Coq_inr idlb ->
        let Coq_existT (x0, _) =
          idlb
            (let Coq_existT (x0, x1) = hasId in
            let ida , idb = Obj.magic x0 in Coq_existT (idb, __))
        in
        let Coq_existT (x1, x2) = hasId in
        let ida , idb = Obj.magic x1 in
        Coq_existT ((Obj.magic (ida , x0)), __)

