open DecSetoid
open Preorder
open PreorderProperties
open Semigroup
open SemigroupProperties
open Specif

let __ = let rec f _ = Obj.repr f in Obj.repr f

(** val le : coq_Semigroup -> carrier -> carrier -> bool **)

let le s x y =
  s.setoid.equal (s.op x y) x

(** val leftNaturalOrder : coq_Semigroup -> coq_Preorder **)

let leftNaturalOrder s =
  { Preorder.setoid = s.setoid; Preorder.le = (le s) }

(** val hasTop : coq_Semigroup -> coq_HasIdentity -> coq_HasTop **)

let hasTop s = function
  | Coq_existT (a, _) -> Coq_existT (a, __)

(** val hasTop_comp :
    coq_Semigroup -> coq_HasIdentity_comp -> coq_HasTop_comp **)

let hasTop_comp s id x =
  let Coq_existT (y, _) = id x in Coq_existT (y, __)

(** val hasBottom : coq_Semigroup -> coq_HasAnnihilator -> coq_HasBottom **)

let hasBottom s = function
  | Coq_existT (a, _) -> Coq_existT (a, __)

(** val hasBottom_comp :
    coq_Semigroup -> coq_HasAnnihilator_comp -> coq_HasBottom_comp **)

let hasBottom_comp s id x =
  let Coq_existT (y, _) = id x in Coq_existT (y, __)

(** val total_comp :
    coq_Semigroup -> coq_IsSelective_comp -> coq_Total_comp **)

let total_comp s = function
  | Coq_existT (a, s0) ->
      let Coq_existT (b, _) = s0 in Coq_existT (a, (Coq_existT (b, __)))

