open Datatypes
open DecSetoid
open DecSetoidProperties
open FMinSets
open FSets
open Preorder
open PreorderProperties
open Semigroup
open SemigroupProperties
open Specif

type __ = Obj.t
let __ = let rec f _ = Obj.repr f in Obj.repr f

(** val mset_union : coq_Preorder -> carrier -> carrier -> carrier **)

let mset_union a x y =
  min a (Obj.magic (union a.Preorder.setoid (Obj.magic x) (Obj.magic y)))

(** val msetUnionSemigroup : coq_Preorder -> coq_Semigroup **)

let msetUnionSemigroup a =
  { setoid = (msetDecSetoid a); op = (mset_union a) }

(** val total_antisym_sing :
    coq_Preorder -> carrier -> (__, (carrier, __) sigT) sum **)

let total_antisym_sing a x =
  match Obj.magic x with
    | [] -> Coq_inl __
    | x0 :: xs -> Coq_inr
        (let Coq_existT (a0, _) = min_exists_mem a (x0 :: xs) x0 in
        Coq_existT (a0, __))

(** val isSelective_comp :
    coq_Preorder -> coq_Total_comp -> coq_IsSelective_comp **)

let isSelective_comp a = function
  | Coq_existT (a0, s) ->
      let Coq_existT (b, _) = s in
      Coq_existT ((Obj.magic (a0 :: [])), (Coq_existT (
      (Obj.magic (b :: [])), __)))

(** val hasIdentity : coq_Preorder -> coq_HasIdentity **)

let hasIdentity a =
  Coq_existT ((Obj.magic []), __)

(** val hasAnnihilator : coq_Preorder -> coq_Finite -> coq_HasAnnihilator **)

let hasAnnihilator a = function
  | Coq_existT (l, _) -> Coq_existT ((Obj.magic l), __)

(** val isLeft_comp : coq_Preorder -> coq_IsLeft_comp **)

let isLeft_comp a =
  Coq_existT ((Obj.magic []), (Coq_existT
    ((Obj.magic (a.Preorder.setoid.choose :: [])), __)))

(** val isRight_comp : coq_Preorder -> coq_IsRight_comp **)

let isRight_comp a =
  Coq_existT ((Obj.magic (a.Preorder.setoid.choose :: [])), (Coq_existT
    ((Obj.magic []), __)))

(** val leftCondensed_comp : coq_Preorder -> coq_LeftCondensed_comp **)

let leftCondensed_comp a =
  Coq_existT ((Obj.magic []), (Coq_existT ((Obj.magic []), (Coq_existT
    ((Obj.magic (a.Preorder.setoid.choose :: [])), __)))))

(** val rightCondensed_comp : coq_Preorder -> coq_RightCondensed_comp **)

let rightCondensed_comp a =
  Coq_existT ((Obj.magic []), (Coq_existT ((Obj.magic []), (Coq_existT
    ((Obj.magic (a.Preorder.setoid.choose :: [])), __)))))

(** val leftCancelative_comp : coq_Preorder -> coq_LeftCancelative_comp **)

let leftCancelative_comp a =
  Coq_existT ((Obj.magic (a.Preorder.setoid.choose :: [])), (Coq_existT
    ((Obj.magic []), (Coq_existT
    ((Obj.magic (a.Preorder.setoid.choose :: [])), __)))))

(** val rightCancelative_comp : coq_Preorder -> coq_RightCancelative_comp **)

let rightCancelative_comp a =
  Coq_existT ((Obj.magic (a.Preorder.setoid.choose :: [])), (Coq_existT
    ((Obj.magic []), (Coq_existT
    ((Obj.magic (a.Preorder.setoid.choose :: [])), __)))))

(** val antiRight_comp : coq_Preorder -> coq_AntiRight_comp **)

let antiRight_comp a =
  Coq_existT ((Obj.magic []), (Coq_existT ((Obj.magic []), __)))

(** val antiLeft_comp : coq_Preorder -> coq_AntiLeft_comp **)

let antiLeft_comp a =
  Coq_existT ((Obj.magic []), (Coq_existT ((Obj.magic []), __)))

