open Datatypes
open DecSetoid
open FMinSets
open FSetOp
open FSets
open List0
open Logic0
open OrderSemigroup
open OrderSemigroupProperties
open Preorder
open Semigroup
open SemigroupProperties
open Specif

type __ = Obj.t
let __ = let rec f _ = Obj.repr f in Obj.repr f

(** val mset_op : coq_OrderSemigroup -> carrier -> carrier -> carrier **)

let mset_op a x y =
  min (preorderOS a) (fset_op (semigroupOS a) x y)

(** val upper_op_elim :
    coq_OrderSemigroup -> carrier -> carrier -> carrier -> (carrier,
    (carrier, __) sigT) sigT **)

let upper_op_elim a a0 x y =
  let Coq_existT (d, _) =
    upper_mem_elim (preorderOS a) a0 (fset_op (semigroupOS a) x y)
  in
  let Coq_existT (b, s) = fset_op_elim (semigroupOS a) d x y in
  let Coq_existT (c, _) = s in
  let Coq_existT (b', _) = min_exists_mem (preorderOS a) (Obj.magic x) b in
  let Coq_existT (c', _) = min_exists_mem (preorderOS a) (Obj.magic y) c in
  Coq_existT (b', (Coq_existT (c', __)))

(** val msetOpSemigroup : coq_OrderSemigroup -> coq_Semigroup **)

let msetOpSemigroup a =
  { setoid = (msetDecSetoid (preorderOS a)); op = (mset_op a) }

(** val isIdempotent_comp :
    coq_OrderSemigroup -> (coq_IsIdempotent_comp, __ *
    coq_SelectiveOpNonDecreasing_comp) sum -> coq_IsIdempotent_comp **)

let isIdempotent_comp a = function
  | Coq_inl i ->
      let Coq_existT (x0, _) = i in Coq_existT ((Obj.magic (x0 :: [])), __)
  | Coq_inr p ->
      let _ , sond = p in
      let Coq_existT (x0, s) = sond __ __ in
      let Coq_existT (y, _) = s in
      Coq_existT ((Obj.magic (x0 :: (y :: []))), __)

(** val isCommutative_comp :
    coq_OrderSemigroup -> coq_IsCommutative_comp -> coq_IsCommutative_comp **)

let isCommutative_comp a = function
  | Coq_existT (a0, s) ->
      let Coq_existT (b, _) = s in
      Coq_existT ((Obj.magic (a0 :: [])), (Coq_existT (
      (Obj.magic (b :: [])), __)))

(** val hasIdentity :
    coq_OrderSemigroup -> coq_HasIdentity -> coq_HasIdentity **)

let hasIdentity a = function
  | Coq_existT (a0, _) -> Coq_existT ((Obj.magic (a0 :: [])), __)

(** val hasAnnihilator : coq_OrderSemigroup -> coq_HasAnnihilator **)

let hasAnnihilator a =
  Coq_existT ((Obj.magic []), __)

(** val isLeft_comp : coq_OrderSemigroup -> coq_IsLeft_comp **)

let isLeft_comp a =
  Coq_existT ((Obj.magic (a.OrderSemigroup.setoid.choose :: [])), (Coq_existT
    ((Obj.magic []), __)))

(** val isRight_comp : coq_OrderSemigroup -> coq_IsRight_comp **)

let isRight_comp a =
  Coq_existT ((Obj.magic []), (Coq_existT
    ((Obj.magic (a.OrderSemigroup.setoid.choose :: [])), __)))

(** val leftCondensed_comp : coq_OrderSemigroup -> coq_LeftCondensed_comp **)

let leftCondensed_comp a =
  Coq_existT ((Obj.magic (a.OrderSemigroup.setoid.choose :: [])), (Coq_existT
    ((Obj.magic []), (Coq_existT
    ((Obj.magic (a.OrderSemigroup.setoid.choose :: [])), __)))))

(** val rightCondensed_comp :
    coq_OrderSemigroup -> coq_RightCondensed_comp **)

let rightCondensed_comp a =
  Coq_existT ((Obj.magic (a.OrderSemigroup.setoid.choose :: [])), (Coq_existT
    ((Obj.magic []), (Coq_existT
    ((Obj.magic (a.OrderSemigroup.setoid.choose :: [])), __)))))

(** val leftCancelative_comp :
    coq_OrderSemigroup -> coq_LeftCancelative_comp **)

let leftCancelative_comp a =
  Coq_existT ((Obj.magic (a.OrderSemigroup.setoid.choose :: [])), (Coq_existT
    ((Obj.magic []), (Coq_existT ((Obj.magic []), __)))))

(** val rightCancelative_comp :
    coq_OrderSemigroup -> coq_RightCancelative_comp **)

let rightCancelative_comp a =
  Coq_existT ((Obj.magic (a.OrderSemigroup.setoid.choose :: [])), (Coq_existT
    ((Obj.magic []), (Coq_existT ((Obj.magic []), __)))))

(** val antiRight_comp : coq_OrderSemigroup -> coq_AntiRight_comp **)

let antiRight_comp a =
  Coq_existT ((Obj.magic []), (Coq_existT ((Obj.magic []), __)))

(** val antiLeft_comp : coq_OrderSemigroup -> coq_AntiLeft_comp **)

let antiLeft_comp a =
  Coq_existT ((Obj.magic []), (Coq_existT ((Obj.magic []), __)))

(** val sel_dec :
    coq_OrderSemigroup -> carrier -> carrier -> (__, __) sum **)

let sel_dec a x y =
  let Coq_existT (w, _) =
    copy_var (a.OrderSemigroup.setoid.equal (a.OrderSemigroup.op x y) x)
  in
  if w
  then Coq_inl __
  else let Coq_existT (w0, _) =
         copy_var (a.OrderSemigroup.setoid.equal (a.OrderSemigroup.op x y) y)
       in
       if w0 then Coq_inr __ else Coq_inl __

(** val coq_Lrel_dec :
    coq_OrderSemigroup -> carrier -> carrier -> (__, __) sum **)

let coq_Lrel_dec a x y =
  if a.OrderSemigroup.setoid.equal (a.OrderSemigroup.op x y) x
  then if a.OrderSemigroup.setoid.equal (a.OrderSemigroup.op y x) y
       then Coq_inl __
       else Coq_inr __
  else Coq_inr __

(** val coq_Rrel_dec :
    coq_OrderSemigroup -> carrier -> carrier -> (__, __) sum **)

let coq_Rrel_dec a x y =
  if a.OrderSemigroup.setoid.equal (a.OrderSemigroup.op x y) y
  then if a.OrderSemigroup.setoid.equal (a.OrderSemigroup.op y x) x
       then Coq_inl __
       else Coq_inr __
  else Coq_inr __

(** val coq_Arel_dec :
    coq_OrderSemigroup -> carrier -> carrier -> (__, __) sum **)

let coq_Arel_dec a x y =
  if a.OrderSemigroup.setoid.equal (a.OrderSemigroup.op x y) y
  then if a.OrderSemigroup.setoid.equal (a.OrderSemigroup.op y x) y
       then if a.OrderSemigroup.setoid.equal x y
            then Coq_inr __
            else Coq_inl __
       else Coq_inr __
  else Coq_inr __

(** val rel_dec :
    coq_OrderSemigroup -> carrier -> carrier -> (((__, __) sum, __) sum, __)
    sum **)

let rel_dec a x y =
  let Coq_existT (w, _) = copy_var (a.OrderSemigroup.setoid.equal x y) in
  if w
  then Coq_inl (Coq_inl (Coq_inl __))
  else (match sel_dec a x y with
          | Coq_inl _ ->
              (match sel_dec a y x with
                 | Coq_inl _ -> Coq_inl (Coq_inl (Coq_inl __))
                 | Coq_inr _ -> Coq_inr __)
          | Coq_inr _ ->
              (match sel_dec a y x with
                 | Coq_inl _ -> Coq_inl (Coq_inr __)
                 | Coq_inr _ -> Coq_inl (Coq_inl (Coq_inr __))))

(** val coq_LR_comp_eq :
    coq_OrderSemigroup -> carrier -> carrier -> carrier -> (__, __) sum **)

let coq_LR_comp_eq a x y z =
  let Coq_existT (w, _) = copy_var (a.OrderSemigroup.setoid.equal x y) in
  if w
  then Coq_inl __
  else let Coq_existT (w0, _) = copy_var (a.OrderSemigroup.setoid.equal y z)
       in
       if w0 then Coq_inr __ else assert false (* absurd case *)

(** val coq_RL_comp_eq :
    coq_OrderSemigroup -> carrier -> carrier -> carrier -> (__, __) sum **)

let coq_RL_comp_eq a x y z =
  match coq_LR_comp_eq a z y x with
    | Coq_inl _ -> Coq_inr __
    | Coq_inr _ -> Coq_inl __

type coq_AntichainChoiceComparable_comp =
  (carrier, (carrier, __ * (carrier, __) sigT) sigT) sigT

type coq_AntichainArrowUniqueSrc_comp =
  (carrier, (carrier, __ * (carrier, __) sigT) sigT) sigT

type coq_AntichainChoiceMidleOrder_comp =
  (carrier, (carrier, __ * (carrier, __) sigT) sigT) sigT

type coq_AntichainMiddleElm_comp =
  (carrier, (carrier, __ * (carrier, __) sigT) sigT) sigT

type coq_CE = coq_IsSelective_comp

(** val acc_CE_1 :
    coq_OrderSemigroup -> carrier -> carrier -> carrier -> coq_CE **)

let acc_CE_1 a x y z =
  Coq_existT ((Obj.magic (y :: [])), (Coq_existT
    ((Obj.magic (x :: (z :: []))), __)))

(** val acc_CE_2 :
    coq_OrderSemigroup -> carrier -> carrier -> carrier -> coq_CE **)

let acc_CE_2 a x y z =
  Coq_existT ((Obj.magic (x :: (z :: []))), (Coq_existT
    ((Obj.magic (y :: [])), __)))

(** val acc_CE_3 :
    coq_OrderSemigroup -> carrier -> carrier -> carrier -> coq_CE **)

let acc_CE_3 a x y z =
  Coq_existT ((Obj.magic (y :: [])), (Coq_existT
    ((Obj.magic (x :: (z :: []))), __)))

(** val acc_CE_4 :
    coq_OrderSemigroup -> carrier -> carrier -> carrier -> coq_CE **)

let acc_CE_4 a x y z =
  Coq_existT ((Obj.magic (y :: [])), (Coq_existT
    ((Obj.magic (x :: (z :: []))), __)))

(** val acc_CE_5 :
    coq_OrderSemigroup -> carrier -> carrier -> carrier -> coq_CE **)

let acc_CE_5 a x y z =
  Coq_existT ((Obj.magic (x :: (z :: []))), (Coq_existT
    ((Obj.magic (y :: [])), __)))

(** val acc_CE :
    coq_OrderSemigroup -> coq_AntichainChoiceComparable_comp -> coq_CE **)

let acc_CE a = function
  | Coq_existT (x0, s) ->
      let Coq_existT (y, p) = s in
      let _ , s0 = p in
      let Coq_existT (z, _) = s0 in
      (match rel_dec a y z with
         | Coq_inl s1 ->
             (match s1 with
                | Coq_inl s2 ->
                    (match s2 with
                       | Coq_inl _ -> Coq_existT
                           ((Obj.magic (z :: (x0 :: []))), (Coq_existT
                           ((Obj.magic (y :: [])), __)))
                       | Coq_inr _ -> Coq_existT ((Obj.magic (y :: [])),
                           (Coq_existT ((Obj.magic (z :: (x0 :: []))), __))))
                | Coq_inr _ -> Coq_existT ((Obj.magic (y :: [])), (Coq_existT
                    ((Obj.magic (x0 :: (z :: []))), __))))
         | Coq_inr _ ->
             (match rel_dec a x0 z with
                | Coq_inl s1 ->
                    (match s1 with
                       | Coq_inl s2 ->
                           (match s2 with
                              | Coq_inl _ -> Coq_existT
                                  ((Obj.magic (x0 :: [])), (Coq_existT
                                  ((Obj.magic (z :: (y :: []))), __)))
                              | Coq_inr _ -> Coq_existT
                                  ((Obj.magic (z :: (y :: []))), (Coq_existT
                                  ((Obj.magic (x0 :: [])), __))))
                       | Coq_inr _ -> Coq_existT ((Obj.magic (z :: [])),
                           (Coq_existT ((Obj.magic (x0 :: (y :: []))), __))))
                | Coq_inr _ -> Coq_existT ((Obj.magic (x0 :: [])),
                    (Coq_existT ((Obj.magic (z :: (y :: []))), __)))))

(** val aaus_CE_1 :
    coq_OrderSemigroup -> carrier -> carrier -> carrier -> (__, __) sum ->
    coq_CE **)

let aaus_CE_1 a x y z p5 =
  Coq_existT ((Obj.magic (z :: [])), (Coq_existT
    ((Obj.magic (x :: (y :: []))), __)))

(** val aaus_CE_2 :
    coq_OrderSemigroup -> carrier -> carrier -> carrier -> (__, __) sum ->
    coq_CE **)

let aaus_CE_2 a x y z p5 =
  Coq_existT ((Obj.magic (z :: [])), (Coq_existT
    ((Obj.magic (x :: (y :: []))), __)))

(** val aaus_CE_3 :
    coq_OrderSemigroup -> carrier -> carrier -> carrier -> (__, __) sum ->
    coq_CE **)

let aaus_CE_3 a x y z p5 =
  Coq_existT ((Obj.magic (x :: (y :: []))), (Coq_existT
    ((Obj.magic (z :: [])), __)))

(** val aaus_CE :
    coq_OrderSemigroup -> coq_AntichainArrowUniqueSrc_comp -> coq_CE **)

let aaus_CE a = function
  | Coq_existT (x0, s) ->
      let Coq_existT (y, p) = s in
      let _ , s0 = p in
      let Coq_existT (z, _) = s0 in
      let Coq_existT (w, _) =
        copy_var
          (if negb (a.OrderSemigroup.le x0 z)
           then negb (a.OrderSemigroup.le z x0)
           else false)
      in
      if w
      then acc_CE a (Coq_existT (x0, (Coq_existT (y, (__ , (Coq_existT (z,
             __)))))))
      else (match rel_dec a x0 z with
              | Coq_inl s1 ->
                  (match s1 with
                     | Coq_inl s2 ->
                         (match s2 with
                            | Coq_inl _ -> Coq_existT (
                                (Obj.magic (z :: [])), (Coq_existT
                                ((Obj.magic (x0 :: (y :: []))), __)))
                            | Coq_inr _ -> Coq_existT
                                ((Obj.magic (x0 :: (y :: []))), (Coq_existT
                                ((Obj.magic (z :: [])), __))))
                     | Coq_inr _ ->
                         (match rel_dec a z y with
                            | Coq_inl s2 ->
                                (match s2 with
                                   | Coq_inl s3 -> assert false
                                       (* absurd case *)
                                   | Coq_inr _ -> Coq_existT
                                       ((Obj.magic (z :: [])), (Coq_existT
                                       ((Obj.magic (x0 :: (y :: []))), __))))
                            | Coq_inr _ -> assert false (* absurd case *)))
              | Coq_inr _ -> Coq_existT ((Obj.magic (x0 :: [])), (Coq_existT
                  ((Obj.magic (z :: (y :: []))), __))))

(** val acmo_CE :
    coq_OrderSemigroup -> coq_AntichainChoiceMidleOrder_comp -> coq_CE **)

let acmo_CE a = function
  | Coq_existT (x0, s) ->
      let Coq_existT (y, p) = s in
      let _ , s0 = p in
      let Coq_existT (z, _) = s0 in
      Coq_existT ((Obj.magic (x0 :: (y :: []))), (Coq_existT
      ((Obj.magic (z :: [])), __)))

(** val ame_CE :
    coq_OrderSemigroup -> coq_AntichainMiddleElm_comp -> coq_CE **)

let ame_CE a = function
  | Coq_existT (x0, s) ->
      let Coq_existT (y, p) = s in
      let _ , s0 = p in
      let Coq_existT (z, _) = s0 in
      (match rel_dec a y z with
         | Coq_inl s1 ->
             (match s1 with
                | Coq_inl s2 ->
                    (match s2 with
                       | Coq_inl _ -> Coq_existT
                           ((Obj.magic (x0 :: (y :: []))), (Coq_existT
                           ((Obj.magic (z :: [])), __)))
                       | Coq_inr _ -> Coq_existT ((Obj.magic (z :: [])),
                           (Coq_existT ((Obj.magic (x0 :: (y :: []))), __))))
                | Coq_inr _ -> assert false (* absurd case *))
         | Coq_inr _ -> Coq_existT ((Obj.magic (x0 :: (y :: []))),
             (Coq_existT ((Obj.magic (z :: [])), __))))

(** val mset_L_single_dec :
    coq_OrderSemigroup -> carrier -> carrier -> (__, (carrier, __) sigT) sum **)

let mset_L_single_dec a a0 n =
  let rec f = function
    | [] -> Coq_inl __
    | a1 :: l0 ->
        (match f l0 with
           | Coq_inl _ ->
               (match coq_Lrel_dec a a0 a1 with
                  | Coq_inl _ -> Coq_inl __
                  | Coq_inr _ -> Coq_inr (Coq_existT (a1, __)))
           | Coq_inr s ->
               let Coq_existT (c, _) = s in Coq_inr (Coq_existT (c, __)))
  in f (Obj.magic n)

(** val mset_L_dec :
    coq_OrderSemigroup -> carrier -> carrier -> (__, (carrier, (carrier, __)
    sigT) sigT) sum **)

let mset_L_dec a m n =
  let rec f l n0 =
    match l with
      | [] -> Coq_inl __
      | a0 :: l0 ->
          (match f l0 n0 with
             | Coq_inl _ ->
                 (match mset_L_single_dec a a0 n0 with
                    | Coq_inl _ -> Coq_inl __
                    | Coq_inr s ->
                        let Coq_existT (c, _) = s in
                        Coq_inr (Coq_existT (a0, (Coq_existT (c, __)))))
             | Coq_inr s ->
                 let Coq_existT (b, s0) = s in
                 let Coq_existT (c, _) = s0 in
                 Coq_inr (Coq_existT (b, (Coq_existT (c, __)))))
  in f (Obj.magic m) n

(** val mset_R_single_dec :
    coq_OrderSemigroup -> carrier -> carrier -> (__, (carrier, __) sigT) sum **)

let mset_R_single_dec a a0 n =
  let rec f = function
    | [] -> Coq_inl __
    | a1 :: l0 ->
        (match f l0 with
           | Coq_inl _ ->
               (match coq_Rrel_dec a a0 a1 with
                  | Coq_inl _ -> Coq_inl __
                  | Coq_inr _ -> Coq_inr (Coq_existT (a1, __)))
           | Coq_inr s ->
               let Coq_existT (c, _) = s in Coq_inr (Coq_existT (c, __)))
  in f (Obj.magic n)

(** val mset_R_dec :
    coq_OrderSemigroup -> carrier -> carrier -> (__, (carrier, (carrier, __)
    sigT) sigT) sum **)

let mset_R_dec a m n =
  let rec f l n0 =
    match l with
      | [] -> Coq_inl __
      | a0 :: l0 ->
          (match f l0 n0 with
             | Coq_inl _ ->
                 (match mset_R_single_dec a a0 n0 with
                    | Coq_inl _ -> Coq_inl __
                    | Coq_inr s ->
                        let Coq_existT (c, _) = s in
                        Coq_inr (Coq_existT (a0, (Coq_existT (c, __)))))
             | Coq_inr s ->
                 let Coq_existT (b, s0) = s in
                 let Coq_existT (c, _) = s0 in
                 Coq_inr (Coq_existT (b, (Coq_existT (c, __)))))
  in f (Obj.magic m) n

(** val coq_LR_Arel :
    coq_OrderSemigroup -> carrier -> carrier -> carrier -> carrier -> (__,
    __) sum **)

let coq_LR_Arel a x y z w =
  match rel_dec a x z with
    | Coq_inl s ->
        (match s with
           | Coq_inl s0 -> assert false (* absurd case *)
           | Coq_inr _ -> Coq_inl __)
    | Coq_inr _ -> Coq_inr __

(** val mset_dec_1 :
    coq_OrderSemigroup -> carrier -> carrier -> carrier -> (carrier,
    (carrier, __) sigT) sigT **)

let mset_dec_1 a x y m =
  Coq_existT (x, (Coq_existT (y, __)))

(** val coq_Emset : coq_OrderSemigroup -> carrier -> bool **)

let coq_Emset a m =
  (msetOpSemigroup a).setoid.equal m (Obj.magic [])

type coq_Smset = (carrier, __) sigT

type coq_Tmset = (carrier, (carrier, __) sigT) sigT

type coq_Amset = (carrier, (carrier, __) sigT) sigT

(** val coq_Amset_rev :
    coq_OrderSemigroup -> carrier -> carrier -> coq_Amset -> coq_Amset **)

let coq_Amset_rev a m n = function
  | Coq_existT (x0, s) ->
      let Coq_existT (y, _) = s in Coq_existT (x0, (Coq_existT (y, __)))

(** val coq_Amset_rev_2 :
    coq_OrderSemigroup -> carrier -> carrier -> coq_Amset -> coq_Amset **)

let coq_Amset_rev_2 a m n = function
  | Coq_existT (x, s) ->
      let Coq_existT (y, _) = s in Coq_existT (x, (Coq_existT (y, __)))

(** val mset_dec :
    coq_OrderSemigroup -> carrier -> ((__, __) sum, coq_Amset) sum **)

let mset_dec a m =
  match mset_L_dec a (min (preorderOS a) m) (min (preorderOS a) m) with
    | Coq_inl _ -> Coq_inl (Coq_inl __)
    | Coq_inr s ->
        let Coq_existT (a0, s0) = s in
        let Coq_existT (b, _) = s0 in
        (match mset_R_dec a (min (preorderOS a) m) (min (preorderOS a) m) with
           | Coq_inl _ -> Coq_inl (Coq_inr __)
           | Coq_inr s1 ->
               let Coq_existT (c, s2) = s1 in
               let Coq_existT (d, _) = s2 in
               Coq_inr
               (match rel_dec a a0 b with
                  | Coq_inl s3 ->
                      (match s3 with
                         | Coq_inl s4 ->
                             (match s4 with
                                | Coq_inl _ -> assert false (* absurd case *)
                                | Coq_inr _ ->
                                    (match rel_dec a c d with
                                       | Coq_inl s5 ->
                                           (match s5 with
                                              | Coq_inl s6 ->
                                                  (
                                                  match s6 with
                                                    | 
                                                  Coq_inl _ ->
                                                  (match 
                                                  match 
                                                  rel_dec a c a0 with
                                                    | 
                                                  Coq_inl s7 ->
                                                  (match s7 with
                                                    | 
                                                  Coq_inl s8 -> assert false
                                                  (* absurd case *)
                                                    | 
                                                  Coq_inr _ -> Coq_inl __)
                                                    | 
                                                  Coq_inr _ -> Coq_inr __ with
                                                    | 
                                                  Coq_inl _ -> Coq_existT (c,
                                                  (Coq_existT (a0, __)))
                                                    | 
                                                  Coq_inr _ -> Coq_existT
                                                  (a0, (Coq_existT (c, __))))
                                                    | 
                                                  Coq_inr _ -> assert false
                                                  (* absurd case *))
                                              | Coq_inr _ -> Coq_existT (c,
                                                  (Coq_existT (d, __))))
                                       | Coq_inr _ -> Coq_existT (d,
                                           (Coq_existT (c, __)))))
                         | Coq_inr _ -> Coq_existT (a0, (Coq_existT (b, __))))
                  | Coq_inr _ -> Coq_existT (b, (Coq_existT (a0, __)))))

(** val mset_empty_dec :
    coq_OrderSemigroup -> carrier -> (__, (carrier, __) sigT) sum **)

let mset_empty_dec a m =
  match Obj.magic m with
    | [] -> Coq_inl __
    | a0 :: n -> Coq_inr
        (let Coq_existT (b, _) = min_exists_mem (preorderOS a) (a0 :: n) a0
         in
        Coq_existT (b, __))

(** val mset_red : coq_OrderSemigroup -> carrier -> (carrier, __) sigT **)

let mset_red a m =
  Coq_existT ((min (preorderOS a) m), __)

(** val mset_red_2 : coq_OrderSemigroup -> carrier -> (carrier, __) sigT **)

let mset_red_2 a m =
  Coq_existT ((min (preorderOS a) m), __)

(** val coq_LR_mset_order :
    coq_OrderSemigroup -> carrier -> carrier -> coq_Tmset -> coq_Tmset ->
    (__, __) sum **)

let coq_LR_mset_order a m n x x0 =
  let Coq_existT (a0, s) = x in
  let Coq_existT (b, _) = s in
  let Coq_existT (c, s0) = x0 in
  let Coq_existT (d, _) = s0 in
  (match rel_dec a b c with
     | Coq_inl s1 ->
         (match s1 with
            | Coq_inl s2 -> assert false (* absurd case *)
            | Coq_inr _ -> Coq_inl __)
     | Coq_inr _ -> Coq_inr __)

(** val mset_size_dec :
    coq_OrderSemigroup -> carrier -> ((__, coq_Smset) sum, coq_Tmset) sum **)

let mset_size_dec a m =
  let Coq_existT (n, _) = mset_red a m in
  (match Obj.magic n with
     | [] -> Coq_inl (Coq_inl __)
     | a0 :: n0 ->
         let Coq_existT (w, _) =
           copy_var (forallb ((preorderOS a).Preorder.setoid.equal a0) n0)
         in
         if w
         then Coq_inl (Coq_inr (Coq_existT (a0, __)))
         else Coq_inr
                (let Coq_existT (b, _) =
                   existsb_mem_elim a.OrderSemigroup.setoid (fun x ->
                     negb (a.OrderSemigroup.setoid.equal a0 x)) n0
                 in
                Coq_existT (a0, (Coq_existT (b, __)))))

(** val coq_Tmset_neq :
    coq_OrderSemigroup -> carrier -> carrier -> coq_Tmset -> (carrier, __)
    sigT **)

let coq_Tmset_neq a m x = function
  | Coq_existT (y1, s) ->
      let Coq_existT (y2, _) = s in
      let Coq_existT (w, _) =
        copy_var ((preorderOS a).Preorder.setoid.equal x y1)
      in
      if w then Coq_existT (y2, __) else Coq_existT (y1, __)

(** val isSelective_comp :
    coq_OrderSemigroup -> (coq_IsSelective_comp, __ *
    (coq_IncompArrowUniqueSrc_comp, coq_IncompArrowFactor_comp) sum) sum ->
    coq_IsSelective_comp **)

let isSelective_comp a = function
  | Coq_inl i ->
      let Coq_existT (x0, s) = i in
      let Coq_existT (y, _) = s in
      Coq_existT ((Obj.magic (x0 :: [])), (Coq_existT (
      (Obj.magic (y :: [])), __)))
  | Coq_inr p ->
      let _ , s = p in
      (match s with
         | Coq_inl i ->
             let Coq_existT (x0, s0) = i __ __ __ __ in
             let Coq_existT (y, s1) = s0 in
             let Coq_existT (z, _) = s1 in
             aaus_CE a (Coq_existT (x0, (Coq_existT (y, (__ , (Coq_existT (z,
               __)))))))
         | Coq_inr i ->
             let Coq_existT (x0, s0) = i __ __ __ __ in
             let Coq_existT (y, s1) = s0 in
             let Coq_existT (z, _) = s1 in
             ame_CE a (Coq_existT (x0, (Coq_existT (y, (__ , (Coq_existT (z,
               __))))))))

