open Bisemigroup
open BisemigroupGlue
open BisemigroupProperties
open Datatypes
open DecSetoid
open FMinSets
open FMinSetsOp
open FMinSetsUnion
open FSets
open List0
open Logic0
open OrderSemigroup
open OrderSemigroupProperties
open PreorderProperties
open Specif

type __ = Obj.t
let __ = let rec f _ = Obj.repr f in Obj.repr f

(** val minsetBisemigroup : coq_OrderSemigroup -> coq_Bisemigroup **)

let minsetBisemigroup a =
  glueBSmg (msetUnionSemigroup (preorderOS a)) (msetOpSemigroup a)

(** val isRightStrictStable_comp :
    coq_OrderSemigroup -> (carrier, (carrier, (carrier, __) sigT) sigT) sigT **)

let isRightStrictStable_comp a =
  Coq_existT ((Obj.magic (a.setoid.choose :: [])), (Coq_existT
    ((Obj.magic []), (Coq_existT ((Obj.magic []), __)))))

(** val isLeftStrictStable_comp :
    coq_OrderSemigroup -> (carrier, (carrier, (carrier, __) sigT) sigT) sigT **)

let isLeftStrictStable_comp a =
  Coq_existT ((Obj.magic (a.setoid.choose :: [])), (Coq_existT
    ((Obj.magic []), (Coq_existT ((Obj.magic []), __)))))

(** val total_singleton :
    coq_OrderSemigroup -> carrier -> (__, (carrier, __) sigT) sum **)

let total_singleton a x =
  match Obj.magic x with
    | [] -> Coq_inl __
    | x0 :: xs -> Coq_inr
        (let Coq_existT (a0, _) = min_exists_mem (preorderOS a) (x0 :: xs) x0
         in
        Coq_existT (a0, __))

(** val isRightCompEqCancel_comp :
    coq_OrderSemigroup -> coq_Total_comp -> (carrier, (carrier, (carrier, __)
    sigT) sigT) sigT **)

let isRightCompEqCancel_comp a = function
  | Coq_existT (a0, s) ->
      let Coq_existT (b, _) = s in
      Coq_existT ((Obj.magic (a0 :: [])), (Coq_existT (
      (Obj.magic (b :: [])), (Coq_existT ((Obj.magic []), __)))))

(** val isLeftCompEqCancel_comp :
    coq_OrderSemigroup -> coq_Total_comp -> (carrier, (carrier, (carrier, __)
    sigT) sigT) sigT **)

let isLeftCompEqCancel_comp a = function
  | Coq_existT (a0, s) ->
      let Coq_existT (b, _) = s in
      Coq_existT ((Obj.magic (a0 :: [])), (Coq_existT (
      (Obj.magic (b :: [])), (Coq_existT ((Obj.magic []), __)))))

(** val leftDiscrete_comp :
    coq_OrderSemigroup -> (carrier, (carrier, (carrier, __) sigT) sigT) sigT **)

let leftDiscrete_comp a =
  Coq_existT ((Obj.magic (a.setoid.choose :: [])), (Coq_existT
    ((Obj.magic []), (Coq_existT ((Obj.magic (a.setoid.choose :: [])),
    __)))))

(** val rightDiscrete_comp :
    coq_OrderSemigroup -> (carrier, (carrier, (carrier, __) sigT) sigT) sigT **)

let rightDiscrete_comp a =
  Coq_existT ((Obj.magic (a.setoid.choose :: [])), (Coq_existT
    ((Obj.magic []), (Coq_existT ((Obj.magic (a.setoid.choose :: [])),
    __)))))

(** val rc_CE_1 :
    coq_OrderSemigroup -> coq_RightTotal_comp -> (carrier, (carrier,
    (carrier, __) sigT) sigT) sigT **)

let rc_CE_1 a = function
  | Coq_existT (z, s) ->
      let Coq_existT (x0, s0) = s in
      let Coq_existT (y, _) = s0 in
      Coq_existT ((Obj.magic (x0 :: [])), (Coq_existT (
      (Obj.magic (y :: [])), (Coq_existT ((Obj.magic (z :: [])), __)))))

(** val rc_CE_2 :
    coq_OrderSemigroup -> coq_RightMultChoiseComp_comp -> (carrier, (carrier,
    (carrier, __) sigT) sigT) sigT **)

let rc_CE_2 a x =
  let Coq_existT (x0, s) = x __ in
  let Coq_existT (y, s0) = s in
  let Coq_existT (z, s1) = s0 in
  let Coq_existT (w, _) = s1 in
  Coq_existT ((Obj.magic (x0 :: [])), (Coq_existT (
  (Obj.magic (y :: [])), (Coq_existT ((Obj.magic (z :: (w :: []))), __)))))

(** val rc_sing :
    coq_OrderSemigroup -> carrier -> carrier -> carrier -> (carrier, __) sigT **)

let rc_sing a x u b =
  let rec f l u0 b0 =
    match l with
      | [] -> assert false (* absurd case *)
      | a0 :: l0 ->
          (match l0 with
             | [] -> Coq_existT (a0, __)
             | a' :: x0 ->
                 let Coq_existT (c, _) = f l0 a' b0 in
                 let Coq_existT (w, _) =
                   copy_var (a.le (a.op a0 b0) (a.op c b0))
                 in
                 if w then Coq_existT (a0, __) else Coq_existT (c, __))
  in f (Obj.magic x) u b

(** val rc_unique :
    coq_OrderSemigroup -> carrier -> carrier -> carrier -> (carrier, __) sigT **)

let rc_unique a x u z =
  let rec f = function
    | [] -> Coq_existT (u, __)
    | a0 :: l0 ->
        let Coq_existT (a1, _) = f l0 in
        let Coq_existT (a', _) = rc_sing a x u a0 in
        let Coq_existT (w, _) =
          copy_var (a.setoid.equal (a.op a1 a0) (a.op a' a0))
        in
        if w
        then Coq_existT (a1, __)
        else let Coq_existT (w0, _) =
               copy_var
                 (forallb (fun z1 ->
                   if negb
                        (mem a.setoid (a.op a1 z1)
                          (Obj.magic
                            ((minsetBisemigroup a).times
                              (Obj.magic (a1 :: [])) 
                              (Obj.magic l0))))
                   then true
                   else a.setoid.equal (a.op a' z1) (a.op a1 z1)) l0)
             in
             if w0
             then Coq_existT (a', __)
             else let Coq_existT (z0, _) =
                    existsb_mem_elim a.setoid (fun x0 ->
                      negb
                        (if negb
                              (mem a.setoid (a.op a1 x0)
                                (Obj.magic
                                  (mset_op a (Obj.magic (a1 :: []))
                                    (Obj.magic l0))))
                         then true
                         else a.setoid.equal (a.op a' x0) (a.op a1 x0))) l0
                  in
                  let Coq_existT (w1, _) =
                    copy_var (a.le (a.op a' a0) (a.op a1 z0))
                  in
                  if w1 then Coq_existT (a', __) else Coq_existT (a1, __)
  in f (Obj.magic z)

(** val rightComparable_comp :
    coq_OrderSemigroup -> (coq_RightTotal_comp, __ *
    coq_RightMultChoiseComp_comp) sum -> (carrier, (carrier, (carrier, __)
    sigT) sigT) sigT **)

let rightComparable_comp a = function
  | Coq_inl rt ->
      let Coq_existT (z, s) = rt in
      let Coq_existT (x0, s0) = s in
      let Coq_existT (y, _) = s0 in
      Coq_existT ((Obj.magic (x0 :: [])), (Coq_existT (
      (Obj.magic (y :: [])), (Coq_existT ((Obj.magic (z :: [])), __)))))
  | Coq_inr p ->
      let _ , rmcc = p in
      let Coq_existT (x0, s) = rmcc __ in
      let Coq_existT (y, s0) = s in
      let Coq_existT (z, s1) = s0 in
      let Coq_existT (w, _) = s1 in
      Coq_existT ((Obj.magic (x0 :: [])), (Coq_existT (
      (Obj.magic (y :: [])), (Coq_existT ((Obj.magic (z :: (w :: []))),
      __)))))

(** val lc_CE_1 :
    coq_OrderSemigroup -> coq_LeftTotal_comp -> (carrier, (carrier, (carrier,
    __) sigT) sigT) sigT **)

let lc_CE_1 a = function
  | Coq_existT (z, s) ->
      let Coq_existT (x0, s0) = s in
      let Coq_existT (y, _) = s0 in
      Coq_existT ((Obj.magic (x0 :: [])), (Coq_existT (
      (Obj.magic (y :: [])), (Coq_existT ((Obj.magic (z :: [])), __)))))

(** val lc_CE_2 :
    coq_OrderSemigroup -> coq_LeftMultChoiseComp_comp -> (carrier, (carrier,
    (carrier, __) sigT) sigT) sigT **)

let lc_CE_2 a x =
  let Coq_existT (x0, s) = x __ in
  let Coq_existT (y, s0) = s in
  let Coq_existT (z, s1) = s0 in
  let Coq_existT (w, _) = s1 in
  Coq_existT ((Obj.magic (x0 :: [])), (Coq_existT (
  (Obj.magic (y :: [])), (Coq_existT ((Obj.magic (z :: (w :: []))), __)))))

(** val lc_sing :
    coq_OrderSemigroup -> carrier -> carrier -> carrier -> (carrier, __) sigT **)

let lc_sing a x u b =
  let rec f l u0 b0 =
    match l with
      | [] -> assert false (* absurd case *)
      | a0 :: l0 ->
          (match l0 with
             | [] -> Coq_existT (a0, __)
             | a' :: x0 ->
                 let Coq_existT (c, _) = f l0 a' b0 in
                 let Coq_existT (w, _) =
                   copy_var (a.le (a.op b0 a0) (a.op b0 c))
                 in
                 if w then Coq_existT (a0, __) else Coq_existT (c, __))
  in f (Obj.magic x) u b

(** val lc_unique :
    coq_OrderSemigroup -> carrier -> carrier -> carrier -> (carrier, __) sigT **)

let lc_unique a x u z =
  let rec f = function
    | [] -> Coq_existT (u, __)
    | a0 :: l0 ->
        let Coq_existT (a1, _) = f l0 in
        let Coq_existT (a', _) = lc_sing a x u a0 in
        let Coq_existT (w, _) =
          copy_var (a.setoid.equal (a.op a0 a1) (a.op a0 a'))
        in
        if w
        then Coq_existT (a1, __)
        else let Coq_existT (w0, _) =
               copy_var
                 (forallb (fun z1 ->
                   if negb
                        (mem a.setoid (a.op z1 a1)
                          (Obj.magic
                            ((minsetBisemigroup a).times 
                              (Obj.magic l0) (Obj.magic (a1 :: [])))))
                   then true
                   else a.setoid.equal (a.op z1 a') (a.op z1 a1)) l0)
             in
             if w0
             then Coq_existT (a', __)
             else let Coq_existT (z0, _) =
                    existsb_mem_elim a.setoid (fun x0 ->
                      negb
                        (if negb
                              (mem a.setoid (a.op x0 a1)
                                (Obj.magic
                                  (mset_op a (Obj.magic l0)
                                    (Obj.magic (a1 :: [])))))
                         then true
                         else a.setoid.equal (a.op x0 a') (a.op x0 a1))) l0
                  in
                  let Coq_existT (w1, _) =
                    copy_var (a.le (a.op a0 a') (a.op z0 a1))
                  in
                  if w1 then Coq_existT (a', __) else Coq_existT (a1, __)
  in f (Obj.magic z)

(** val leftComparable_comp :
    coq_OrderSemigroup -> (coq_LeftTotal_comp, __ *
    coq_LeftMultChoiseComp_comp) sum -> (carrier, (carrier, (carrier, __)
    sigT) sigT) sigT **)

let leftComparable_comp a = function
  | Coq_inl rt ->
      let Coq_existT (z, s) = rt in
      let Coq_existT (x0, s0) = s in
      let Coq_existT (y, _) = s0 in
      Coq_existT ((Obj.magic (x0 :: [])), (Coq_existT (
      (Obj.magic (y :: [])), (Coq_existT ((Obj.magic (z :: [])), __)))))
  | Coq_inr p ->
      let _ , rmcc = p in
      let Coq_existT (x0, s) = rmcc __ in
      let Coq_existT (y, s0) = s in
      let Coq_existT (z, s1) = s0 in
      let Coq_existT (w, _) = s1 in
      Coq_existT ((Obj.magic (x0 :: [])), (Coq_existT (
      (Obj.magic (y :: [])), (Coq_existT ((Obj.magic (z :: (w :: []))),
      __)))))

(** val isRightCompCancel_comp :
    coq_OrderSemigroup -> (coq_RightTotal_comp, __ *
    coq_RightMultChoiseComp_comp) sum -> (carrier, (carrier, (carrier, __)
    sigT) sigT) sigT **)

let isRightCompCancel_comp a x =
  let Coq_existT (x0, s) = rightComparable_comp a x in
  let Coq_existT (y, s0) = s in
  let Coq_existT (z, _) = s0 in
  Coq_existT (x0, (Coq_existT (y, (Coq_existT (z, __)))))

(** val isLeftCompCancel_comp :
    coq_OrderSemigroup -> (coq_LeftTotal_comp, __ *
    coq_LeftMultChoiseComp_comp) sum -> (carrier, (carrier, (carrier, __)
    sigT) sigT) sigT **)

let isLeftCompCancel_comp a x =
  let Coq_existT (x0, s) = leftComparable_comp a x in
  let Coq_existT (y, s0) = s in
  let Coq_existT (z, _) = s0 in
  Coq_existT (x0, (Coq_existT (y, (Coq_existT (z, __)))))

(** val leftIncreasing_comp :
    coq_OrderSemigroup -> coq_RightOpNonDecreasing_comp -> (carrier,
    (carrier, __) sigT) sigT **)

let leftIncreasing_comp a = function
  | Coq_existT (x0, s) ->
      let Coq_existT (y, _) = s in
      Coq_existT ((Obj.magic (x0 :: [])), (Coq_existT (
      (Obj.magic (y :: [])), __)))

(** val rightIncreasing_comp :
    coq_OrderSemigroup -> coq_LeftOpNonDecreasing_comp -> (carrier, (carrier,
    __) sigT) sigT **)

let rightIncreasing_comp a = function
  | Coq_existT (x0, s) ->
      let Coq_existT (y, _) = s in
      Coq_existT ((Obj.magic (x0 :: [])), (Coq_existT (
      (Obj.magic (y :: [])), __)))

(** val leftStrictIncreasing_comp :
    coq_OrderSemigroup -> (carrier, (carrier, __) sigT) sigT **)

let leftStrictIncreasing_comp a =
  Coq_existT ((Obj.magic []), (Coq_existT ((Obj.magic []), __)))

(** val rightStrictIncreasing_comp :
    coq_OrderSemigroup -> (carrier, (carrier, __) sigT) sigT **)

let rightStrictIncreasing_comp a =
  Coq_existT ((Obj.magic []), (Coq_existT ((Obj.magic []), __)))

(** val nilOrElement :
    coq_OrderSemigroup -> carrier -> (__, (carrier, __) sigT) sum **)

let nilOrElement a x =
  match Obj.magic x with
    | [] -> Coq_inl __
    | a0 :: x0 -> Coq_inr
        (let Coq_existT (y, _) = min_exists_mem (preorderOS a) (a0 :: x0) a0
         in
        Coq_existT (y, __))

(** val isRightTimesMapToIdConstantPlus_comp :
    coq_OrderSemigroup -> coq_IsRightTimesMapToIdConstantPlus_comp **)

let isRightTimesMapToIdConstantPlus_comp a i =
  let a0 = a.setoid.choose in
  Coq_existT ((Obj.magic (a0 :: [])), (Coq_existT (
  (Obj.magic (a0 :: [])), (Coq_existT ((Obj.magic (a0 :: [])), __)))))

(** val isLeftTimesMapToIdConstantPlus_comp :
    coq_OrderSemigroup -> coq_IsLeftTimesMapToIdConstantPlus_comp **)

let isLeftTimesMapToIdConstantPlus_comp a i =
  let a0 = a.setoid.choose in
  Coq_existT ((Obj.magic (a0 :: [])), (Coq_existT (
  (Obj.magic (a0 :: [])), (Coq_existT ((Obj.magic (a0 :: [])), __)))))

