open Datatypes
open DecSetoid
open DecSetoidProperties
open FSets
open List0
open Logic0
open Preorder
open Specif

type __ = Obj.t
let __ = let rec f _ = Obj.repr f in Obj.repr f

(** val minimal_el : coq_Preorder -> carrier -> carrier -> bool **)

let minimal_el a a0 x =
  forallb (fun b -> negb (if a.le b a0 then negb (a.le a0 b) else false))
    (Obj.magic x)

(** val min : coq_Preorder -> carrier -> carrier **)

let min a x =
  Obj.magic (filter (fun a0 -> minimal_el a a0 x) (Obj.magic x))

(** val eq_mset : coq_Preorder -> carrier -> carrier -> bool **)

let eq_mset a x y =
  (fsetDecSetoid a.setoid).equal (min a x) (min a y)

(** val msetDecSetoid : coq_Preorder -> coq_DecSetoid **)

let msetDecSetoid a =
  { choose = (Obj.magic []); equal = (eq_mset a) }

(** val min_exists_le :
    coq_Preorder -> carrier -> carrier -> (carrier, __) sigT **)

let min_exists_le a x a0 =
  let rec f l a1 =
    match l with
      | [] -> assert false (* absurd case *)
      | a2 :: l0 ->
          let Coq_existT (w, _) = copy_var (minimal_el a a2 (Obj.magic l0))
          in
          if w
          then let Coq_existT (w0, _) =
                 copy_var (if a.le a2 a1 then negb (a.le a1 a2) else false)
               in
               if w0
               then Coq_existT (a2, __)
               else let Coq_existT (y, _) = f l0 a1 in Coq_existT (y, __)
          else let Coq_existT (y, _) = f l0 a1 in Coq_existT (y, __)
  in f (Obj.magic x) a0

(** val min_exists_mem :
    coq_Preorder -> carrier list -> carrier -> (carrier, __) sigT **)

let min_exists_mem a x a0 =
  let Coq_existT (w, _) = copy_var (minimal_el a a0 (Obj.magic x)) in
  if w then Coq_existT (a0, __) else min_exists_le a (Obj.magic x) a0

(** val isSingleton_comp : coq_Preorder -> coq_IsSingleton_comp **)

let isSingleton_comp a c =
  match Obj.magic c with
    | [] -> Coq_existT ((Obj.magic (a.setoid.choose :: [])), __)
    | a0 :: x -> Coq_existT ((Obj.magic []), __)

(** val twoElements : coq_Preorder -> coq_IsSingleton -> coq_TwoElements **)

let twoElements a = function
  | Coq_existT (a0, _) -> Coq_existT ((Obj.magic []), (Coq_existT
      ((Obj.magic (a0 :: [])), __)))

(** val twoElements_comp :
    coq_Preorder -> coq_IsSingleton_comp -> coq_TwoElements_comp **)

let twoElements_comp a sa a0 b =
  match Obj.magic a0 with
    | [] ->
        (match Obj.magic b with
           | [] -> Coq_existT ((Obj.magic []), __)
           | b0 :: y ->
               let Coq_existT (d, _) = min_exists_mem a (b0 :: y) b0 in
               let Coq_existT (c, _) = sa d in
               Coq_existT ((Obj.magic (c :: [])), __))
    | a1 :: x ->
        (match Obj.magic b with
           | [] ->
               let Coq_existT (d, _) = min_exists_mem a (a1 :: x) a1 in
               let Coq_existT (c, _) = sa d in
               Coq_existT ((Obj.magic (c :: [])), __)
           | b0 :: y -> Coq_existT ((Obj.magic []), __))

(** val finite : coq_Preorder -> coq_Finite -> coq_Finite **)

let finite a = function
  | Coq_existT (l, _) -> Coq_existT ((map (min a) (Obj.magic (powerset l))),
      __)

(** val finite_comp : coq_Preorder -> coq_Finite_comp -> coq_Finite_comp **)

let finite_comp a fl l =
  let Coq_existT (x, _) = Obj.magic fl (flat a.setoid (map (min a) l)) in
  Coq_existT ((Obj.magic (x :: [])), __)

(** val upper_mem : coq_Preorder -> carrier -> carrier -> bool **)

let upper_mem a a0 x =
  (fsetDecSetoid a.setoid).equal (min a (Obj.magic (a0 :: (Obj.magic x))))
    (min a x)

(** val upper_mem_elim :
    coq_Preorder -> carrier -> carrier -> (carrier, __) sigT **)

let upper_mem_elim a a0 x =
  let Coq_existT (b, _) = min_exists_mem a (a0 :: (Obj.magic x)) a0 in
  Coq_existT (b, __)

