open Dual
open OrderSemigroup
open OrderSemigroupGlue
open OrderSemigroupProperties
open Specif

let __ = let rec f _ = Obj.repr f in Obj.repr f

(** val dualOrderSemigroup : coq_OrderSemigroup -> coq_OrderSemigroup **)

let dualOrderSemigroup a =
  glueOSmg (semigroupOS a) (dualPreorder (preorderOS a))

(** val leftMonotonic_comp :
    coq_OrderSemigroup -> coq_LeftMonotonic_comp -> coq_LeftMonotonic_comp **)

let leftMonotonic_comp a = function
  | Coq_existT (x0, s) ->
      let Coq_existT (y, s0) = s in
      let Coq_existT (z, _) = s0 in
      Coq_existT (x0, (Coq_existT (z, (Coq_existT (y, __)))))

(** val rightMonotonic_comp :
    coq_OrderSemigroup -> coq_RightMonotonic_comp -> coq_RightMonotonic_comp **)

let rightMonotonic_comp a = function
  | Coq_existT (x0, s) ->
      let Coq_existT (y, s0) = s in
      let Coq_existT (z, _) = s0 in
      Coq_existT (y, (Coq_existT (x0, (Coq_existT (z, __)))))

(** val leftEquivCancelative_comp :
    coq_OrderSemigroup -> coq_LeftEquivCancelative_comp ->
    coq_LeftEquivCancelative_comp **)

let leftEquivCancelative_comp a = function
  | Coq_existT (a0, s) ->
      let Coq_existT (b, s0) = s in
      let Coq_existT (c, _) = s0 in
      Coq_existT (b, (Coq_existT (a0, (Coq_existT (c, __)))))

(** val rightEquivCancelative_comp :
    coq_OrderSemigroup -> coq_RightEquivCancelative_comp ->
    coq_RightEquivCancelative_comp **)

let rightEquivCancelative_comp a = function
  | Coq_existT (a0, s) ->
      let Coq_existT (b, s0) = s in
      let Coq_existT (c, _) = s0 in
      Coq_existT (b, (Coq_existT (a0, (Coq_existT (c, __)))))

(** val leftEquivCondensed_comp :
    coq_OrderSemigroup -> coq_LeftEquivCondensed_comp ->
    coq_LeftEquivCondensed_comp **)

let leftEquivCondensed_comp a = function
  | Coq_existT (a0, s) ->
      let Coq_existT (b, s0) = s in
      let Coq_existT (c, _) = s0 in
      Coq_existT (a0, (Coq_existT (c, (Coq_existT (b, __)))))

(** val rightEquivCondensed_comp :
    coq_OrderSemigroup -> coq_RightEquivCondensed_comp ->
    coq_RightEquivCondensed_comp **)

let rightEquivCondensed_comp a = function
  | Coq_existT (a0, s) ->
      let Coq_existT (b, s0) = s in
      let Coq_existT (c, _) = s0 in
      Coq_existT (a0, (Coq_existT (c, (Coq_existT (b, __)))))

