open DecSetoid
open DecSetoidProperties
open List0
open Specif

let __ = let rec f _ = Obj.repr f in Obj.repr f

type dsProp = { isSingleton : coq_IsSingleton option;
                isSingleton_comp : coq_IsSingleton_comp option;
                twoElements : coq_TwoElements option;
                twoElements_comp : coq_TwoElements_comp option;
                finite : coq_Finite option;
                finite_comp : coq_Finite_comp option }

(** val dsProp_rect :
    coq_DecSetoid -> (coq_IsSingleton option -> coq_IsSingleton_comp option
    -> coq_TwoElements option -> coq_TwoElements_comp option -> coq_Finite
    option -> coq_Finite_comp option -> 'a1) -> dsProp -> 'a1 **)

let dsProp_rect d f d0 =
  let { isSingleton = x; isSingleton_comp = x0; twoElements = x1;
    twoElements_comp = x2; finite = x3; finite_comp = x4 } = d0
  in
  f x x0 x1 x2 x3 x4

(** val dsProp_rec :
    coq_DecSetoid -> (coq_IsSingleton option -> coq_IsSingleton_comp option
    -> coq_TwoElements option -> coq_TwoElements_comp option -> coq_Finite
    option -> coq_Finite_comp option -> 'a1) -> dsProp -> 'a1 **)

let dsProp_rec d f d0 =
  let { isSingleton = x; isSingleton_comp = x0; twoElements = x1;
    twoElements_comp = x2; finite = x3; finite_comp = x4 } = d0
  in
  f x x0 x1 x2 x3 x4

(** val isSingleton : coq_DecSetoid -> dsProp -> coq_IsSingleton option **)

let isSingleton _ x = x.isSingleton

(** val isSingleton_comp :
    coq_DecSetoid -> dsProp -> coq_IsSingleton_comp option **)

let isSingleton_comp _ x = x.isSingleton_comp

(** val twoElements : coq_DecSetoid -> dsProp -> coq_TwoElements option **)

let twoElements _ x = x.twoElements

(** val twoElements_comp :
    coq_DecSetoid -> dsProp -> coq_TwoElements_comp option **)

let twoElements_comp _ x = x.twoElements_comp

(** val finite : coq_DecSetoid -> dsProp -> coq_Finite option **)

let finite _ x = x.finite

(** val finite_comp : coq_DecSetoid -> dsProp -> coq_Finite_comp option **)

let finite_comp _ x = x.finite_comp

(** val dsPropIso :
    coq_DecSetoid -> coq_DecSetoid -> coq_DsIso -> dsProp -> dsProp **)

let dsPropIso d d' i dsp =
  let { isSingleton = isSingleton0; isSingleton_comp = isSingleton_comp0;
    twoElements = twoElements0; twoElements_comp = twoElements_comp0;
    finite = finite0; finite_comp = finite_comp0 } = dsp
  in
  { isSingleton =
  (match isSingleton0 with
     | Some x -> Some
         (let Coq_existT (x0, _) = x in Coq_existT ((i.phi x0), __))
     | None -> None); isSingleton_comp =
  (match isSingleton_comp0 with
     | Some x -> Some (coq_Iso_IsSingleton_comp d d' i x)
     | None -> None); twoElements =
  (match twoElements0 with
     | Some x -> Some (coq_Iso_TwoElements d d' i x)
     | None -> None); twoElements_comp =
  (match twoElements_comp0 with
     | Some x -> Some (coq_Iso_TwoElements_comp d d' i x)
     | None -> None); finite =
  (match finite0 with
     | Some x -> Some
         (let Coq_existT (x0, _) = x in Coq_existT ((map i.phi x0), __))
     | None -> None); finite_comp =
  (match finite_comp0 with
     | Some x -> Some (coq_Iso_Finite_comp d d' i x)
     | None -> None) }

