open Datatypes
open Specif

(** val zerop : nat -> sumbool **)

let zerop = function
  | O -> Coq_left
  | S n0 -> Coq_right

(** val lt_eq_lt_dec : nat -> nat -> sumbool sumor **)

let rec lt_eq_lt_dec n m =
  match n with
    | O ->
        (match m with
           | O -> Coq_inleft Coq_right
           | S n0 -> Coq_inleft Coq_left)
    | S n0 ->
        (match m with
           | O -> Coq_inright
           | S m0 -> lt_eq_lt_dec n0 m0)

(** val gt_eq_gt_dec : nat -> nat -> sumbool sumor **)

let gt_eq_gt_dec n m =
  lt_eq_lt_dec n m

(** val le_lt_dec : nat -> nat -> sumbool **)

let rec le_lt_dec n m =
  match n with
    | O -> Coq_left
    | S n0 -> (match m with
                 | O -> Coq_right
                 | S m0 -> le_lt_dec n0 m0)

(** val le_le_S_dec : nat -> nat -> sumbool **)

let le_le_S_dec n m =
  le_lt_dec n m

(** val le_ge_dec : nat -> nat -> sumbool **)

let le_ge_dec n m =
  le_lt_dec n m

(** val le_gt_dec : nat -> nat -> sumbool **)

let le_gt_dec n m =
  le_lt_dec n m

(** val le_lt_eq_dec : nat -> nat -> sumbool **)

let le_lt_eq_dec n m =
  match lt_eq_lt_dec n m with
    | Coq_inleft x -> x
    | Coq_inright -> assert false (* absurd case *)

(** val nat_compare : nat -> nat -> comparison **)

let nat_compare n m =
  match lt_eq_lt_dec n m with
    | Coq_inleft s -> (match s with
                         | Coq_left -> Lt
                         | Coq_right -> Eq)
    | Coq_inright -> Gt

(** val leb : nat -> nat -> bool **)

let rec leb m x =
  match m with
    | O -> true
    | S m' -> (match x with
                 | O -> false
                 | S n' -> leb m' n')

