open Bisemigroup
open DecSetoid
open IdArrow
open Semigroup
open SemigroupPropRecord

(** val glueBSmg_bad : coq_Semigroup -> coq_Semigroup -> coq_Bisemigroup **)

let glueBSmg_bad a b =
  { Bisemigroup.setoid = { choose = b.setoid.choose; equal =
    b.setoid.equal }; plus = a.op; times = b.op }

(** val glueBSmg : coq_Semigroup -> coq_Semigroup -> coq_Bisemigroup **)

let glueBSmg a b =
  { Bisemigroup.setoid = b.setoid; plus = a.op; times = b.op }

(** val glueBSmg_IdSmgIso_plus :
    coq_Semigroup -> coq_Semigroup -> coq_IdSmgIso **)

let glueBSmg_IdSmgIso_plus a b =
  let { setoid = setoid0; op = op0 } = a in
  let { setoid = setoid1; op = op1 } = b in
  { phi = (fun x -> x); phi' = (fun x -> x) }

(** val glueBSmg_IdSmgIso_times :
    coq_Semigroup -> coq_Semigroup -> coq_IdSmgIso **)

let glueBSmg_IdSmgIso_times a b =
  let { setoid = setoid0; op = op0 } = a in
  let { setoid = setoid1; op = op1 } = b in
  { phi = (fun x -> x); phi' = (fun x -> x) }

(** val plusBSmgIso : coq_Semigroup -> coq_Semigroup -> coq_SmgIso **)

let plusBSmgIso a b =
  let { setoid = setoid0; op = op0 } = a in
  let { setoid = setoid1; op = op1 } = b in
  { phi = (fun x -> x); phi' = (fun x -> x) }

(** val timesBSmgIso : coq_Semigroup -> coq_Semigroup -> coq_SmgIso **)

let timesBSmgIso a0 b0 =
  let { setoid = setoid0; op = op0 } = a0 in
  let { setoid = setoid1; op = op1 } = b0 in
  { phi = (fun x -> x); phi' = (fun x -> x) }

(** val projPlusBSmgIso :
    coq_Semigroup -> coq_Semigroup -> sgProp -> sgProp **)

let projPlusBSmgIso a b h =
  sgPropIso a (plusSmg (glueBSmg a b)) (plusBSmgIso a b) h

(** val projTimesBSmgIso :
    coq_Semigroup -> coq_Semigroup -> sgProp -> sgProp **)

let projTimesBSmgIso a b h =
  sgPropIso b (timesSmg (glueBSmg a b)) (timesBSmgIso a b) h

