open AstDS
open DecSetoid
open OcamlTypes
open Preorder
open Specif

(** val le_T :
    coq_Preorder -> (carrier, 'a1) splitMono -> carrier -> carrier -> bool **)

let le_T p smono a b =
  p.le ((Obj.magic smono).mono_inv a) ((Obj.magic smono).mono_inv b)

(** val buildIsoPro :
    coq_Preorder -> (carrier, 'a1) splitMono -> coq_Preorder **)

let buildIsoPro p smono =
  { setoid = (buildIsoDs p.setoid smono); le = (fun x x0 ->
    le_T p smono x x0) }

(** val buildIsoPro_Iso :
    coq_Preorder -> (carrier, 'a1) splitMono -> coq_ProIso **)

let buildIsoPro_Iso p smono =
  { phi = (fun x -> (Obj.magic smono).mono x); phi' = (fun x ->
    (Obj.magic smono).mono_inv x) }

(** val astPO :
    coq_Preorder -> ocamlTypes -> (coq_Preorder, coq_ProIso) sigT **)

let astPO x t =
  let h = astSplitMono t in
  Coq_existT ((buildIsoPro x h), { phi = (fun x0 -> 
  (Obj.magic h).mono x0); phi' = (fun x0 -> (Obj.magic h).mono_inv x0) })

