open BinPos
open Bool
open Datatypes
open Peano
open Specif

type ascii =
  | Ascii of bool * bool * bool * bool * bool * bool * bool * bool

(** val ascii_rect :
    (bool -> bool -> bool -> bool -> bool -> bool -> bool -> bool -> 'a1) ->
    ascii -> 'a1 **)

let ascii_rect f = function
  | Ascii (x, x0, x1, x2, x3, x4, x5, x6) -> f x x0 x1 x2 x3 x4 x5 x6

(** val ascii_rec :
    (bool -> bool -> bool -> bool -> bool -> bool -> bool -> bool -> 'a1) ->
    ascii -> 'a1 **)

let ascii_rec f = function
  | Ascii (x, x0, x1, x2, x3, x4, x5, x6) -> f x x0 x1 x2 x3 x4 x5 x6

(** val zero : ascii **)

let zero =
  Ascii (false, false, false, false, false, false, false, false)

(** val one : ascii **)

let one =
  Ascii (true, false, false, false, false, false, false, false)

(** val app1 : (bool -> bool) -> ascii -> ascii **)

let app1 f = function
  | Ascii (a1, a2, a3, a4, a5, a6, a7, a8) -> Ascii (
      (f a1), (f a2), (f a3), (f a4), (f a5), (f a6), 
      (f a7), (f a8))

(** val app2 : (bool -> bool -> bool) -> ascii -> ascii -> ascii **)

let app2 f a b =
  let Ascii (a1, a2, a3, a4, a5, a6, a7, a8) = a in
  let Ascii (b1, b2, b3, b4, b5, b6, b7, b8) = b in
  Ascii ((f a1 b1), (f a2 b2), (f a3 b3), (f a4 b4), 
  (f a5 b5), (f a6 b6), (f a7 b7), (f a8 b8))

(** val shift : bool -> ascii -> ascii **)

let shift c = function
  | Ascii (a1, a2, a3, a4, a5, a6, a7, a8) -> Ascii (c, a1, a2, a3, a4, a5,
      a6, a7)

(** val ascii_dec : ascii -> ascii -> sumbool **)

let ascii_dec a b =
  let Ascii (x, x0, x1, x2, x3, x4, x5, x6) = a in
  let Ascii (b8, b9, b10, b11, b12, b13, b14, b15) = b in
  (match bool_dec x b8 with
     | Coq_left ->
         (match bool_dec x0 b9 with
            | Coq_left ->
                (match bool_dec x1 b10 with
                   | Coq_left ->
                       (match bool_dec x2 b11 with
                          | Coq_left ->
                              (match bool_dec x3 b12 with
                                 | Coq_left ->
                                     (match bool_dec x4 b13 with
                                        | Coq_left ->
                                            (match 
                                             bool_dec x5 b14 with
                                               | Coq_left -> bool_dec x6 b15
                                               | Coq_right -> Coq_right)
                                        | Coq_right -> Coq_right)
                                 | Coq_right -> Coq_right)
                          | Coq_right -> Coq_right)
                   | Coq_right -> Coq_right)
            | Coq_right -> Coq_right)
     | Coq_right -> Coq_right)

(** val ascii_of_pos_aux : ascii -> ascii -> positive -> nat -> ascii **)

let rec ascii_of_pos_aux res acc z = function
  | O -> res
  | S n1 ->
      (match z with
         | Coq_xI z' ->
             ascii_of_pos_aux
               (app2 (fun b1 b2 -> if b1 then true else b2) res acc)
               (shift false acc) z' n1
         | Coq_xO z' -> ascii_of_pos_aux res (shift false acc) z' n1
         | Coq_xH -> app2 (fun b1 b2 -> if b1 then true else b2) res acc)

(** val ascii_of_pos : positive -> ascii **)

let ascii_of_pos a =
  ascii_of_pos_aux zero one a (S (S (S (S (S (S (S (S O))))))))

(** val ascii_of_nat : nat -> ascii **)

let ascii_of_nat = function
  | O -> zero
  | S a' -> ascii_of_pos (coq_P_of_succ_nat a')

(** val nat_of_ascii : ascii -> nat **)

let nat_of_ascii = function
  | Ascii (a1, a2, a3, a4, a5, a6, a7, a8) ->
      plus
        (mult (S (S O))
          (plus
            (mult (S (S O))
              (plus
                (mult (S (S O))
                  (plus
                    (mult (S (S O))
                      (plus
                        (mult (S (S O))
                          (plus
                            (mult (S (S O))
                              (plus (mult (S (S O)) (if a8 then S O else O))
                                (if a7 then S O else O)))
                            (if a6 then S O else O)))
                        (if a5 then S O else O))) (
                    if a4 then S O else O))) (if a3 then S O else O)))
            (if a2 then S O else O))) (if a1 then S O else O)

(** val coq_Space : ascii **)

let coq_Space =
  Ascii (false, false, false, false, false, true, false, false)

(** val coq_DoubleQuote : ascii **)

let coq_DoubleQuote =
  Ascii (false, true, false, false, false, true, false, false)

(** val coq_Beep : ascii **)

let coq_Beep =
  Ascii (true, true, true, false, false, false, false, false)

