open Datatypes
open DecSetoid
open DecSetoidProperties
open Logic0
open Preorder
open PreorderProperties
open Semigroup
open SemigroupProperties
open Specif

let __ = let rec f _ = Obj.repr f in Obj.repr f

(** val ann : coq_Semigroup -> coq_HasAnnihilator -> carrier **)

let ann s hasAnn =
  projT1 hasAnn

(** val ann_le :
    coq_Semigroup -> coq_HasAnnihilator -> carrier -> carrier -> bool **)

let ann_le s hasAnn x y =
  if s.setoid.equal x y then true else s.setoid.equal y (projT1 hasAnn)

(** val annTopPreorder :
    coq_Semigroup -> coq_HasAnnihilator -> coq_Preorder **)

let annTopPreorder s hasAnn =
  { Preorder.setoid = s.setoid; le = (ann_le s hasAnn) }

(** val hasTop : coq_Semigroup -> coq_HasAnnihilator -> coq_HasTop **)

let hasTop s hasAnn =
  Coq_existT ((projT1 hasAnn), __)

(** val hasBottom :
    coq_Semigroup -> coq_HasAnnihilator -> (coq_IsSingleton, coq_TwoElements)
    sum -> coq_HasBottom **)

let hasBottom s hasAnn = function
  | Coq_inl i -> let Coq_existT (x0, _) = i in Coq_existT (x0, __)
  | Coq_inr t ->
      let Coq_existT (x0, s0) = t in
      let Coq_existT (y, _) = s0 in
      let Coq_existT (w, _) = copy_var (s.setoid.equal x0 (projT1 hasAnn)) in
      if w then Coq_existT (y, __) else Coq_existT (x0, __)

(** val hasBottom_comp :
    coq_Semigroup -> coq_HasAnnihilator -> (coq_IsSingleton_comp *
    coq_TwoElements_comp) -> coq_HasBottom_comp **)

let hasBottom_comp s hasAnn x t =
  let sg , te = x in
  let a = s.setoid.choose in
  let Coq_existT (b, _) = sg a in
  let Coq_existT (c, _) = te a b in
  let Coq_existT (w, _) = copy_var (s.setoid.equal a (projT1 hasAnn)) in
  if w
  then let Coq_existT (w0, _) =
         copy_var ((annTopPreorder s hasAnn).Preorder.setoid.equal t b)
       in
       if w0 then Coq_existT (c, __) else Coq_existT (b, __)
  else let Coq_existT (w0, _) = copy_var (s.setoid.equal b (projT1 hasAnn))
       in
       if w0
       then let Coq_existT (w1, _) =
              copy_var ((annTopPreorder s hasAnn).Preorder.setoid.equal t a)
            in
            if w1 then Coq_existT (c, __) else Coq_existT (a, __)
       else let Coq_existT (w1, _) =
              copy_var ((annTopPreorder s hasAnn).Preorder.setoid.equal t a)
            in
            if w1 then Coq_existT (b, __) else Coq_existT (a, __)

(** val total_comp :
    coq_Semigroup -> coq_HasAnnihilator -> (coq_IsSingleton_comp *
    coq_TwoElements_comp) -> coq_Total_comp **)

let total_comp s hasAnn = function
  | sg , te ->
      let a = s.setoid.choose in
      let Coq_existT (b, _) = sg a in
      let Coq_existT (c, _) = te a b in
      let Coq_existT (w, _) = copy_var (s.setoid.equal a (projT1 hasAnn)) in
      if w
      then Coq_existT (b, (Coq_existT (c, __)))
      else let Coq_existT (w0, _) =
             copy_var (s.setoid.equal b (projT1 hasAnn))
           in
           if w0
           then Coq_existT (a, (Coq_existT (c, __)))
           else Coq_existT (a, (Coq_existT (b, __)))

