open Bisemigroup
open BisemigroupGlue
open BisemigroupProperties
open Datatypes
open DecSetoid
open SemigroupProperties
open Specif
open Union0
open UnionSwap
open Unit0

type __ = Obj.t
let __ = let rec f _ = Obj.repr f in Obj.repr f

(** val addOneBisemigroup : coq_Bisemigroup -> coq_Bisemigroup **)

let addOneBisemigroup a =
  glueBSmg (unionSemigroup unitSemigroup (plusSmg a))
    (unionSwapSemigroup (timesSmg a) unitSemigroup)

(** val one : coq_Bisemigroup -> carrier **)

let one a =
  Obj.magic (Coq_inl ())

(** val isLeftDistributive_comp :
    coq_Bisemigroup -> ((coq_IsLeftDistributive_comp, coq_IsIdempotent_comp)
    sum, coq_RightIncreasing_comp * __) sum -> coq_IsLeftDistributive_comp **)

let isLeftDistributive_comp a = function
  | Coq_inl s ->
      (match s with
         | Coq_inl i ->
             let Coq_existT (x0, s0) = i in
             let Coq_existT (y, s1) = s0 in
             let Coq_existT (z, _) = s1 in
             Coq_existT ((Obj.magic (Coq_inr x0)), (Coq_existT
             ((Obj.magic (Coq_inr y)), (Coq_existT (
             (Obj.magic (Coq_inr z)), __)))))
         | Coq_inr i ->
             let Coq_existT (x0, _) = i in
             Coq_existT ((Obj.magic (Coq_inl ())), (Coq_existT
             ((Obj.magic (Coq_inl ())), (Coq_existT
             ((Obj.magic (Coq_inr x0)), __))))))
  | Coq_inr p ->
      let ri , _ = p in
      let Coq_existT (x0, s) = ri __ __ in
      let Coq_existT (y, _) = s in
      Coq_existT ((Obj.magic (Coq_inl ())), (Coq_existT
      ((Obj.magic (Coq_inr y)), (Coq_existT ((Obj.magic (Coq_inr x0)),
      __)))))

(** val isRightDistributive_comp :
    coq_Bisemigroup -> ((coq_IsRightDistributive_comp, coq_IsIdempotent_comp)
    sum, coq_LeftIncreasing_comp * __) sum -> coq_IsRightDistributive_comp **)

let isRightDistributive_comp a = function
  | Coq_inl s ->
      (match s with
         | Coq_inl i ->
             let Coq_existT (x0, s0) = i in
             let Coq_existT (y, s1) = s0 in
             let Coq_existT (z, _) = s1 in
             Coq_existT ((Obj.magic (Coq_inr x0)), (Coq_existT
             ((Obj.magic (Coq_inr y)), (Coq_existT (
             (Obj.magic (Coq_inr z)), __)))))
         | Coq_inr i ->
             let Coq_existT (x0, _) = i in
             Coq_existT ((Obj.magic (Coq_inl ())), (Coq_existT
             ((Obj.magic (Coq_inl ())), (Coq_existT
             ((Obj.magic (Coq_inr x0)), __))))))
  | Coq_inr p ->
      let ri , _ = p in
      let Coq_existT (x0, s) = ri __ __ in
      let Coq_existT (y, _) = s in
      Coq_existT ((Obj.magic (Coq_inl ())), (Coq_existT
      ((Obj.magic (Coq_inr y)), (Coq_existT ((Obj.magic (Coq_inr x0)),
      __)))))

(** val hasTimesAnn_back :
    coq_Bisemigroup -> coq_HasAnnihilator -> coq_HasAnnihilator **)

let hasTimesAnn_back a = function
  | Coq_existT (x0, x1) ->
      (match Obj.magic x0 with
         | Coq_inl c -> let () = c in assert false (* absurd case *)
         | Coq_inr an -> Coq_existT (an, __))

(** val hasPlusId_back :
    coq_Bisemigroup -> coq_HasIdentity -> coq_HasIdentity **)

let hasPlusId_back a = function
  | Coq_existT (x0, x1) ->
      (match Obj.magic x0 with
         | Coq_inl c -> let () = c in assert false (* absurd case *)
         | Coq_inr an -> Coq_existT (an, __))

(** val isRightStrictStable_comp :
    coq_Bisemigroup -> (coq_IsRightStrictStable_comp,
    coq_LeftStrictIncreasing_comp) sum -> (carrier, (carrier, (carrier, __)
    sigT) sigT) sigT **)

let isRightStrictStable_comp a = function
  | Coq_inl rss ->
      let Coq_existT (x0, s) = rss __ __ in
      let Coq_existT (y, s0) = s in
      let Coq_existT (z, _) = s0 in
      Coq_existT ((Obj.magic (Coq_inr x0)), (Coq_existT
      ((Obj.magic (Coq_inr y)), (Coq_existT ((Obj.magic (Coq_inr z)), __)))))
  | Coq_inr rsi ->
      let Coq_existT (x0, s) = rsi __ __ in
      let Coq_existT (y, _) = s in
      Coq_existT ((Obj.magic (Coq_inl ())), (Coq_existT
      ((Obj.magic (Coq_inr y)), (Coq_existT ((Obj.magic (Coq_inr x0)),
      __)))))

(** val isLeftStrictStable_comp :
    coq_Bisemigroup -> (coq_IsLeftStrictStable_comp,
    coq_RightStrictIncreasing_comp) sum -> (carrier, (carrier, (carrier, __)
    sigT) sigT) sigT **)

let isLeftStrictStable_comp a = function
  | Coq_inl rss ->
      let Coq_existT (x0, s) = rss __ __ in
      let Coq_existT (y, s0) = s in
      let Coq_existT (z, _) = s0 in
      Coq_existT ((Obj.magic (Coq_inr x0)), (Coq_existT
      ((Obj.magic (Coq_inr y)), (Coq_existT ((Obj.magic (Coq_inr z)), __)))))
  | Coq_inr rsi ->
      let Coq_existT (x0, s) = rsi __ __ in
      let Coq_existT (y, _) = s in
      Coq_existT ((Obj.magic (Coq_inl ())), (Coq_existT
      ((Obj.magic (Coq_inr y)), (Coq_existT ((Obj.magic (Coq_inr x0)),
      __)))))

(** val isRightCompEqCancel_comp :
    coq_Bisemigroup -> coq_IsRightCompEqCancel_comp -> (carrier, (carrier,
    (carrier, __) sigT) sigT) sigT **)

let isRightCompEqCancel_comp a rcec =
  let Coq_existT (x, s) = rcec __ __ in
  let Coq_existT (y, s0) = s in
  let Coq_existT (z, _) = s0 in
  Coq_existT ((Obj.magic (Coq_inr x)), (Coq_existT (
  (Obj.magic (Coq_inr y)), (Coq_existT ((Obj.magic (Coq_inr z)), __)))))

(** val isLeftCompEqCancel_comp :
    coq_Bisemigroup -> coq_IsLeftCompEqCancel_comp -> (carrier, (carrier,
    (carrier, __) sigT) sigT) sigT **)

let isLeftCompEqCancel_comp a rcec =
  let Coq_existT (x, s) = rcec __ __ in
  let Coq_existT (y, s0) = s in
  let Coq_existT (z, _) = s0 in
  Coq_existT ((Obj.magic (Coq_inr x)), (Coq_existT (
  (Obj.magic (Coq_inr y)), (Coq_existT ((Obj.magic (Coq_inr z)), __)))))

(** val isLeftCompCancel_comp :
    coq_Bisemigroup -> coq_IsSelective_comp -> (carrier, (carrier, (carrier,
    __) sigT) sigT) sigT **)

let isLeftCompCancel_comp a = function
  | Coq_existT (x0, s) ->
      let Coq_existT (y, _) = s in
      Coq_existT ((Obj.magic (Coq_inr x0)), (Coq_existT
      ((Obj.magic (Coq_inr y)), (Coq_existT ((Obj.magic (Coq_inl ())),
      __)))))

(** val isRightCompCancel_comp :
    coq_Bisemigroup -> coq_IsSelective_comp -> (carrier, (carrier, (carrier,
    __) sigT) sigT) sigT **)

let isRightCompCancel_comp a = function
  | Coq_existT (x0, s) ->
      let Coq_existT (y, _) = s in
      Coq_existT ((Obj.magic (Coq_inr x0)), (Coq_existT
      ((Obj.magic (Coq_inr y)), (Coq_existT ((Obj.magic (Coq_inl ())),
      __)))))

(** val leftDiscrete_comp :
    coq_Bisemigroup -> (carrier, (carrier, (carrier, __) sigT) sigT) sigT **)

let leftDiscrete_comp a =
  Coq_existT ((Obj.magic (Coq_inl ())), (Coq_existT
    ((Obj.magic (Coq_inr a.setoid.choose)), (Coq_existT
    ((Obj.magic (Coq_inl ())), __)))))

(** val rightDiscrete_comp :
    coq_Bisemigroup -> (carrier, (carrier, (carrier, __) sigT) sigT) sigT **)

let rightDiscrete_comp a =
  Coq_existT ((Obj.magic (Coq_inl ())), (Coq_existT
    ((Obj.magic (Coq_inr a.setoid.choose)), (Coq_existT
    ((Obj.magic (Coq_inl ())), __)))))

(** val leftComparable_comp :
    coq_Bisemigroup -> coq_IsSelective_comp -> (carrier, (carrier, (carrier,
    __) sigT) sigT) sigT **)

let leftComparable_comp a = function
  | Coq_existT (x0, s) ->
      let Coq_existT (y, _) = s in
      Coq_existT ((Obj.magic (Coq_inr x0)), (Coq_existT
      ((Obj.magic (Coq_inr y)), (Coq_existT ((Obj.magic (Coq_inl ())),
      __)))))

(** val rightComparable_comp :
    coq_Bisemigroup -> coq_IsSelective_comp -> (carrier, (carrier, (carrier,
    __) sigT) sigT) sigT **)

let rightComparable_comp a = function
  | Coq_existT (x0, s) ->
      let Coq_existT (y, _) = s in
      Coq_existT ((Obj.magic (Coq_inr x0)), (Coq_existT
      ((Obj.magic (Coq_inr y)), (Coq_existT ((Obj.magic (Coq_inl ())),
      __)))))

(** val leftIncreasing_comp :
    coq_Bisemigroup -> coq_LeftIncreasing_comp -> (carrier, (carrier, __)
    sigT) sigT **)

let leftIncreasing_comp a li =
  let Coq_existT (x, s) = li __ __ in
  let Coq_existT (y, _) = s in
  Coq_existT ((Obj.magic (Coq_inr x)), (Coq_existT (
  (Obj.magic (Coq_inr y)), __)))

(** val rightIncreasing_comp :
    coq_Bisemigroup -> coq_RightIncreasing_comp -> (carrier, (carrier, __)
    sigT) sigT **)

let rightIncreasing_comp a li =
  let Coq_existT (x, s) = li __ __ in
  let Coq_existT (y, _) = s in
  Coq_existT ((Obj.magic (Coq_inr x)), (Coq_existT (
  (Obj.magic (Coq_inr y)), __)))

(** val leftStrictIncreasing_comp :
    coq_Bisemigroup -> (carrier, (carrier, __) sigT) sigT **)

let leftStrictIncreasing_comp a =
  Coq_existT ((Obj.magic (Coq_inl ())), (Coq_existT
    ((Obj.magic (Coq_inl ())), __)))

(** val rightStrictIncreasing_comp :
    coq_Bisemigroup -> (carrier, (carrier, __) sigT) sigT **)

let rightStrictIncreasing_comp a =
  Coq_existT ((Obj.magic (Coq_inl ())), (Coq_existT
    ((Obj.magic (Coq_inl ())), __)))

(** val id_back : coq_Bisemigroup -> coq_HasIdentity -> coq_HasIdentity **)

let id_back a = function
  | Coq_existT (x0, x1) ->
      (match Obj.magic x0 with
         | Coq_inl c -> let () = c in assert false (* absurd case *)
         | Coq_inr id -> Coq_existT (id, __))

(** val isRightTimesMapToIdConstantPlus_comp :
    coq_Bisemigroup -> coq_IsRightTimesMapToIdConstantPlus_comp **)

let isRightTimesMapToIdConstantPlus_comp a = function
  | Coq_existT (x, x0) ->
      (match Obj.magic x with
         | Coq_inl c -> let () = c in assert false (* absurd case *)
         | Coq_inr id -> Coq_existT ((Obj.magic (Coq_inl ())), (Coq_existT
             ((Obj.magic (Coq_inl ())), (Coq_existT
             ((Obj.magic (Coq_inl ())), __))))))

(** val isLeftTimesMapToIdConstantPlus_comp :
    coq_Bisemigroup -> coq_IsLeftTimesMapToIdConstantPlus_comp **)

let isLeftTimesMapToIdConstantPlus_comp a = function
  | Coq_existT (x, x0) ->
      (match Obj.magic x with
         | Coq_inl c -> let () = c in assert false (* absurd case *)
         | Coq_inr id -> Coq_existT ((Obj.magic (Coq_inl ())), (Coq_existT
             ((Obj.magic (Coq_inl ())), (Coq_existT
             ((Obj.magic (Coq_inl ())), __))))))

(** val plusIdentityIsTimesLeftAnnihilator_comp :
    coq_Bisemigroup -> coq_PlusIdentityIsTimesLeftAnnihilator_comp ->
    coq_PlusIdentityIsTimesLeftAnnihilator_comp **)

let plusIdentityIsTimesLeftAnnihilator_comp a hid hasId = match hasId with
  | Coq_existT (x, x0) ->
      (match Obj.magic x with
         | Coq_inl c -> let () = c in assert false (* absurd case *)
         | Coq_inr id ->
             let Coq_existT (x1, _) =
               hid
                 (let Coq_existT (x1, x2) = hasId in
                 (match Obj.magic x1 with
                    | Coq_inl c ->
                        let () = c in assert false (* absurd case *)
                    | Coq_inr id0 -> Coq_existT (id0, __)))
             in
             Coq_existT ((Obj.magic (Coq_inr x1)), __))

(** val plusIdentityIsTimesRightAnnihilator_comp :
    coq_Bisemigroup -> coq_PlusIdentityIsTimesRightAnnihilator_comp ->
    coq_PlusIdentityIsTimesRightAnnihilator_comp **)

let plusIdentityIsTimesRightAnnihilator_comp a hid hasId = match hasId with
  | Coq_existT (x, x0) ->
      (match Obj.magic x with
         | Coq_inl c -> let () = c in assert false (* absurd case *)
         | Coq_inr id ->
             let Coq_existT (x1, _) =
               hid
                 (let Coq_existT (x1, x2) = hasId in
                 (match Obj.magic x1 with
                    | Coq_inl c ->
                        let () = c in assert false (* absurd case *)
                    | Coq_inr id0 -> Coq_existT (id0, __)))
             in
             Coq_existT ((Obj.magic (Coq_inr x1)), __))

