(*
 * Exports Ocaml code for Metarouting *.v files into working
 * directory.
 *)
 
(* import starting point what needs to be extracted *)
Require Import Metarouting.Language.ExtractionList.
Require Import Coq.Lists.List.
Require Import Coq.Strings.String.
Require Import Coq.Strings.Ascii.

(* avoid name clashes *)
Extraction Blacklist List String nth.

(* use native Ocaml types *)
Extract Inductive unit => "unit" [ "()" ].
Extract Inductive bool => "bool" [ "true" "false" ].
Extract Inductive prod => "(*)"  [ "(,)" ].
Extract Inductive list => "list" [ "[]" "(::)" ].
(* Extract Inductive nat => "int" [ "0" "succ" ] (""). *)
Extract Inductive option => "option"  [ "Some" "None" ].
(*Extract Inductive sum => "(+)" [ "inl" "inr"].*)
(* 
Extract Inductive ascii => "char" [ "(fun (b0, b1, b2, b3, b4, b5, b6, b7) -> 
                                        let f = fun b -> if b then 1 else 0 in
                                        char_of_int (
                                               ((f b7) lsl 7)
                                           lor ((f b6) lsl 6)
                                           lor ((f b5) lsl 5)
                                           lor ((f b4) lsl 4)
                                           lor ((f b3) lsl 3)
                                           lor ((f b2) lsl 2)
                                           lor ((f b1) lsl 1)
                                           lor (f b0)
                                        ))" ].
Extract Inductive string => "string" [ "(String.create 0)" "((fun x y -> (String.make 1 x) ^ y))" ].

Open Scope string_scope.
Definition string_test := "abc".
Recursive Extraction string_test.
*)

(* do extraction *)
Set Extraction Optimize.
Set Extraction AutoInline.
Recursive Extraction Library ExtractionList.
