Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Transform.
Require Export Metarouting.Signatures.DecSetoidProperties.
Require Export Metarouting.Signatures.SemigroupProperties.

Section TransformProperties.

   Open Scope Transform_scope.

      Variables T : Transform.

      Definition Cancelative      := forall x y : T, forall f, f |> x == f |> y -> x == y.
      Definition Cancelative_comp := Exists x y : T, Exists f, f |> x == f |> y /\ x != y.

      Definition Condensed      := forall x y : T, forall f, f |> x == f |> y.
      Definition Condensed_comp := Exists x y : T, Exists f, f |> x != f |> y.
      
      Definition Identity      := forall x : T, forall f, f |> x == x.
      Definition Identity_comp := Exists x : T, Exists f, f |> x != x.

   Close Scope Transform_scope.

End TransformProperties.

(********************************************************************)
(* Isomorphic order semigroups have the same properties of interest *)
(********************************************************************)

Section TransformIso.

   Ltac isoSimpl h iso :=
      rewrite ?(pres_app iso), ?(pres_app' iso), 
              ?(inv (fnIso iso)), ?(inv' (fnIso iso)),
              ?(inv iso), ?(inv' iso) in h.

   Ltac propIso h iso pos :=
      clear - h iso;
      hnf; 
      hnf in h;
      dseq_f;
      try match goal with
         | |- False => apply h
         | |- True => auto
         | |- (forall (_ : carrier (setoid _)), _) => 
            let x := fresh "x" in
            let h' := fresh "h" in
            intros x; 
            match pos with
               | true  => assert (h' := h (phi' iso x))
               | false => assert (h' := h (phi iso x))
            end;
            propIso h' iso pos
         | |- (forall (_ : carrier (fn _)), _) => 
            let x := fresh "x" in
            let h' := fresh "h" in
            intros x; 
            match pos with
               | true  => assert (h' := h (phi' (fnIso iso) x))
               | false => assert (h' := h (phi  (fnIso iso) x))
            end;
            propIso h' iso pos
         | |- (@sigT (carrier (setoid _)) _) =>
            let x := fresh "x" in
            let h' := fresh "h" in
            destruct h as [x h'];
            match pos with
               | true  => exists (phi iso x)
               | false => exists (phi' iso x)
            end;
            propIso h' iso pos
         | |- (@sigT (carrier (fn _)) _) =>
            let x := fresh "x" in
            let h' := fresh "h" in
            destruct h as [x h'];
            match pos with
               | true  => exists (phi (fnIso iso) x)
               | false => exists (phi' (fnIso iso) x)
            end;
            propIso h' iso pos
         | |- (_ /\ _) =>
            let h' := fresh "h" in
            split; 
            [ destruct h as [h' _]; propIso h' iso pos
            | destruct h as [_ h']; propIso h' iso pos]
         | |- (_ \/ _) =>
            let h' := fresh "h" in
            destruct h as [h' | h'];
            [ apply or_introl; propIso h' iso pos
            | apply or_intror; propIso h' iso pos]
         | |- (_ -> _) =>
            let h' := fresh "h" in
            let h'' := fresh "h" in
            intros h';
            let ht := type of h in
            match ht with
               | (?X -> _) => assert X as h''
            end;
            [ match pos with
                 | true  => propIso h' iso false
                 | false => propIso h' iso true
              end
            | let h''' := fresh "h" in
              assert (h''' := h h'');
              propIso h''' iso pos
            ]
         | |- (_ == _) =>
            let h' := fresh "h" in
            match pos with
               | true  => assert (h' := pres_eq iso h)
               | false => assert (h' := pres_eq' iso h)
            end;
            repeat (progress (isoSimpl h' iso));
            trivial
         | |- (_ -> False) =>
            let h' := fresh "h" in
            intros h'; elim h;
            match pos with
               | true  => propIso h' iso false
               | false => propIso h' iso true
            end
         | |- (bool_to_Prop _) =>
            progress (toProp);
            propIso h iso pos
      end.

   Lemma Iso_Cancelative : forall {T T'} (I : TfIso T T'), Cancelative T -> Cancelative T'.
   Proof. intros T T' I h; propIso h I true. Defined.

   Lemma Iso_Cancelative_comp : forall {T T'} (I : TfIso T T'), Cancelative_comp T -> Cancelative_comp T'.
   Proof. intros T T' I h; propIso h I true. Defined.

   Lemma Iso_Condensed : forall {T T'} (I : TfIso T T'), Condensed T -> Condensed T'.
   Proof. intros T T' I h; propIso h I true. Defined.

   Lemma Iso_Condensed_comp : forall {T T'} (I : TfIso T T'), Condensed_comp T -> Condensed_comp T'.
   Proof. intros T T' I h; propIso h I true. Defined.

   Lemma Iso_Identity : forall {T T'} (I : TfIso T T'), Identity T -> Identity T'.
   Proof. intros T T' I h; propIso h I true. Defined.

   Lemma Iso_Identity_comp : forall {T T'} (I : TfIso T T'), Identity_comp T -> Identity_comp T'.
   Proof. intros T T' I h; propIso h I true. Defined.

End TransformIso.
