Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupPropRecord.
Require Import Metarouting.Signatures.Transform.
Require Import Metarouting.Signatures.TransformPropRecord.
Require Import Metarouting.Signatures.SemigroupTransform.
Require Import Metarouting.Signatures.IdArrow.

Section Glue.

   Definition glueSTf_DsEq : forall (A : Semigroup) (B : Transform), DsEq A B -> SemigroupTransform.
     intros A B e. (* unfold DsEq in *.*)
     assert (q := fun op assoc op_pres_eq =>
              @Build_SemigroupTransform 
              (*(@Build_DecSetoid B (choose B) (@equal B) (refl B) (sym B) (trans B))*)
              B
              op
              assoc
              op_pres_eq
              (Transform.fn B)
              (Transform.app B)
              (Transform.app_pres_eq B)
            ).
     simpl in q.
     destruct e.
     apply (q (Semigroup.op A) 
              (Semigroup.assoc A) 
              (Semigroup.op_pres_eq A)).
   Defined.
   
   Lemma glueSTf_DsEq_IdSmgIso : forall A B e, IdSmgIso (glueSTf_DsEq A B e) A.
   Proof. intros. destruct A; destruct B; simpl in *; destruct e; auto.
      (*destruct A; destruct setoid;
      destruct B; destruct setoid;
      unfold DsEq in e; simpl in *; destruct e.
      unfold semigroupST; simpl; auto.*)
   Defined.

   Lemma glueSTf_DsEq_IdTfIso : forall A B e, IdTfIso (glueSTf_DsEq A B e) B.
   Proof. intros. destruct A; destruct B; simpl in *; destruct e; auto.
      (*destruct A; destruct setoid;
      destruct B; destruct setoid;
      unfold DsEq in e; simpl in *; destruct e.
      unfold semigroupST; simpl; auto.*)
   Defined.

   Definition glueSTf : forall (A : Semigroup) (B' : Transform), DsIso A B' -> SemigroupTransform.
      intros A B' iso.
      destruct (liftTfIso A B' iso) as [B [iso' [p1 p2]]].
      apply (glueSTf_DsEq _ _ (DsEq_sym p1)).
   Defined.

   Definition glueSTfSmg_DsEq : forall A B e, SmgIso A (glueSTf_DsEq A B e).
      intros A B e. destruct A; destruct B; simpl in *.
      (*unfold DsEq in e; simpl in *.
      destruct setoid; destruct setoid0; simpl in *.*)
      destruct e; simpl in *.
      unfold semigroupST; simpl.
      apply (SmgIso_refl _).
   Defined.
   
   Definition glueSTfSmgIso : forall A B iso, SmgIso A (glueSTf A B iso).
      intros A B e.
      unfold glueSTf; simpl.
      unfold glueSTf_DsEq; simpl.
      unfold DsEq_sym; simpl. destruct A; destruct setoid; simpl.
      apply (SmgIso_refl _).
   Defined.
   
   Definition glueSTfTf_DsEq : forall A B e, TfIso B (glueSTf_DsEq A B e).
      intros A B e. destruct A; destruct B; simpl in *.
      (*unfold DsEq in e; simpl in *.
      destruct setoid; destruct setoid0; simpl in *.*)
      destruct e; simpl in *.
      unfold transformST; simpl.
      apply (TfIso_refl _).
   Defined.
   
   Definition glueSTfTf : forall A B iso, TfIso B (glueSTf A B iso).
      intros A B iso. unfold glueSTf.
      destruct (liftTfIso A B iso) as [B' [iso' [p1 p2]]]; simpl.
      apply (TfIso_trans (TfIso_sym iso')).
      apply glueSTfTf_DsEq; auto.
   Defined.

   Definition projSTfTfIso : forall A B iso, tfProp B -> tfProp (glueSTf A B iso).
      intros A B iso h; apply (tfPropIso (glueSTfTf A B iso) h).
   Defined.

   Definition projSTfSmgIso : forall A B iso, sgProp A -> sgProp (glueSTf A B iso).
      intros A B iso h; apply (sgPropIso (glueSTfSmgIso A B iso) h).
   Defined.

End Glue.

Section STfIso_lift.
   Open Scope SemigroupTransform_scope.

   (* Given a semigroup transform B we can move the semigroup transform over an isomorphism of setoid.
    
                    iso
           B  <------------> B'
           |                 |
           |         /\      |
           |         ||      |   
           |         ||      |
           |                 | 
           v         iso     v
        setoid B <---------> A

     
    *)

   Definition liftSTfIso : forall (A : DecSetoid) (B : SemigroupTransform), DsIso A B -> 
      Exists B', (STfIso B' B * 
                  ((DsEq B' A) /\ 
                   (DsEq (fn B') (fn B))))%type.
      intros A B iso.

      set (op' := fun x y => phi' iso ((phi iso x) + (phi iso y))).
      set (app' := (fun f x => phi' iso (f |> (phi iso x)))).

      assert (Associative op') as assoc.
         intros x y z; unfold op'; do 2 rewrite (inv iso); apply (pres_eq' iso); apply assoc.
      assert (Preserves op') as op_pres_eq.
         intros x y u v p q; unfold op'; apply (pres_eq' iso);
         apply op_pres_eq; apply (pres_eq iso); auto.
      assert (AppPreserve app') as app_pres.
         intros x y f g p q; unfold app'; apply (pres_eq' iso);
         apply (app_pres_eq B); auto; apply (pres_eq iso); auto.
      set (b := Build_SemigroupTransform assoc op_pres_eq app_pres).
      exists b; split; auto.
      set (bB_iso := @Build_DsIso (setoid b) B (phi iso) (phi' iso)
                     (Build_IsDsIso _ _ (pres_eq iso) (pres_eq' iso) (inv iso) (inv' iso))).
      split with bB_iso (DsIso_refl _).
      unfold bB_iso; split; simpl; intros; unfold op'; unfold app'; simpl; rewrite ?(inv iso); auto.
      (*unfold b; split; split.*)
   Defined.

End STfIso_lift.