Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.Preorder.
Require Import Metarouting.Signatures.PreorderPropRecord.
Require Import Metarouting.Signatures.Transform.
Require Import Metarouting.Signatures.TransformPropRecord.
Require Import Metarouting.Signatures.OrderTransform.
Require Import Metarouting.Signatures.IdArrow.

Section Glue.

   Definition glueOTf : forall (A : Preorder) (B : Transform), DsEq A B -> OrderTransform.
     intros A B e. (* unfold DsEq in *.*)
     assert (q := fun le le_refl le_trans le_pres_eq =>
              @Build_OrderTransform 
              B
              le
              le_refl
              le_trans
              le_pres_eq
              (Transform.fn B)
              (Transform.app B)
              (Transform.app_pres_eq B)
            ).
     simpl in q.
     destruct e.
     apply (q (Preorder.le A) 
              (Preorder.le_refl A) 
              (Preorder.le_trans A) 
              (Preorder.le_pres_eq A)).
   Defined.
   
   Lemma glueOTf_IdProIso : forall A B e, IdProIso (glueOTf A B e) A.
   Proof. intros. destruct A; destruct B; simpl in *; destruct e; auto.
   Defined.

   Lemma glueOTf_IdTfIso : forall A B e, IdTfIso (glueOTf A B e) B.
   Proof. intros. destruct A; destruct B; simpl in *; destruct e; auto.
   Defined.

   Definition projTfOTfIso : forall A B e, tfProp B -> tfProp (glueOTf A B e).
      intros A B e h.
      destruct A; destruct B; simpl in *.
      destruct e; auto.
   Defined.

   Definition projProOTfIso : forall A B e, poProp A -> poProp (glueOTf A B e).
      intros A B e h.
      destruct A; destruct B; simpl in *.
      destruct e; auto.
   Defined.

End Glue.