Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.Preorder.
Require Import Metarouting.Signatures.OrderSemigroup.
Require Import Metarouting.Signatures.Bisemigroup.
Require Import Metarouting.Signatures.Transform.
Require Import Metarouting.Signatures.SemigroupTransform.
Require Import Coq.Lists.List.
   
Definition id X (x : X) : X := x.

   Inductive IsId X : forall Y, (X -> Y) -> Prop :=
      | IsId_refl : forall (f : X -> X), ext_eq f (id X) -> IsId X X f.
      
   Implicit Arguments IsId [X Y].
   
   Definition IsId_init X : IsId (fun x : X => x).
      intros X; split. intros x. auto.
   Defined.
   
   Lemma IsId_eq {X Y} (f : X -> Y) (p : IsId f) : X = Y.
   Proof. intros X Y f p. destruct p. auto. Qed.
   
   Definition eqFunRev {X Y} (f : X -> Y) (e : X = Y) : X -> X.
      intros X Y f e.
      destruct e.
      apply f.
   Defined.

(*
   Definition IsId_ext_eq {X} (f : X -> X) (p : IsId f) : ext_eq f (id X).
      intros X f p x. unfold id; simpl.
      refine (
      match p in (@IsId _ Y f0)
      return f x = x with
      | IsId_refl _ e => _
      end
      ).
      assert (q := e x); simpl in q. unfold id in *; simpl in *.
      rewrite 
      
      refine(
      match p in (@IsId _ Y f0) return forall (e : X = Y), ext_eq (eqFunRev f0 e) (id X) with
         | IsId_refl f e => _
      end (refl_equal X)
     ).
     intros h. intros x. 
     unfold id in *; simpl in *.
     assert (q := e x); simpl in q.
     clear -q.
     unfold eqFunRev. 
     pattern h.
     case h.
*)

   Lemma IsId_ext_eq : forall {X} (f : X -> X), IsId f -> ext_eq f (id X).
   Proof. clear. intros X f p.
      inversion p.
      assert (q := eq_dep_eq _ _ _ _ (Coq.Logic.EqdepFacts.eq_sigT_eq_dep _ (fun x : Type => X -> x) _ _ _ _ H)).
      rewrite <- q.
      apply H1.
   Qed.
         
   Lemma IsIdCancel4 : forall {A B C D} 
      (f1 : D -> A) 
      (f2 : C -> D) 
      (f3 : B -> C) 
      (f4 : A -> B), 
      IsId f1 -> 
      IsId f2 -> 
      IsId f3 -> 
      IsId f4 -> 
      forall x, f1 (f2 (f3 (f4 x))) = x.
   Proof. clear. intros A B C D f1 f2 f3 f4 p1 p2 p3 p4 x.
     destruct p1; destruct p2; destruct p3.
     rewrite H, H0, H1. unfold id; simpl.
     apply (IsId_ext_eq _ p4).
   Qed.

   Lemma IsId_map : forall {A B} {f : A -> B}, IsId f -> IsId (map f).
   Proof. intros A B f p; destruct p as [f p]. split; intros l; induction l; auto.
      simpl; rewrite IHl, (p a); auto.
   Qed.

   Record IsIdIso {A B : DecSetoid} (iso : DsIso A B) := {
      phi_id  :> IsId (phi iso);
      phi_id' :> IsId (phi' iso)
   }.
   
   Record IdDsIso (A B : DecSetoid) := {
      dsIso     :> DsIso A B;
      isIsDsIso :> IsIdIso dsIso
   }.
   
   Record IdSmgIso (A B : Semigroup) := {
      sgIso      :> SmgIso A B;
      isIdSmgIso :> IsIdIso sgIso
   }.

   Record IdProIso (A B : Preorder) := {
      poIso      :> ProIso A B;
      isIdProIso :> IsIdIso poIso
   }.
   
   Record IdOSmgIso (A B : OrderSemigroup) := {
      osIso       :> OSmgIso A B;
      isIdOSmgIso :> IsIdIso osIso
   }.

   Record IdBSmgIso (A B : Bisemigroup) := {
      bsIso       :> BSmgIso A B;
      isIdBSmgIso :> IsIdIso bsIso
   }.

   Record IdTfIso (A B : Transform) := {
      tfIso       :> TfIso A B;
      isIdTfIso   :> IsIdIso tfIso;
      fnIdIso     : IsIdIso (Transform.fnIso tfIso)
   }.

   Record IdSTfIso (A B : SemigroupTransform) := {
      stIso       :> STfIso A B;
      isIdSTfIso  :> IsIdIso stIso;
      fnIdSTfIso  : IsIdIso (fnIso stIso)
   }.

   (*** Reflexive ***)

   Definition IdDsIso_refl : forall A, IdDsIso A A.
      intros A; split with (DsIso_refl A); split; split; intros x; auto.
   Defined.
   
   Hint Resolve IdDsIso_refl.

   Definition IdSmgIso_refl : forall A, IdSmgIso A A.
      intros A; split with (SmgIso_refl A); split; split; intros x; auto.
   Defined.

   Hint Resolve IdSmgIso_refl.

   Definition IdProIso_refl : forall A, IdProIso A A.
      intros A; split with (ProIso_refl A); split; split; intros x; auto.
   Defined.

   Hint Resolve IdProIso_refl.
   
   Definition IdOSmgIso_refl : forall A, IdOSmgIso A A.
      intros A; split with (OSmgIso_refl A); split; split; intros x; auto.
   Defined.

   Hint Resolve IdOSmgIso_refl.

   Definition IdBSmgIso_refl : forall A, IdBSmgIso A A.
      intros A; split with (BSmgIso_refl A); split; split; intros x; auto.
   Defined.

   Hint Resolve IdBSmgIso_refl.

   Definition IdTfIso_refl : forall A, IdTfIso A A.
      intros A; split with (TfIso_refl A); split; split; intros x; auto.
   Defined.

   Hint Resolve IdTfIso_refl.

   Definition IdSTfIso_refl : forall A, IdSTfIso A A.
      intros A; split with (STfIso_refl A); split; split; intros x; auto.
   Defined.

   Hint Resolve IdSTfIso_refl.

   (*** Symmetric ***)

   Definition IdDsIso_sym : forall {A B}, IdDsIso A B -> IdDsIso B A.
      intros A B p; split with (DsIso_sym p).
      destruct p as [[f f'] [p1 p2]]; simpl in *; split; simpl; auto.
   Defined.

   Definition IdSmgIso_sym : forall {A B}, IdSmgIso A B -> IdSmgIso B A.
      intros A B p; split with (SmgIso_sym p).
      destruct p as [[f f'] [p1 p2]]; simpl in *; split; simpl; auto.
   Defined.

   Definition IdProIso_sym : forall {A B}, IdProIso A B -> IdProIso B A.
      intros A B p; split with (ProIso_sym p).
      destruct p as [[f f'] [p1 p2]]; simpl in *; split; simpl; auto.
   Defined.

   Definition IdOSmgIso_sym : forall {A B}, IdOSmgIso A B -> IdOSmgIso B A.
      intros A B p; split with (OSmgIso_sym p).
      destruct p as [[f f'] [p1 p2]]; simpl in *; split; simpl; auto.
   Defined.

   Definition IdBSmgIso_sym : forall {A B}, IdBSmgIso A B -> IdBSmgIso B A.
      intros A B p; split with (BSmgIso_sym p).
      destruct p as [[f f'] [p1 p2]]; simpl in *; split; simpl; auto.
   Defined.

   Definition IdTfIso_sym : forall {A B}, IdTfIso A B -> IdTfIso B A.
      intros A B p; split with (TfIso_sym p).
      destruct p as [[f f'] [p1 p2]]; simpl in *; split; simpl; auto.
      destruct p as [[[] [f f']] [] [p1 p2]]; simpl in *; split; simpl; auto.
   Defined.

   Definition IdSTfIso_sym : forall {A B}, IdSTfIso A B -> IdSTfIso B A.
      intros A B p; split with (STfIso_sym p).
      destruct p as [[f f'] [p1 p2]]; simpl in *; split; simpl; auto.
      destruct p as [[[] [f f']] [] [p1 p2]]; simpl in *; split; simpl; auto.
   Defined.

   (*** Transitive ***)

   Definition IdDsIso_trans : forall {A B C}, IdDsIso A B -> IdDsIso B C -> IdDsIso A C.
      intros A B C p q; split with (DsIso_trans p q).
      destruct p as [[f f'] [p1 p2]]; destruct q as [[g g'] [q1 q2]]; simpl;
      split; simpl; unfold DsIso_trans_phi, DsIso_trans_phi'; simpl in *.
      clear - p1 q1; destruct p1; destruct q1; split; intros x; rewrite H, H0; auto.
      clear - p2 q2; destruct p2; destruct q2; split; intros x; rewrite H, H0; auto.
   Defined.

   Definition IdSmgIso_trans : forall {A B C}, IdSmgIso A B -> IdSmgIso B C -> IdSmgIso A C.
      intros A B C p q; split with (SmgIso_trans p q).
      destruct p as [[[f f']] [p1 p2]]; destruct q as [[[g g']] [q1 q2]]; simpl;
      split; simpl; unfold DsIso_trans_phi, DsIso_trans_phi'; simpl in *.
      clear - p1 q1; destruct p1; destruct q1; split; intros x; rewrite H, H0; auto.
      clear - p2 q2; destruct p2; destruct q2; split; intros x; rewrite H, H0; auto.
   Defined.

   Definition IdProIso_trans : forall {A B C}, IdProIso A B -> IdProIso B C -> IdProIso A C.
      intros A B C p q; split with (ProIso_trans p q).
      destruct p as [[[f f']] [p1 p2]]; destruct q as [[[g g']] [q1 q2]]; simpl;
      split; simpl; unfold DsIso_trans_phi, DsIso_trans_phi'; simpl in *.
      clear - p1 q1; destruct p1; destruct q1; split; intros x; rewrite H, H0; auto.
      clear - p2 q2; destruct p2; destruct q2; split; intros x; rewrite H, H0; auto.
   Defined.

   Definition IdOSmgIso_trans : forall {A B C}, IdOSmgIso A B -> IdOSmgIso B C -> IdOSmgIso A C.
      intros A B C p q; split with (OSmgIso_trans p q).
      destruct p as [[[f f']] [p1 p2]]; destruct q as [[[g g']] [q1 q2]]; simpl;
      split; simpl; unfold DsIso_trans_phi, DsIso_trans_phi'; simpl in *.
      clear - p1 q1; destruct p1; destruct q1; split; intros x; rewrite H, H0; auto.
      clear - p2 q2; destruct p2; destruct q2; split; intros x; rewrite H, H0; auto.
   Defined.

   Definition IdBSmgIso_trans : forall {A B C}, IdBSmgIso A B -> IdBSmgIso B C -> IdBSmgIso A C.
      intros A B C p q; split with (BSmgIso_trans p q).
      destruct p as [[[f f']] [p1 p2]]; destruct q as [[[g g']] [q1 q2]]; simpl;
      split; simpl; unfold DsIso_trans_phi, DsIso_trans_phi'; simpl in *.
      clear - p1 q1; destruct p1; destruct q1; split; intros x; rewrite H, H0; auto.
      clear - p2 q2; destruct p2; destruct q2; split; intros x; rewrite H, H0; auto.
   Defined.

   Definition IdTfIso_trans : forall {A B C}, IdTfIso A B -> IdTfIso B C -> IdTfIso A C.
      intros A B C p q; split with (TfIso_trans p q).
      destruct p as [[[f f']] [p1 p2]]; destruct q as [[[g g']] [q1 q2]]; simpl;
      split; simpl; unfold DsIso_trans_phi, DsIso_trans_phi'; simpl in *.
      clear - p1 q1; destruct p1; destruct q1; split; intros x; rewrite H, H0; auto.
      clear - p2 q2; destruct p2; destruct q2; split; intros x; rewrite H, H0; auto.

      destruct p as [[[][f f']] [] [p1 p2]]; destruct q as [[[][g g']] [][q1 q2]]; simpl;
      split; simpl; unfold DsIso_trans_phi, DsIso_trans_phi'; simpl in *.
      clear - p1 q1; destruct p1; destruct q1; split; intros x; rewrite H, H0; auto.
      clear - p2 q2; destruct p2; destruct q2; split; intros x; rewrite H, H0; auto.
   Defined.

   Definition IdSTfIso_trans : forall {A B C}, IdSTfIso A B -> IdSTfIso B C -> IdSTfIso A C.
      intros A B C p q; split with (STfIso_trans p q).
      destruct p as [[[f f']] [p1 p2]]; destruct q as [[[g g']] [q1 q2]]; simpl;
      split; simpl; unfold DsIso_trans_phi, DsIso_trans_phi'; simpl in *.
      clear - p1 q1; destruct p1; destruct q1; split; intros x; rewrite H, H0; auto.
      clear - p2 q2; destruct p2; destruct q2; split; intros x; rewrite H, H0; auto.

      destruct p as [[[][f f']] [] [p1 p2]]; destruct q as [[[][g g']] [][q1 q2]]; simpl;
      split; simpl; unfold DsIso_trans_phi, DsIso_trans_phi'; simpl in *.
      clear - p1 q1; destruct p1; destruct q1; split; intros x; rewrite H, H0; auto.
      clear - p2 q2; destruct p2; destruct q2; split; intros x; rewrite H, H0; auto.
   Defined.

   (*** Projections ***)

   Definition IdSmgIso__IdDsIso {A B} (x : IdSmgIso A B) : IdDsIso A B.
      intros. split with x. apply x.
   Defined.

   Definition IdProIso__IdDsIso {A B} (x : IdProIso A B) : IdDsIso A B.
      intros. split with x. apply x.
   Defined.

   Definition IdOSmgIso__IdSmgIso {A B} (x : IdOSmgIso A B) : IdSmgIso A B.
      intros. split with x. apply x.
   Defined.

   Definition IdOSmgIso__IdProIso {A B} (x : IdOSmgIso A B) : IdProIso A B.
      intros. split with x. apply x.
   Defined.

   Definition plus_IdBSmgIso__IdSmgIso {A B} (x : IdBSmgIso A B) : IdSmgIso (plusSmg A) (plusSmg B).
      intros. split with (plusSmgBSmgIso x). apply x.
   Defined.

   Definition times_IdBSmgIso__IdSmgIso {A B} (x : IdBSmgIso A B) : IdSmgIso (timesSmg A) (timesSmg B).
      intros. split with (timesSmgBSmgIso x). apply x.
   Defined.

   Definition IdTfIso__IdDsIso {A B} (x : IdTfIso A B) : IdDsIso A B.
      intros. split with x. apply x.
   Defined.

   Definition fn_IdTfIso__IdDsIso {A B} (x : IdTfIso A B) : IdDsIso (Transform.fn A) (Transform.fn B).
      intros. split with (Transform.fnIso x). apply x.
   Defined.

   Definition IdSTfIso__IdSmgIso {A B} (x : IdSTfIso A B) : IdSmgIso A B.
      intros. split with x. apply x.
   Defined.

   Definition IdSTfIso__IdTfIso {A B} (x : IdSTfIso A B) : IdTfIso A B.
      intros. split with x. apply x. apply (fnIdSTfIso _ _ x).
   Defined.
