Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.Bisemigroup.
Require Import Metarouting.Signatures.BisemigroupProperties.
Require Import Metarouting.Signatures.SemigroupPropRecord.
Section bsProp.
   Variable BS : Bisemigroup.
   Notation "'of' P" := (option (P BS)) (at level 0).

   Record bsProp  :=
   {
      bs_plus_sgprop                            : sgProp (plusSmg BS);
      bs_times_sgprop                           : sgProp (timesSmg BS);
      isLeftDistributive                        : of IsLeftDistributive;
      isLeftDistributive_comp                   : of IsLeftDistributive_comp;
      isRightDistributive                       : of IsRightDistributive;
      isRightDistributive_comp                  : of IsRightDistributive_comp;
      plusIdentityIsTimesAnnihilator            : of PlusIdentityIsTimesAnnihilator;
      plusIdentityIsTimesAnnihilator_comp       : of PlusIdentityIsTimesAnnihilator_comp;
      plusAnnihilatorIsTimesIdentity            : of PlusAnnihilatorIsTimesIdentity;
      plusAnnihilatorIsTimesIdentity_comp       : of PlusAnnihilatorIsTimesIdentity_comp;
      (* LatticeProps *)
      isRightStrictStable                       : of IsRightStrictStable;
      isRightStrictStable_comp                  : of IsRightStrictStable_comp;
      isLeftStrictStable                        : of IsLeftStrictStable;
      isLeftStrictStable_comp                   : of IsLeftStrictStable_comp;
      isRightCompEqCancel                       : of IsRightCompEqCancel;
      isRightCompEqCancel_comp                  : of IsRightCompEqCancel_comp;
      isLeftCompEqCancel                        : of IsLeftCompEqCancel;
      isLeftCompEqCancel_comp                   : of IsLeftCompEqCancel_comp;
      isRightCompCancel                         : of IsRightCompCancel;
      isRightCompCancel_comp                    : of IsRightCompCancel_comp;
      isLeftCompCancel                          : of IsLeftCompCancel;
      isLeftCompCancel_comp                     : of IsLeftCompCancel_comp;
      leftDiscrete                              : of LeftDiscrete;
      leftDiscrete_comp                         : of LeftDiscrete_comp;
      rightDiscrete                             : of RightDiscrete;
      rightDiscrete_comp                        : of RightDiscrete_comp;
      leftComparable                            : of LeftComparable;
      leftComparable_comp                       : of LeftComparable_comp;
      rightComparable                           : of RightComparable;
      rightComparable_comp                      : of RightComparable_comp;
      leftIncreasing                            : of LeftIncreasing;
      leftIncreasing_comp                       : of LeftIncreasing_comp;
      rightIncreasing                           : of RightIncreasing;
      rightIncreasing_comp                      : of RightIncreasing_comp;
      leftStrictIncreasing                      : of LeftStrictIncreasing;
      leftStrictIncreasing_comp                 : of LeftStrictIncreasing_comp;
      rightStrictIncreasing                     : of RightStrictIncreasing;
      rightStrictIncreasing_comp                : of RightStrictIncreasing_comp;
      (* IdProps *)
      isRightTimesMapToIdConstantPlus           : of IsRightTimesMapToIdConstantPlus;
      isRightTimesMapToIdConstantPlus_comp      : of IsRightTimesMapToIdConstantPlus_comp;
      isLeftTimesMapToIdConstantPlus            : of IsLeftTimesMapToIdConstantPlus;
      isLeftTimesMapToIdConstantPlus_comp       : of IsLeftTimesMapToIdConstantPlus_comp;
      plusIdentityIsTimesLeftAnnihilator        : of PlusIdentityIsTimesLeftAnnihilator;
      plusIdentityIsTimesLeftAnnihilator_comp   : of PlusIdentityIsTimesLeftAnnihilator_comp;
      plusIdentityIsTimesRightAnnihilator       : of PlusIdentityIsTimesRightAnnihilator;
      plusIdentityIsTimesRightAnnihilator_comp  : of PlusIdentityIsTimesRightAnnihilator_comp
   }.
End bsProp.

   Definition bsPropIso : forall {B B'} (I : BSmgIso B B'), bsProp B -> bsProp B'.
      intros B B' I bsp; apply (Build_bsProp _ 
         (sgPropIso (plusSmgBSmgIso I) (bs_plus_sgprop _ bsp))
         (sgPropIso (timesSmgBSmgIso I) (bs_times_sgprop _ bsp))); 
      destruct bsp.
      apply (opfn (Iso_IsLeftDistributive I)); trivial.
      apply (opfn (Iso_IsLeftDistributive_comp I)); trivial.
      apply (opfn (Iso_IsRightDistributive I)); trivial.
      apply (opfn (Iso_IsRightDistributive_comp I)); trivial.
      apply (opfn (Iso_PlusIdentityIsTimesAnnihilator I)); trivial.
      apply (opfn (Iso_PlusIdentityIsTimesAnnihilator_comp I)); trivial.
      apply (opfn (Iso_PlusAnnihilatorIsTimesIdentity I)); trivial.
      apply (opfn (Iso_PlusAnnihilatorIsTimesIdentity_comp I)); trivial.
      (* LatticeProps *)
      apply (opfn (Iso_IsRightStrictStable I)); trivial.
      apply (opfn (Iso_IsRightStrictStable_comp I)); trivial.
      apply (opfn (Iso_IsLeftStrictStable I)); trivial.
      apply (opfn (Iso_IsLeftStrictStable_comp I)); trivial.
      apply (opfn (Iso_IsRightCompEqCancel I)); trivial.
      apply (opfn (Iso_IsRightCompEqCancel_comp I)); trivial.
      apply (opfn (Iso_IsLeftCompEqCancel I)); trivial.
      apply (opfn (Iso_IsLeftCompEqCancel_comp I)); trivial.
      apply (opfn (Iso_IsRightCompCancel I)); trivial.
      apply (opfn (Iso_IsRightCompCancel_comp I)); trivial.
      apply (opfn (Iso_IsLeftCompCancel I)); trivial.
      apply (opfn (Iso_IsLeftCompCancel_comp I)); trivial.
      apply (opfn (Iso_LeftDiscrete I)); trivial.
      apply (opfn (Iso_LeftDiscrete_comp I)); trivial.
      apply (opfn (Iso_RightDiscrete I)); trivial.
      apply (opfn (Iso_RightDiscrete_comp I)); trivial.
      apply (opfn (Iso_LeftComparable I)); trivial.
      apply (opfn (Iso_LeftComparable_comp I)); trivial.
      apply (opfn (Iso_RightComparable I)); trivial.
      apply (opfn (Iso_RightComparable_comp I)); trivial.
      apply (opfn (Iso_LeftIncreasing I)); trivial.
      apply (opfn (Iso_LeftIncreasing_comp I)); trivial.
      apply (opfn (Iso_RightIncreasing I)); trivial.
      apply (opfn (Iso_RightIncreasing_comp I)); trivial.
      apply (opfn (Iso_LeftStrictIncreasing I)); trivial.
      apply (opfn (Iso_LeftStrictIncreasing_comp I)); trivial.
      apply (opfn (Iso_RightStrictIncreasing I)); trivial.
      apply (opfn (Iso_RightStrictIncreasing_comp I)); trivial.
      (* IdProps *)
      apply (opfn (Iso_IsRightTimesMapToIdConstantPlus I)); trivial.
      apply (opfn (Iso_IsRightTimesMapToIdConstantPlus_comp I)); trivial.
      apply (opfn (Iso_IsLeftTimesMapToIdConstantPlus I)); trivial.
      apply (opfn (Iso_IsLeftTimesMapToIdConstantPlus_comp I)); trivial.
      apply (opfn (Iso_PlusIdentityIsTimesLeftAnnihilator I)); trivial.
      apply (opfn (Iso_PlusIdentityIsTimesLeftAnnihilator_comp I)); trivial.
      apply (opfn (Iso_PlusIdentityIsTimesRightAnnihilator I)); trivial.
      apply (opfn (Iso_PlusIdentityIsTimesRightAnnihilator_comp I)); trivial.
   Defined.