Require Import Coq.Lists.List.

Section BigPairs.

   Fixpoint add_types_iter n (l : list Type) (f : list Type ->Type) : Type :=
      match n with
         | 0 => f l
         | S n => forall {A : Type}, (add_types_iter n (A :: l) f)
      end.
   
   Definition add_type n f : Type := add_types_iter n nil f.
      
   Definition fi2 (Al : list Type) (Xl : list Type) (i : nat) :=
      List.fold_left (fun T T' => (T' -> T)) Xl (@List.nth_default Type unit Al i).

   Definition fi (A : Type) (Xl : list Type) :=
      List.fold_left (fun T T' => (T' -> T)) Xl A.

   Definition ret_type (l : list Type) : Type :=
      match (List.rev l) with
         | nil => unit (* the list normaly should not be empty *)
         | x :: l => List.fold_left (fun T T' => (T * T')%type) l x
      end.

   Definition args_type (Xl : list Type) (R : Type) : Type :=
      List.fold_left (fun T A => A -> T) Xl R.

   Definition inner_type (Al : list Type) (Xl : list Type) : Type :=
      List.fold_left (fun T A => ((fi A Xl) -> T)) Al (args_type Xl (ret_type Al)).
   
   Definition pair_type n m := 
      add_type n (fun Al => add_type m (fun Xl => inner_type Al Xl)).

End BigPairs.

(*************************************************************)
(*                 Concrete big tuples                       *)
(*************************************************************)
   
   Ltac pair_def := compute; intros; repeat split; auto.

   Definition pair3_10 : pair_type 3 10. pair_def. Defined.

   Definition pair5_62 : pair_type 5 62. pair_def. Defined.

   Definition pair7_72 : pair_type 7 72. pair_def. Defined.

   Implicit Arguments pair7_72
      [ A  A0  A1  A2  A3  A4  A5  A6  A7  A8  A9
          A10 A11 A12 A13 A14 A15 A16 A17 A18 A19
          A20 A21 A22 A23 A24 A25 A26 A27 A28 A29
          A30 A31 A32 A33 A34 A35 A36 A37 A38 A39
          A40 A41 A42 A43 A44 A45 A46 A47 A48 A49
          A50 A51 A52 A53 A54 A55 A56 A57 A58 A59
          A60 A61 A62 A63 A64 A65 A66 A67 A68 A69
          A70 A71 A72 A73 A74 A75 A76 A77
      ].

   Definition pair7_73 : pair_type 7 73. pair_def. Defined.

   Implicit Arguments pair7_73
      [ A  A0  A1  A2  A3  A4  A5  A6  A7  A8  A9
          A10 A11 A12 A13 A14 A15 A16 A17 A18 A19
          A20 A21 A22 A23 A24 A25 A26 A27 A28 A29
          A30 A31 A32 A33 A34 A35 A36 A37 A38 A39
          A40 A41 A42 A43 A44 A45 A46 A47 A48 A49
          A50 A51 A52 A53 A54 A55 A56 A57 A58 A59
          A60 A61 A62 A63 A64 A65 A66 A67 A68 A69
          A70 A71 A72 A73 A74 A75 A76 A77 A78
      ].

   Definition pair7_74 : pair_type 7 74. pair_def. Defined.

   Implicit Arguments pair7_74
      [ A  A0  A1  A2  A3  A4  A5  A6  A7  A8  A9
          A10 A11 A12 A13 A14 A15 A16 A17 A18 A19
          A20 A21 A22 A23 A24 A25 A26 A27 A28 A29
          A30 A31 A32 A33 A34 A35 A36 A37 A38 A39
          A40 A41 A42 A43 A44 A45 A46 A47 A48 A49
          A50 A51 A52 A53 A54 A55 A56 A57 A58 A59
          A60 A61 A62 A63 A64 A65 A66 A67 A68 A69
          A70 A71 A72 A73 A74 A75 A76 A77 A78 A79
      ].

   Definition pair7_75 : pair_type 7 75. pair_def. Defined.

   Implicit Arguments pair7_75
      [ A  A0  A1  A2  A3  A4  A5  A6  A7  A8  A9
          A10 A11 A12 A13 A14 A15 A16 A17 A18 A19
          A20 A21 A22 A23 A24 A25 A26 A27 A28 A29
          A30 A31 A32 A33 A34 A35 A36 A37 A38 A39
          A40 A41 A42 A43 A44 A45 A46 A47 A48 A49
          A50 A51 A52 A53 A54 A55 A56 A57 A58 A59
          A60 A61 A62 A63 A64 A65 A66 A67 A68 A69
          A70 A71 A72 A73 A74 A75 A76 A77 A78 A79
          A80
      ].

   Definition pair7_77 : pair_type 7 77. pair_def. Defined.

   Implicit Arguments pair7_77
      [ A  A0  A1  A2  A3  A4  A5  A6  A7  A8  A9
          A10 A11 A12 A13 A14 A15 A16 A17 A18 A19
          A20 A21 A22 A23 A24 A25 A26 A27 A28 A29
          A30 A31 A32 A33 A34 A35 A36 A37 A38 A39
          A40 A41 A42 A43 A44 A45 A46 A47 A48 A49
          A50 A51 A52 A53 A54 A55 A56 A57 A58 A59
          A60 A61 A62 A63 A64 A65 A66 A67 A68 A69
          A70 A71 A72 A73 A74 A75 A76 A77 A78 A79
          A80 A81 A82
      ].


   Definition pair7_78 : pair_type 7 78. pair_def. Defined.

   Implicit Arguments pair7_78
      [ A  A0  A1  A2  A3  A4  A5  A6  A7  A8  A9
          A10 A11 A12 A13 A14 A15 A16 A17 A18 A19
          A20 A21 A22 A23 A24 A25 A26 A27 A28 A29
          A30 A31 A32 A33 A34 A35 A36 A37 A38 A39
          A40 A41 A42 A43 A44 A45 A46 A47 A48 A49
          A50 A51 A52 A53 A54 A55 A56 A57 A58 A59
          A60 A61 A62 A63 A64 A65 A66 A67 A68 A69
          A70 A71 A72 A73 A74 A75 A76 A77 A78 A79
          A80 A81 A82 A83
      ].

   Definition pair7_82 : pair_type 7 82. pair_def. Defined.

   Implicit Arguments pair7_82
      [ A  A0  A1  A2  A3  A4  A5  A6  A7  A8  A9
          A10 A11 A12 A13 A14 A15 A16 A17 A18 A19
          A20 A21 A22 A23 A24 A25 A26 A27 A28 A29
          A30 A31 A32 A33 A34 A35 A36 A37 A38 A39
          A40 A41 A42 A43 A44 A45 A46 A47 A48 A49
          A50 A51 A52 A53 A54 A55 A56 A57 A58 A59
          A60 A61 A62 A63 A64 A65 A66 A67 A68 A69
          A70 A71 A72 A73 A74 A75 A76 A77 A78 A79
          A80 A81 A82 A83 A84 A85 A86 A87
      ].

   Definition pair7_86 : pair_type 7 86. pair_def. Defined.

   Implicit Arguments pair7_86
      [ A  A0  A1  A2  A3  A4  A5  A6  A7  A8  A9
          A10 A11 A12 A13 A14 A15 A16 A17 A18 A19
          A20 A21 A22 A23 A24 A25 A26 A27 A28 A29
          A30 A31 A32 A33 A34 A35 A36 A37 A38 A39
          A40 A41 A42 A43 A44 A45 A46 A47 A48 A49
          A50 A51 A52 A53 A54 A55 A56 A57 A58 A59
          A60 A61 A62 A63 A64 A65 A66 A67 A68 A69
          A70 A71 A72 A73 A74 A75 A76 A77 A78 A79
          A80 A81 A82 A83 A84 A85 A86 A87 A88 A89
          A90 A91
      ].

   Definition pair7_90 : pair_type 7 90. pair_def. Defined.

   Implicit Arguments pair7_90
      [ A  A0  A1  A2  A3  A4  A5  A6  A7  A8  A9
          A10 A11 A12 A13 A14 A15 A16 A17 A18 A19
          A20 A21 A22 A23 A24 A25 A26 A27 A28 A29
          A30 A31 A32 A33 A34 A35 A36 A37 A38 A39
          A40 A41 A42 A43 A44 A45 A46 A47 A48 A49
          A50 A51 A52 A53 A54 A55 A56 A57 A58 A59
          A60 A61 A62 A63 A64 A65 A66 A67 A68 A69
          A70 A71 A72 A73 A74 A75 A76 A77 A78 A79
          A80 A81 A82 A83 A84 A85 A86 A87 A88 A89
          A90 A91 A92 A93 A94 A95
      ].
