(* The place where all come together *)

Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Logic.BigTuples.

Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.Preorder.
Require Import Metarouting.Signatures.Transform.
Require Import Metarouting.Signatures.OrderSemigroup.
Require Import Metarouting.Signatures.Bisemigroup.
Require Import Metarouting.Signatures.SemigroupTransform.

Require Import Metarouting.Signatures.DecSetoidProperties.
Require Import Metarouting.Signatures.SemigroupProperties.
Require Import Metarouting.Signatures.PreorderProperties.
Require Import Metarouting.Signatures.OrderSemigroupProperties.
Require Import Metarouting.Signatures.BisemigroupProperties.
Require Import Metarouting.Signatures.TransformProperties.
Require Import Metarouting.Signatures.SemigroupTransformProperties.

Require Import Metarouting.Signatures.DecSetoidPropRecord.
Require Import Metarouting.Signatures.SemigroupPropRecord.
Require Import Metarouting.Signatures.PreorderPropRecord.
Require Import Metarouting.Signatures.OrderSemigroupPropRecord.
Require Import Metarouting.Signatures.BisemigroupPropRecord.
Require Import Metarouting.Signatures.TransformPropRecord.
Require Import Metarouting.Signatures.SemigroupTransformPropRecord.

Require Import Metarouting.Signatures.OrderSemigroupGlue.
Require Import Metarouting.Signatures.BisemigroupGlue.
Require Import Metarouting.Signatures.SemigroupTransformGlue.

Require Import Metarouting.Signatures.IdArrow.

Require Import Metarouting.Constructions.DecSetoids.AddConstant.
Require Import Metarouting.Constructions.DecSetoids.Bool.
Require Import Metarouting.Constructions.DecSetoids.FMinSets.
Require Import Metarouting.Constructions.DecSetoids.FSets.
Require Import Metarouting.Constructions.DecSetoids.Nat.
Require Import Metarouting.Constructions.DecSetoids.Product.
Require Import Metarouting.Constructions.DecSetoids.Range.
Require Import Metarouting.Constructions.DecSetoids.Union.
Require Import Metarouting.Constructions.DecSetoids.Unit.
Require Import Metarouting.Constructions.DecSetoids.Seq.
Require Import Metarouting.Constructions.DecSetoids.SimpleSeq.
Require Import Metarouting.Constructions.DecSetoids.MultiSets.

Require Import Metarouting.Constructions.Semigroups.Unit.
Require Import Metarouting.Constructions.Semigroups.BoolAnd.
Require Import Metarouting.Constructions.Semigroups.BoolOr.
Require Import Metarouting.Constructions.Semigroups.NatMax.
Require Import Metarouting.Constructions.Semigroups.NatMin.
Require Import Metarouting.Constructions.Semigroups.NatPlus.
Require Import Metarouting.Constructions.Semigroups.RangeMax.
Require Import Metarouting.Constructions.Semigroups.RangeMin.
Require Import Metarouting.Constructions.Semigroups.RangePlus.
Require Import Metarouting.Constructions.Semigroups.FSetsIntersect.
Require Import Metarouting.Constructions.Semigroups.FSetsUnion.
Require Import Metarouting.Constructions.Semigroups.FSetOp.
Require Import Metarouting.Constructions.Semigroups.FMinSetsUnion.
Require Import Metarouting.Constructions.Semigroups.FMinSetsOp.
Require Import Metarouting.Constructions.Semigroups.TopUnion.
Require Import Metarouting.Constructions.Semigroups.Union.
Require Import Metarouting.Constructions.Semigroups.UnionSwap.
Require Import Metarouting.Constructions.Semigroups.Lex.
Require Import Metarouting.Constructions.Semigroups.Product.
Require Import Metarouting.Constructions.Semigroups.Left.
Require Import Metarouting.Constructions.Semigroups.Right.
Require Import Metarouting.Constructions.Semigroups.SelLex.
Require Import Metarouting.Constructions.Semigroups.Seq.
Require Import Metarouting.Constructions.Semigroups.Prefix.
Require Import Metarouting.Constructions.Semigroups.Postfix.
Require Import Metarouting.Constructions.Semigroups.SimpleSeq.
Require Import Metarouting.Constructions.Semigroups.RevOp.
Require Import Metarouting.Constructions.Semigroups.MultiSetsUnion.
Require Import Metarouting.Constructions.Semigroups.MultiSetsIntersection.

Require Import Metarouting.Constructions.Preorders.Dual.
Require Import Metarouting.Constructions.Preorders.LeftNaturalOrder.
Require Import Metarouting.Constructions.Preorders.RightNaturalOrder.
Require Import Metarouting.Constructions.Preorders.Lex.
Require Import Metarouting.Constructions.Preorders.NatLe.
Require Import Metarouting.Constructions.Preorders.AnnTop.

Require Import Metarouting.Constructions.OrderSemigroups.Dual.
Require Import Metarouting.Constructions.OrderSemigroups.LeftNaturalOrder.
Require Import Metarouting.Constructions.OrderSemigroups.RightNaturalOrder.
Require Import Metarouting.Constructions.OrderSemigroups.Lex.
Require Import Metarouting.Constructions.OrderSemigroups.NatLePlus.
Require Import Metarouting.Constructions.OrderSemigroups.BSLeftNaturalOrder.
Require Import Metarouting.Constructions.OrderSemigroups.SimpleSeq.

Require Import Metarouting.Constructions.Bisemigroups.Unit.
Require Import Metarouting.Constructions.Bisemigroups.BoolOrAnd.
Require Import Metarouting.Constructions.Bisemigroups.NatIMaxMin.
Require Import Metarouting.Constructions.Bisemigroups.NatIMaxPlus.
Require Import Metarouting.Constructions.Bisemigroups.NatIMinPlus.
Require Import Metarouting.Constructions.Bisemigroups.NatMaxPlus.
Require Import Metarouting.Constructions.Bisemigroups.NatMinPlus.
Require Import Metarouting.Constructions.Bisemigroups.NatMaxMin.
Require Import Metarouting.Constructions.Bisemigroups.RangeMaxMin.
Require Import Metarouting.Constructions.Bisemigroups.RangeMaxPlus.
Require Import Metarouting.Constructions.Bisemigroups.RangeMinPlus.
Require Import Metarouting.Constructions.Bisemigroups.Swap.
Require Import Metarouting.Constructions.Bisemigroups.Lex.
Require Import Metarouting.Constructions.Bisemigroups.Product.
Require Import Metarouting.Constructions.Bisemigroups.FSetsOp.
Require Import Metarouting.Constructions.Bisemigroups.FSets.
Require Import Metarouting.Constructions.Bisemigroups.FMinSets.
Require Import Metarouting.Constructions.Bisemigroups.FMinSetsOpUnion.
Require Import Metarouting.Constructions.Bisemigroups.Left.
Require Import Metarouting.Constructions.Bisemigroups.AddZero.
Require Import Metarouting.Constructions.Bisemigroups.AddOne.
Require Import Metarouting.Constructions.Bisemigroups.SelLex.
Require Import Metarouting.Constructions.Bisemigroups.RevTimes.
Require Import Metarouting.Constructions.Bisemigroups.PrefixSeq.
Require Import Metarouting.Constructions.Bisemigroups.PostfixSeq.
Require Import Metarouting.Constructions.Bisemigroups.MultiSets.

Require Import Metarouting.Constructions.Transforms.Id.
Require Import Metarouting.Constructions.Transforms.Product.
Require Import Metarouting.Constructions.Transforms.Replace.
Require Import Metarouting.Constructions.Transforms.Union.
Require Import Metarouting.Constructions.Transforms.Cayley.

Require Import Metarouting.Constructions.SemigroupTransforms.Left.
Require Import Metarouting.Constructions.SemigroupTransforms.Right.
Require Import Metarouting.Constructions.SemigroupTransforms.Lex.
Require Import Metarouting.Constructions.SemigroupTransforms.SelLex.
Require Import Metarouting.Constructions.SemigroupTransforms.Union.
Require Import Metarouting.Constructions.SemigroupTransforms.Cayley.

Require Import Metarouting.IsoPres.DecSetoids.Union.
Require Import Metarouting.IsoPres.DecSetoids.Product.
Require Import Metarouting.IsoPres.DecSetoids.FSets.
Require Import Metarouting.IsoPres.DecSetoids.FMinSets.
Require Import Metarouting.IsoPres.DecSetoids.Seq.
Require Import Metarouting.IsoPres.DecSetoids.SimpleSeq.
Require Import Metarouting.IsoPres.DecSetoids.MultiSets.

Require Import Metarouting.IsoPres.Semigroups.FMinSetsOp.
Require Import Metarouting.IsoPres.Semigroups.FMinSetsUnion.
Require Import Metarouting.IsoPres.Semigroups.FSetOp.
Require Import Metarouting.IsoPres.Semigroups.FSetsIntersect.
Require Import Metarouting.IsoPres.Semigroups.FSetsUnion.
Require Import Metarouting.IsoPres.Semigroups.Left.
Require Import Metarouting.IsoPres.Semigroups.Right.
Require Import Metarouting.IsoPres.Semigroups.Lex.
Require Import Metarouting.IsoPres.Semigroups.Product.
Require Import Metarouting.IsoPres.Semigroups.SelLex.
Require Import Metarouting.IsoPres.Semigroups.Seq.
Require Import Metarouting.IsoPres.Semigroups.Prefix.
Require Import Metarouting.IsoPres.Semigroups.Postfix.
Require Import Metarouting.IsoPres.Semigroups.SimpleSeq.
Require Import Metarouting.IsoPres.Semigroups.TopUnion.
Require Import Metarouting.IsoPres.Semigroups.Union.
Require Import Metarouting.IsoPres.Semigroups.UnionSwap.
Require Import Metarouting.IsoPres.Semigroups.RevOp.
Require Import Metarouting.IsoPres.Semigroups.MultiSetsUnion.
Require Import Metarouting.IsoPres.Semigroups.MultiSetsIntersection.

Require Import Metarouting.IsoPres.Preorders.Dual.
Require Import Metarouting.IsoPres.Preorders.LeftNaturalOrder.
Require Import Metarouting.IsoPres.Preorders.RightNaturalOrder.
Require Import Metarouting.IsoPres.Preorders.Lex.
Require Import Metarouting.IsoPres.Preorders.AnnTop.

Require Import Metarouting.IsoPres.OrderSemigroups.Dual.
Require Import Metarouting.IsoPres.OrderSemigroups.LeftNaturalOrder.
Require Import Metarouting.IsoPres.OrderSemigroups.RightNaturalOrder.
Require Import Metarouting.IsoPres.OrderSemigroups.Lex.
Require Import Metarouting.IsoPres.OrderSemigroups.BSLeftNaturalOrder.
Require Import Metarouting.IsoPres.OrderSemigroups.SimpleSeq.

Require Import Metarouting.IsoPres.Bisemigroups.AddOne.
Require Import Metarouting.IsoPres.Bisemigroups.AddZero.
Require Import Metarouting.IsoPres.Bisemigroups.FMinSets.
Require Import Metarouting.IsoPres.Bisemigroups.FMinSetsOpUnion.
Require Import Metarouting.IsoPres.Bisemigroups.FSets.
Require Import Metarouting.IsoPres.Bisemigroups.FSetsOp.
Require Import Metarouting.IsoPres.Bisemigroups.Left.
Require Import Metarouting.IsoPres.Bisemigroups.Lex.
Require Import Metarouting.IsoPres.Bisemigroups.Product.
Require Import Metarouting.IsoPres.Bisemigroups.SelLex.
Require Import Metarouting.IsoPres.Bisemigroups.Swap.
Require Import Metarouting.IsoPres.Bisemigroups.RevTimes.
Require Import Metarouting.IsoPres.Bisemigroups.PrefixSeq.
Require Import Metarouting.IsoPres.Bisemigroups.PostfixSeq.
Require Import Metarouting.IsoPres.Bisemigroups.MultiSets.

Require Import Metarouting.IsoPres.Transforms.Id.
Require Import Metarouting.IsoPres.Transforms.Product.
Require Import Metarouting.IsoPres.Transforms.Replace.
Require Import Metarouting.IsoPres.Transforms.Union.
Require Import Metarouting.IsoPres.Transforms.Cayley.

Require Import Metarouting.IsoPres.SemigroupTransforms.Left.
Require Import Metarouting.IsoPres.SemigroupTransforms.Lex.
Require Import Metarouting.IsoPres.SemigroupTransforms.SelLex.
Require Import Metarouting.IsoPres.SemigroupTransforms.Right.
Require Import Metarouting.IsoPres.SemigroupTransforms.Union.
Require Import Metarouting.IsoPres.SemigroupTransforms.Cayley.

Require Import Metarouting.Inference.DecSetoids.AddConstant.
Require Import Metarouting.Inference.DecSetoids.Bool.
Require Import Metarouting.Inference.DecSetoids.FMinSets.
Require Import Metarouting.Inference.DecSetoids.FSets.
Require Import Metarouting.Inference.DecSetoids.Nat.
Require Import Metarouting.Inference.DecSetoids.Product.
Require Import Metarouting.Inference.DecSetoids.Range.
Require Import Metarouting.Inference.DecSetoids.Union.
Require Import Metarouting.Inference.DecSetoids.Unit.
Require Import Metarouting.Inference.DecSetoids.Seq.
Require Import Metarouting.Inference.DecSetoids.SimpleSeq.
Require Import Metarouting.Inference.DecSetoids.MultiSets.

Require Import Metarouting.Inference.Semigroups.Unit.
Require Import Metarouting.Inference.Semigroups.BoolAnd.
Require Import Metarouting.Inference.Semigroups.BoolOr.
Require Import Metarouting.Inference.Semigroups.NatMax.
Require Import Metarouting.Inference.Semigroups.NatMin.
Require Import Metarouting.Inference.Semigroups.NatPlus.
Require Import Metarouting.Inference.Semigroups.RangeMax.
Require Import Metarouting.Inference.Semigroups.RangeMin.
Require Import Metarouting.Inference.Semigroups.RangePlus.
Require Import Metarouting.Inference.Semigroups.FSetsIntersect.
Require Import Metarouting.Inference.Semigroups.FSetsUnion.
Require Import Metarouting.Inference.Semigroups.FSetOp.
Require Import Metarouting.Inference.Semigroups.FMinSetUnion.
Require Import Metarouting.Inference.Semigroups.FMinSetsOp.
Require Import Metarouting.Inference.Semigroups.TopUnion.
Require Import Metarouting.Inference.Semigroups.Union.
Require Import Metarouting.Inference.Semigroups.UnionSwap.
Require Import Metarouting.Inference.Semigroups.Lex.
Require Import Metarouting.Inference.Semigroups.Product.
Require Import Metarouting.Inference.Semigroups.Left.
Require Import Metarouting.Inference.Semigroups.Right.
Require Import Metarouting.Inference.Semigroups.SelLex.
Require Import Metarouting.Inference.Semigroups.Seq.
Require Import Metarouting.Inference.Semigroups.Prefix.
Require Import Metarouting.Inference.Semigroups.Postfix.
Require Import Metarouting.Inference.Semigroups.SimpleSeq.
Require Import Metarouting.Inference.Semigroups.RevOp.
Require Import Metarouting.Inference.Semigroups.MultiSetsUnion.
Require Import Metarouting.Inference.Semigroups.MultiSetsIntersection.

Require Import Metarouting.Inference.Preorders.Dual.
Require Import Metarouting.Inference.Preorders.LeftNaturalOrder.
Require Import Metarouting.Inference.Preorders.RightNaturalOrder.
Require Import Metarouting.Inference.Preorders.Lex.
Require Import Metarouting.Inference.Preorders.NatLe.
Require Import Metarouting.Inference.Preorders.AnnTop.

Require Import Metarouting.Inference.OrderSemigroups.Dual.
Require Import Metarouting.Inference.OrderSemigroups.LeftNaturalOrder.
Require Import Metarouting.Inference.OrderSemigroups.RightNaturalOrder.
Require Import Metarouting.Inference.OrderSemigroups.Lex.
Require Import Metarouting.Inference.OrderSemigroups.BSLeftNaturalOrder.
Require Import Metarouting.Inference.OrderSemigroups.SimpleSeq.

Require Import Metarouting.Inference.Bisemigroups.Unit.
Require Import Metarouting.Inference.Bisemigroups.BoolOrAnd.
Require Import Metarouting.Inference.Bisemigroups.NatIMaxMin.
Require Import Metarouting.Inference.Bisemigroups.NatIMaxPlus.
Require Import Metarouting.Inference.Bisemigroups.NatIMinPlus.
Require Import Metarouting.Inference.Bisemigroups.NatMaxPlus.
Require Import Metarouting.Inference.Bisemigroups.NatMinPlus.
Require Import Metarouting.Inference.Bisemigroups.NatMaxMin.
Require Import Metarouting.Inference.Bisemigroups.RangeMaxMin.
Require Import Metarouting.Inference.Bisemigroups.RangeMaxPlus.
Require Import Metarouting.Inference.Bisemigroups.RangeMinPlus.
Require Import Metarouting.Inference.Bisemigroups.Swap.
Require Import Metarouting.Inference.Bisemigroups.Lex.
Require Import Metarouting.Inference.Bisemigroups.Product.
Require Import Metarouting.Inference.Bisemigroups.FSetsOp.
Require Import Metarouting.Inference.Bisemigroups.FSets.
Require Import Metarouting.Inference.Bisemigroups.FMinSets.
Require Import Metarouting.Inference.Bisemigroups.FMinSetsOpUnion.
Require Import Metarouting.Inference.Bisemigroups.Left.
Require Import Metarouting.Inference.Bisemigroups.AddZero.
Require Import Metarouting.Inference.Bisemigroups.AddOne.
Require Import Metarouting.Inference.Bisemigroups.SelLex.
Require Import Metarouting.Inference.Bisemigroups.RevTimes.
Require Import Metarouting.Inference.Bisemigroups.PrefixSeq.
Require Import Metarouting.Inference.Bisemigroups.PostfixSeq.
Require Import Metarouting.Inference.Bisemigroups.MultiSets.

Require Import Metarouting.Inference.Transforms.Id.
Require Import Metarouting.Inference.Transforms.Product.
Require Import Metarouting.Inference.Transforms.Replace.
Require Import Metarouting.Inference.Transforms.Union.
Require Import Metarouting.Inference.Transforms.Cayley.

Require Import Metarouting.Inference.SemigroupTransforms.Left.
Require Import Metarouting.Inference.SemigroupTransforms.Right.
Require Import Metarouting.Inference.SemigroupTransforms.Lex.
Require Import Metarouting.Inference.SemigroupTransforms.SelLex.
Require Import Metarouting.Inference.SemigroupTransforms.Union.
Require Import Metarouting.Inference.SemigroupTransforms.Cayley.


Require Import Metarouting.Language.Syntax.
Require Import Coq.Lists.List.

(********************************************************************)
(*                            Semantics                             *)
(********************************************************************)

Definition DecSetoidSem          := Exists d, dsProp d.
Definition SemigroupSem          := Exists s, sgProp s.
Definition PreorderSem           := Exists p, poProp p.
Definition OrderSemigroupSem     := Exists o, osProp o.
Definition BisemigroupSem        := Exists b, bsProp b.
Definition TransformSem          := Exists t, tfProp t.
Definition SemigroupTransformSem := Exists s, stProp s.

(***************************************************************************)
(*                              Coercions                                  *)
(***************************************************************************)

Definition DecSetoidSem_DecSetoid           (x : DecSetoidSem)      : DecSetoid      := projT1 x.
Definition SemigroupSem_Semigroup           (x : SemigroupSem)      : Semigroup      := projT1 x.
Definition PreorderSem_Preorder             (x : PreorderSem)       : Preorder       := projT1 x.
Definition OrderSemigroupSem_OrderSemigroup (x : OrderSemigroupSem) : OrderSemigroup := projT1 x.
Definition BisemigroupSem_Bisemigroup       (x : BisemigroupSem)    : Bisemigroup    := projT1 x.

Definition SemigroupSem_DecSetoidSem (x : SemigroupSem) : DecSetoidSem :=
   existT (fun x => dsProp x) (projT1 x) (projT2 x).
Definition PreorderSem_DecSetoidSem (x : PreorderSem) : DecSetoidSem :=
   existT (fun x => dsProp x) (projT1 x) (projT2 x).
Definition OrderSemigroupSem_SemigroupSem (x : OrderSemigroupSem) : SemigroupSem :=
   existT (fun x => sgProp x) (projT1 x) (projT2 x).
Definition BisemigroupSem_PlusSemigroupSem (x : BisemigroupSem) : SemigroupSem :=
   existT (fun x => sgProp x) (plusSmg (projT1 x)) (bs_plus_sgprop _ (projT2 x)).
Definition BisemigroupSem_TimesSemigroupSem (x : BisemigroupSem) : SemigroupSem :=
   existT (fun x => sgProp x) (timesSmg (projT1 x)) (bs_times_sgprop _ (projT2 x)).

Coercion DecSetoidSem_DecSetoid           : DecSetoidSem >-> DecSetoid.
Coercion SemigroupSem_Semigroup           : SemigroupSem >-> Semigroup.
Coercion PreorderSem_Preorder                   : PreorderSem >-> Preorder.
Coercion OrderSemigroupSem_OrderSemigroup : OrderSemigroupSem >-> OrderSemigroup.
Coercion BisemigroupSem_Bisemigroup       : BisemigroupSem >-> Bisemigroup.

Coercion SemigroupSem_DecSetoidSem      : SemigroupSem >-> DecSetoidSem.
Coercion PreorderSem_DecSetoidSem       : PreorderSem >-> DecSetoidSem.
Coercion OrderSemigroupSem_SemigroupSem : OrderSemigroupSem >-> SemigroupSem.

(***************************************************************************)
(*                     Syntax directed semantics                           *)
(***************************************************************************)

Require Import Coq.Strings.String.

Section SemanticsRelation.

   Record NotWF :=
   {  
      exp    : Lang;
      errMsg : string
   }.

   Definition notWF {X} (e : Lang) (m : string) : X + NotWF :=
      inr _ (Build_NotWF e m).

   Inductive DsSemRel : DS -> DecSetoid -> Type :=
      | dsrUnit           : DsSemRel dUnit unitDecSetoid
      | dsrBool           : DsSemRel dBool boolDecSetoid
      | dsrNat            : DsSemRel dNat natDecSetoid
      | dsrRange          : forall n, DsSemRel (dRange n) (rangeDecSetoid n)
      | dsrAddConstant    : forall x a, DsSemRel x a -> DsSemRel (dAddConstant x) (addConstDecSetoid a)
      | dsrFSets          : forall x a, DsSemRel x a -> DsSemRel (dFSets x) (fsetDecSetoid a)
      | dsrFMinSets       : forall x a, PoSemRel x a -> DsSemRel (dFMinSets x) (msetDecSetoid a)
      | dsrSeq            : forall x a, DsSemRel x a -> DsSemRel (dSeq x) (seqDecSetoid a)
      | dsrSimpleSeq      : forall x a, DsSemRel x a -> DsSemRel (dSimpleSeq x) (simpleSeqDecSetoid a)
      | dsrProduct        : forall x a y b, DsSemRel x a -> DsSemRel y b -> DsSemRel (dProduct x y) (prodDecSetoid a b)
      | dsrUnion          : forall x a y b, DsSemRel x a -> DsSemRel y b -> DsSemRel (dUnion x y) (unionDecSetoid a b)
      | dsrMultiSets      : forall x a, DsSemRel x a -> DsSemRel (dMultiSets x) (multisetDecSetoid a)
   with SgSemRel : SG -> Semigroup -> Type :=
      | ssrUnit           : SgSemRel sUnit    unitSemigroup
      | ssrBoolAnd        : SgSemRel sBoolAnd boolAndSemigroup
      | ssrBoolOr         : SgSemRel sBoolOr  boolOrSemigroup
      | ssrNatMax         : SgSemRel sNatMax  natMaxSemigroup
      | ssrNatMin         : SgSemRel sNatMin  natMinSemigroup
      | ssrNatPlus        : SgSemRel sNatPlus natPlusSemigroup
      | ssrRangeMax       : forall n, SgSemRel (sRangeMax n) (rangeMaxSemigroup n)
      | ssrRangeMin       : forall n, SgSemRel (sRangeMin n) (rangeMinSemigroup n)
      | ssrRangePlus      : forall n, SgSemRel (sRangePlus n) (rangePlusSemigroup n)
      | ssrFSetsIntersect : forall x a, DsSemRel x a -> SgSemRel (sFSetsIntersect x) (fsetsIntersectionSemigroup a)
      | ssrFSetsUnion     : forall x a, DsSemRel x a -> SgSemRel (sFSetsUnion x) (fsetsUnionSemigroup a)
      | ssrFSetsOp        : forall x a, SgSemRel x a -> SgSemRel (sFSetsOp x) (fsetOpSemigroup a)
      | ssrFMinSetsUnion  : forall x a, PoSemRel x a -> SgSemRel (sFMinSetsUnion x) (msetUnionSemigroup a)
      | ssrLeft           : forall x a, DsSemRel x a -> SgSemRel (sLeft x) (leftSemigroup a)
      | ssrRight          : forall x a, DsSemRel x a -> SgSemRel (sRight x) (rightSemigroup a)	
      | ssrSeq            : forall x a, DsSemRel x a -> SgSemRel (sSeq x) (seqSemigroup a)
      | ssrPrefix         : forall x a, DsSemRel x a -> SgSemRel (sPrefix x) (prefixSemigroup a)
      | ssrPostfix        : forall x a, DsSemRel x a -> SgSemRel (sPostfix x) (postfixSemigroup a)
      | ssrSimpleSeq      : forall x a, DsSemRel x a -> SgSemRel (sSimpleSeq x) (simpleSeqSemigroup a)
      | ssrFMinSetsOp     : forall x a, OsSemRel x a -> 
                            forall (lmon : LeftMonotonic a) (rmon : RightMonotonic a) (asm : Antisym a),
                            SgSemRel (sFMinSetsOp x) (msetOpSemigroup a lmon rmon asm)
      | ssrProduct        : forall x a y b, SgSemRel x a -> SgSemRel y b -> SgSemRel (sProduct x y) (prodSemigroup a b)
      | ssrTopUnion       : forall x a y b, SgSemRel x a -> SgSemRel y b -> SgSemRel (sTopUnion x y) (topUnionSemigroup a b)
      | ssrUnion          : forall x a y b, SgSemRel x a -> SgSemRel y b -> SgSemRel (sUnion x y) (unionSemigroup a b)
      | ssrUnionSwap      : forall x a y b, SgSemRel x a -> SgSemRel y b -> SgSemRel (sUnionSwap x y) (unionSwapSemigroup a b)
      | ssrLex            : forall x a y b, SgSemRel x a -> SgSemRel y b -> 
                            forall (comm : IsCommutative a) (idem : IsIdempotent a) (iden : HasIdentity b),
                            SgSemRel (sLex x y) (lexSemigroup a b comm idem iden)
      | ssrSelLex         : forall x a y b, SgSemRel x a -> SgSemRel y b -> 
                            forall (comm : IsCommutative a) (sel : IsSelective a),
                            SgSemRel (sSelLex x y) (selLexSemigroup a b comm sel)
      | ssrRevOp          : forall x a, SgSemRel x a -> SgSemRel (sRevOp x) (revOpSemigroup a)
      | ssrMultiSetsUnion      : forall x a, DsSemRel x a -> SgSemRel (sMultiSetsUnion x) (multisetUnionSemigroup a)
      | ssrMultiSetsIntersect  : forall x a, DsSemRel x a -> SgSemRel (sMultiSetsIntersect x) (multisetIntersectionSemigroup a)
   with PoSemRel : PO -> Preorder -> Type :=
      | psrNatLe             : PoSemRel pNatLe natPreorder
      | psrDual              : forall x a, PoSemRel x a -> PoSemRel (pDual x) (dualPreorder a)
      | psrLeftNaturalOrder  : forall x a, SgSemRel x a -> forall (idem : IsIdempotent a), PoSemRel (pLeftNaturalOrder x) (Preorders.LeftNaturalOrder.leftNaturalOrder a idem)
      | psrRightNaturalOrder : forall x a, SgSemRel x a -> forall (idem : IsIdempotent a), PoSemRel (pRightNaturalOrder x) (Preorders.RightNaturalOrder.rightNaturalOrder a idem)
      | psrLex               : forall x a y b, PoSemRel x a -> PoSemRel y b -> PoSemRel (pLex x y) (lexPreorder a b)
      | psrAnnTop            : forall x a, SgSemRel x a -> forall (hasAnn : HasAnnihilator a), PoSemRel (pAnnTop x) (annTopPreorder a hasAnn)
   with OsSemRel : OS -> OrderSemigroup -> Type :=
      | osrDual               : forall x a, OsSemRel x a -> OsSemRel (oDual x) (dualOrderSemigroup a)
      | osrLeftNaturalOrder   : forall x a, SgSemRel x a -> forall (idem : IsIdempotent a), OsSemRel (oLeftNaturalOrder x) (leftNaturalOrder a idem)
      | osrRightNaturalOrder  : forall x a, SgSemRel x a -> forall (idem : IsIdempotent a), OsSemRel (oRightNaturalOrder x) (rightNaturalOrder a idem)
      | osrLex                : forall x a y b, OsSemRel x a -> OsSemRel y b -> OsSemRel (oLex x y) (lexOrderSemigroup a b)
      | osrBsLeftNaturalOrder : forall x a, BsSemRel x a -> forall (idem : IsIdempotent (plusSmg a)), OsSemRel (oBsLeftNaturalOrder x) (bsLeftNaturalOrder a idem)
      | osrSimpleSeq          : forall x a, DsSemRel x a -> OsSemRel (oSimpleSeq x) (simpleSeqOrderSemigroup a)
   with BsSemRel : BS -> Bisemigroup -> Type :=
      | bsrUnit           : BsSemRel bUnit        unitBisemigroup
      | bsrBoolOrAnd      : BsSemRel bBoolOrAnd   boolOrAndBisemigroup
      | bsrNatMaxPlus     : BsSemRel bNatMaxPlus  natMaxPlusBisemigroup
      | bsrNatMinPlus     : BsSemRel bNatMinPlus  natMinPlusBisemigroup
      | bsrNatMaxMin      : BsSemRel bNatMaxMin   natMaxMinBisemigroup
      | bsrNatIMaxPlus    : BsSemRel bNatIMaxPlus natIMaxPlusBisemigroup
      | bsrNatIMinPlus    : BsSemRel bNatIMinPlus natIMinPlusBisemigroup
      | bsrNatIMaxMin     : BsSemRel bNatIMaxMin  natIMaxMinBisemigroup
      | bsrRangeMaxPlus   : forall n, BsSemRel (bRangeMaxPlus n) (rangeMaxPlusBisemigroup n)
      | bsrRangeMinPlus   : forall n, BsSemRel (bRangeMinPlus n) (rangeMinPlusBisemigroup n)
      | bsrRangeMaxMin    : forall n, BsSemRel (bRangeMaxMin n)  (rangeMaxMinBisemigroup n)
      | bsrSwap           : forall x a, BsSemRel x a -> BsSemRel (bSwap x) (swapBisemigroup a)
      | bsrFMinSets       : forall x a, OsSemRel x a -> 
                            forall (lmon : LeftMonotonic a) (rmon : RightMonotonic a) (asm : Antisym a),
                            BsSemRel (bFMinSets x) (minsetBisemigroup a lmon rmon asm)
      | bsrFMinSetsOpUnion : forall x a, OsSemRel x a -> 
                            forall (lmon : LeftMonotonic a) (rmon : RightMonotonic a) (asm : Antisym a),
                            BsSemRel (bFMinSetsOpUnion x) (minsetOpUnionBisemigroup a lmon rmon asm)
      | bsrFSets          : forall x a, DsSemRel x a -> BsSemRel (bFSets x) (fsetBisemigroup a)
      | bsrFSetsOp        : forall x a, SgSemRel x a -> BsSemRel (bFSetsOp x) (fsetOpBisemigroup a)
      | bsrLeft           : forall x a, SgSemRel x a -> BsSemRel (bLeft x) (leftBisemigroup a)
      | bsrAddZero        : forall x a, BsSemRel x a -> BsSemRel (bAddZero x) (addZeroBisemigroup a)
      | bsrAddOne         : forall x a, BsSemRel x a -> BsSemRel (bAddOne x) (addOneBisemigroup a)
      | bsrProduct        : forall x a y b, BsSemRel x a -> BsSemRel y b -> BsSemRel (bProduct x y) (prodBisemigroup a b)
      | bsrLex            : forall x a y b, BsSemRel x a -> BsSemRel y b -> 
                            forall (comm : IsCommutative (plusSmg a)) (idem : IsIdempotent (plusSmg a)) (hasId : HasIdentity (plusSmg b)), 
                            BsSemRel (bLex x y) (lexBisemigroup a b hasId comm idem)
      | bsrSelLex         : forall x a y b, BsSemRel x a -> BsSemRel y b ->
                            forall (comm : IsCommutative (plusSmg a)) (sel : IsSelective (plusSmg a)), 
                            BsSemRel (bSelLex x y) (selLexBisemigroup a b comm sel)
      | bsrRevTimes       : forall x a, BsSemRel x a -> BsSemRel (bRevTimes x) (revTimesBisemigroup a)
      | bsrPrefixSeq      : forall x a, DsSemRel x a -> BsSemRel (bPrefixSeq x) (prefixSeqBisemigroup a)
      | bsrPostfixSeq     : forall x a, DsSemRel x a -> BsSemRel (bPostfixSeq x) (postfixSeqBisemigroup a)
      | bsrMultiSets      : forall x a, DsSemRel x a -> BsSemRel (bMultiSets x) (multisetBisemigroup a)
   with TfSemRel : TF -> Transform -> Type :=
      | tsrId             : forall x a, DsSemRel x a -> TfSemRel (tId x) (idTransform a)
      | tsrReplace        : forall x a, DsSemRel x a -> TfSemRel (tReplace x) (replaceTransform a)
      | tsrProduct        : forall x a y b, TfSemRel x a -> TfSemRel y b -> TfSemRel (tProduct x y) (prodTransform a b)
      | tsrUnion          : forall x a y b, TfSemRel x a -> TfSemRel y b -> forall (iso : IdDsIso a b), TfSemRel (tUnion x y) (unionTransform a b iso)
      | tsrCayley         : forall x a, SgSemRel x a -> TfSemRel (tCayley x) (cayleyMapTransform a)
   with StSemRel : ST -> SemigroupTransform -> Type :=
      | stsrLeft          : forall x a, SgSemRel x a -> StSemRel (stLeft x) (leftSemigroupTransform a)
      | stsrRight         : forall x a, SgSemRel x a -> StSemRel (stRight x) (rightSemigroupTransform a)
      | stsrLex           : forall x a y b, StSemRel x a -> StSemRel y b ->
                            forall (comm : IsCommutative a) (idem : IsIdempotent a) (hasId : HasIdentity b) (strict : Strict b),
                            StSemRel (stLex x y) (lexSemigroupTransform a b comm idem hasId)
      | stsrSelLex        : forall x a y b, StSemRel x a -> StSemRel y b ->
                            forall (comm : IsCommutative a) (sel : IsSelective a) (B_comm : IsCommutative b),
                            StSemRel (stSelLex x y) (selLexSemigroupTransform a b comm sel)
      | stsrUnion         : forall x a y b, StSemRel x a -> StSemRel y b -> forall (iso : IdSmgIso a b), StSemRel (stUnion x y) (unionSemigroupTransform a b iso)
      | stsrCayley        : forall x a, BsSemRel x a -> StSemRel (stCayley x) (cayleyMapSemigroupTransform a).

   Local Notation "'big_pair'" := (pair7_90).

   Scheme DsSemRel_rect2 :=
      Induction for DsSemRel Sort Type
   with SgSemRel_rect2 :=
      Induction for SgSemRel Sort Type
   with PoSemRel_rect2 :=
      Induction for PoSemRel Sort Type
   with OsSemRel_rect2 :=
      Induction for OsSemRel Sort Type
   with BsSemRel_rect2 :=
      Induction for BsSemRel Sort Type
   with TfSemRel_rect2 :=
      Induction for TfSemRel Sort Type
   with StSemRel_rect2 :=
      Induction for StSemRel Sort Type.

   Definition SemRel_rect
      (ds_spec : forall x a, DsSemRel x a -> Type)
      (sg_spec : forall x a, SgSemRel x a -> Type)
      (po_spec : forall x a, PoSemRel x a -> Type)
      (os_spec : forall x a, OsSemRel x a -> Type)
      (bs_spec : forall x a, BsSemRel x a -> Type) 
      (tf_spec : forall x a, TfSemRel x a -> Type) 
      (st_spec : forall x a, StSemRel x a -> Type) :=
   big_pair
     (DsSemRel_rect2 ds_spec sg_spec po_spec os_spec bs_spec tf_spec st_spec)
     (SgSemRel_rect2 ds_spec sg_spec po_spec os_spec bs_spec tf_spec st_spec)
     (PoSemRel_rect2 ds_spec sg_spec po_spec os_spec bs_spec tf_spec st_spec)
     (OsSemRel_rect2 ds_spec sg_spec po_spec os_spec bs_spec tf_spec st_spec)
     (BsSemRel_rect2 ds_spec sg_spec po_spec os_spec bs_spec tf_spec st_spec)
     (TfSemRel_rect2 ds_spec sg_spec po_spec os_spec bs_spec tf_spec st_spec)
     (StSemRel_rect2 ds_spec sg_spec po_spec os_spec bs_spec tf_spec st_spec).

   Scheme DsSemRel_ind2 :=
      Induction for DsSemRel Sort Prop
   with SgSemRel_ind2 :=
      Induction for SgSemRel Sort Prop
   with PoSemRel_ind2 :=
      Induction for PoSemRel Sort Prop
   with OsSemRel_ind2 :=
      Induction for OsSemRel Sort Prop
   with BsSemRel_ind2 :=
      Induction for BsSemRel Sort Prop
   with TfSemRel_ind2 :=
      Induction for TfSemRel Sort Prop
   with StSemRel_ind2 :=
      Induction for StSemRel Sort Prop.

   Definition SemRel_ind
      (ds_spec : forall x a, DsSemRel x a -> Prop)
      (sg_spec : forall x a, SgSemRel x a -> Prop)
      (po_spec : forall x a, PoSemRel x a -> Prop)
      (os_spec : forall x a, OsSemRel x a -> Prop)
      (bs_spec : forall x a, BsSemRel x a -> Prop) 
      (tf_spec : forall x a, TfSemRel x a -> Prop) 
      (st_spec : forall x a, StSemRel x a -> Prop) :=
   big_pair
     (DsSemRel_ind2 ds_spec sg_spec po_spec os_spec bs_spec tf_spec st_spec)
     (SgSemRel_ind2 ds_spec sg_spec po_spec os_spec bs_spec tf_spec st_spec)
     (PoSemRel_ind2 ds_spec sg_spec po_spec os_spec bs_spec tf_spec st_spec)
     (OsSemRel_ind2 ds_spec sg_spec po_spec os_spec bs_spec tf_spec st_spec)
     (BsSemRel_ind2 ds_spec sg_spec po_spec os_spec bs_spec tf_spec st_spec)
     (TfSemRel_ind2 ds_spec sg_spec po_spec os_spec bs_spec tf_spec st_spec)
     (StSemRel_ind2 ds_spec sg_spec po_spec os_spec bs_spec tf_spec st_spec).

     
   (**********************************************)
   (* Check that semantics preserves projections *)
   (**********************************************)

   Close Scope nat_scope.

   (*       Syntax_proj
        x   ---------->  x'
        |                |
        |                |
        a --------> a0 ~ a'
            proj     id arrow
   *)
   
   Definition semRel_pres_proj :
      (forall x a, DsSemRel x a -> True) *
      (forall x a, SgSemRel x a -> Exists a', DsSemRel (SG_DS x) a' * IdDsIso a a') *
      (forall x a, PoSemRel x a -> Exists a', DsSemRel (PO_DS x) a' * IdDsIso a a') *
      (forall x a, OsSemRel x a -> ( (Exists a', SgSemRel (OS_SG x) a' * IdSmgIso a a')
                                   * (Exists a', PoSemRel (OS_PO x) a' * IdProIso a a') ) ) *
      (forall x a, BsSemRel x a -> ( (Exists a', SgSemRel (BS_SG_plus x) a' * IdSmgIso (plusSmg a) a')
                                   * (Exists a', SgSemRel (BS_SG_times x) a' * IdSmgIso (timesSmg a) a') ) ) *
      (forall x a, TfSemRel x a -> ( (Exists a', DsSemRel (TF_DS x) a' * IdDsIso a a')
	                           * (Exists a', DsSemRel (fn_TF_DS x) a' * IdDsIso (Transform.fn a) a' ) ) )*
      (forall x a, StSemRel x a -> ( (Exists a', SgSemRel (ST_SG x) a' * IdSmgIso a a')
                                   * (Exists a', TfSemRel (ST_TF x) a' * IdTfIso a a') ) ).
      apply SemRel_rect;
      intros; auto;
      try match goal with
      | |- _ * _ => split; auto
      end.


      (*****************************************)
      (*              DecSetoids               *)
      (*****************************************)
      
      (* all trivial *)
      
      (*****************************************)
      (*              Semigroups               *)
      (*****************************************)
      
      (* unit *)
      esplit; split; [ apply dsrUnit | auto ].
      (* bool and *)
      esplit; split; [ apply dsrBool | auto ].
      (* bool or *)
      esplit; split; [ apply dsrBool | auto ].
      (* nat max *)
      esplit; split; [ apply dsrNat | auto ].
      (* nat min *)
      esplit; split; [ apply dsrNat | auto ].
      (* nat plus *)
      esplit; split; [ apply dsrNat | auto ].
      (* range max *)
      esplit; split; [ apply (dsrRange n) | auto ].
      (* range min *)
      esplit; split; [ apply (dsrRange n) | auto ].
      (* range plus *)
      esplit; split; [ apply (dsrRange n) | auto ].
      (* fsets intersect *)
      esplit; split; [ apply (dsrFSets _ _ d) | auto ].
      (* fsets union *)
      esplit; split; [ apply (dsrFSets _ _ d) | auto ].
      (* fsets op *)
      destruct X as [a' [p q]]; esplit; split; simpl; 
      [ apply (dsrFSets _ _ p) | apply DecSetoids.FSets.idPres; auto ].
      (* mset union *)
      esplit; split; simpl; [ apply (dsrFMinSets _ _ p) | auto ].
      (* left *)
      esplit; split; simpl; [ apply d | auto ].
      (* right *)
      esplit; split; simpl; [ apply d | auto ].
      (* seq *)
      esplit; split; simpl; [ apply (dsrSeq _ _ d) | auto ].
      (* prefix *)
      esplit; split; simpl; [ apply (dsrSeq _ _ d) | auto ].      
      (* postfix *)
      esplit; split; simpl; [ apply (dsrSeq _ _ d) | auto ].
      (* simple seq *)
      esplit; split; simpl; [ apply (dsrSimpleSeq _ _ d) | auto ].
      (* mset op *)
      destruct X as [_ [a' [p q]]].
      esplit; split; simpl; [ apply (dsrFMinSets _ _ p) | apply DecSetoids.FMinSets.idPres; auto ].
      (* prod *)
      destruct X as [a1 [p1 q1]];
      destruct X0 as [a2 [p2 q2]];
      esplit; split; simpl in *; [ apply (dsrProduct _ _ _ _ p1 p2) | apply DecSetoids.Product.idPres; auto ].
      (* top union *)
      destruct X as [a1 [p1 q1]];
      destruct X0 as [a2 [p2 q2]];
      esplit; split; simpl in *;
      [ apply (dsrUnion _ _ _ _ (dsrUnion _ _ _ _ p1 p2) dsrUnit)
      | apply DecSetoids.Union.idPres; auto;
        apply DecSetoids.Union.idPres; auto ].
      (* union *)
      destruct X as [a1 [p1 q1]];
      destruct X0 as [a2 [p2 q2]];
      esplit; split; simpl in *; [ apply (dsrUnion _ _ _ _ p1 p2) | apply DecSetoids.Union.idPres; auto ].
      (* union swap *)
      destruct X as [a1 [p1 q1]];
      destruct X0 as [a2 [p2 q2]];
      esplit; split; simpl in *; [ apply (dsrUnion _ _ _ _ p2 p1) | apply DecSetoids.Union.idPres; auto ].
      (* lex *)
      destruct X as [a1 [p1 q1]];
      destruct X0 as [a2 [p2 q2]];
      esplit; split; simpl in *; [ apply (dsrProduct _ _ _ _ p1 p2) | apply DecSetoids.Product.idPres; auto ].
      (* selective lex *)
      destruct X as [a1 [p1 q1]];
      destruct X0 as [a2 [p2 q2]];
      esplit; split; simpl in *; [ apply (dsrProduct _ _ _ _ p1 p2) | apply DecSetoids.Product.idPres; auto ].
      (* multisets union *)
      esplit; split; simpl; [ apply (dsrMultiSets _ _ d) | auto ].
      (* multisets intersection *)
      esplit; split; simpl; [ apply (dsrMultiSets _ _ d) | auto ].

      (*****************************************)
      (*               Preorders               *)
      (*****************************************)
      
      (* nat le *)
      esplit; split; [ apply dsrNat | auto ].      
      (* lex *)
      destruct X as [a1 [p1 q1]];
      destruct X0 as [a2 [p2 q2]];
      esplit; split; simpl in *; [ apply (dsrProduct _ _ _ _ p1 p2) | apply DecSetoids.Product.idPres; auto ].

      (*****************************************)
      (*            OrderSemigroups            *)
      (*****************************************)
      
      (* dual *)
      destruct X as [[a1 [p1 q1]] _]; esplit; split; simpl in *;
      [ apply p1 | eapply IdSmgIso_trans; [ apply glueOSmg_IdSmgIso | auto ] ].

      destruct X as [_ [a1 [p1 q1]]]; esplit; split; simpl in *;
      [ apply (psrDual _ _ p1)
      | eapply IdProIso_trans; [ apply glueOSmg_IdProIso | apply Preorders.Dual.idPres; auto ]].
      (* left natural order *)
      destruct X as [a1 [p1 q1]]; esplit; split; simpl in *; [ apply s | apply glueOSmg_IdSmgIso ].

      destruct X as [a1 [p1 q1]]; esplit; split; simpl in *; [ apply (psrLeftNaturalOrder _ _ s idem) | apply glueOSmg_IdProIso ].
      (* right natural order *)
      destruct X as [a1 [p1 q1]]; esplit; split; simpl in *; [ apply s | apply glueOSmg_IdSmgIso ].

      destruct X as [a1 [p1 q1]]; esplit; split; simpl in *; [ apply (psrRightNaturalOrder _ _ s idem) | apply glueOSmg_IdProIso ].
      (* lex *)
      destruct X as [[a1 [p1 q1]] _]; destruct X0 as [[a2 [p2 q2]] _];
      esplit; split; simpl in *; [ apply (ssrProduct _ _ _ _ p1 p2) |];
      eapply IdSmgIso_trans; [ apply glueOSmg_IdSmgIso | apply Semigroups.Product.idPres; auto ].

      destruct X as [_ [a1 [p1 q1]]]; destruct X0 as [_ [a2 [p2 q2]]];
      esplit; split; simpl in *; [ apply (psrLex _ _ _ _ p1 p2) |].
      eapply IdProIso_trans; [ apply glueOSmg_IdProIso | apply Preorders.Lex.idPres; auto ].

      (* bs left natural order *)
      destruct X as [a1 [p1 [q1 q2]]]; esplit; split; simpl in *.
      apply q1.
      eapply IdSmgIso_trans; [ apply glueOSmg_IdSmgIso | apply q2]; auto.

      simpl.
      destruct X as [[a' [p1 p2]] q].
      esplit; split.
      eapply (psrLeftNaturalOrder _ _ p1 (Iso_IsIdempotent p2 idem)).
      eapply IdProIso_trans; [ apply glueOSmg_IdProIso | apply Preorders.LeftNaturalOrder.idPres]; auto.

      (* simple seq *)
      esplit; split; [ apply (ssrSimpleSeq _ _ d) | auto ].
      
      esplit; split; [ apply (psrAnnTop _ _ (ssrSimpleSeq _ _ d) (Semigroups.SimpleSeq.hasAnnihilator a)) | auto ].

      (*****************************************)
      (*              Bisemigroups             *)
      (*****************************************)

      (* unit *)
      esplit; split; [ apply ssrUnit | auto ].

      esplit; split; [ apply ssrUnit | auto ].
      (* bool or and *)
      esplit; split; [ apply ssrBoolOr | auto ].

      esplit; split; [ apply ssrBoolAnd | auto ].
      (* nat max plus *)
      esplit; split; [ apply ssrNatMax | auto ].

      esplit; split; [ apply ssrNatPlus | auto ].
      (* nat min plus *)
      esplit; split; [ apply ssrNatMin | auto ].

      esplit; split; [ apply ssrNatPlus | auto ].
      (* nat max min *)
      esplit; split; [ apply ssrNatMax | auto ].

      esplit; split; [ apply ssrNatMin | auto ].
      (* natI max plus *)
      esplit; split; simpl; [ apply (ssrUnion _ _ _ _ ssrUnit ssrNatMax) | auto ].

      esplit; split; simpl; [ apply (ssrUnion _ _ _ _ ssrUnit ssrNatPlus) | auto ].
      (* natI min plus *)
      esplit; split; simpl; [ apply (ssrUnionSwap _ _ _ _ ssrNatMin ssrUnit) | auto ].

      esplit; split; simpl; [ apply (ssrUnion _ _ _ _ ssrUnit ssrNatPlus) | auto ].
      (* natI max min *)
      esplit; split; simpl; [ apply (ssrUnion _ _ _ _ ssrUnit ssrNatMax) | auto ].

      esplit; split; simpl; [ apply (ssrUnionSwap _ _ _ _ ssrNatMin ssrUnit) | auto ].
      (* range max plus *)
      esplit; split; simpl; [ apply (ssrRangeMax n) | auto ].

      esplit; split; simpl; [ apply (ssrRangePlus n) | auto ].
      (* range min plus *)
      esplit; split; simpl; [ apply (ssrRangeMin n) | auto ].

      esplit; split; simpl; [ apply (ssrRangePlus n) | auto ].
      (* range max min *)
      esplit; split; simpl; [ apply (ssrRangeMax n) | auto ].

      esplit; split; simpl; [ apply (ssrRangeMin n) | auto ].
      (* swap *)
      destruct X as [_ [a1 [p1 q1]]]; esplit; split; simpl; [ apply p1 | ];
      eapply IdSmgIso_trans; [ apply glueBSmg_IdSmgIso_plus | auto ].

      destruct X as [[a1 [p1 q1]] _]; esplit; split; simpl; [ apply p1 | ];
      eapply IdSmgIso_trans; [ apply glueBSmg_IdSmgIso_times | auto ].

      (* minsets *)
      destruct X as [_ [a1 [p1 q1]]]; esplit; split; simpl; [ apply (ssrFMinSetsUnion _ _ p1) | ].
      eapply IdSmgIso_trans; [ apply glueBSmg_IdSmgIso_plus | apply Semigroups.FMinSetsUnion.idPres; auto ].

      esplit; split; simpl; [ apply (ssrFMinSetsOp _ _ o) | ];
      eapply IdSmgIso_trans; [ apply glueBSmg_IdSmgIso_times | auto ].
      
      (* minsets op union *)
      esplit; split; simpl; [ apply (ssrFMinSetsOp _ _ o) | ];
      eapply IdSmgIso_trans; [ apply glueBSmg_IdSmgIso_plus | auto ].

      destruct X as [_ [a1 [p1 q1]]]; esplit; split; simpl; [ apply (ssrFMinSetsUnion _ _ p1) | ].
      eapply IdSmgIso_trans; [ apply glueBSmg_IdSmgIso_times | apply Semigroups.FMinSetsUnion.idPres; auto ].

      (* fsets *)
      esplit; split; simpl; [ apply (ssrFSetsUnion _ _ d) | ];
      eapply IdSmgIso_trans; [ apply glueBSmg_IdSmgIso_plus | apply Semigroups.FSetsUnion.idPres; auto ].

      esplit; split; simpl; [ apply (ssrFSetsIntersect _ _ d) | ];
      eapply IdSmgIso_trans; [ apply glueBSmg_IdSmgIso_times | auto ].

      (* fsets op *)
      destruct X as [a1 [p1 q1]]; esplit; split; simpl; [ apply (ssrFSetsUnion _ _ p1) | ];
      eapply IdSmgIso_trans; [ apply glueBSmg_IdSmgIso_plus | apply Semigroups.FSetsUnion.idPres; auto ].

      esplit; split; simpl; [ apply (ssrFSetsOp _ _ s) | ];
      eapply IdSmgIso_trans; [ apply glueBSmg_IdSmgIso_times | auto ].

      (* left *)
      esplit; split; simpl; [ apply s | ];
      eapply IdSmgIso_trans; [ apply glueBSmg_IdSmgIso_plus | auto ].

      destruct X as [a1 [p1 q1]];  esplit; split; simpl; [ apply (ssrLeft _ _ p1) | ];
      eapply IdSmgIso_trans; [ apply glueBSmg_IdSmgIso_times | apply Semigroups.Left.idPres; auto ].

      (* add zero *)
      destruct X as [[a1 [p1 q1]] _]; esplit; split; simpl; [ apply (ssrUnion _ _ _ _ p1 ssrUnit) | ];
      eapply IdSmgIso_trans; [ apply glueBSmg_IdSmgIso_plus | apply Semigroups.Union.idPres; auto ].

      destruct X as [_ [a1 [p1 q1]]];  esplit; split; simpl; [ apply (ssrUnionSwap _ _ _ _ ssrUnit p1) | ];
      eapply IdSmgIso_trans; [ apply glueBSmg_IdSmgIso_times | apply Semigroups.UnionSwap.idPres; auto ].

      (* add one *)
      destruct X as [[a1 [p1 q1]] _]; esplit; split; simpl; [ apply (ssrUnion _ _ _ _ ssrUnit p1) | ];
      eapply IdSmgIso_trans; [ apply glueBSmg_IdSmgIso_plus | apply Semigroups.Union.idPres; auto ].

      destruct X as [_ [a1 [p1 q1]]];  esplit; split; simpl; [ apply (ssrUnionSwap _ _ _ _ p1 ssrUnit) | ];
      eapply IdSmgIso_trans; [ apply glueBSmg_IdSmgIso_times | apply Semigroups.UnionSwap.idPres; auto ].

      (* prod *)
      destruct X as [[a1 [p1 q1]] _]; destruct X0 as [[a2 [p2 q2]] _];
      esplit; split; simpl; [ apply (ssrProduct _ _ _ _ p1 p2) | ];
      eapply IdSmgIso_trans; [ apply glueBSmg_IdSmgIso_plus | apply Semigroups.Product.idPres; auto ].

      destruct X as [_ [a1 [p1 q1]]]; destruct X0 as [_ [a2 [p2 q2]]];
      esplit; split; simpl; [ apply (ssrProduct _ _ _ _ p1 p2) | ];
      eapply IdSmgIso_trans; [ apply glueBSmg_IdSmgIso_times | apply Semigroups.Product.idPres; auto ].

      (* lex *)
      destruct X as [[a1 [p1 q1]] _]; destruct X0 as [[a2 [p2 q2]] _];
      esplit; split; simpl; [ apply (ssrLex _ _ _ _ p1 p2 (Iso_IsCommutative q1 comm) (Iso_IsIdempotent q1 idem) (Iso_HasIdentity q2 hasId)) | ];
      eapply IdSmgIso_trans; [ apply glueBSmg_IdSmgIso_plus | apply Semigroups.Lex.idPres; auto ].

      destruct X as [_ [a1 [p1 q1]]]; destruct X0 as [_ [a2 [p2 q2]]];
      esplit; split; simpl; [ apply (ssrProduct _ _ _ _ p1 p2) | ];
      eapply IdSmgIso_trans; [ apply glueBSmg_IdSmgIso_times | apply Semigroups.Product.idPres; auto ].

      (* selective lex *)
      destruct X as [[a1 [p1 q1]] _]; destruct X0 as [[a2 [p2 q2]] _];
      esplit; split; simpl; [ apply (ssrSelLex _ _ _ _ p1 p2 (Iso_IsCommutative q1 comm) (Iso_IsSelective q1 sel)) | ];
      eapply IdSmgIso_trans; [ apply glueBSmg_IdSmgIso_plus | apply Semigroups.SelLex.idPres; auto ].

      destruct X as [_ [a1 [p1 q1]]]; destruct X0 as [_ [a2 [p2 q2]]];
      esplit; split; simpl; [ apply (ssrProduct _ _ _ _ p1 p2) | ];
      eapply IdSmgIso_trans; [ apply glueBSmg_IdSmgIso_times | apply Semigroups.Product.idPres; auto ].
      
      (* bRevTimes *)
      simpl. destruct X as [X _]; apply X.

      destruct X as [_ [a1 [p1 q1]]];  esplit; split; simpl; [ apply (ssrRevOp _ _ p1) |  ];
      eapply IdSmgIso_trans; [ apply glueBSmg_IdSmgIso_times | apply Semigroups.RevOp.idPres; auto ].
      
      (* prefix seq *)
      esplit; split; simpl; [ apply (ssrPrefix _ _ d) | ];
      eapply IdSmgIso_trans; [ apply glueBSmg_IdSmgIso_plus | apply Semigroups.Prefix.idPres; auto ].

      esplit; split; simpl; [ apply (ssrSeq _ _ d) | ];
      eapply IdSmgIso_trans; [ apply glueBSmg_IdSmgIso_times | apply Semigroups.Seq.idPres; auto ].

      (* postfix seq *)
      esplit; split; simpl; [ apply (ssrPostfix _ _ d) | ];
      eapply IdSmgIso_trans; [ apply glueBSmg_IdSmgIso_plus | apply Semigroups.Postfix.idPres; auto ].

      esplit; split; simpl; [ apply (ssrSeq _ _ d) | ];
      eapply IdSmgIso_trans; [ apply glueBSmg_IdSmgIso_times | apply Semigroups.Seq.idPres; auto ].      

      (* multisets *)
      esplit; split; simpl; [ apply (ssrMultiSetsIntersect _ _ d) | ];
      eapply IdSmgIso_trans; [ apply glueBSmg_IdSmgIso_plus | apply Semigroups.MultiSetsIntersection.idPres; auto ].

      esplit; split; simpl; [ apply (ssrMultiSetsUnion _ _ d) | ];
      eapply IdSmgIso_trans; [ apply glueBSmg_IdSmgIso_times | apply Semigroups.MultiSetsUnion.idPres; auto ].      
      
      (*****************************************)
      (*              Transforms               *)
      (*****************************************)
      
      (* id *)
      esplit; split; simpl; [ apply d | auto ].

      esplit; split; simpl; [ apply dsrUnit | auto ].

      (* replace *)
      esplit; split; simpl; [ apply d | auto ].

      esplit; split; simpl; [ apply d | auto ].

      (* prod *)
      destruct X as [[a1 [p1 q1]] _]; destruct X0 as [[a2 [p2 q2]] _];
      esplit; split; simpl; [ apply (dsrProduct _ _ _ _ p1 p2) | apply DecSetoids.Product.idPres; auto ].

      destruct X as [_ [a1 [p1 q1]]]; destruct X0 as [_ [a2 [p2 q2]]];
      esplit; split; simpl; [ apply (dsrProduct _ _ _ _ p1 p2) | apply DecSetoids.Product.idPres; auto ].

      (* union *)
      destruct X as [[a1 [p1 q1]] _]; destruct X0 as [[a2 [p2 q2]] _];
      esplit; split; simpl; [ apply p1 |];
      destruct a; destruct b; destruct setoid; destruct setoid0; simpl; apply q1.
      
      destruct X as [_ [a1 [p1 q1]]]; destruct X0 as [_ [a2 [p2 q2]]];
      esplit; split; simpl; [ apply (dsrUnion _ _ _ _ p1 p2) |];
      destruct a; destruct b; destruct setoid; destruct setoid0; simpl;
      apply DecSetoids.Union.idPres; auto.
      

      (*****************************************)
      (*         SemigroupTransforms           *)
      (*****************************************)

      (* left *)
      destruct X as [a1 [p1 q1]]; esplit; split; simpl; [ apply s | apply glueSTf_DsEq_IdSmgIso ].

      destruct X as [a1 [p1 q1]]; esplit; split; simpl; [ apply (tsrReplace _ _ p1) |];
      eapply IdTfIso_trans; [ apply glueSTf_DsEq_IdTfIso | apply Transforms.Replace.idPres; auto ].

      (* right *)
      destruct X as [a1 [p1 q1]]; esplit; split; simpl; [ apply s | apply glueSTf_DsEq_IdSmgIso ].

      destruct X as [a1 [p1 q1]]; esplit; split; simpl; [ apply (tsrId _ _ p1) |];
      eapply IdTfIso_trans; [ apply glueSTf_DsEq_IdTfIso | apply Transforms.Id.idPres; auto ].

      (* lex *)
      destruct X as [[a1 [p1 q1]] _]; destruct X0 as [[a2 [p2 q2]] _]; 
      esplit; split; simpl; [ apply (ssrLex _ _ _ _ p1 p2 (Iso_IsCommutative q1 comm) (Iso_IsIdempotent q1 idem) (Iso_HasIdentity q2 hasId)) | ].
      eapply IdSmgIso_trans; [ apply glueSTf_DsEq_IdSmgIso | apply Semigroups.Lex.idPres; auto ].

      destruct X as [_ [a1 [p1 q1]]]; destruct X0 as [_ [a2 [p2 q2]]]; 
      esplit; split; simpl; [ apply (tsrProduct _ _ _ _ p1 p2) |];
      eapply IdTfIso_trans; [ apply glueSTf_DsEq_IdTfIso | apply Transforms.Product.idPres; auto ].
      (* selective lex *)
      destruct X as [[a1 [p1 q1]] _]; destruct X0 as [[a2 [p2 q2]] _]; 
      esplit; split; simpl; [ apply (ssrSelLex _ _ _ _ p1 p2 (Iso_IsCommutative q1 comm) (Iso_IsSelective q1 sel)) | ].
      eapply IdSmgIso_trans; [ apply glueSTf_DsEq_IdSmgIso | apply Semigroups.SelLex.idPres; auto ].

      destruct X as [_ [a1 [p1 q1]]]; destruct X0 as [_ [a2 [p2 q2]]]; 
      esplit; split; simpl; [ apply (tsrProduct _ _ _ _ p1 p2) |];
      eapply IdTfIso_trans; [ apply glueSTf_DsEq_IdTfIso | apply Transforms.Product.idPres; auto ].      

      (* union *)
      destruct X as [[a1 [p1 q1]] _]; destruct X0 as [[a2 [p2 q2]] _]; 
      esplit; split; simpl; [ apply p1 | ];
      eapply IdSmgIso_trans; [ apply unionSTf_proj1 | auto ].

      destruct X as [_ [a1 [p1 q1]]]; destruct X0 as [_ [a2 [p2 q2]]].
      assert (iso' := IdDsIso_trans (IdDsIso_trans
                     (IdDsIso_sym (IdTfIso__IdDsIso q1))
                     (IdSmgIso__IdDsIso iso))
                     (IdTfIso__IdDsIso q2)).
      split with (unionTransform a1 a2 iso'); split; simpl.  
      apply (tsrUnion _ _ _ _ p1 p2 iso').
      eapply IdTfIso_trans; [ apply unionSTf_proj2 | apply Transforms.Union.idPres; auto ].

      (* cayley *)
      destruct X as [[a1 [p1 q1]] _]; esplit; split; simpl; [ apply p1 | ];
      eapply IdSmgIso_trans; [ apply glueSTf_DsEq_IdSmgIso | auto ].

      destruct X as [_ [a1 [p1 q1]]]; esplit; split; simpl; [ apply (tsrCayley _ _ p1) | ].
      eapply IdTfIso_trans; [ apply glueSTf_DsEq_IdTfIso | apply Transforms.Cayley.idPres; auto ].
   Defined.
   
   Definition semRel_SG_DS := snd (fst (fst (fst (fst (fst (semRel_pres_proj)))))).
   Definition semRel_PO_DS := snd (fst (fst (fst (fst (semRel_pres_proj))))).
   Definition semRel_OS_SG := fun x a r => fst (snd (fst (fst (fst (semRel_pres_proj)))) x a r).
   Definition semRel_OS_PO := fun x a r => snd (snd (fst (fst (fst (semRel_pres_proj)))) x a r).
   Definition semRel_BS_SG_plus := fun x a r => fst (snd (fst (fst (semRel_pres_proj))) x a r).
   Definition semRel_BS_SG_times := fun x a r => snd (snd (fst (fst (semRel_pres_proj))) x a r).
   Definition semRel_TF_DS := fun x a r => fst (snd (fst (semRel_pres_proj)) x a r).
   Definition semRel_fn_TF_DS := fun x a r => snd (snd (fst (semRel_pres_proj)) x a r).
   Definition semRel_ST_SG := fun x a r => fst (snd (semRel_pres_proj) x a r).
   Definition semRel_ST_TF := fun x a r => snd (snd (semRel_pres_proj) x a r).
   
   Definition findIdIso : 
      (forall x a (p : DsSemRel x a) y b (q : DsSemRel y b) (e : eq_DS x y), IdDsIso a b) *
      (forall x a (p : SgSemRel x a) y b (q : SgSemRel y b) (e : eq_SG x y), IdSmgIso a b) *
      (forall x a (p : PoSemRel x a) y b (q : PoSemRel y b) (e : eq_PO x y), IdProIso a b) *
      (forall x a (p : OsSemRel x a) y b (q : OsSemRel y b) (e : eq_OS x y), IdOSmgIso a b) *
      (forall x a (p : BsSemRel x a) y b (q : BsSemRel y b) (e : eq_BS x y), IdBSmgIso a b) *
      (forall x a (p : TfSemRel x a) y b (q : TfSemRel y b) (e : eq_TF x y), IdTfIso a b) *
      (forall x a (p : StSemRel x a) y b (q : StSemRel y b) (e : eq_ST x y), IdSTfIso a b).
      apply SemRel_rect;
      intros; try (destruct q; try discriminate; auto);
      let t := type of e in 
      match t with
         | bool_to_Prop (eq_DS _ _) => injection (eq_DS_correct _ _ e)
         | bool_to_Prop (eq_SG _ _) => injection (eq_SG_correct _ _ e)
         | bool_to_Prop (eq_PO _ _) => injection (eq_PO_correct _ _ e)
         | bool_to_Prop (eq_OS _ _) => injection (eq_OS_correct _ _ e)
         | bool_to_Prop (eq_BS _ _) => injection (eq_BS_correct _ _ e)
         | bool_to_Prop (eq_TF _ _) => injection (eq_TF_correct _ _ e)
         | bool_to_Prop (eq_ST _ _) => injection (eq_ST_correct _ _ e)
      end;
      repeat match goal with
         |- (_ = _) -> _ => let w := fresh "w" in intros w; rewrite w in *
      end; auto.

      (*****************************************)
      (*              DecSetoids               *)
      (*****************************************)

      (* add const *)
      apply DecSetoids.Union.idPres; eauto.
      (* fset *)
      apply DecSetoids.FSets.idPres; eauto.
      (* mset *)
      apply DecSetoids.FMinSets.idPres; eauto.
      (* seq *)
      apply DecSetoids.Seq.idPres; eauto.
      (* simple seq *)
      apply DecSetoids.SimpleSeq.idPres; eauto.
      (* prod *)
      apply DecSetoids.Product.idPres; eauto.
      (* union *)
      apply DecSetoids.Union.idPres; eauto.
      (* multisets *)
      apply DecSetoids.MultiSets.idPres; eauto.

      (*****************************************)
      (*              Semigroups               *)
      (*****************************************)
      
      (* fset intersect *)
      apply Semigroups.FSetsIntersect.idPres; eauto.
      (* fset union *)
      apply Semigroups.FSetsUnion.idPres; eauto.
      (* fset op *)
      apply Semigroups.FSetOp.idPres; eauto.
      (* mset union *)
      apply Semigroups.FMinSetsUnion.idPres; eauto.
      (* left *)
      apply Semigroups.Left.idPres; eauto.
      (* right *)
      apply Semigroups.Right.idPres; eauto.	
      (* seq *)
      apply Semigroups.Seq.idPres; eauto.
      (* prefix *)
      apply Semigroups.Prefix.idPres; eauto.
      (* postfix *)
      apply Semigroups.Postfix.idPres; eauto.
      (* simple seq *)
      apply Semigroups.SimpleSeq.idPres; eauto.
      (* mset op *)
      apply Semigroups.FMinSetsOp.idPres; eauto.
      (* prod *)
      apply Semigroups.Product.idPres; eauto.
      (* top union *)
      apply Semigroups.TopUnion.idPres; eauto.
      (* union *)
      apply Semigroups.Union.idPres; eauto.
      (* union swap *)
      apply Semigroups.UnionSwap.idPres; eauto.
      (* lex *)
      apply Semigroups.Lex.idPres; eauto.
      (* selective lex *)
      apply Semigroups.SelLex.idPres; eauto.
      (* rev op *)
      apply Semigroups.RevOp.idPres; eauto.
      (* multisets union *)
      apply Semigroups.MultiSetsUnion.idPres; eauto.
      (* multisets intersection *)
      apply Semigroups.MultiSetsIntersection.idPres; eauto.
      
      (*****************************************)
      (*               Preorders               *)
      (*****************************************)
      
      (* dual *)
      apply Preorders.Dual.idPres; eauto.
      (* left natural order *)
      apply Preorders.LeftNaturalOrder.idPres; eauto.
      (* right natural order *)
      apply Preorders.RightNaturalOrder.idPres; eauto.
      (* lex *)
      apply Preorders.Lex.idPres; eauto.
      (* ann top *)
      apply Preorders.AnnTop.idPres; eauto.

      (*****************************************)
      (*            OrderSemigroups            *)
      (*****************************************)
      
      (* dual *)
      apply OrderSemigroups.Dual.idPres; eauto.
      (* left natural order *)
      apply OrderSemigroups.LeftNaturalOrder.idPres; eauto.
      (* right natural order *)
      apply OrderSemigroups.RightNaturalOrder.idPres; eauto.
      (* lex *)
      apply OrderSemigroups.Lex.idPres; eauto.
      (* bs left natural order *)
      apply OrderSemigroups.BSLeftNaturalOrder.idPres; eauto.
      (* simple seq *)
      apply OrderSemigroups.SimpleSeq.idPres; eauto.

      (*****************************************)
      (*              Bisemigroups             *)
      (*****************************************)
      
      (* swap *)
      apply Bisemigroups.Swap.idPres; eauto.
      (* minset *)
      apply Bisemigroups.FMinSets.idPres; eauto.
      (* minset op union *)
      apply Bisemigroups.FMinSetsOpUnion.idPres; eauto.
      (* fset *)
      apply Bisemigroups.FSets.idPres; eauto.
      (* fset op *)
      apply Bisemigroups.FSetsOp.idPres; eauto.
      (* left *)
      apply Bisemigroups.Left.idPres; eauto.
      (* add zero *)
      apply Bisemigroups.AddZero.idPres; eauto.
      (* add one *)
      apply Bisemigroups.AddOne.idPres; eauto.
      (* prod *)
      apply Bisemigroups.Product.idPres; eauto.
      (* lex *)
      apply Bisemigroups.Lex.idPres; eauto.
      (* selective lex *)
      apply Bisemigroups.SelLex.idPres; eauto.
      (* rev times *)
      apply Bisemigroups.RevTimes.idPres; eauto.
      (* prefix seq *)
      apply Bisemigroups.PrefixSeq.idPres; eauto.
      (* postfix seq *)
      apply Bisemigroups.PostfixSeq.idPres; eauto.
      (* multisets *)
      apply Bisemigroups.MultiSets.idPres; eauto.

      (*****************************************)
      (*              Transforms               *)
      (*****************************************)
      
      (* id *)
      apply Transforms.Id.idPres; eauto.
      (* replace *)
      apply Transforms.Replace.idPres; eauto.
      (* prod *)
      apply Transforms.Product.idPres; eauto.
      (* union *)
      apply Transforms.Union.idPres; eauto.
      (* cayley *)
      apply Transforms.Cayley.idPres; eauto.

      (*****************************************)
      (*         SemigroupTransforms           *)
      (*****************************************)
      
      (* left *)
      apply SemigroupTransforms.Left.idPres; eauto.
      (* right *)
      apply SemigroupTransforms.Right.idPres; eauto.
      (* lex *)
      apply SemigroupTransforms.Lex.idPres; eauto.
      (* selective lex *)
      apply SemigroupTransforms.SelLex.idPres; eauto.
      (* union *)
      apply SemigroupTransforms.Union.idPres; eauto.
      (* cayley *)
      apply SemigroupTransforms.Cayley.idPres; eauto.
   Defined.

   Definition findIdDsIso := fst (fst (fst (fst (fst (fst findIdIso))))).
   Definition findIdSgIso := snd (fst (fst (fst (fst (fst findIdIso))))).
   Definition findIdPoIso := snd (fst (fst (fst (fst findIdIso)))).
   Definition findIdOsIso := snd (fst (fst (fst findIdIso))).
   Definition findIdBsIso := snd (fst (fst findIdIso)).
   Definition findIdTfIso := snd (fst findIdIso).
   Definition findIdStIso := snd findIdIso.

   Definition getProof X {A} {P Prf : A -> Type}
                       (prj : forall a', P a' -> option (Prf a'))
                       (errMsg : string)
                       (exp : Lang)
                       {a : A} (p : P a)
                       (f : (Prf a) -> X + NotWF) : X + NotWF :=
      match prj _ p with
         | Some prf => f prf
         | None => notWF exp errMsg
      end.

   Definition getAntisym {X}        := getProof X PreorderPropRecord.antisym              "Not antisymmetric".
   Definition getIsCommutative {X}  := getProof X SemigroupPropRecord.isCommutative       "Not commutative".
   Definition getIsIdempotent {X}   := getProof X SemigroupPropRecord.isIdempotent        "Not idempotent".
   Definition getIsSelective {X}    := getProof X SemigroupPropRecord.isSelective         "Not selective".
   Definition getHasIdentity {X}    := getProof X SemigroupPropRecord.hasIdentity         "Does not have the identity element.".
   Definition getHasAnnihilator {X} := getProof X SemigroupPropRecord.hasAnnihilator      "Does not have the annihilator element.".
   Definition getLeftMonotonic {X}  := getProof X OrderSemigroupPropRecord.leftMonotonic  "Not left monotonic.".
   Definition getRightMonotonic {X} := getProof X OrderSemigroupPropRecord.rightMonotonic "Not right monotonic.".
   Definition getStrict {X}         := getProof X SemigroupTransformPropRecord.strict     "Not strict.".
   Definition getIsLeftDistributive {X}  := getProof X BisemigroupPropRecord.isLeftDistributive  "Not left distributive.".
   Definition getIsRightDistributive {X} := getProof X BisemigroupPropRecord.isRightDistributive "Not right distributive.".

      
   Definition semF :
      (forall (x : DS), (Exists a, (dsProp a * DsSemRel x a)%type) + NotWF) *
      (forall (x : SG), (Exists a, (sgProp a * SgSemRel x a)%type) + NotWF) *
      (forall (x : PO), (Exists a, (poProp a * PoSemRel x a)%type) + NotWF) *
      (forall (x : OS), (Exists a, (osProp a * OsSemRel x a)%type) + NotWF) *
      (forall (x : BS), (Exists a, (bsProp a * BsSemRel x a)%type) + NotWF) *
      (forall (x : TF), (Exists a, (tfProp a * TfSemRel x a)%type) + NotWF) *
      (forall (x : ST), (Exists a, (stProp a * StSemRel x a)%type) + NotWF).
      apply Syntax_rect.
      
      Ltac arg0 prop sr :=
         apply inl; eapply existT; split;
         [| (apply sr)];
         (apply prop); fail.

      Ltac arg1 prop sr :=
         let x := fresh "x" in
         let a := fresh "a" in
         let p := fresh "p" in
         let r := fresh "r" in
         intros x [[a [p r]] | err]; [| apply (inr _ err); fail];
         apply inl; eapply existT; split;
         [| (apply (sr _ _ r))];
         (apply (prop _ p)); fail.

      Ltac arg2 prop sr :=
         let x := fresh "x" in
         let a := fresh "a" in
         let p := fresh "p" in
         let r := fresh "r" in
         let x' := fresh "x" in
         let a' := fresh "a" in
         let p' := fresh "p" in
         let r' := fresh "r" in
         intros x [[a [p r]] | err] x' [[a' [p' r']] | err'];
         [| apply (inr _ err'); fail | apply (inr _ err); fail | apply (inr _ err'); fail ];
         apply inl; eapply existT; split;
         [| (apply (sr _ _ _ _ r r'))];
         (apply (prop _ _ p p')); fail.

      (*****************************************)
      (*              DecSetoids               *)
      (*****************************************)

      (* dAddConstant *)
      arg1 @addConstDecSetoid_props dsrAddConstant.
      (* dBool *)
      arg0 @boolDecSetoid_props dsrBool.
      (* dNat *)
      arg0 @natDecSetoid_props dsrNat.
      (* dProduct *)
      arg2 @prodDecSetoid_props dsrProduct.
      (* dRange *)
      intros n; arg0 (rangeDecSetoid_props n) (dsrRange n).
      (* dUnion *)
      arg2 @unionDecSetoid_props dsrUnion.
      (* dUnit *)
      arg0 @unitDecSetoid_props dsrUnit.
      (* dFSets *)
      arg1 @fsetDecSetoid_props dsrFSets.
      (* dFMinSets *)
      intros x [[a [p r]] | err]; [| apply (inr _ err)];
      apply (getAntisym x _ p); intros asm;
      apply inl; eapply existT; split; 
      [ apply (msetDecSetoid_props asm p) | apply (dsrFMinSets _ _ r) ]; fail.
      (* dSeq *)
      arg1 @seqDecSetoid_props dsrSeq.
      (* dSimpleSeq *)
      arg1 @simpleSeqDecSetoid_props dsrSimpleSeq.
      (* dMultiSets *)
      arg1 @multisetDecSetoid_props dsrMultiSets.

      (*****************************************)
      (*              Semigroups               *)
      (*****************************************)

      (* sBoolAnd *)
      arg0 @boolAndSemigroup_props ssrBoolAnd.
      (* sBoolOr *)
      arg0 @boolOrSemigroup_props ssrBoolOr.
      (* sNatMax *)
      arg0 @natMaxSemigroup_props ssrNatMax.
      (* sNatMin *)
      arg0 @natMinSemigroup_props ssrNatMin.
      (* sNatPlus *)
      arg0 @natPlusSemigroup_props ssrNatPlus.
      (* sLex *)
      intros x [[a [p r]]| err] x' [[a' [p' r']] | err'];
      [| apply (inr _ err') | apply (inr _ err) | apply (inr _ err)];
      apply (getIsCommutative x _ p); intros comm;
      apply (getIsIdempotent x _ p); intros idem;
      apply (getHasIdentity x' _ p'); intros hasId;
      apply inl; eapply existT; split;
      [ apply (lexSemigroup_props comm idem hasId p p')
      | apply (ssrLex _ _ _ _ r r' comm idem hasId) ].
      (* sProduct *)
      arg2 @prodSemigroup_props ssrProduct.
      (* sRangeMax *)
      intros n; arg0 (@rangeMaxSemigroup_props n) (ssrRangeMax n).
      (* sRangeMin *)
      intros n; arg0 (@rangeMinSemigroup_props n) (ssrRangeMin n).
      (* sRangeplus *)
      intros n; arg0 (@rangePlusSemigroup_props n) (ssrRangePlus n).
      (* sTopUnion *)
      arg2 @topUnionSemigroup_props ssrTopUnion.
      (* sUnion *)
      arg2 @unionSemigroup_props ssrUnion.
      (* sUnionSwap *)
      arg2 @unionSwapSemigroup_props ssrUnionSwap.
      (* sUnit *)
      arg0 @unitSemigroup_props ssrUnit.
      (* sFSetsIntersect *)
      arg1 @fsetsIntersectionSemigroup_props ssrFSetsIntersect.
      (* sFSetsUnion *)
      arg1 @fsetsUnionSemigroup_props ssrFSetsUnion.
      (* sFSetsUnion *)
      arg1 @fsetOpSemigroup_props ssrFSetsOp.
      (* sFMinSetsUnion *)
      intros x [[a [p r]]| err]; [| apply (inr _ err)];
      apply (getAntisym x _ p); intros asm;
      apply inl; eapply existT; split;  
      [ apply (msetUnionSemigroup_props asm p)
      | apply (ssrFMinSetsUnion _ _ r) ].
      (* sFMinSetsOp *)
      intros x [[a [p r]]| err]; [| apply (inr _ err)];
      apply (getAntisym x _ p); intros asm;
      apply (getLeftMonotonic x _ p); intros lmon;
      apply (getRightMonotonic x _ p); intros rmon;
      apply inl; eapply existT; split;
      [ apply (msetOpSemigroup_props lmon rmon asm p)
      | apply (ssrFMinSetsOp _ _ r) ].
      (* sLeft *)
      arg1 @leftSemigroup_props ssrLeft.
      (* sRight *)
      arg1 @rightSemigroup_props ssrRight.	
      (* sSelLex *)
      intros x [[a [p r]]| err] x' [[a' [p' r']] | err'];
      [| apply (inr _ err') | apply (inr _ err) | apply (inr _ err)];
      apply (getIsCommutative x _ p); intros comm;
      apply (getIsSelective x _ p); intros sel;
      apply inl; eapply existT; split;
      [ apply (selLexSemigroup_props comm sel p p')
      | apply (ssrSelLex _ _ _ _ r r' comm sel) ].
      (* sSeq *)
      arg1 @seqSemigroup_props ssrSeq.
      (* sSimpleSeq *)
      arg1 @simpleSeqSemigroup_props ssrSimpleSeq.
      (* sPrefix *)
      arg1 @prefixSemigroup_props ssrPrefix.
      (* sPostfix *)
      arg1 @postfixSemigroup_props ssrPostfix.
      (* sRevOp *)
      arg1 @revOpSemigroup_props ssrRevOp.
      (* sMultiSetsUnion *)
      arg1 @multisetUnionSemigroup_props ssrMultiSetsUnion.
      (* sMultiSetsIntersect *)
      arg1 @multisetIntersectionSemigroup_props ssrMultiSetsIntersect.

      (*****************************************)
      (*               Preorders               *)
      (*****************************************)

      (* pDual *)
      arg1 @dualPreorder_props psrDual.
      (* pLeftNaturalOrder *)
      intros x [[a [p r]]| err]; [| apply (inr _ err)];
      apply (getIsIdempotent x _ p); intros idem;
      apply (getIsCommutative x _ p); intros comm;
      apply inl; eapply existT; split;
      [ apply (Preorders.LeftNaturalOrder.leftNaturalOrder_props p idem comm)
      | apply (psrLeftNaturalOrder _ _ r) ].
      (* pRightNaturalOrder *)
      intros x [[a [p r]]| err]; [| apply (inr _ err)];
      apply (getIsIdempotent x _ p); intros idem;
      apply (getIsCommutative x _ p); intros comm;
      apply inl; eapply existT; split;
      [ apply (Preorders.RightNaturalOrder.rightNaturalOrder_props p idem comm)
      | apply (psrRightNaturalOrder _ _ r) ].
      (* pLex *)
      arg2 @lexPreorder_props psrLex.
      (* pNatLe *)
      arg0 @natPreorder_props psrNatLe.
      (* pAnnTop *)
      intros x [[a [p r]]| err]; [| apply (inr _ err)];
      apply (getHasAnnihilator x _ p); intros hasAnn;
      apply inl; eapply existT; split;
      [ apply (annTopPreorder_props p hasAnn)
      | apply (psrAnnTop _ _ r) ].

      (*****************************************)
      (*            OrderSemigroups            *)
      (*****************************************)
      
      (* oDual *)
      arg1 @dualOrderSemigroup_props osrDual.
      (* oLeftNaturalOrder *)
      intros x [[a [p r]]| err]; [| apply (inr _ err)];
      apply (getIsIdempotent x _ p); intros idem;
      apply (getIsCommutative x _ p); intros comm;
      apply inl; eapply existT; split;
      [ apply (OrderSemigroups.LeftNaturalOrder.leftNaturalOrder_props p idem comm)
      | apply (osrLeftNaturalOrder _ _ r) ].
      (* oRightNaturalOrder *)
      intros x [[a [p r]]| err]; [| apply (inr _ err)];
      apply (getIsIdempotent x _ p); intros idem;
      apply (getIsCommutative x _ p); intros comm;
      apply inl; eapply existT; split;
      [ apply (OrderSemigroups.RightNaturalOrder.rightNaturalOrder_props p idem comm)
      | apply (osrRightNaturalOrder _ _ r) ].
      (* oLex *)
      arg2 @lexOrderSemigroup_props osrLex.
      (* oBsLeftNaturalOrder *)
      intros x [[a [p r]]| err]; [| apply (inr _ err)];
      apply (getIsIdempotent x _ (bs_plus_sgprop _ p)); intros idem;
      apply (getIsCommutative x _ (bs_plus_sgprop _ p)); intros comm;
      apply (getIsLeftDistributive x _ p); intros ldist;
      apply (getIsRightDistributive x _ p); intros rdist;
      apply inl; eapply existT; split;
      [ apply (bsLeftNaturalOrder_props p idem comm ldist rdist)
      | apply (osrBsLeftNaturalOrder _ _ r) ].
      (* simple seq *)
      arg1 @simpleSeqOrderSemigroup_props osrSimpleSeq.
      
      (*****************************************)
      (*              Bisemigroups             *)
      (*****************************************)
      
      (* bUnit *)
      arg0 @unitBisemigroup_props bsrUnit.
      (* bBoolOrAnd *)
      arg0 @boolOrAndBisemigroup_props bsrBoolOrAnd.
      (* bNatMaxPlus *)
      arg0 @natMaxPlusBisemigroup_props bsrNatMaxPlus.
      (* bNatMinPlus *)
      arg0 @natMinPlusBisemigroup_props bsrNatMinPlus.
      (* bNatMaxMin *)
      arg0 @natMaxMinBisemigroup_props bsrNatMaxMin.
      (* bNatIMaxPlus *)
      arg0 @natIMaxPlusBisemigroup_props bsrNatIMaxPlus.
      (* bNatIMinPlus *)
      arg0 @natIMinPlusBisemigroup_props bsrNatIMinPlus.
      (* bNatIMaxMin *)
      arg0 @natIMaxMinBisemigroup_props bsrNatIMaxMin.
      (* bRangeMaxPlus *)
      intros n; arg0 (rangeMaxPlusBisemigroup_props n) (bsrRangeMaxPlus n).
      (* bRangeMinPlus *)
      intros n; arg0 (rangeMinPlusBisemigroup_props n) (bsrRangeMinPlus n).
      (* bRangeMaxMin *)
      intros n; arg0 (rangeMaxMinBisemigroup_props n) (bsrRangeMaxMin n).
      (* bSwap *)
      arg1 @swapBisemigroup_props bsrSwap.
      (* bFMinSets *)
      intros x [[a [p r]]| err]; [| apply (inr _ err)];
      apply (getLeftMonotonic x _ p); intros lmon;
      apply (getRightMonotonic x _ p); intros rmon;
      apply (getAntisym x _ p); intros asm;
      apply inl; eapply existT; split;
      [ apply (minsetBisemigroup_props p lmon rmon asm)
      | apply (bsrFMinSets _ _ r lmon rmon asm) ].
      (* bFMinSetsOpUnion *)
      intros x [[a [p r]]| err]; [| apply (inr _ err)];
      apply (getLeftMonotonic x _ p); intros lmon;
      apply (getRightMonotonic x _ p); intros rmon;
      apply (getAntisym x _ p); intros asm;
      apply inl; eapply existT; split;
      [ apply (minsetOpUnionBisemigroup_props p lmon rmon asm)
      | apply (bsrFMinSetsOpUnion _ _ r lmon rmon asm) ].
      (* bFSets *)
      arg1 @fsetBisemigroup_props bsrFSets.
      (* bFSetsOp *)
      arg1 @fsetOpBisemigroup_props bsrFSetsOp.
      (* bLex *)
      intros x [[a [p r]]| err] x' [[a' [p' r']] | err'];
      [| apply (inr _ err') | apply (inr _ err) | apply (inr _ err)];
      apply (getIsCommutative x _ (bs_plus_sgprop _ p)); intros comm;
      apply (getIsIdempotent x _ (bs_plus_sgprop _ p)); intros idem;
      apply (getHasIdentity x' _ (bs_plus_sgprop _ p')); intros hasId;
      apply inl; eapply existT; split;
      [ apply (lexBisemigroup_props p p' comm idem hasId)
      | apply (bsrLex _ _ _ _ r r' comm idem hasId) ].
      (* bProduct *)
      arg2 @prodBisemigroup_props bsrProduct.
      (* bLeft *)
      arg1 @leftBisemigroup_props bsrLeft.
      (* bAddZero *)
      arg1 @addZeroBisemigroup_props bsrAddZero.
      (* bAddOne *)
      intros x [[a [p r]]| err]; [| apply (inr _ err)];
      apply (getIsCommutative x _ (bs_plus_sgprop _ p)); intros comm;
      apply inl; eapply existT; split;
      [ apply (addOneBisemigroup_props p comm)
      | apply (bsrAddOne _ _ r) ].
      (* bSelLex *)
      intros x [[a [p r]]| err] x' [[a' [p' r']] | err'];
      [| apply (inr _ err') | apply (inr _ err) | apply (inr _ err)];
      apply (getIsCommutative x _ (bs_plus_sgprop _ p)); intros comm;
      apply (getIsSelective x _ (bs_plus_sgprop _ p)); intros sel;
      apply (getIsCommutative x _ (bs_plus_sgprop _ p')); intros comm';
      apply inl; eapply existT; split;
      [ apply (selLexBisemigroup_props p p' comm sel comm')
      | apply (bsrSelLex _ _ _ _ r r' comm sel) ].
      (* bRevTimes *)
      arg1 @revTimesBisemigroup_props bsrRevTimes.
      (* bPrefixSeq *)
      arg1 @prefixSeqBisemigroup_props bsrPrefixSeq.
      (* bPostfixSeq *)
      arg1 @postfixSeqBisemigroup_props bsrPostfixSeq.
      (* bMultiSets *)
      arg1 @multisetBisemigroup_props bsrMultiSets.
      
      (*****************************************)
      (*              Transforms               *)
      (*****************************************)
      
      (* tId *)
      arg1 @idTransform_props tsrId.
      (* tReplace *)
      arg1 @replaceTransform_props tsrReplace.
      (* tProduct *)
      arg2 @prodTransform_props tsrProduct.
      (* tUnion *)
      intros x [[a [p r]]| err] x' [[a' [p' r']] | err'];
      [| apply (inr _ err') | apply (inr _ err) | apply (inr _ err)].
      
      (*          r             r'
       *     x ------- a    a' ------ x'
       *     |         |    |         |         ||
       *     |         |    |         |         || SemRel
       *     |         b    b'        |         ||
       *     |    iso1 ~    ~ iso1'   |         \/
       *     y ------- b1 ~ b1'-------y'
       *         r1      iso2    r1'
       *)
      destruct (semRel_TF_DS _ _ r) as [b1 [r1 iso1]].
      destruct (semRel_TF_DS _ _ r') as [b1' [r1' iso1']].
      copy_destruct (eq_DS (TF_DS x) (TF_DS x'));
      [| apply (notWF (tUnion x x') "Could not validate that arguments to tUnion are isomorphic.") ].
      assert (iso2 := findIdDsIso _ _ r1 _ _ r1' ew). 
      set (iso := IdDsIso_trans (IdDsIso_trans iso1 iso2) (IdDsIso_sym iso1')).
      apply inl; exists (unionTransform a a' iso); split;
      [ apply (unionTransform_props p p' _)
      | apply (tsrUnion _ _ _ _ r r' _) ].
      (* tCayley *)
      arg1 @cayleyMapTransform_props tsrCayley.
      
      (*****************************************)
      (*         SemigroupTransforms           *)
      (*****************************************)
      
      (* stLeft *)
      arg1 @leftSemigroupTransform_props stsrLeft.
      (* stRight *)
      arg1 @rightSemigroupTransform_props stsrRight.
      (* stLex *)
      intros x [[a [p r]]| err] x' [[a' [p' r']] | err'];
      [| apply (inr _ err') | apply (inr _ err) | apply (inr _ err)];
      apply (getIsCommutative x _ p); intros comm;
      apply (getIsIdempotent x _ p); intros idem;
      apply (getHasIdentity x' _ p'); intros hasId;
      apply (getStrict x' _ p'); intros strict.
      apply inl; eapply existT; split;
      [ apply (lexSemigroupTransform_props p p' comm idem hasId strict)
      | apply (stsrLex _ _ _ _ r r' comm idem hasId strict) ].
      (* stSelLex *)
      intros x [[a [p r]]| err] x' [[a' [p' r']] | err'];
      [| apply (inr _ err') | apply (inr _ err) | apply (inr _ err)];
      apply (getIsCommutative x _ p); intros comm;
      apply (getIsSelective x _ p); intros sel;
      apply (getIsCommutative x' _ p'); intros B_comm;
      apply inl; eapply existT; split;
      [ apply (selLexSemigroupTransform_props p p' comm sel B_comm)
      | apply (stsrSelLex _ _ _ _ r r' comm sel B_comm) ].
      (* stUnion *)
      intros x [[a [p r]]| err] x' [[a' [p' r']] | err'];
      [| apply (inr _ err') | apply (inr _ err) | apply (inr _ err)].
      (*          r             r'
       *     x ------- a    a' ------ x'
       *     |         |    |         |         ||
       *     |         |    |         |         || SemRel
       *     |         b    b'        |         ||
       *     |    iso1 ~    ~ iso1'   |         \/
       *     y ------- b1 ~ b1'-------y'
       *         r1      iso2    r1'
       *)
      destruct (semRel_ST_SG _ _ r) as [b1 [r1 iso1]];
      destruct (semRel_ST_SG _ _ r') as [b1' [r1' iso1']].
      
      copy_destruct (eq_SG (ST_SG x) (ST_SG x'));
      [| apply (notWF (stUnion x x') "Could not validate that arguments to tUnion are isomorphic.") ].
      assert (iso2 := findIdSgIso _ _ r1 _ _ r1' ew). 
      set (iso := IdSmgIso_trans (IdSmgIso_trans iso1 iso2) (IdSmgIso_sym iso1')).
      apply inl; exists (unionSemigroupTransform a a' iso); split;
      [ apply (unionSemigroupTransform_props p p' _)
      | apply (stsrUnion _ _ _ _ r r' _) ].
      (* stCayley *)
      arg1 @cayleyMapSemigroupTransform_props stsrCayley.
   Defined.

   Definition dsSemF (x : DS) : DecSetoidSem + NotWF := 
      match fst ( fst ( fst ( fst ( fst ( fst semF ))))) x with
         | inl ( existT a ( p , _ ) ) => inl _ ( existT _ a p )
         | inr err => inr _ err
      end.

   Definition sgSemF (x : SG) : SemigroupSem + NotWF := 
      match snd ( fst ( fst ( fst ( fst ( fst semF ))))) x with
         | inl ( existT a ( p , _ ) ) => inl _ ( existT _ a p )
         | inr err => inr _ err
      end.

   Definition poSemF (x : PO) : PreorderSem + NotWF := 
      match snd ( fst ( fst ( fst ( fst semF )))) x with
         | inl ( existT a ( p , _ ) ) => inl _ ( existT _ a p )
         | inr err => inr _ err
      end.

   Definition osSemF (x : OS) : OrderSemigroupSem + NotWF := 
      match snd ( fst ( fst ( fst semF ))) x with
         | inl ( existT a ( p , _ ) ) => inl _ ( existT _ a p )
         | inr err => inr _ err
      end.

   Definition bsSemF (x : BS) : BisemigroupSem + NotWF := 
      match snd ( fst ( fst semF)) x with
         | inl ( existT a ( p , _ ) ) => inl _ ( existT _ a p )
         | inr err => inr _ err
      end.

   Definition tfSemF (x : TF) : TransformSem + NotWF := 
      match snd ( fst semF) x with
         | inl ( existT a ( p , _ ) ) => inl _ ( existT _ a p )
         | inr err => inr _ err
      end.

   Definition stSemF (x : ST) : SemigroupTransformSem + NotWF := 
      match snd ( semF) x with
         | inl ( existT a ( p , _ ) ) => inl _ ( existT _ a p )
         | inr err => inr _ err
      end.

End SemanticsRelation.