Require Import Coq.Lists.List.
Require Import Coq.Bool.Bool.
Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Language.Syntax.
Require Import Metarouting.Language.Semantics.
Require Import Metarouting.Language.OcamlTypes.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Preorder.
Require Import Metarouting.Signatures.PreorderProperties.
Require Import Metarouting.Language.AstDS.


(*********************************************************************)
(*                            Preorders                              *)
(*********************************************************************)

Section BuildIsoPreorder.
   Set Implicit Arguments.

   (** 
     * Build a decidable setoid from type split mono f.
     *)
   Variable P : Preorder.
   Variable T : Type.
   Variable smono : splitMono P T.
   Local Notation f := (mono smono).
   Local Notation f' := (mono_inv smono).

   (**
     * Lift algebraic structure
     *)

   Definition le_T (a b : buildIsoDs P smono) := ((f' a) <= (f' b)) %bool.
   
   Lemma le_T_refl : Reflexive le_T.
   Proof. intros x; unfold dseq; simpl; unfold le_T, eq_T; simpl; dseq_f.
      apply le_refl.
   Qed.
   
   Lemma le_T_trans : Transitive le_T.
   Proof. intros x y z; unfold dseq; simpl; unfold le_T, eq_T; simpl; dseq_f.
      apply le_trans.
   Qed.
   
   Lemma le_T_pres_eq : RelPreserves le_T.
   Proof. intros x y u v; unfold dseq; simpl; unfold le_T, eq_T; simpl; dseq_f.
      apply le_pres_eq.
   Qed.
   
   Definition buildIsoPro : Preorder :=
      Build_Preorder
         le_T_refl
         le_T_trans
         le_T_pres_eq.

   Definition buildIsoPro_Iso : ProIso P buildIsoPro.
      apply (@Build_ProIso P buildIsoPro (buildIsoDs_Iso P smono)).
      apply Build_IsProIso.
      intros x y; unfold dseq; simpl; unfold le_T, eq_T; simpl; dseq_f; repeat rewrite (mono_spec smono); auto.
      intros x y; unfold dseq; simpl; unfold le_T, eq_T; simpl; dseq_f; repeat rewrite (mono_spec smono); auto.
   Defined.

(*
   Definition astPreorderSem : PreorderSem :=
      existT _ buildIsoPro (poPropIso buildIsoPro_Iso (projT2 P)).
*)

End BuildIsoPreorder.

Section OcamlPO.
   Set Implicit Arguments.

   Definition astPO (x : Preorder) t (e : ocmType t = carrier x) : Exists y, ProIso x y.
      intros.
      assert (h := @astSplitMono t).
      rewrite e in h.
      exists (buildIsoPro x h).
      apply buildIsoPro_Iso.
   Defined.   

(*
   Definition astProSem (sm : PreorderSem) t (e : ocmType t = carrier sm) : PreorderSem.
      intros. apply (@astPreorderSem sm (wfAst t)).
      rewrite <- e. apply astSplitMono.
   Defined.
   
   Definition astPO (po : PO) : PreorderSem + NotWF.
      intros po.
      assert (ot := otPO_correct po); red in ot.
      destruct (semPO po).
      apply inl; apply (astProSem p (otPO po)); destruct p; simpl in *; rewrite <- ot; auto.
      apply inr; apply n.
   Defined.
*)
   
End OcamlPO.