Require Import Coq.Lists.List.
Require Import Coq.Bool.Bool.
Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Language.Syntax.
Require Import Metarouting.Language.Semantics.
Require Import Metarouting.Language.OcamlTypes.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Preorder.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.OrderSemigroup.
Require Import Metarouting.Signatures.OrderSemigroupProperties.
Require Import Metarouting.Language.AstDS.

(*********************************************************************)
(*                         Order Semigroups                          *)
(*********************************************************************)

Section BuildIsoOrderSemigroup.
   Set Implicit Arguments.
   Open Scope OrderSemigroup_scope.

   (** 
     * Build a decidable setoid from type split mono f.
     *)
   Variable O : OrderSemigroup.
   Variable T : Type.
   Variable smono : splitMono O T.
   Local Notation f := (mono smono).
   Local Notation f' := (mono_inv smono).

   (**
     * Lift algebraic structure
     *)
   Definition le_T (a b : buildIsoDs O smono) := (le O (f' a) (f' b)) %bool.
   Definition op_T (a b : buildIsoDs O smono) : buildIsoDs O smono := f ((f' a) + (f' b)).
   
   Lemma le_T_refl : Reflexive le_T.
   Proof. intros x; unfold dseq; simpl; unfold le_T, eq_T; simpl; dseq_f.
      apply le_refl.
   Qed.
   
   Lemma le_T_trans : Transitive le_T.
   Proof. intros x y z; unfold dseq; simpl; unfold le_T, eq_T; simpl; dseq_f.
      apply le_trans.
   Qed.
   
   Lemma le_T_pres_eq : RelPreserves le_T.
   Proof. intros x y u v; unfold dseq; simpl; unfold le_T, eq_T; simpl; dseq_f.
      apply le_pres_eq.
   Qed.

   Lemma op_T_assoc : Associative op_T.
   Proof. intros x y z. unfold dseq; simpl; unfold op_T, eq_T; simpl; dseq_f.
      repeat rewrite (mono_spec smono). apply assoc.
   Qed.
   
   Lemma op_T_pres_eq : Preserves op_T.
   Proof. intros x y u v; unfold dseq; simpl; unfold op_T, eq_T; simpl; dseq_f.
      repeat rewrite (mono_spec smono). apply op_pres_eq.
   Qed.
   
   Definition buildIsoOSmg : OrderSemigroup :=
      Build_OrderSemigroup
         le_T_refl
         le_T_trans
         le_T_pres_eq
         op_T_assoc
         op_T_pres_eq.

   Definition buildIsoOSmg_Iso : OSmgIso O buildIsoOSmg.
      apply (@Build_OSmgIso O buildIsoOSmg (buildIsoDs_Iso O smono)).
      apply Build_IsOSmgIso.
      intros x y; unfold dseq; simpl; unfold le_T, op_T, eq_T; simpl; dseq_f; repeat rewrite (mono_spec smono); auto.
      intros x y; unfold dseq; simpl; unfold le_T, op_T, eq_T; simpl; dseq_f; repeat rewrite (mono_spec smono); auto.
      intros x y; unfold dseq; simpl; unfold le_T, op_T, eq_T; simpl; dseq_f; repeat rewrite (mono_spec smono); auto.
      intros x y; unfold dseq; simpl; unfold le_T, op_T, eq_T; simpl; dseq_f; repeat rewrite (mono_spec smono); auto.
   Defined.

(*
   Definition astOrderSemigroupSem : OrderSemigroupSem :=
      existT _ buildIsoOSmg (osPropIso buildIsoOSmg_Iso (projT2 O)).
*)

End BuildIsoOrderSemigroup.

Section OcamlOS.
   Set Implicit Arguments.
   
   Definition astOS (x : OrderSemigroup) t (e : ocmType t = carrier x) : Exists y, OSmgIso x y.
      intros.
      assert (h := @astSplitMono t).
      rewrite e in h.
      exists (buildIsoOSmg x h).
      apply buildIsoOSmg_Iso.
   Defined.

(*
   Definition astOSmgSem (sm : OrderSemigroupSem) t (e : ocmType t = carrier sm) : OrderSemigroupSem.
      intros. apply (@astOrderSemigroupSem sm (wfAst t)).
      rewrite <- e. apply astSplitMono.
   Defined.
   
   Definition astOS (os : OS) : OrderSemigroupSem + NotWF.
      intros os.
      assert (ot := otOS_correct os); red in ot.
      destruct (semOS os).
      apply inl; apply (astOSmgSem o (otOS os)); destruct o; simpl in *; rewrite <- ot; auto.
      apply inr; apply n.
   Defined.
*)
   
End OcamlOS.
