Require Import Coq.Lists.List.
Require Import Coq.Bool.Bool.
Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Language.Syntax.
Require Import Metarouting.Language.Semantics.
Require Import Metarouting.Language.OcamlTypes.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.DecSetoidProperties.

(***********************************************************************)
(*                          DecSetoids                                 *)
(***********************************************************************)

Section BuildIsoDecSetoid.
   Set Implicit Arguments.

   (** 
     * Build a decidable setoid from type split mono f.
     *)
   Variable D : DecSetoid.
   Variable T : Type.
   Variable smono : splitMono D T.
   Local Notation f := (mono smono).
   Local Notation f' := (mono_inv smono).

   (**
     * Let equality for T be the kernel of f'.
     *)
   Definition eq_T (a b : T) := ((f' a) == (f' b)) %bool.
   
   Lemma eq_T_refl : Reflexive eq_T.
   Proof. intros x. apply refl. Qed.
   
   Lemma eq_T_sym : Symmetric eq_T.
   Proof. intros x y. apply sym. Qed.
   
   Lemma eq_T_trans : Transitive eq_T.
   Proof. intros x y z. apply trans. Qed.
   
   Definition buildIsoDs : DecSetoid :=
      Build_DecSetoid
         (f (choose D))
         eq_T
         eq_T_refl
         eq_T_sym
         eq_T_trans.

   Definition buildIsoDs_Iso : DsIso D buildIsoDs.
      apply (@Build_DsIso D buildIsoDs f f').
      apply Build_IsDsIso.
      intros x y; unfold dseq; simpl; unfold eq_T; dseq_f; repeat rewrite (mono_spec smono); auto.
      intros x y; unfold dseq; simpl; unfold eq_T; dseq_f; auto.
      intros x; unfold dseq; simpl; unfold eq_T; dseq_f; rewrite (mono_spec smono); auto.
      intros x; rewrite (mono_spec smono); auto.
   Defined.
   
(*
   Definition astDecSetoidSem : DecSetoidSem :=
      existT _ buildIsoDs (dsPropIso buildIsoDs_Iso (projT2 D)).
*)

End BuildIsoDecSetoid.

Section OcamlDS.
   Set Implicit Arguments.

   Definition astDS (x : DecSetoid) t (e : ocmType t = carrier x) : Exists y, DsIso x y.
      intros.
      assert (h := @astSplitMono t).
      rewrite e in h.
      exists (buildIsoDs x h).
      apply buildIsoDs_Iso.
   Defined.
   
(*
   Definition astDsSem (sm : DecSetoidSem) t (e : ocmType t = carrier sm) : DecSetoidSem.
      intros. apply (@astDecSetoidSem sm (wfAst t)).
      rewrite <- e. apply astSplitMono.
   Defined.
   
   Definition astDS (ds : DS) : DecSetoidSem + NotWF.
      intros ds.
      assert (ot := otDS_correct ds); red in ot.
      destruct (semF ds).
      apply inl; apply (astDsSem d (otDS ds)); destruct d; simpl in *; rewrite <- ot; auto.
      apply inr; apply n.
   Defined.
*)
   
End OcamlDS.